/*
 * a12nd.e.c
 * Copyright (C) 2011-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <a1-inter.h>
#include <a1-types.h>
#include <er.h>
#include <exerrors.h>

#define shuffle(shuffle) \
    ((struct a1_shuffle_type *) (shuffle))

int
_x1f4_a1_stat_call(void *shuffle, const char *call, unsigned size)
{
    LINE_EEER(shuffle(shuffle)->x);

    PUSH_DATA("non function pointer first argument for function `", 50);
    PUSH_DATA(call, size);
    PUSH_DATA("'", 1);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_x1f4_a1_stat_deck(void *shuffle, unsigned size, long mode)
{
    int status;

    if (size) {
	status = _x1f4_a1_stat_time(shuffle, size, mode);
    } else {
	status = _x1f4_a1_stat_null(shuffle);
    }

    return status;
}


int
_x1f4_a1_stat_free(void *shuffle)
{
    LINE_EEER(shuffle(shuffle)->x);

    PUSH_DATA("cannot free memory", 18);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_x1f4_a1_stat_link(void *shuffle)
{
    LINE_EEER(shuffle(shuffle)->x);

    PUSH_DATA("cannot allocate memory", 22);

    POST_EEER();

    return X1f4_EX_CANNOT_CONTINUE;
}


int
_x1f4_a1_stat_miss(void *shuffle)
{
    LINE_EEER(shuffle(shuffle)->x);

    PUSH_DATA("unset function pointer", 22);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


#if 0
int
_x1f4_a1_stat_mode(void *shuffle)
{
    LINE_EEER(shuffle(shuffle)->x);

    PUSH_DATA("cannot reallocate memory", 24);

    POST_EEER();

    return X1f4_EX_CANNOT_CONTINUE;
}
#endif				/* 0 */


int
_x1f4_a1_stat_null(void *shuffle)
{
    LINE_EEER(shuffle(shuffle)->x);

    PUSH_DATA("function takes no arguments", 27);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


#if 0
int
_x1f4_a1_stat_post(void *shuffle)
{
    LINE_EEER(shuffle(shuffle)->x);

    PUSH_DATA("improper reference argument positional access", 45);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}
#endif				/* 0 */


int
_x1f4_a1_stat_time(void *shuffle, unsigned size, long mode)
{
    LINE_EEER(shuffle(shuffle)->x);

    PUSH_DATA("out of range (-", 15);
    PUSH_BILL(size);
    PUSH_DATA(" .. ", 4);
    PUSH_BILL(size - 1);
    PUSH_DATA(") argument index (", 18);
    PUSH_LONG(mode);
    PUSH_DATA(")", 1);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_x1f4_a1_stat_type(void *shuffle, int target, int source)
{
    const struct x1f4_eelookup_type *eelookup_data;

    LINE_EEER(shuffle(shuffle)->x);

    eelookup_data = shuffle(shuffle)->y.eelookup_data;

    PUSH_DATA("cannot set ", 11);
    PUSH_TYPE(target, eelookup_data);
    PUSH_DATA(" from ", 6);
    PUSH_TYPE(source, eelookup_data);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_x1f4_a1_stat_zero(void *shuffle, const char *call, unsigned size)
{
    LINE_EEER(shuffle(shuffle)->x);

    PUSH_DATA(call, size);
    PUSH_DATA(": null function pointer", 23);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}
