/*
 * a12nd.d.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <a1-inter.h>
#include <a1-types.h>
#include <af.h>
#include <e4.h>
#include <lxcast.h>

#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

static int slip_cast(void *, int, struct a1_shuffle_type *);
static int slip_node(void *, int, struct a1_shuffle_type *);
static int slip_text(void *, struct a1_shuffle_type *);

static int
slip_cast(void *link, int type, struct a1_shuffle_type *shuffle_data)
{
    int status;

    if (type < X1f4_E4_VOID) {
	if (type == X1f4_E4_TEXT) {
	    status = slip_text(link, shuffle_data);
	} else {
	    status = 0;
	}
    } else {
	if (X1f4_E4_CALL < type) {
	    status = _x1f4_slip_effect(NULL, link);
	} else {
	    status = slip_node(link, type, shuffle_data);
	}
    }

    return status;
}


static int
slip_node(void *link, int type, struct a1_shuffle_type *shuffle_data)
{
    const char *name;
    int status;
    const struct x1f4_datatype_type *datatype_data;

    datatype_data = shuffle_data->u.datatype_data;
    name = datatype_data->name;
    while (name) {
	if (datatype_data->type == type) {
	    break;
	} else {
	    datatype_data++;
	    name = datatype_data->name;
	}
    }
    if (name) {
    } else {
	datatype_data = shuffle_data->u.sidetype_data;
	name = datatype_data->name;
	while (name) {
	    if (datatype_data->type == type) {
		break;
	    } else {
		datatype_data++;
		name = datatype_data->name;
	    }
	}
    }

    if (name) {
	if (datatype_data->slip) {
	    status = datatype_data->slip(datatype_data->context, link);
	} else {
	    status = 0;
	}
    } else {
	status = 0;
    }

    return status;
}


static int
slip_text(void *link, struct a1_shuffle_type *shuffle_data)
{
    int status;

    status = shuffle_data->m.free(shuffle_data->m.data, I_TEXT(link));
    if (status) {
	status = _x1f4_a1_stat_free(shuffle_data);
    }

    return status;
}


int
_x1f4_a1_slip_slip(struct a1_shuffle_type *shuffle_data,
		   struct a1_link_type *link_data, int class,
		   const struct x1f4_function_type *function_data,
		   const struct x1f4_function_type *function_slip, void *used)
{
    const int *args, *slip;
    int excess, status = 0;
    unsigned count, flags, i;

    count = function_slip->count;

    flags = function_slip->flags;

    slip = function_slip->args;
    args = function_data->args;

    i = class;
    if (i ^ -1) {
    } else {
	i = count;
    }
    for (; i; i--) {
	if (*slip == X1f4_E4_SLIP) {
	    int type;

	    type = *args;
	    if (0) {
	    } else {
		do {
		    void *link;

		    if (flags & X1f4_E4_POST_TYPE) {
			if (slip[count] & X1f4_E4_POST_XSET) {
			    if (1) {
				break;
			    }
			}
		    }

		    link = (char *) used + (int) link_data->datatext.link;

		    excess = slip_cast(link, type, shuffle_data);
		    if (excess) {
			if (status) {
			} else {
			    status = excess;
			}
		    }
		} while (0);
	    }
	}

	args++;

	slip++;

	link_data++;
    }

    return status;
}
