/*
 * a12nd.c.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <string.h>

#include <a1-copy.h>
#include <a1-inter.h>
#include <a1-types.h>
#include <af.h>
#include <dt.h>
#include <e4.h>
#include <exerrors.h>
#include <lxcall.h>
#include <lxcast.h>

#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

static int lead_cast(void *, int, struct a1_shuffle_type *);
static int lead_node(void *, int, struct a1_shuffle_type *);
static int lead_text(void *, struct a1_shuffle_type *);

static int
lead_cast(void *link, int type, struct a1_shuffle_type *shuffle_data)
{
    int status;

    if (type < X1f4_E4_VOID) {
	if (type == X1f4_E4_TEXT) {
	    status = lead_text(link, shuffle_data);
	} else {
	    status = 0;
	}
    } else {
	if (X1f4_E4_CALL < type) {
	    status = _x1f4_lead_effect(NULL, link);
	} else {
	    status = lead_node(link, type, shuffle_data);
	}
    }

    return status;
}


static int
lead_node(void *link, int type, struct a1_shuffle_type *shuffle_data)
{
    const char *name;
    int status;
    const struct x1f4_datatype_type *datatype_data;

    datatype_data = shuffle_data->u.datatype_data;
    name = datatype_data->name;
    while (name) {
	if (datatype_data->type == type) {
	    break;
	} else {
	    datatype_data++;
	    name = datatype_data->name;
	}
    }
    if (name) {
    } else {
	datatype_data = shuffle_data->u.sidetype_data;
	name = datatype_data->name;
	while (name) {
	    if (datatype_data->type == type) {
		break;
	    } else {
		datatype_data++;
		name = datatype_data->name;
	    }
	}
    }

    if (name) {
	if (datatype_data->lead) {
	    status = datatype_data->lead(datatype_data->context, link);
	    if (status) {
		status = X1f4_EX_CANNOT_CONTINUE;
	    } else {
	    }
	} else {
	    status = 0;
	}
    } else {
	status = 0;
    }

    return status;
}


static int
lead_text(void *link, struct a1_shuffle_type *shuffle_data)
{
    int status;
    unsigned size;
    void *data, *text;

    data = I_TEXT(link);

    size = strlen(data) + 1;
    status = shuffle_data->m.link(shuffle_data->m.data, &text, size);
    if (status) {
	status = _x1f4_a1_stat_link(shuffle_data);
    } else {
	memcpy(text, data, size);
	l_TEXT(text, link);
    }

    return status;
}


int
_x1f4_a1_lead_slip(struct a1_shuffle_type *shuffle_data, void **input,
		   struct a1_link_type *link_data,
		   const struct x1f4_function_type *function_data,
		   const struct x1f4_function_type *function_slip, void *used)
{
    const int *args, *slip;
    int status = 0;
    unsigned count, flags, i;
    void **lead;

    status = 0;

    lead = input;

    count = function_slip->count;

    flags = function_slip->flags;

    slip = function_slip->args;
    args = function_data->args;

    for (i = count; i; i--) {
	if (*slip == X1f4_E4_SLIP) {
	    int type;

	    type = *args;
	    if (0) {
	    } else {
		do {
		    void *link;

		    link = (char *) used + (int) link_data->datatext.link;

		    if (flags & X1f4_E4_POST_TYPE) {
			if (slip[count] & X1f4_E4_POST_XSET) {
			    status =
				_x1f4_a1_land_cast(link, type, shuffle_data);
			    break;
			}
		    }

		    copy_miss(link, type, *lead);

		    status = lead_cast(link, type, shuffle_data);
		} while (0);
		if (status) {
		    break;
		}
	    }
	} else {
	}

	args++;

	lead++;

	slip++;

	link_data++;
    }

    if (status) {
	status = X1f4_EX_CANNOT_CONTINUE;
	count -= i;
	_x1f4_a1_slip_slip
	    (shuffle_data, link_data - count, count, function_data,
	     function_slip, used);
    }

    return status;
}
