/*
 * a12nd.a.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <string.h>

#include <a1-copy.h>
#include <a1-inter.h>
#include <a1-types.h>
#include <af.h>
#include <dt.h>
#include <e4.h>
#include <exerrors.h>
#include <lxcall.h>
#include <lxcast.h>

#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

static int lead_cast(struct x1f4_dxcast_type *, struct a1_shuffle_type *);
static int lead_node(struct x1f4_dxcast_type *, struct a1_shuffle_type *);
static int lead_miss(struct x1f4_dxcast_type *, struct a1_shuffle_type *);
static int lead_text(struct x1f4_dxcast_type *, struct a1_shuffle_type *);

static int
lead_cast(struct x1f4_dxcast_type *dxcast_data,
	  struct a1_shuffle_type *shuffle_data)
{
    int status, type;

    type = dxcast_data->type;
    if (type < X1f4_E4_LAST) {
	if (type == X1f4_E4_TEXT) {
	    status = lead_text(dxcast_data, shuffle_data);
	} else {
	    status = 0;
	}
    } else {
	if (X1f4_E4_CALL < type) {
	    status = _x1f4_lead_effect(NULL, (void *) &dxcast_data->data);
	} else {
	    status = lead_node(dxcast_data, shuffle_data);
	}
    }

    return status;
}


static int
lead_node(struct x1f4_dxcast_type *dxcast_data,
	  struct a1_shuffle_type *shuffle_data)
{
    const char *name;
    int status, type;
    const struct x1f4_datatype_type *datatype_data;

    type = dxcast_data->type;

    datatype_data = shuffle_data->u.datatype_data;
    name = datatype_data->name;
    while (name) {
	if (datatype_data->type == type) {
	    break;
	} else {
	    datatype_data++;
	    name = datatype_data->name;
	}
    }
    if (name) {
    } else {
	datatype_data = shuffle_data->u.sidetype_data;
	name = datatype_data->name;
	while (name) {
	    if (datatype_data->type == type) {
		break;
	    } else {
		datatype_data++;
		name = datatype_data->name;
	    }
	}
    }

    if (name) {
	if (datatype_data->lead) {
	    status = datatype_data->lead
		(datatype_data->context, (void *) &dxcast_data->data);
	    if (status) {
		status = X1f4_EX_CANNOT_CONTINUE;
	    } else {
	    }
	} else {
	    status = 0;
	}
    } else {
	status = 0;
    }

    return status;
}


static int
lead_miss(struct x1f4_dxcast_type *dxcast_data,
	  struct a1_shuffle_type *shuffle_data)
{
    const char *name;
    int status;
    const struct x1f4_datatype_type *datatype_data;

    datatype_data = shuffle_data->u.sidetype_data;
    name = datatype_data->name;
    while (name) {
	if (datatype_data->type == X1f4_E4_CASE) {
	    break;
	} else {
	    datatype_data++;
	    name = datatype_data->name;
	}
    }
    if (name) {
    } else {
	datatype_data = shuffle_data->u.datatype_data;
	name = datatype_data->name;
	while (name) {
	    if (datatype_data->type == X1f4_E4_CASE) {
		break;
	    } else {
		datatype_data++;
		name = datatype_data->name;
	    }
	}
    }

    if (name) {
	if (datatype_data->lead) {
	    status = datatype_data->lead
		(datatype_data->context, (void *) &dxcast_data);
	    if (status) {
		status = X1f4_EX_CANNOT_CONTINUE;
	    } else {
	    }
	} else {
	    status = 0;
	}
    } else {
	status = 0;
    }

    return status;
}


static int
lead_text(struct x1f4_dxcast_type *dxcast_data,
	  struct a1_shuffle_type *shuffle_data)
{
    int status;
    unsigned size;
    void *data, *text;

    data = I_TEXT(&dxcast_data->data);

    size = strlen(data) + 1;
    status = shuffle_data->m.link(shuffle_data->m.data, &text, size);
    if (status) {
	status = _x1f4_a1_stat_link(shuffle_data);
    } else {
	memcpy(text, data, size);
	l_TEXT(text, &dxcast_data->data);
    }

    return status;
}


int
_x1f4_a1_lead_side(struct a1_shuffle_type *shuffle_data, unsigned offset,
		   void **input, unsigned prefix, void **call,
		   const struct x1f4_function_type *function_data)
{
    int status;

    status = shuffle_data->m.link
	(shuffle_data->m.data, call,
	 offset * (sizeof(void *) + sizeof(struct x1f4_dxcast_type)));
    if (status) {
	status = _x1f4_a1_stat_link(shuffle_data);
    } else {
	const int *args;
	struct x1f4_dxcast_type *dxcast_data;
	unsigned count, flags, i;
	void **lead, **rail;

	status = 0;

	dxcast_data = *call;

	rail = (void *) (dxcast_data + offset);

	lead = input + prefix;

	count = prefix + offset;

	flags = function_data->flags;

	args = function_data->args + prefix;

	for (i = offset; i; i--) {
	    int type;

	    dxcast_data->call = 1;

	    type = *args;
	    if (type == X1f4_E4_CASE) {
		*dxcast_data = *(struct x1f4_dxcast_type *) *(void **) *lead++;
		status = lead_miss(dxcast_data, shuffle_data);
		if (status) {
		    break;
		}
	    } else {
		do {
		    dxcast_data->type = type;

		    if (flags & X1f4_E4_POST_TYPE) {
			if (args[count] & X1f4_E4_POST_XSET) {
			    void *text;

			    text = *lead++;
			    *rail = text;

			    status =
				_x1f4_a1_land_cast(rail, type, shuffle_data);

			    if (1) {
				break;
			    }
			}
		    }

		    copy_miss(&dxcast_data->data, type, *lead++);
		    status = lead_cast(dxcast_data, shuffle_data);
		} while (0);
		if (status) {
		    break;
		}
	    }

	    args++;

	    rail++;

	    dxcast_data++;
	}

	if (status) {
	    _x1f4_a1_slip_side
		(shuffle_data, prefix, offset - i, *call, function_data);
	}
    }

    return status;
}
