/*
 * a12nd.7.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <a1-inter.h>
#include <a1-types.h>

int
_x1f4_a1_push_node(struct a1_shuffle_type *shuffle_data,
		   struct a1_node_type *node_data, void **used)
{
    int status;

    status = _x1f4_a1_link_node(shuffle_data, node_data, used);
    if (status) {
    } else {
	struct a1_pipe_type *pipe_data;

	pipe_data = shuffle_data->pipe_long;
	if (pipe_data) {
	    status = _x1f4_a1_fast_node
		(&node_data->linetext.function, pipe_data);
	    if (status) {
		shuffle_data->m.free(shuffle_data->m.data, *used);
	    }
	}
    }

    return status;
}
