/*
 * a12nd.6.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <a1-inter.h>
#include <a1-types.h>
#include <c1i.h>

int
_x1f4_a1_pass_node(struct a1_shuffle_type *shuffle_data,
		   struct a1_node_type *node_data, void *used, int status)
{
    int excess;

    if (status) {
	x1f4_mind_program(node_data->aime, used);
    }

    {
	struct a1_pipe_type *pipe_data;

	pipe_data = shuffle_data->back_pipe;
	if (pipe_data) {
	    excess = _x1f4_a1_lose_node
		(&node_data->linetext.function, pipe_data);
	    if (excess) {
		if (status) {
		} else {
		    status = excess;
		}
	    }
	}
    }

    excess = shuffle_data->m.free(shuffle_data->m.data, used);
    if (excess) {
	excess = _x1f4_a1_stat_free(shuffle_data);
	if (status) {
	} else {
	    status = excess;
	}
    }

    return status;
}
