/*
 * a1.z.c
 * Copyright (C) 2006-2012, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <a1-inter.h>
#include <a1-types.h>
#include <e4fine.h>
#include <trans.h>

#define SHUFFLE(shuffle) \
    ((a1_shuffle_type *) shuffle)

#define E_FREE(mcontext, mdata) \
    (SHUFFLE(mcontext)->m.free(SHUFFLE(mcontext)->m.data, (mdata)))

static int flat_list(struct a1_shuffle_type *);
static int flat_pipe(struct a1_shuffle_type *);

static int
flat_list(struct a1_shuffle_type *shuffle_data)
{
    int status;
    struct a1_node_type *slip_node;

    slip_node = shuffle_data->slip_node;

    if (slip_node) {
	struct a1_node_type *node_data;
	void *node;

	node_data = shuffle_data->node_data;
	if (node_data) {
	    node_data->fast = NULL;
	}

	node = &slip_node->linetext;
	status = _x1f4_a1_slip_news(NULL, &node);
    } else {
	status = 0;
    }

    return status;
}


static int
flat_pipe(struct a1_shuffle_type *shuffle_data)
{
    int status;
    struct a1_pipe_type *pipe_data;

    pipe_data = shuffle_data->pipe_long;
    if (pipe_data) {
	int (*free) (void *, void *);
	void *data;

	data = shuffle_data->m.data;
	free = shuffle_data->m.free;

	while (1) {
	    struct a1_pipe_type *pipe_slip;

	    pipe_slip = pipe_data->pipe_long;

	    status = free(data, pipe_data);
	    if (status) {
		break;
	    } else {
		if (pipe_slip) {
		    pipe_data = pipe_slip->pipe_long;

		    status = free(data, pipe_slip);
		    if (status) {
			break;
		    } else {
			if (pipe_data) {
			} else {
			    break;
			}
		    }
		} else {
		    break;
		}
	    }
	}
    } else {
	status = 0;
    }

    return status;
}


int
x1f4_fini_shuffle(struct a1_shuffle_type **shuffle)
{
    int excess, status;
    struct a1_shuffle_type *shuffle_data;

    shuffle_data = *shuffle;

    status = flat_list(shuffle_data);

    excess = flat_pipe(shuffle_data);
    if (excess) {
	if (status) {
	} else {
	    status = excess;
	}
    }

    if (1) {
	void *fine;

	fine = shuffle_data->fine;
	if (fine) {
	    excess = x1f4_fini_e4fine(&fine);
	    if (status) {
	    } else {
		status = excess;
	    }
	}
    }

    if (1) {
	struct a1_flat_type *flat_text;

	flat_text = shuffle_data->flat_data;
	while (flat_text) {
	    struct a1_flat_type *flat_data;

	    flat_data = flat_text;
	    flat_text = flat_data->flat_data;
	    E_FREE(shuffle_data, flat_data);
	}
    }

    excess = E_FREE(shuffle_data, shuffle_data);
    if (excess) {
	if (status) {
	} else {
	    status = excess;
	}
    }

    return status;
}
