/*
 * a1.w.c
 * Copyright (C) 2007-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */

#include <a1-defs.h>
#include <a1-errors.h>
#include <a1-types.h>
#include <c1.h>
#include <e42.h>
#if !defined HAVE_LIBx1f4i0
# include <cardinal.v-d.h>
# include <ordinal.h>
#endif				/* !HAVE_LIBx1f4i0 */

#define dump_abcdef_error_e_ARGS_0 \
    void *, int (*) (void *, const char *, unsigned), const char *, unsigned, \
    struct a1_back_type *, struct x1f4_eelookup_type *
#define dump_abcdef_error_e_ARGS_1 \
    void *data, int (*this) (void *, const char *, unsigned),		      \
    const char *head, unsigned bits, struct a1_back_type *back_data,	      \
    struct x1f4_eelookup_type *eelookup_data
#define dump_abcdef_error_e_ARGS_2 \
    data, this, head, bits, back_data, eelookup_data

#define dump_abcdef_error_i_ARGS_0 \
    void *, int (*) (void *, const char *, unsigned), const char *,	      \
    struct a1_back_type *, struct x1f4_eelookup_type *
#define dump_abcdef_error_i_ARGS_1 \
    void *data, int (*this) (void *, const char *, unsigned),		      \
    const char *head, struct a1_back_type *back_data,			      \
    struct x1f4_eelookup_type *eelookup_data
#define dump_abcdef_error_i_ARGS_2 \
    data, this, head, back_data, eelookup_data

#define dump_abcdef_error_l_ARGS_0 \
    void *, int (*) (void *, const char *, unsigned),			      \
    struct a1_back_type *
#define dump_abcdef_error_l_ARGS_1 \
    void *data, int (*this) (void *, const char *, unsigned),		      \
    struct a1_back_type *back_data
#define dump_abcdef_error_l_ARGS_2 \
    data, this, back_data

static int dump_090818_error_0(dump_abcdef_error_l_ARGS_0);
static int dump_090818_error_1(dump_abcdef_error_l_ARGS_0);
static int dump_090818_error_2(dump_abcdef_error_l_ARGS_0);
static int dump_090818_error_3(dump_abcdef_error_l_ARGS_0);
static int dump_090818_error_4(dump_abcdef_error_l_ARGS_0);
static int dump_090818_error_5(dump_abcdef_error_l_ARGS_0);
static int dump_090818_error_6(dump_abcdef_error_l_ARGS_0);
static int dump_090819_error_0(dump_abcdef_error_l_ARGS_0);
static int dump_090819_error_1(dump_abcdef_error_l_ARGS_0);
static int dump_090819_error_2(dump_abcdef_error_l_ARGS_0);
static int dump_090819_error_3(dump_abcdef_error_l_ARGS_0);
static int dump_090820_error_0(dump_abcdef_error_e_ARGS_0);
static int dump_090821_error_0(dump_abcdef_error_l_ARGS_0);
static int dump_090822_error_0(dump_abcdef_error_l_ARGS_0);
static int dump_090822_error_1(dump_abcdef_error_l_ARGS_0);
static int dump_090822_error_3(dump_abcdef_error_l_ARGS_0);
static int dump_090822_error_4(dump_abcdef_error_l_ARGS_0);
static int dump_090822_error_5(dump_abcdef_error_l_ARGS_0);
static int dump_090828_error_0(dump_abcdef_error_l_ARGS_0);
static int dump_091210_error_0(dump_abcdef_error_l_ARGS_0);
static int dump_101114_error_0(dump_abcdef_error_l_ARGS_0);
static int dump_101115_error_0(dump_abcdef_error_e_ARGS_0);
static int dump_101115_error_1(dump_abcdef_error_l_ARGS_0);
static int dump_101116_error_0(dump_abcdef_error_i_ARGS_0);
static int dump_101116_error_1(dump_abcdef_error_i_ARGS_0);
static int dump_101116_error_2(dump_abcdef_error_i_ARGS_0);
static int dump_111111_error_0(dump_abcdef_error_i_ARGS_0);
static int dump_111221_error_0(dump_abcdef_error_l_ARGS_0);
static int dump_130414_error_0(dump_abcdef_error_l_ARGS_0);
static int dump_130806_error_0(dump_abcdef_error_i_ARGS_0);
static int dump_line(void *, int (*) (void *, const char *, unsigned),
		     const char *, unsigned, struct a1_back_type *,
		     const char *);
static int dump_type(void *, int (*) (void *, const char *, unsigned), int,
		     struct x1f4_eelookup_type *);

static int
dump_090818_error_0(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this(data, ": junk where function type expected", 35);

    return status;
}


static int
dump_090818_error_1(dump_abcdef_error_l_ARGS_1)
{
    int status;

    if (1) {
	status = this(data, ": unknown type `", 16);
	if (status) {
	} else {
	    status = this
		(data, back_data->line, back_data->data.misstype.size);
	    if (status) {
	    } else {
		status = this(data, "'", 1);
	    }
	}
    }

    return status;
}


static int
dump_090818_error_2(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this(data, ": junk where function name expected", 35);

    return status;
}


static int
dump_090818_error_3(dump_abcdef_error_l_ARGS_1)
{
    int status;

    if (1) {
	status = this(data, ": function `", 12);
	if (status) {
	} else {
	    status = this
		(data, back_data->line, back_data->data.misstype.size);
	    if (status) {
	    } else {
		status = this(data, "' already defined", 17);
	    }
	}
    }

    return status;
}


static int
dump_090818_error_4(dump_abcdef_error_l_ARGS_1)
{
    int status;

    if (1) {
	status = this(data, ": invalid function name (`", 26);
	if (status) {
	} else {
	    status = this
		(data, back_data->line, back_data->data.reserved.size);
	    if (status) {
	    } else {
		status = this(data, "')", 2);
	    }
	}
    }

    return status;
}


static int
dump_090818_error_5(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this
	(data, ": junk where function argument list leading parenthesis expe"
	 "cted", 64);

    return status;
}


static int
dump_090818_error_6(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this
	(data, ": junk where function argument list trailing parenthesis exp"
	 "ected", 65);

    return status;
}


static int
dump_090819_error_0(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this(data, ": junk where function argument list expected", 44);

    return status;
}


static int
dump_090819_error_1(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this(data, ": junk where function argument type expected", 44);

    return status;
}


static int
dump_090819_error_2(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this(data, ": improper (`void') type for function argument", 46);

    return status;
}


static int
dump_090819_error_3(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this(data, ": junk where function argument name expected", 44);

    return status;
}


static int
dump_090820_error_0(dump_abcdef_error_e_ARGS_1)
{
    int status;
    struct x1f4_c1record_type *c1record_data;
    unsigned here;

    c1record_data = &back_data->data.c_syntax.c1record;

    c1record_data->pick = back_data->pick;

    if (bits & HINT_MASK) {
	c1record_data->hint.data = back_data->hint.data;
	c1record_data->hint.rule = back_data->hint.rule;
	here = X1f4_C1_HINT_MASK;
    } else {
	here = 0;
    }

    status = x1f4_lame_program
	(data, this, head, here, c1record_data, eelookup_data);

    return status;
}


static int
dump_090821_error_0(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this(data, ": junk where function leading brace expected", 44);

    return status;
}


static int
dump_090822_error_0(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this(data, ": type of `main' is not `integer'", 33);

    return status;
}


static int
dump_090822_error_1(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this(data, ": argument list of `main' is not empty", 38);

    return status;
}


static int
dump_090822_error_3(dump_abcdef_error_l_ARGS_1)
{
    return this(data, "undefined function `main'", 25);
}


static int
dump_090822_error_4(dump_abcdef_error_l_ARGS_1)
{
    int status;

    if (1) {
	status = this(data, ": defined function argument name (`", 35);
	if (status) {
	} else {
	    status = this
		(data, back_data->line, back_data->data.lesslink.size);
	    if (status) {
	    } else {
		status = this(data, "')", 2);
	    }
	}
    }

    return status;
}


static int
dump_090822_error_5(dump_abcdef_error_l_ARGS_1)
{
    int status;

    if (1) {
	status = this(data, ": invalid function argument name (`", 35);
	if (status) {
	} else {
	    status = this
		(data, back_data->line, back_data->data.lesslink.size);
	    if (status) {
	    } else {
		status = this(data, "')", 2);
	    }
	}
    }

    return status;
}


static int
dump_090828_error_0(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this(data, ": junk where function trailing brace expected", 45);

    return status;
}


static int
dump_091210_error_0(dump_abcdef_error_l_ARGS_1)
{
    int status;

    if (1) {
	status = this(data, ": improper function type (`", 27);
	if (status) {
	} else {
	    status = this
		(data, back_data->line, back_data->data.flattype.size);
	    if (status) {
	    } else {
		status = this(data, "')", 2);
	    }
	}
    }

    return status;
}


static int
dump_101114_error_0(dump_abcdef_error_l_ARGS_1)
{
    int status;

    if (1) {
	status = this(data, ": never defined `", 17);
	if (status) {
	} else {
	    status = this
		(data, back_data->line, back_data->data.xdefined.size);
	    if (status) {
	    } else {
		status = this(data, "' function", 10);
	    }
	}
    }

    return status;
}


static int
dump_101115_error_0(dump_abcdef_error_e_ARGS_1)
{
    int status;

    if (1) {
	status = this(data, ": conflicting types for `", 25);
	if (status) {
	} else {
	    status = this
		(data, back_data->line, back_data->data.missline.size);
	    if (status) {
	    } else {
		status = this(data, "', previous declaration of `", 28);
		if (status) {
		} else {
		    status = this
			(data, back_data->line, back_data->data.missline.size);
		    if (status) {
		    } else {
			status = this(data, "' at ", 5);
			if (status) {
			} else {
			    status = dump_line
				(data, this, head, bits, back_data,
				 back_data->data.missline.fast);
			    if (status) {
			    } else {
				switch(back_data->data.missline.code) {
				case NAMECALL:
				    status = dump_101116_error_2
					(dump_abcdef_error_i_ARGS_2);
				    break;
				case NAMETYPE:
				    status = dump_101116_error_1
					(dump_abcdef_error_i_ARGS_2);
				    break;
				case SLIPTYPE:
				    status = dump_101116_error_0
					(dump_abcdef_error_i_ARGS_2);
				}
			    }
			}
		    }
		}
	    }
	}
    }

    return status;
}


static int
dump_101115_error_1(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this
	(data, ": junk where semicolon expected (after redeclaration of `",
	 57);
    if (status) {
    } else {
	status = this
	    (data, back_data->data.postfeat.fast,
	     back_data->data.postfeat.size);
	if (status) {
	} else {
	    status = this(data, "')", 2);
	}
    }

    return status;
}


static int
dump_101116_error_0(dump_abcdef_error_i_ARGS_1)
{
    int status;

    if (1) {
	status = this(data, " - function type changed from ", 30);
	if (status) {
	} else {
	    status = dump_type
		(data, this, back_data->data.missline.data.sliptype.slip,
		 eelookup_data);
	    if (status) {
	    } else {
		status = this(data, " to ", 4);
		if (status) {
		} else {
		    status = dump_type
			(data, this,
			 back_data->data.missline.data.sliptype.type,
			 eelookup_data);
		}
	    }
	}
    }

    return status;
}


static int
dump_101116_error_1(dump_abcdef_error_i_ARGS_1)
{
    int status;

    status = this(data, " - ", 3);
    if (status) {
    } else {
	unsigned name;

	name = back_data->data.missline.data.nametype.name;
	status = x1f4_vprint_dcardinal(data, this, name + 1);
	if (status) {
	} else {
	    char suffix[2];

	    x1f4_extend_ordinal(suffix, name);
	    status = this(data, suffix, 2);
	    if (status) {
	    } else {
		status = this(data, " parameter type changed from ", 29);
		if (status) {
		} else {
		    status = dump_type
			(data, this,
			 back_data->data.missline.data.nametype.slip,
			 eelookup_data);
		    if (status) {
		    } else {
			status = this(data, " to ", 4);
			if (status) {
			} else {
			    status = dump_type
				(data, this,
				 back_data->data.missline.data.nametype.type,
				 eelookup_data);
			}
		    }
		}
	    }
	}
    }

    return status;
}


static int
dump_101116_error_2(dump_abcdef_error_i_ARGS_1)
{
    int status;

    status = this(data, " - reference class changed for ", 31);
    if (status) {
    } else {
	unsigned name;

	name = back_data->data.missline.data.namecall.name;
	status = x1f4_vprint_dcardinal(data, this, name + 1);
	if (status) {
	} else {
	    char suffix[2];

	    x1f4_extend_ordinal(suffix, name);
	    status = this(data, suffix, 2);
	    if (status) {
	    } else {
		status = this(data, " parameter", 10);
	    }
	}
    }

    return status;
}


static int
dump_111111_error_0(dump_abcdef_error_i_ARGS_1)
{
    int status;

    if (1) {
	status =
	    this(data, ": non referable nor copyable, non intrinsic ", 44);
	if (status) {
	} else {
	    status = dump_type
		(data, this, back_data->data.misslead.type, eelookup_data);
	    if (status) {
	    } else {
		status = this(data, " used for function parameter", 28);
	    }
	}
    }

    return status;
}


static int
dump_111221_error_0(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this(data, ": ", 2);
    if (status) {
    } else {
	status = x1f4_stat_e4jack
	    (data, this, &back_data->data.higherof.ejrecord);
    }

    return status;
}


static int
dump_130414_error_0(dump_abcdef_error_l_ARGS_1)
{
    int status;

    if (1) {
	status = this
	    (data,
	     ": non referable nor copyable, non intrinsic function type (`",
	     60);
	if (status) {
	} else {
	    status = this
		(data, back_data->line, back_data->data.flattype.size);
	    if (status) {
	    } else {
		status = this(data, "')", 2);
	    }
	}
    }

    return status;
}


static int
dump_130806_error_0(dump_abcdef_error_i_ARGS_1)
{
    int status;

    if (1) {
	status = this(data, ": non declarable ", 17);
	if (status) {
	} else {
	    status = dump_type
		(data, this, back_data->data.sideline.type, eelookup_data);
	    if (status) {
	    } else {
		status = this
		    (data, " used for reference function parameter", 38);
	    }
	}
    }

    return status;
}


static int
dump_line(void *data, int (*this) (void *, const char *, unsigned),
	  const char *head, unsigned bits, struct a1_back_type *back_data,
	  const char *line)
{
    int status;

    if (bits & HINT_MASK) {
	status = back_data->hint.rule
	    (back_data->hint.data, back_data->pick, line - head);
    } else {
	const char *dana;
	unsigned byte, rank;

	rank = back_data->pick;

	byte = line - head;

	dana = head;
	while (byte) {
	    byte--;
	    if (*dana == 10) {
		rank++;
		head = dana;
	    }

	    dana++;
	}

	status = x1f4_vprint_dcardinal(data, this, rank);
    }

    return status;
}


static int
dump_type(void *data, int (*this) (void *, const char *, unsigned), int type,
	  struct x1f4_eelookup_type *eelookup_data)
{
    return x1f4_dump_type(data, this, type, eelookup_data);
}


int
x1f4_lame_shuffle(void *data, int (*this) (void *, const char *, unsigned),
		  const char *head, unsigned bits,
		  struct a1_back_type *back_data,
		  struct x1f4_eelookup_type *eelookup_data)
{
    int status;

    switch (back_data->code) {
    case C_SYNTAX:
	status = dump_090820_error_0
	    (data, this, head, bits, back_data, eelookup_data);
	break;
    case INTERNAL:
	status = this(data, "no description available", 24);
	break;
    case MISSMAIN:
	status = dump_090822_error_3(data, this, back_data);
	break;
    default:
	status = dump_line(data, this, head, bits, back_data, back_data->line);
	switch (back_data->code) {
	case FAILLINK:
	    status = dump_090819_error_3(data, this, back_data);
	    break;
	case FAILLIST:
	    status = dump_090819_error_0(data, this, back_data);
	    break;
	case FAILNAME:
	    status = dump_090818_error_2(data, this, back_data);
	    break;
	case FAILPOST:
	    status = dump_090819_error_1(data, this, back_data);
	    break;
	case FAILTYPE:
	    status = dump_090818_error_0(data, this, back_data);
	    break;
	case FLATTYPE:
	    status = dump_091210_error_0(data, this, back_data);
	    break;
	case HIGHEROF:
	    status = dump_111221_error_0(data, this, back_data);
	    break;
	case LESSLINK:
	    status = dump_090822_error_5(data, this, back_data);
	    break;
	case LOSELIST:
	    status = dump_090818_error_6(data, this, back_data);
	    break;
	case LOSETEXT:
	    status = dump_090828_error_0(data, this, back_data);
	    break;
	case MAINLIST:
	    status = dump_090822_error_1(data, this, back_data);
	    break;
	case MAINTYPE:
	    status = dump_090822_error_0(data, this, back_data);
	    break;
	case MISSLEAD:
	    status = dump_111111_error_0
		(data, this, head, back_data, eelookup_data);
	    break;
	case MISSLINE:
	    status = dump_101115_error_0
		(data, this, head, bits, back_data, eelookup_data);
	    break;
	case MISSLINK:
	    status = dump_090822_error_4(data, this, back_data);
	    break;
	case MISSNAME:
	    status = dump_090818_error_3(data, this, back_data);
	    break;
	case MISSTYPE:
	    status = dump_090818_error_1(data, this, back_data);
	    break;
	case NEARTYPE:
	    status = dump_130414_error_0(data, this, back_data);
	    break;
	case OPENLIST:
	    status = dump_090818_error_5(data, this, back_data);
	    break;
	case OPENTEXT:
	    status = dump_090821_error_0(data, this, back_data);
	    break;
	case POSTFEAT:
	    status = dump_101115_error_1(data, this, back_data);
	    break;
	case RESERVED:
	    status = dump_090818_error_4(data, this, back_data);
	    break;
	case SIDELINE:
	    status = dump_130806_error_0
		(data, this, head, back_data, eelookup_data);
	    break;
	case VOIDPOST:
	    status = dump_090819_error_2(data, this, back_data);
	    break;
	case XDEFINED:
	    status = dump_101114_error_0(data, this, back_data);
	}
    }

    return status;
}
