/*
 * a1.v.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <a1-defs.h>
#include <a1-inter.h>
#include <a1-types.h>
#include <c1i.h>
#include <e4.h>

static int text_line(struct a1_shuffle_type *, struct a1_link_type *,
		     struct a1_node_type *, void *, void **);

static int
text_line(struct a1_shuffle_type *shuffle_data, struct a1_link_type *link_data,
	  struct a1_node_type *node_data, void *context, void **used)
{
    int status = 0;

    if (1) {
	unsigned count;
	void *subtext[2];

	subtext[0] = context;
	subtext[1] = shuffle_data;

	count = node_data->linetext.function.count;
	for (; count; count--) {
	    int (*miss) (void **, struct a1_link_type *, void *);

	    miss = link_data->miss;
	    if (miss) {
		status = miss(subtext, link_data, used);
		if (status) {
		    if (1) {
			break;
		    }
		}
	    }

	    link_data++;
	}
    }

    return status;
}


int
x1f4_side_shuffle(struct a1_trans19_type **trans19,
		  struct a1_shuffle_type *shuffle_data, void *context)
{
    int excess, (*free) (void *, void *), status = 0;
    struct a1_lock_type *lock_data;
    struct a1_pipe_type *pipe_data;
    struct a1_trans19_type *trans19_data;
    void *text;

    trans19_data = *trans19;

    lock_data = trans19_data->e.lock;

    free = shuffle_data->m.free;
    text = shuffle_data->m.data;

    pipe_data = shuffle_data->back_pipe;

    while (lock_data) {
	struct a1_fast_type *fast_head;
	struct a1_lock_type *miss_lock;
	struct a1_node_type *node_data;
	struct x1f4_c1node_type *c1node_data;
	void *less, **link, *used;

	node_data = lock_data->node_data;

	miss_lock = lock_data->lock_data;

	c1node_data = lock_data->slip;
	if (c1node_data->data.data) {
	} else {
	    c1node_data++;
	}
	excess = x1f4_tail_expression
	    (c1node_data->data.data, &lock_data->port);
	if (excess) {
	    if (status) {
	    } else {
		status = excess;
	    }
	}

	fast_head = lock_data->fast_head;
	while (fast_head) {
	    struct a1_fast_type *fast_data;

	    fast_data = fast_head->fast_data;

	    excess = _x1f4_a1_miss_fast(shuffle_data, fast_head);
	    if (excess) {
		if (status) {
		} else {
		    status = excess;
		}
	    }

	    fast_head = fast_data;
	}

	link = trans19_data->i.link;

	used = *link;

	x1f4_mind_program(node_data->aime, trans19_data->i.used);

	if (pipe_data) {
	    _x1f4_a1_back_node(lock_data->function_data, pipe_data);
	}

	less = lock_data->lead;
	if (less) {
	    const struct x1f4_function_type *function_lead;
	    unsigned prefix;

	    prefix = node_data->linetext.function.count;
	    function_lead = lock_data->function_lead;
	    excess = _x1f4_a1_slip_side
		(shuffle_data, prefix, function_lead->count - prefix, less,
		 function_lead);
	    if (excess) {
		if (status) {
		} else {
		    status = excess;
		}
	    }
	}

	if (node_data->linetext.function.flags & X1f4_E4_SLIP_LIST) {
	    int excess;

	    excess = _x1f4_a1_slip_slip
		(shuffle_data, node_data->link_data, -1,
		 lock_data->function_lead,
		 &node_data->linetext.function, trans19_data->i.used);
	    if (excess) {
		if (status) {
		} else {
		    status = excess;
		}
	    }
	}

	less = node_data->link_data;
	if (less) {
	    excess = text_line
		(trans19_data->f.shuffle_data, less, node_data, context,
		 trans19_data->i.used);
	    if (excess) {
		if (status) {
		} else {
		    status = excess;
		}
	    }
	}

	trans19_data->i.link = used;
	trans19_data->i.used = (char *) used + sizeof(void *);

	excess = free(text, link);
	if (excess) {
	    if (status) {
	    } else {
		status = excess;
	    }
	}

	excess = free(text, lock_data);
	if (excess) {
	    if (status) {
	    } else {
		status = excess;
	    }
	}

	lock_data = miss_lock;
    }

    if (trans19_data->e.port) {
	excess = _x1f4_a1_miss_port(trans19_data);
	if (excess) {
	    if (status) {
	    } else {
		status = excess;
	    }
	}
    }

    if (pipe_data) {
	excess = _x1f4_a1_lose_node
	    (&shuffle_data->slip_node->linetext.function, pipe_data);
	if (excess) {
	    if (status) {
	    } else {
		status = excess;
	    }
	}
    }

    /*
     * FEATURES
     *
     * it is unfortunate that -main- state is cleared even for successful
     * execution
     */
    x1f4_mind_program(shuffle_data->slip_node->aime, trans19_data->i.used);

    excess = free(text, trans19_data->i.link);
    if (excess) {
	if (status) {
	} else {
	    status = excess;
	}
    }

    excess = free(text, trans19_data);
    if (excess) {
	if (status) {
	} else {
	    status = excess;
	}
    }

    return status;
}
