/*
 * a1.s.c
 * Copyright (C) 2008, 2009, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <a1-defs.h>
#include <a1-inter.h>
#include <a1-types.h>
#include <c1i.h>

static int pipe_slip(struct a1_node_type *, struct a1_shuffle_type *);

static int
pipe_slip(struct a1_node_type *node_data, struct a1_shuffle_type *shuffle_data)
{
    int status;
    struct a1_pipe_type *pipe_data;

    pipe_data = shuffle_data->pipe_long;
    if (pipe_data) {
	status = _x1f4_a1_fast_node(&node_data->linetext.function, pipe_data);
    } else {
	status = 0;
    }

    return status;
}


int
x1f4_near_shuffle(struct a1_trans19_type **trans19,
		  struct a1_shuffle_type *shuffle_data)
{
    int status;
    void *data;

    status = shuffle_data->m.link
	(shuffle_data->m.data, &data, sizeof(struct a1_trans19_type));
    if (status) {
	status = ALLOC_ERROR;
    } else {
	struct a1_node_type *slip_node;
	struct a1_trans19_type *trans19_data;
	void *used;

	trans19_data = data;

	slip_node = shuffle_data->slip_node;

	status = _x1f4_a1_line_node
	    (shuffle_data, slip_node, sizeof(void *), &used);
	if (status) {
	    shuffle_data->m.free(shuffle_data->m.data, data);
	} else {
	    void **link;

	    link = used;

	    used = (char *) used + sizeof(void *);

	    status = pipe_slip(slip_node, shuffle_data);
	    if (status) {
		x1f4_mind_program(slip_node->aime, used);

		shuffle_data->m.free(shuffle_data->m.data, link);

		shuffle_data->m.free(shuffle_data->m.data, data);
	    } else {
		*link = NULL;

		*trans19 = trans19_data;

		trans19_data->e.deck = NULL;
		trans19_data->e.lock = NULL;
		trans19_data->e.port = NULL;

		trans19_data->i.link = link;
		trans19_data->i.used = used;

		trans19_data->i.miss = (char *) used + slip_node->post;

		trans19_data->f.shuffle_data = shuffle_data;
	    }
	}
    }

    return status;
}
