/*
 * a1.q.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * NOTES, #1
 *
 * dispatched call completion failed, there's nothing left to do for the
 * function that made the call.  let it fail.  the error may still be trapped
 * by a function further down on the call stack.
 */

/*
 * NOTES, #2
 *
 * arguments are to be processed outside call observation.  it is done like
 * that by the non sequenced a1 interpreter.  the outer temporaries allocation
 * scope is needed by arguments processing.
 */

#include <stddef.h>
#include <string.h>

#include <a1-copy.h>
#include <a1-inter.h>
#include <a1-types.h>
#include <c1.h>
#include <c1i.h>
#include <e4.h>
#include <exerrors.h>

#define false(e)			0

#define copy_link(copy, call) \
    copy_miss((char *) used + (int) (copy)->datatext.link,		      \
	      (copy)->variable.type, (call))

typedef union link_type {
    X1f4_E4_C_MODE mode;
    X1f4_E4_C_REAL real;
    X1f4_E4_C_TEXT text;
    X1f4_E4_C_USER user;
} link_type;

extern const void *const x1f4_a1_walk_link;

static int case_back(struct a1_trans19_type *, struct x1f4_c1node_type *);
static int case_miss(struct a1_trans19_type *, struct x1f4_c1node_type *);
static int case_node(struct a1_trans19_type *, struct x1f4_c1node_type *);
static int case_slip(struct a1_trans19_type *, struct x1f4_c1node_type *, int);
static int copy_node(struct a1_trans19_type *, struct x1f4_c1node_type *,
		     int *);
static int deck_node(struct a1_trans19_type *, struct x1f4_transfer_type *);
static int ever_node(struct a1_trans19_type *, struct x1f4_c1node_type *,
		     int *);
static int fast_lock(struct a1_trans19_type *, struct a1_lock_type *, void *,
		     void *);
static int fast_node(struct a1_trans19_type *, struct x1f4_transfer_type *);
static int fast_port(struct a1_trans19_type *, struct a1_shuffle_type *,
		     struct a1_lock_type *, struct a1_fast_type **, int,
		     struct x1f4_dispatch_type **);
static int fine_last(struct a1_trans19_type *, struct x1f4_transfer_type *,
		     int *);
static int fine_link(struct a1_trans19_type *, struct x1f4_transfer_type *,
		     int *, int (*) (void *, void *, void **), unsigned);
static int head_node(struct a1_trans19_type *, struct x1f4_c1node_type *);
static int lead_back(struct a1_trans19_type *, struct x1f4_c1node_type *);
static int lead_miss(struct a1_trans19_type *, struct x1f4_c1node_type *);
static int lead_node(struct a1_trans19_type *, struct x1f4_c1node_type *);
static int link_aime(struct a1_trans19_type *, struct a1_node_type *,
		     struct x1f4_transfer_type *);
static int lock_node(struct a1_trans19_type *, struct x1f4_transfer_type *);
static int long_aime(struct a1_trans19_type *, struct a1_node_type *,
		     struct x1f4_transfer_type *);
static int lose_node(struct a1_trans19_type *, struct x1f4_c1node_type *);
static int miss_aime(struct a1_trans19_type *, struct a1_node_type *);
static int miss_line(struct a1_trans19_type *, struct a1_link_type *,
		     unsigned);
static int near_node(struct a1_trans19_type *, struct a1_node_type *,
		     struct a1_lock_type *);
static int pick_node(struct a1_trans19_type *, int);
static int pick_slip(struct a1_trans19_type *, int);
static int side_call(struct a1_trans19_type *,
		     const struct x1f4_function_type *);
static int slip_node(struct a1_trans19_type *);
static int tail_node(struct a1_trans19_type *, struct x1f4_c1node_type *);
static int text_line(struct a1_trans19_type *, struct a1_node_type *,
		     struct a1_link_type *);
static int type_line(struct a1_trans19_type *, struct a1_node_type *,
		     struct a1_link_type *, void **);

static int
case_back(struct a1_trans19_type *trans19_data,
	  struct x1f4_c1node_type *c1node_data)
{
    int status;

    if (0) {
    } else {
	int slipping = 0;

	status = copy_node(trans19_data, c1node_data, &slipping);
	if (status) {
	} else {
	    if (slipping) {
	    } else {
		status = tail_node(trans19_data, c1node_data + 1);
	    }
	}
    }

    return status;
}


static int
case_miss(struct a1_trans19_type *trans19_data,
	  struct x1f4_c1node_type *c1node_data)
{
    int status;

    status = head_node(trans19_data, c1node_data + 1);
    if (status) {
    } else {
	int slipping = 0;

	status = copy_node(trans19_data, c1node_data, &slipping);
	if (status) {
	} else {
	    if (slipping) {
	    } else {
		status = tail_node(trans19_data, c1node_data + 1);
	    }
	}
    }

    return status;
}


static int
case_node(struct a1_trans19_type *trans19_data,
	  struct x1f4_c1node_type *c1node_data)
{
    int status;

    if (c1node_data->state & X1f4_C1_1st_STATE) {
	status = case_miss(trans19_data, c1node_data);
    } else {
	int deck;

	status = x1f4_cast_expression
	    ((c1node_data + 1)->data.data, &deck, trans19_data->i.miss,
	     trans19_data->i.used);
	if (status) {
	} else {
	    case_slip(trans19_data, c1node_data, deck);
	}
    }

    return status;
}


static int
case_slip(struct a1_trans19_type *trans19_data,
	  struct x1f4_c1node_type *c1node_data, int deck)
{
    if (deck) {
	trans19_data->e.slip = c1node_data->c1node_data;
    } else {
	c1node_data++;
	trans19_data->e.slip = c1node_data->c1node_data->c1node_data;
    }

    return 0;
}


static int
copy_node(struct a1_trans19_type *trans19_data,
	  struct x1f4_c1node_type *c1node_data, int *sideline)
{
    int status;
    void *expression, *slip;

    expression = (c1node_data + 1)->data.data;

    slip = trans19_data->e.port;

    while (1) {
	int slipping;
	struct x1f4_transfer_type transfer;
	union link_type link;

	status = x1f4_span_expression
	    (expression, slip, 0, &slipping, &link, &transfer,
	     trans19_data->i.used);
	if (status) {
	    break;
	} else {
	    if (slipping) {
		status = fine_last(trans19_data, &transfer, sideline);
		if (*sideline) {
		    break;
		} else {
		    if (status) {
			break;
		    }
		}
	    } else {
		int type;

		type = x1f4_type_expression(expression);
		if (type == X1f4_E4_MODE) {
		    type = *(X1f4_E4_C_MODE *) &link;
		} else if (type == X1f4_E4_REAL) {
		    type = *(X1f4_E4_C_REAL *) &link ? 1 : 0;
		} else {
		    type = 1;
		}

		if (1) {
		    case_slip(trans19_data, c1node_data, type);
		    if (1) {
			*sideline = 0;
			if (1) {
			    break;
			}
		    }
		}
	    }
	}
    }

    return status;
}


static int
deck_node(struct a1_trans19_type *trans19_data,
	  struct x1f4_transfer_type *transfer_data)
{
    int status;

    do {
	struct a1_lock_type *lock_data;
	struct a1_node_type *node_data;
	struct a1_shuffle_type *shuffle_data;
	const struct x1f4_function_type *function_data;
	void **text;

	text = transfer_data->context;

	node_data = text[0];

	shuffle_data = trans19_data->f.shuffle_data;

	function_data = text[1];

	shuffle_data->s.function_data = function_data;

	transfer_data->context = node_data;

	status = lock_node(trans19_data, transfer_data);

	if (status) {
	    break;
	}

	lock_data = trans19_data->e.lock;

	lock_data->lead = shuffle_data->s.lead;
	lock_data->function_lead = function_data;
    } while (0);

    return status;
}


static int
ever_node(struct a1_trans19_type *trans19_data,
	  struct x1f4_c1node_type *c1node_data, int *sideline)
{
    int status;
    void *expression, *slip;

    expression = (c1node_data + 0)->data.data;

    slip = trans19_data->e.port;

    while (1) {
	int slipping;
	struct x1f4_transfer_type transfer;
	union link_type link;

	status = x1f4_span_expression
	    (expression, slip, 0, &slipping, &link, &transfer,
	     trans19_data->i.used);
	if (status) {
	    break;
	} else {
	    if (slipping) {
		status = fine_last(trans19_data, &transfer, sideline);
		if (*sideline) {
		    break;
		} else {
		    if (status) {
			break;
		    }
		}
	    } else {
		if (1) {
		    struct x1f4_c1node_type *c1node_slip;

		    c1node_slip = c1node_data->c1node_data;

		    if (c1node_slip) {
			struct a1_lock_type *lock_data;

			lock_data = trans19_data->e.lock;
			if (lock_data) {
			    void *expression;

			    x1f4_pick_program
				(lock_data->node_data->aime, &expression);
			    if (expression == c1node_data->data.data) {
				status = x1f4_last_expression
				    (c1node_slip->data.data,
				     trans19_data->i.miss,
				     trans19_data->i.used);
				if (status) {
				} else {
				    c1node_slip = c1node_slip->c1node_data;
				}
			    }
			}
		    }

		    trans19_data->e.slip = c1node_slip;
		    if (1) {
			*sideline = 0;
			if (1) {
			    break;
			}
		    }
		}
	    }
	}
    }

    return status;
}


static int
fast_lock(struct a1_trans19_type *trans19_data, struct a1_lock_type *lock_data,
	  void *dispatch, void *dispatched_output)
{
    int status;
    struct a1_shuffle_type *shuffle_data;
    void *fast;

    shuffle_data = trans19_data->f.shuffle_data;

    status = shuffle_data->m.link
	(shuffle_data->m.data, &fast, sizeof(struct a1_fast_type));
    if (status) {
	status = _x1f4_a1_stat_link(shuffle_data);
    } else {
	struct a1_fast_type *fast_data, *fast_tail;

	fast_data = fast;

	fast_data->fast_data = NULL;
	fast_data->dispatch_data = dispatch;
	fast_data->dispatched_output = dispatched_output;

	fast_tail = lock_data->fast_tail;

	lock_data->fast_tail = fast_data;

	if (fast_tail) {
	    fast_tail->fast_data = fast_data;
	} else {
	    lock_data->fast_head = fast_data;
	}
    }

    return status;
}


static int
fast_node(struct a1_trans19_type *trans19_data,
	  struct x1f4_transfer_type *transfer_data)
{
    int status;

    do {
	struct a1_pipe_type *pipe_data;
	struct a1_shuffle_type *shuffle_data;

	shuffle_data = trans19_data->f.shuffle_data;

	pipe_data = shuffle_data->pipe_long;
	if (pipe_data) {
	    const struct x1f4_function_type *function_data;

	    function_data = transfer_data->function_data;

	    do {
		status = pipe_data->pass.fast
		    (pipe_data->pass.text, function_data);
		if (status) {
		    status = X1f4_EX_CANNOT_CONTINUE;
		    break;
		}

		pipe_data = pipe_data->pipe_long;
	    } while (pipe_data);
	    if (pipe_data) {
		pipe_data = pipe_data->back_pipe;
		if (pipe_data) {
		    _x1f4_a1_back_node(function_data, pipe_data);
		}

		break;
	    }
	}

	status = 0;
    } while (0);

    return status;
}


static int
fast_port(struct a1_trans19_type *trans19_data,
	  struct a1_shuffle_type *shuffle_data, struct a1_lock_type *lock_data,
	  struct a1_fast_type **fast, int delete,
	  struct x1f4_dispatch_type **dispatch)
{
    int status;
    struct a1_fast_type *fast_head;
    struct x1f4_dispatch_type *dispatch_data;
    void *output;

    dispatch_data = *dispatch;

    fast_head = *fast;

    output = lock_data->dispatched_output;

    while (1) {
	delete = dispatch_data->call
	    (dispatch_data->back, delete, output, &dispatch_data);
	if (delete) {
	    if (delete == X1f4_EX_CAN_CONTINUE) {
		dispatch_data = NULL;
	    } else {
		status = delete;
		break;
	    }
	}
	{
	    if (dispatch_data) {
		int slipping = 0;

		delete = fine_last
		    (trans19_data, &dispatch_data->transfer, &slipping);
		if (delete) {
		    if (delete == X1f4_EX_CAN_CONTINUE) {
			/*
			 * no aime function failed (the aime function executors
			 * will not return CAN CONTINUE for failure)
			 */
		    } else {
			status = delete;
			break;
		    }
		} else {
		    if (slipping) {
			struct a1_lock_type *lock_text;

			lock_text = trans19_data->e.lock;

			if (lock_text->dispatch_data) {
			    status = fast_lock
				(trans19_data, lock_text, dispatch_data,
				 output);
			} else {
			    lock_text->dispatch_data = dispatch_data;
			    lock_text->dispatched_output = output;
			}
			if (fast_head) {
			    struct a1_fast_type *tail_fast;

			    tail_fast = lock_text->fast_tail;

			    lock_text->fast_tail = lock_data->fast_tail;

			    if (tail_fast) {
				tail_fast->fast_data = fast_head;
			    } else {
				lock_text->fast_head = fast_head;
			    }

			    fast_head = NULL;
			}

			status = delete;

			break;
		    }
		}
	    } else {
		if (fast_head) {
		    struct a1_fast_type *fast_data;

		    fast_data = fast_head;

		    fast_head = fast_head->fast_data;

		    dispatch_data = fast_data->dispatch_data;
		    output = fast_data->dispatched_output;

		    status = shuffle_data->m.free
			(shuffle_data->m.data, fast_data);
		    if (status) {
			status = _x1f4_a1_stat_free(shuffle_data);
		    }
		} else {
		    status = delete;
		    if (1) {
			break;
		    }
		}
	    }
	}
    }

    *fast = fast_head;

    *dispatch = dispatch_data;

    return status;
}


/*
 * NOTES
 *
 * the function does execute recursively.  If the WALK_LINK function(s)
 * recurse(s) for too many times, the stack will be overrun.  The condition can
 * (!?) be cured, and yet the functions are application introduced, and curing
 * application code is beyond scope here.
 */
static int
fine_last(struct a1_trans19_type *trans19_data,
	  struct x1f4_transfer_type *transfer_data, int *sideline)
{
    int (*function) (void *, void *, void **), status;
    const struct x1f4_function_type *function_data;

    function_data = transfer_data->function_data;

    function = function_data->function;

    if (function == _x1f4_a1_link_aime) {
	status = lock_node(trans19_data, transfer_data);
	if (status) {
	} else {
	    *sideline = 1;
	}
    } else {
	if (function == _x1f4_a1_deck_aime) {
	    status = deck_node(trans19_data, transfer_data);
	    if (status) {
	    } else {
		*sideline = 1;
	    }
	} else {
	    if (function) {
		if (function_data->flags & X1f4_E4_WALK_LINK) {
		    status = fine_link
			(trans19_data, transfer_data, sideline, function,
			 function_data->flags);
		} else {
		    void **input, *output;

		    input = transfer_data->input;
		    output = transfer_data->output;

		    input[-1] = trans19_data->i.used;

		    if (function_data->flags & X1f4_E4_TEXT_LINK) {
			status = function
			    (transfer_data->context, output, input);
		    } else {
			status = function(NULL, output, input);
		    }
		}
	    } else {
		status = _x1f4_a1_stat_miss(trans19_data->f.shuffle_data);
	    }
	}
    }

    return status;
}


static int
fine_link(struct a1_trans19_type *trans19_data,
	  struct x1f4_transfer_type *transfer_data, int *sideline,
	  int (*function) (void *, void *, void **), unsigned flags)
{
    int status;
    void *mid[3];

    mid[0] = transfer_data->output;
    mid[1] = transfer_data->input;

    transfer_data->input[-1] = trans19_data->i.used;

    if (flags & X1f4_E4_TEXT_LINK) {
	status = function
	    (transfer_data->context, (void *) x1f4_a1_walk_link, mid);
    } else {
	status = function(NULL, (void *) x1f4_a1_walk_link, mid);
    }
    if (status) {
    } else {
	struct x1f4_dispatch_type *dispatch_data;

	dispatch_data = mid[2];
	while (dispatch_data) {
	    status = fine_last
		(trans19_data, &dispatch_data->transfer, sideline);
	    if (*sideline) {
		if (false(status)) {
		} else {
		    struct a1_lock_type *lock_data;

		    lock_data = trans19_data->e.lock;

		    if (lock_data->dispatch_data) {
			status = fast_lock
			    (trans19_data, lock_data, dispatch_data,
			     transfer_data->output);
		    } else {
			lock_data->dispatch_data = dispatch_data;
			lock_data->dispatched_output = transfer_data->output;
		    }
		}

		break;
	    } else {
		if (status) {
		    if (status == X1f4_EX_CAN_CONTINUE) {
		    } else {
			break;
		    }
		}
		{
		    status = dispatch_data->call
			(dispatch_data->back, status, transfer_data->output,
			 &dispatch_data);
		    if (status) {
			if (status == X1f4_EX_CAN_CONTINUE) {
			    dispatch_data = NULL;
			} else {
			    break;
			}
		    }
		}
	    }
	}
    }

    return status;
}


static int
head_node(struct a1_trans19_type *trans19_data,
	  struct x1f4_c1node_type *c1node_data)
{
    return x1f4_land_expression
	(c1node_data->data.data, trans19_data->i.miss, &trans19_data->e.port);
}


static int
lead_back(struct a1_trans19_type *trans19_data,
	  struct x1f4_c1node_type *c1node_data)
{
    int status;

    if (0) {
    } else {
	int slipping = 0;

	status = ever_node(trans19_data, c1node_data, &slipping);
	if (status) {
	} else {
	    if (slipping) {
	    } else {
		status = tail_node(trans19_data, c1node_data + 0);
	    }
	}
    }

    return status;
}


static int
lead_miss(struct a1_trans19_type *trans19_data,
	  struct x1f4_c1node_type *c1node_data)
{
    int status;

    status = head_node(trans19_data, c1node_data + 0);
    if (status) {
    } else {
	int slipping = 0;

	status = ever_node(trans19_data, c1node_data, &slipping);
	if (status) {
	} else {
	    if (slipping) {
	    } else {
		status = tail_node(trans19_data, c1node_data + 0);
	    }
	}
    }

    return status;
}


static int
lead_node(struct a1_trans19_type *trans19_data,
	  struct x1f4_c1node_type *c1node_data)
{
    int status;

    if (c1node_data->state & X1f4_C1_1st_STATE) {
	status = lead_miss(trans19_data, c1node_data);
    } else {
	status = x1f4_last_expression
	    (c1node_data->data.data, trans19_data->i.miss,
	     trans19_data->i.used);
	if (status) {
	} else {
	    if (c1node_data == trans19_data->e.deck) {
		c1node_data = c1node_data->c1node_data;
		status = x1f4_last_expression
		    (c1node_data->data.data, trans19_data->i.miss,
		     trans19_data->i.used);
		if (status) {
		} else {
		    trans19_data->e.slip = c1node_data->c1node_data;
		}
	    } else {
		trans19_data->e.slip = c1node_data->c1node_data;
	    }
	}
    }

    return status;
}


static int
link_aime(struct a1_trans19_type *trans19_data, struct a1_node_type *node_data,
	  struct x1f4_transfer_type *transfer_data)
{
    int status;

    status = long_aime(trans19_data, node_data, transfer_data);
    if (status) {
    } else {
	status = fast_node(trans19_data, transfer_data);
	if (status) {
	    miss_aime(trans19_data, node_data);
	}
    }

    return status;
}


static int
lock_node(struct a1_trans19_type *trans19_data,
	  struct x1f4_transfer_type *transfer_data)
{
    int status;
    struct a1_shuffle_type *shuffle_data;
    void *lock;

    shuffle_data = trans19_data->f.shuffle_data;

    status = shuffle_data->m.link
	(shuffle_data->m.data, &lock, sizeof(struct a1_lock_type));
    if (status) {
	status = _x1f4_a1_stat_link(shuffle_data);
    } else {
	struct a1_lock_type *lock_data;
	struct a1_node_type *node_data;
	void *used;

	lock_data = lock;

	node_data = transfer_data->context;

	status = _x1f4_a1_line_node
	    (shuffle_data, node_data, sizeof(void *), &used);
	if (status) {
	    shuffle_data->m.free(shuffle_data->m.data, lock);
	} else {
	    trans19_data->i.used = (char *) used + sizeof(void *);

	    status = link_aime(trans19_data, node_data, transfer_data);

	    if (status) {
		trans19_data->i.used =
		    (char *) trans19_data->i.link + sizeof(void *);

		shuffle_data->m.free(shuffle_data->m.data, used);
		shuffle_data->m.free(shuffle_data->m.data, lock);
	    } else {
		struct x1f4_c1node_type *c1node_data;
		void *aime, **link;

		link = used;

		*link = trans19_data->i.link;

		aime = node_data->aime;

		x1f4_node_program(aime, &c1node_data);

		lock_data->fail_node = shuffle_data->fail_node;

		lock_data->c1node_deck = trans19_data->e.deck;

		lock_data->lock_data = trans19_data->e.lock;

		lock_data->slip = trans19_data->e.slip;

		lock_data->port = trans19_data->e.port;

		shuffle_data->fail_node = node_data;

		trans19_data->e.port = NULL;

		trans19_data->e.lock = lock_data;

		trans19_data->e.slip = c1node_data;

		trans19_data->i.link = used;

		trans19_data->i.miss =
		    (char *) trans19_data->i.used + node_data->post;

		lock_data->fast_head = NULL;
		lock_data->fast_tail = NULL;

		lock_data->lead = NULL;

		lock_data->node_data = node_data;

		lock_data->output = transfer_data->output;

		lock_data->dispatch_data = NULL;

		lock_data->function_data = transfer_data->function_data;

		x1f4_land_program(aime, &c1node_data);
		if (c1node_data) {
		    if (c1node_data->c1node_data) {
		    } else {
			c1node_data = NULL;
		    }
		}

		trans19_data->e.deck = c1node_data;
	    }
	}
    }

    return status;
}


static int
long_aime(struct a1_trans19_type *trans19_data, struct a1_node_type *node_data,
	  struct x1f4_transfer_type *transfer_data)
{
    int status = 0;

    do {
	struct a1_link_type *link_data;
	struct a1_shuffle_type *shuffle_data;
	void *line = NULL;

	shuffle_data = trans19_data->f.shuffle_data;

	link_data = node_data->link_data;

	if (link_data) {
	    status = type_line
		(trans19_data, node_data, link_data, transfer_data->input);
	    if (status) {
		break;
	    }
	}

	if (transfer_data->function_data->function == _x1f4_a1_deck_aime) {
	    const struct x1f4_function_type *function_data;
	    unsigned prefix, offset;

	    prefix = node_data->linetext.function.count;

	    function_data = shuffle_data->s.function_data;

	    offset = function_data->count - prefix;
	    if (node_data->linetext.function.flags & X1f4_E4_SLIP_LIST) {
		status = _x1f4_a1_lead_slip
		    (shuffle_data, transfer_data->input, node_data->link_data,
		     function_data, &node_data->linetext.function,
		     trans19_data->i.used);
		if (status) {
		    text_line(trans19_data, node_data, node_data->link_data);
		    break;
		} else {
		}
	    }
	    if (offset) {
		status = _x1f4_a1_lead_side
		    (shuffle_data, offset, transfer_data->input, prefix, &line,
		     function_data);
		if (status) {
		    if (node_data->linetext.function.flags
			& X1f4_E4_SLIP_LIST) {
			_x1f4_a1_slip_slip
			    (shuffle_data, node_data->link_data, -1,
			     function_data, &node_data->linetext.function,
			     trans19_data->i.used);
			text_line
			    (trans19_data, node_data, node_data->link_data);
		    }

		    break;
		}
	    }
	}

	shuffle_data->s.lead = line;
    } while (0);

    return status;
}


static int
lose_node(struct a1_trans19_type *trans19_data,
	  struct x1f4_c1node_type *c1node_data)
{
    int status;

    if (c1node_data->data.data) {
	status = lead_back(trans19_data, c1node_data);
    } else {
	status = case_back(trans19_data, c1node_data);
    }

    return status;
}


static int
miss_aime(struct a1_trans19_type *trans19_data, struct a1_node_type *node_data)
{
    int status;

    do {
	struct a1_shuffle_type *shuffle_data;

	shuffle_data = trans19_data->f.shuffle_data;

	if (1) {
	    void *text;

	    text = shuffle_data->s.lead;
	    if (text) {
		const struct x1f4_function_type *function_lead;
		unsigned prefix;

		prefix = node_data->linetext.function.count;
		function_lead = shuffle_data->s.function_data;
		status = _x1f4_a1_slip_side
		    (shuffle_data, prefix, function_lead->count - prefix, text,
		     function_lead);
		if (status) {
		    break;
		}
	    } else {
		status = 0;
	    }
	    if (node_data->linetext.function.flags & X1f4_E4_SLIP_LIST) {
		int excess;

		excess = _x1f4_a1_slip_slip
		    (shuffle_data, node_data->link_data, -1,
		     shuffle_data->s.function_data,
		     &node_data->linetext.function, trans19_data->i.used);
		if (excess) {
		    if (status) {
		    } else {
			status = excess;
		    }

		    break;
		}
	    }
	}

	if (1) {
	    struct a1_link_type *link_data;

	    link_data = node_data->link_data;
	    if (link_data) {
		status = text_line(trans19_data, node_data, link_data);
		if (status) {
		    break;
		}
	    }
	}
    } while (0);

    return status;
}


static int
miss_line(struct a1_trans19_type *trans19_data, struct a1_link_type *link_data,
	  unsigned count)
{
    int status = 0;

    if (1) {
	void *subtext[2], *used;

	subtext[1] = trans19_data->f.shuffle_data;

	used = trans19_data->i.used;

	for (; count; count--) {
	    int (*miss) (void **, struct a1_link_type *, void *);

	    link_data--;

	    miss = link_data->miss;
	    if (miss) {
		status = miss(subtext, link_data, used);
		if (status) {
		    if (1) {
			break;
		    }
		}
	    }
	}
    }

    return status;
}


static int
near_node(struct a1_trans19_type *trans19_data, struct a1_node_type *node_data,
	  struct a1_lock_type *lock_data)
{
    const struct x1f4_function_type *function_data;

    function_data = lock_data->function_data;
    if (function_data->type == X1f4_E4_VOID) {
    } else {
	void *expression;

	x1f4_pick_program(node_data->aime, &expression);
	if (1) {
	    x1f4_fast_expression
		(expression, trans19_data->i.miss, lock_data->output);
	}
    }

    return 0;
}


static int
pick_node(struct a1_trans19_type *trans19_data, int delete)
{
    int excess, status;
    struct a1_lock_type *lock_data;
    struct a1_node_type *node_data;
    struct x1f4_c1node_type *c1node_data;

    lock_data = trans19_data->e.lock;

    node_data = lock_data->node_data;

    if (delete) {
    } else {
	near_node(trans19_data, node_data, lock_data);
    }

    c1node_data = lock_data->slip;

    trans19_data->e.deck = lock_data->c1node_deck;

    trans19_data->e.lock = lock_data->lock_data;

    trans19_data->e.port = lock_data->port;

    trans19_data->e.slip = c1node_data;

    status = side_call(trans19_data, lock_data->function_data);

    excess = miss_aime(trans19_data, node_data);
    if (excess) {
	if (status) {
	} else {
	    status =  excess;
	}
    }

    if (0) {
    } else {
	struct a1_fast_type *fast_head;
	struct a1_lock_type *lock_text;
	struct a1_shuffle_type *shuffle_data;
	void **link, *used;

	shuffle_data = trans19_data->f.shuffle_data;

	shuffle_data->fail_node = lock_data->fail_node;

	lock_text = trans19_data->e.lock;
	if (lock_text) {
	    shuffle_data->s.function_data = lock_text->function_lead;
	    shuffle_data->s.lead = lock_text->lead;
	} else {
	}

	fast_head = lock_data->fast_head;

	link = trans19_data->i.link;

	used = *link;

	trans19_data->i.link = used;
	trans19_data->i.used = (char *) used + sizeof(void *);

	trans19_data->i.miss =
	    (char *) trans19_data->i.used + shuffle_data->fail_node->post;

	if (1) {
	    if (status) {
	    } else {
		do {
		    struct x1f4_dispatch_type *dispatch_data;

		    dispatch_data = lock_data->dispatch_data;
		    if (dispatch_data) {
			status = fast_port
			    (trans19_data, shuffle_data, lock_data, &fast_head,
			     delete, &dispatch_data);
			if (1) {
			    delete = 0;
			    if (status) {
				/*
				 * See NOTES, #1
				 */
				break;
			    } else {
				if (dispatch_data) {
				    break;
				}
			    }
			}
		    } else {
			if (delete) {
			    status = delete;
			    if (1) {
				break;
			    }
			}
		    }

		    status = lose_node(trans19_data, c1node_data);
		} while (0);
	    }
	}

	if (fast_head) {
	    excess = _x1f4_a1_miss_fast(shuffle_data, fast_head);
	    if (excess) {
		if (status) {
		} else {
		    status = excess;
		}
	    }
	}

	excess = shuffle_data->m.free(shuffle_data->m.data, link);
	if (excess) {
	    if (status) {
	    } else {
		status = _x1f4_a1_stat_free(shuffle_data);
	    }
	}

	excess = shuffle_data->m.free(shuffle_data->m.data, lock_data);
	if (excess) {
	    if (status) {
	    } else {
		status = _x1f4_a1_stat_free(shuffle_data);
	    }
	}
    }

    return status;
}


static int
pick_slip(struct a1_trans19_type *trans19_data, int status)
{
    while (status == X1f4_EX_CAN_CONTINUE) {
	if (trans19_data->e.port) {
	    int excess;

	    excess = _x1f4_a1_miss_port(trans19_data);
	    if (excess) {
		if (false(excess == X1f4_EX_CAN_CONTINUE)) {
		} else {
		    status = excess;
		    if (1) {
			break;
		    }
		}
	    } else {
		trans19_data->e.port = NULL;
	    }
	}

	if (trans19_data->e.lock) {
	    struct a1_lock_type *lock_data;

	    lock_data = trans19_data->e.lock;
	    status = x1f4_mind_program
		(lock_data->node_data->aime, trans19_data->i.used);
	    if (status) {
		if (status == X1f4_EX_CAN_CONTINUE) {
		} else {
		    break;
		}
	    }

	    status = pick_node(trans19_data, X1f4_EX_CAN_CONTINUE);
	} else {
	    break;
	}
    }

    return status;
}


static int
side_call(struct a1_trans19_type *trans19_data,
	  const struct x1f4_function_type *function_data)
{
    int status;

    do {
	struct a1_pipe_type *pipe_data;

	pipe_data = trans19_data->f.shuffle_data->back_pipe;

	if (pipe_data) {
	    do {
		status = pipe_data->pass.lose
		    (pipe_data->pass.text, function_data);
		if (status) {
		    status = X1f4_EX_CANNOT_CONTINUE;
		    break;
		}

		pipe_data = pipe_data->back_pipe;
	    } while (pipe_data);
	    if (pipe_data) {
		pipe_data = pipe_data->back_pipe;
		if (pipe_data) {
		    _x1f4_a1_back_node(function_data, pipe_data);
		}

		break;
	    }
	}

	status = 0;
    } while (0);

    return status;
}


static int
slip_node(struct a1_trans19_type *trans19_data)
{
    int status;
    struct x1f4_c1node_type *c1node_data;

    c1node_data = trans19_data->e.slip;
    if (c1node_data->data.data) {
	status = lead_node(trans19_data, c1node_data);
    } else {
	if ((c1node_data + 1)->data.data) {
	    status = case_node(trans19_data, c1node_data);
	} else {
	    c1node_data++;
	    trans19_data->e.slip = c1node_data->c1node_data;
	    status = 0;
	}
    }

    return status;
}


static int
tail_node(struct a1_trans19_type *trans19_data,
	  struct x1f4_c1node_type *c1node_data)
{
    int status;

    status = x1f4_tail_expression
	(c1node_data->data.data, &trans19_data->e.port);
    if (status) {
    } else {
	trans19_data->e.port = NULL;
    }

    return status;
}


static int
text_line(struct a1_trans19_type *trans19_data, struct a1_node_type *node_data,
	  struct a1_link_type *link_data)
{
    int status = 0;

    if (1) {
	unsigned count;
	void *subtext[2], *used;

	subtext[1] = trans19_data->f.shuffle_data;

	used = trans19_data->i.used;

	count = node_data->linetext.function.count;
	for (; count; count--) {
	    int (*miss) (void **, struct a1_link_type *, void *);

	    miss = link_data->miss;
	    if (miss) {
		status = miss(subtext, link_data, used);
		if (status) {
		    if (1) {
			break;
		    }
		}
	    }

	    link_data++;
	}
    }

    return status;
}


static int
type_line(struct a1_trans19_type *trans19_data, struct a1_node_type *node_data,
	  struct a1_link_type *link_data, void **input)
{
    int status = 0;

    if (1) {
	unsigned count;
	void *subtext[4], *used;

	subtext[1] = trans19_data->f.shuffle_data;
	subtext[2] = NULL;
	subtext[3] = NULL;

	used = trans19_data->i.used;

	count = node_data->linetext.function.count;
	for (; count; count--) {
	    int (*line) (void **, void **, struct a1_link_type *, void *);

	    line = link_data->line;
	    if (line) {
		status = line(subtext, input, link_data, used);
		if (status) {
		    miss_line
			(trans19_data, link_data,
			 node_data->linetext.function.count - count);
		    if (1) {
			break;
		    }
		}
	    } else {
		copy_link(link_data, *input);
	    }

	    input++;

	    link_data++;
	}
    }

    return status;
}


int
x1f4_slip_shuffle(struct a1_trans19_type *trans19_data)
{
    int status;

    if (trans19_data->e.slip) {
	status = slip_node(trans19_data);
    } else {
	status = pick_node(trans19_data, 0);
    }
    if (status) {
	status = pick_slip(trans19_data, status);
    }

    return status;
}
