/*
 * a1.n.c
 * Copyright (C) 2007-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <a1-inter.h>
#include <a1-types.h>
#include <e4.h>

#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

int
_x1f4_a1_lead_text(void **context, void **call, struct a1_link_type *link_data,
		   void *used)
{
    int status;
    struct a1_shuffle_type *shuffle_data;
    unsigned size;
    void *data, *text;

    shuffle_data = context[1];

    data = I_TEXT(*call);

    size = strlen(data) + 1;
    status = shuffle_data->m.link(shuffle_data->m.data, &text, size);
    if (status) {
	status = _x1f4_a1_stat_link(shuffle_data);
    } else {
	memcpy(text, data, size);
	l_TEXT(text, (char *) used + (int) link_data->datatext.link);
    }

    return status;
}
