/*
 * a1.k.c
 * Copyright (C) 2006-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <a1-types.h>
#include <c1i.h>

int
x1f4_look_shuffle(struct a1_trans19_type *trans19_data, unsigned *line)
{
    struct x1f4_c1node_type *c1node_data;

    c1node_data = trans19_data->e.slip;

    if (c1node_data) {
	struct a1_lock_type *lock_data;
	unsigned deck;

	lock_data = trans19_data->e.lock;

	deck = c1node_data->state & X1f4_C1_LINE_COPY;
	if (lock_data) {
	    deck += lock_data->node_data->offset;
	} else {
	    deck += trans19_data->f.shuffle_data->slip_node->offset;
	}

	*line = deck;
    } else {
	*line = 0;
    }

    return 0;
}
