/*
 * a1.j.c
 * Copyright (C) 2006-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <a1-inter.h>
#include <a1-types.h>
#include <c1.h>
#include <c1i.h>

int
x1f4_ever_shuffle(struct a1_shuffle_type *shuffle_data, void *output)
{
    int status;
    struct a1_node_type *slip_node;
    void *used;

    slip_node = shuffle_data->slip_node;
    shuffle_data->fail_node = slip_node;

    shuffle_data->z.note = NULL;

    status = _x1f4_a1_push_node(shuffle_data, slip_node, &used);
    if (status) {
    } else {
	status = x1f4_east_program(slip_node->aime, output, used);
	status = _x1f4_a1_pass_node(shuffle_data, slip_node, used, status);
    }

    return status;
}
