/*
 * a1.h
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_a1_H__
#define __LIBx1f4_a1_H__

#include <e4.h>
#include <frame.h>
#include <track.h>

/*
 * generation flag definitions
 */
#define X1f4_A1_BCOLLECT		(1L << 0x00)
#define X1f4_A1_CASTTYPE		(1L << 0x01)
#define X1f4_A1_COMPOSER		(1L << 0x02)
#define X1f4_A1_DDACCESS		(1L << 0x03)
#define X1f4_A1_EELOOKUP		(1L << 0x04)
#define X1f4_A1_IMPLICIT		(1L << 0x06)
#define X1f4_A1_LEADCAST		(1L << 0x07)
#define X1f4_A1_OPTIMIZE		(1L << 0x08)
#define X1f4_A1_RESOURCE		(1L << 0x09)
#define X1f4_A1_SCOMMENT		(1L << 0x0a)
#define X1f4_A1_SIDELIST		(1L << 0x0b)
#define X1f4_A1_TEXTFLAT		(1L << 0x0c)
#define X1f4_A1_TRANSFER		(1L << 0x0d)
#define X1f4_A1_TYPELIST		(1L << 0x0e)

typedef struct x1f4_a1_type {
    struct x1f4_track_type textflat_set;
    struct {
	struct x1f4_eelookup_type *eelookup_data;
    } eelookup_set;
    struct {
	int (*fix) (const void *, const struct x1f4_function_type *, void **),
	    (*get) (const char *, unsigned, const void *,
		    const struct x1f4_function_type **);
	const void *context;
    } function_set;
    struct {
	const void *context;
    } variable_set;
    struct {
	int (*get) (void *, int, int, const struct x1f4_operator_type **);
	const void *context;
    } implicit_set;
    struct {
	int (*get) (void *, int, int, const struct x1f4_linetext_type **);
	const void *context;
    } composer_set;
    struct {
	struct x1f4_a1record_type *a1record_data;
    } bcollect_set;
    struct {
	void *fine;
    } transfer_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *context;
    } resource_set;
    struct {
	int (*link) (void *, void **, unsigned),
	    (*pick) (void *, void ***, int (*) (void *), unsigned, void **);
	void *context;
    } autolead_set;
    struct {
	const void *miss;
    } datatype_set;
    struct {
	const void *miss;
    } sidetype_set;
    struct x1f4_frame_type autolink_set;
    const struct x1f4_operator_type *const *operator1s, *const *operator2s;
    void *context;
} x1f4_a1_type;

typedef struct x1f4_a1screen_type {
    int (*back) (void *, const struct x1f4_function_type *),
	(*fast) (void *, const struct x1f4_function_type *),
	(*lose) (void *, const struct x1f4_function_type *);
    void *data;
} x1f4_a1screen_type;

extern int x1f4_init_shuffle
    (void **, const char *, unsigned, const struct x1f4_a1_type *);
extern int x1f4_pipe_shuffle
    (void *, struct x1f4_a1screen_type *);

#endif				/* __LIBx1f4_a1_H__ */
