/*
 * a1.d.c
 * Copyright (C) 2011-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <a1-inter.h>
#include <a1-types.h>
#include <e4.h>

int
_x1f4_a1_side_aime(void *context, void *data, void **text)
{
    int (*link) (void *, void **, unsigned), status;
    struct a1_node_type *node_data;
    struct a1_shuffle_type *shuffle_data;
    struct x1f4_function_type *function_data;
    void *near;

    node_data = context;

    function_data = data;

    function_data->function = _x1f4_a1_deck_aime;

    shuffle_data = *text;

    link = shuffle_data->v.link;
    if (link) {
	status = link(shuffle_data->v.data, &near, sizeof(void *) << 1);
	if (status) {
	} else {
	    void **side;

	    side = near;

	    *text = side;

	    *side = node_data;
	    side[1] = function_data;
	}
    } else {
	status = shuffle_data->m.link
	    (shuffle_data->m.data, &near,
	     sizeof(struct a1_flat_type) + (sizeof(void *) << 1));
	if (status) {
	    status = _x1f4_a1_stat_link(shuffle_data);
	} else {
	    struct a1_flat_type *flat_data;
	    void **side;

	    flat_data = near;

	    side = (void *) (flat_data + 1);

	    *text = side;

	    *side = node_data;
	    side[1] = function_data;

	    flat_data->flat_data = shuffle_data->flat_data;
	    shuffle_data->flat_data = flat_data;
	}
    }

    return status;
}
