/*
 * a1.a.c
 * Copyright (C) 2006-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <a1-inter.h>
#include <a1-types.h>
#include <c1.h>
#include <c1i.h>
#include <e4.h>

int
x1f4_long_shuffle(struct a1_shuffle_type *shuffle_data, int *note, void *back,
		  int (*call) (void *), void *output)
{
    int status;
    struct a1_node_type *slip_node;
    void *used;

    slip_node = shuffle_data->slip_node;
    shuffle_data->fail_node = slip_node;

    shuffle_data->z.back = back;
    shuffle_data->z.call = call;
    shuffle_data->z.note = note;

    status = _x1f4_a1_push_node(shuffle_data, slip_node, &used);
    if (status) {
    } else {
	status = x1f4_lift_program
	    (slip_node->aime, note, back, call, output, used);
	status = _x1f4_a1_pass_node(shuffle_data, slip_node, used, status);
    }

    return status;
}
