/*
 * a1.7.6.c
 * Copyright (C) 2006-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <a1-defs.h>
#include <a1-parse.h>
#include <e4.h>
#include <mxdeck.h>
#include <string.h>

#define parser(text) \
    ((struct a1_parser_type *) (text))

int
_x1f4_a1_pick_last(const char *name, unsigned size, const void *context)
{
    int delete;
    const struct x1f4_function_type *function_data;

    delete = parser(context)->get
	(name, size, parser(context)->context, &function_data);
    if (delete) {
	void *function_tree;

	function_tree = parser(context)->function_tree;
	if (1) {
	    const void *node;

	    delete = x1f4_find_mxpath(function_tree, name, size, &node);
	    if (delete) {
		parser(context)->node_text = (void *) node;

		delete = 0;
	    } else {
		parser(context)->node_text = NULL;

		delete = 1;

		if (parser(context)->flags & CASTTYPE_LINK) {
		    if (size == 3) {
			if (memcmp(name, "set", 3)) {
			} else {
			    delete = 0;
			}
		    } else {
			if (size == 4) {
			    if (memcmp(name, "lead", 4)) {
			    } else {
				delete = 0;
			    }
			} else {
			    if (size == 5) {
				if (memcmp(name, "count", 5)) {
				    if (memcmp(name, "xcall", 5)) {
				    } else {
					delete = 0;
				    }
				} else {
				    delete = 0;
				}
			    }
			}
		    }
		}
	    }
	}
    } else {
	parser(context)->node_text = NULL;
    }

    return delete;
}
