/*
 * a1.7.1.c
 * Copyright (C) 2006-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <a1-defs.h>
#include <a1-parse.h>
#include <e4.h>
#include <mxdeck.h>
#include <string.h>
#include <tcvset.h>

#define parser(text) \
    ((struct a1_parser_type *) (text))

#define tccase(vset) \
    ((struct x1f4_tccase_type *) (vset))

extern const struct x1f4_function_type _x1f4_a1_l_c, *_x1f4_a1_l_l,
    _x1f4_a1_l_s, _x1f4_a1_l_x;

int
_x1f4_a1_fix_last(const void *context,
		  const struct x1f4_function_type *function_data,
		  void **subtext)
{
#if 1
    /* calling ->fix is still required */

    int status;

    if (parser(context)->node_text) {
	*subtext = parser(context)->node_text;

	status = 0;
    } else {
	status = parser(context)->fix
	    (parser(context)->context, function_data, subtext);
    }

    return status;
#else
    *subtext = (void *)
	((const struct x1f4_linetext_type *)
	 ((const char *) function_data
	  - offsetof(struct x1f4_linetext_type, function)))->context;

    return 0;
#endif
}


int
_x1f4_a1_get_last(const char *name, unsigned size, const void *context,
		  const struct x1f4_function_type **function)
{
    int delete;

    delete = parser(context)->get
	(name, size, parser(context)->context, function);
    if (delete) {
	void *function_tree;

	function_tree = parser(context)->function_tree;
	if (1) {
	    const void *node;

	    delete = x1f4_find_mxpath(function_tree, name, size, &node);
	    if (delete) {
		struct a1_node_type *node_text;
		void *line;

		parser(context)->node_text = (void *) node;

		node_text = (void *) node;

		*function = &node_text->linetext.function;

		delete = parser(context)->m.link
		    (parser(context)->m.data, &line,
		     sizeof(struct a1_line_type));
		if (delete) {
		} else {
		    struct a1_line_type *line_data;
		    struct a1_node_type *node_data;

		    node_data = parser(context)->node_data;

		    line_data = line;

		    line_data->line_data = node_data->line_data;
		    line_data->node = (void *) &node_text->linetext;
		    node_data->line_data = line_data;

		    delete = tccase(node_text->leadnode.line.text)->push
			(&node_text->leadnode.line.pset,
			 &node_text->leadnode.line.text,
			 &node_data->leadnode.link,
			 (void *) &parser(context)->m);
		    if (delete) {
		    } else {
			node_text->leadnode.line.call++;
		    }
		}
	    } else {
		parser(context)->node_text = NULL;

		delete = 1;

		if (parser(context)->flags & CASTTYPE_LINK) {
		    if (size == 3) {
			if (memcmp(name, "set", 3)) {
			} else {
			    *function = &_x1f4_a1_l_s;

			    delete = 0;
			}
		    } else {
			if (size == 4) {
			    if (memcmp(name, "lead", 4)) {
			    } else {
				*function = _x1f4_a1_l_l;

				delete = 0;
			    }
			} else {
			    if (size == 5) {
				if (memcmp(name, "count", 5)) {
				    if (memcmp(name, "xcall", 5)) {
				    } else {
					*function = &_x1f4_a1_l_x;

					delete = 0;
				    }
				} else {
				    *function = &_x1f4_a1_l_c;

				    delete = 0;
				}
			    }
			}
		    }
		}
	    }
	}
    } else {
	parser(context)->node_text = NULL;
    }

    return delete;
}
