/*
 * a1.6.c
 * Copyright (C) 2008-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <a1-defs.h>
#include <ctype.0.h>

#define A_TYPE_X(c_type_x, c) \
    (!C_TYPE_X((c_type_x), (c)))

static void way_far(const char **);
static void way_new(const char **);
static void way_red(const char **);

static const unsigned c_type_1[] = {
/*
 *
 *
 *
 *
 *   A B C D E F G H I J K L M N O
 * P Q R S T U V W X Y Z         _
 *   a b c d e f g h i j k l m n o
 * p q r s t u v w x y z
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00000000, 0x00000000, 0x87fffffe, 0x07fffffe,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
}, c_type_2[] = {
/*
 *
 *
 *
 * 0 1 2 3 4 5 6 7 8 9
 *   A B C D E F G H I J K L M N O
 * P Q R S T U V W X Y Z         _
 *   a b c d e f g h i j k l m n o
 * p q r s t u v w x y z
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00000000, 0x03ff0000, 0x87fffffe, 0x07fffffe,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
}, c_type_4[] = {
/*
 *                   . .     .
 *
 * .
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00002600, 0x00000001, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
};

static void
way_far(const char **deck)
{
    const char *e;
    unsigned c;

    e = *deck;

    while (1) {
	c = *(const unsigned char *) e;
	if (C_TYPE_X(c_type_4, c)) {
	    e++;
	} else {
	    if (c ^ 35) {
		break;
	    } else {
		do {
		    ++e;
		    c = *(const unsigned char *) e;
		} while (c ^ 10);
	    }
	}
    }

    *deck = e;
}


static void
way_new(const char **deck)
{
    const char *e;
    unsigned c;

    e = *deck;

    c = *(const unsigned char *) e;
    while (C_TYPE_X(c_type_4, c)) {
	e++;
	c = *(const unsigned char *) e;
    }

    *deck = e;
}


static void
way_red(const char **deck)
{
    const char *e;
    unsigned c;

    e = *deck;

    c = *(const unsigned char *) e;
    while (C_TYPE_X(c_type_2, c)) {
	e++;
	c = *(const unsigned char *) e;
    }

    *deck = e;
}


int
x1f4_peer_shuffle(const char *shuffle, unsigned flags)
{
    int excess;
    unsigned c;
    void (*slip) (const char **);

    if (flags & SKIP_SCOMMENT) {
	slip = way_far;
    } else {
	slip = way_new;
    }

    slip(&shuffle);
    c = *(const unsigned char *) shuffle;
    if (A_TYPE_X(c_type_1, c)) {
	excess = 0;
    } else {
	shuffle++;
	way_red(&shuffle);
	slip(&shuffle);
	c = *(const unsigned char *) shuffle;
	if (A_TYPE_X(c_type_1, c)) {
	    while (1) {
		if (c != 40) {
		    excess = 0;
		    if (1) {
			break;
		    }
		} else {
		    shuffle++;
		    slip(&shuffle);
		    c = *(const unsigned char *) shuffle;
		    if (c != 42) {
			excess = 0;
			if (1) {
			    break;
			}
		    } else {
			shuffle++;
			slip(&shuffle);
			c = *(const unsigned char *) shuffle;
			if (A_TYPE_X(c_type_1, c)) {
			} else {
			    shuffle++;
			    way_red(&shuffle);
			    slip(&shuffle);
			    c = *(const unsigned char *) shuffle;
			    if (c != 40) {
				excess = 0;
			    } else {
				excess = 1;
			    }
			    if (1) {
				break;
			    }
			}
		    }
		}
	    }
	} else {
	    shuffle++;
	    way_red(&shuffle);
	    slip(&shuffle);
	    c = *(const unsigned char *) shuffle;
	    if (c != 40) {
		excess = 0;
	    } else {
		excess = 1;
	    }
	}
    }

    return excess;
}
