/*
 * a1.5.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <a1-types.h>
#include <exerrors.h>

int
_x1f4_a1_lose_node(const struct x1f4_function_type *function_data,
		   struct a1_pipe_type *pipe_data)
{
    int status;

    do {
	status = pipe_data->pass.lose(pipe_data->pass.text, function_data);
	if (status) {
	    status = X1f4_EX_CANNOT_CONTINUE;
	    break;
	}

	pipe_data = pipe_data->back_pipe;
    } while (pipe_data);
    if (pipe_data) {
	pipe_data = pipe_data->back_pipe;
	while (pipe_data) {
	    pipe_data->pass.back(pipe_data->pass.text, function_data);
	    pipe_data = pipe_data->back_pipe;
	}
    }

    return status;
}
