/*
 * a1.3.c
 * Copyright (C) 2011-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <a1-inter.h>
#include <a1-types.h>
#include <e4.h>

int
_x1f4_a1_deck_aime(void *context, void *output, void **input)
{
    int status;

    do {
	struct a1_node_type *node_data;
	struct a1_shuffle_type *shuffle_data;
	const struct x1f4_function_type *function_data, *function_lead;
	void **class, **text;

	text = context;

	node_data = text[0];

	shuffle_data = ((void **) input[-1])[X1f4_E4_USED_META];

	function_data = text[1];

	class = shuffle_data->s.lead;

	function_lead = shuffle_data->s.function_data;

	shuffle_data->s.function_data = function_data;

	status = _x1f4_a1_link_aime(node_data, output, input);

	shuffle_data->s.function_data = function_lead;

	shuffle_data->s.lead = class;
    } while (0);

    return status;
}
