/*
 * a1.1.c
 * Copyright (C) 2006-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <stdlib.h>
#include <string.h>

#include <a1-copy.h>
#include <a1-inter.h>
#include <a1-types.h>
#include <c1.h>
#include <c1i.h>
#include <e4.h>
#include <exerrors.h>

#define copy_link(copy, call) \
    copy_miss((char *) used + (int) (copy)->datatext.link,		      \
	      (copy)->variable.type, (call))

static int link_aime(struct a1_node_type *, void *, void **);
static int long_aime(struct a1_node_type *, void *, void **, void **);
static int miss_line(struct a1_shuffle_type *, struct a1_link_type *, void **,
		     unsigned);
static int near_aime(struct a1_node_type *, void *, void **, void **);
static int pipe_aime(struct a1_pipe_type *, struct a1_node_type *, void *,
		     void **, void **);
static int text_line(struct a1_node_type *, struct a1_link_type *, void **,
		     void **);
static int text_side(struct a1_node_type *, void **, void **);
static int type_line(struct a1_node_type *, struct a1_link_type *, void **,
		     void **);
static int type_side(struct a1_node_type *, void **, void **);

static int
link_aime(struct a1_node_type *node_data, void *output, void **input)
{
    int status;
    struct a1_shuffle_type *shuffle_data;
    void *used;

    shuffle_data = ((void **) input[-1])[X1f4_E4_USED_META];

    status = _x1f4_a1_link_node(shuffle_data, node_data, &used);
    if (status) {
    } else {
	int excess;
	struct a1_link_type *link_data;

	link_data = node_data->link_data;
	if (link_data) {
	    status = type_line(node_data, link_data, input, used);
	    if (status) {
	    } else {
		int excess;

		status = near_aime(node_data, output, input, used);

		excess = text_line(node_data, link_data, input, used);
		if (excess) {
		    if (status) {
		    } else {
			status = excess;
		    }
		}
	    }
	} else {
	    status = type_side(node_data, input, used);
	    if (status) {
	    } else {
		int excess;

		status = near_aime(node_data, output, input, used);

		excess = text_side(node_data, input, used);
		if (excess) {
		    if (status) {
		    } else {
			status = excess;
		    }
		}
	    }
	}

	excess = shuffle_data->m.free(shuffle_data->m.data, used);
	if (excess) {
	    excess = _x1f4_a1_stat_free(shuffle_data);
	    if (status) {
	    } else {
		status = excess;
	    }
	}
    }

    return status;
}


static int
long_aime(struct a1_node_type *node_data, void *output, void **input,
	  void **used)
{
    int *note, status;
    struct a1_node_type *fail_node;
    struct a1_shuffle_type *shuffle_data;

    shuffle_data = ((void **) input[-1])[X1f4_E4_USED_META];

    fail_node = shuffle_data->fail_node;

    shuffle_data->fail_node = node_data;

    if (0) {
    } else {
	note = shuffle_data->z.note;
	if (note) {
	    status = x1f4_lift_program
		(node_data->aime, note,
		 shuffle_data->z.back, shuffle_data->z.call, output, used);
	} else {
	    status = x1f4_east_program(node_data->aime, output, used);
	}
	if (status) {
	    x1f4_mind_program(node_data->aime, used);
	}
    }

    shuffle_data->fail_node = fail_node;

    return status;
}


static int
miss_line(struct a1_shuffle_type *shuffle_data,
	  struct a1_link_type *link_data, void **used, unsigned count)
{
    int status = 0;

    if (1) {
	void *subtext[2];

	subtext[1] = shuffle_data;

	for (; count; count--) {
	    int (*miss) (void **, struct a1_link_type *, void *);

	    link_data--;

	    miss = link_data->miss;
	    if (miss) {
		status = miss(subtext, link_data, used);
		if (status) {
		    if (1) {
			break;
		    }
		}
	    }
	}
    }

    return status;
}


static int
near_aime(struct a1_node_type *node_data, void *output, void **input,
	  void **used)
{
    int status;
    struct a1_pipe_type *pipe_data;

    pipe_data =
	((struct a1_shuffle_type *)
	 ((void **) input[-1])[X1f4_E4_USED_META])->pipe_long;
    if (pipe_data) {
	status = pipe_aime(pipe_data, node_data, output, input, used);
    } else {
	status = long_aime(node_data, output, input, used);
    }

    return status;
}


static int
pipe_aime(struct a1_pipe_type *pipe_data, struct a1_node_type *node_data,
	  void *output, void **input, void **used)
{
    int status;

    do {
	status = pipe_data->pass.fast
	    (pipe_data->pass.text, &node_data->linetext.function);
	if (status) {
	    status = X1f4_EX_CANNOT_CONTINUE;
	    break;
	}

	pipe_data = pipe_data->pipe_long;
    } while (pipe_data);
    if (pipe_data) {
    } else {
	int excess;

	status = long_aime(node_data, output, input, used);

	pipe_data =
	    ((struct a1_shuffle_type *)
	     ((void **) input[-1])[X1f4_E4_USED_META])->back_pipe;

	do {
	    excess = pipe_data->pass.lose
		(pipe_data->pass.text, &node_data->linetext.function);
	    if (excess) {
		status = X1f4_EX_CANNOT_CONTINUE;
		break;
	    }

	    pipe_data = pipe_data->back_pipe;
	} while (pipe_data);
    }
    if (pipe_data) {
	pipe_data = pipe_data->back_pipe;
	if (pipe_data) {
	    _x1f4_a1_back_node(&node_data->linetext.function, pipe_data);
	}
    }

    return status;
}


static int
text_line(struct a1_node_type *node_data, struct a1_link_type *link_data,
	  void **input, void **used)
{
    int status;

    status = text_side(node_data, input, used);

    if (1) {
	unsigned count;
	void *subtext[2];

	subtext[1] = ((void **) input[-1])[X1f4_E4_USED_META];

	count = node_data->linetext.function.count;
	for (; count; count--) {
	    int (*miss) (void **, struct a1_link_type *, void *);

	    miss = link_data->miss;
	    if (miss) {
		status = miss(subtext, link_data, used);
		if (status) {
		    if (1) {
			break;
		    }
		}
	    }

	    link_data++;
	}
    }

    return status;
}


static int
text_side(struct a1_node_type *node_data, void **input, void **used)
{
    int status = 0;

    if (node_data->linetext.function.function == _x1f4_a1_side_aime) {
	struct a1_shuffle_type *shuffle_data;
	const struct x1f4_function_type *function_data;
	void *line;

	shuffle_data = ((void **) input[-1])[X1f4_E4_USED_META];

	function_data = shuffle_data->s.function_data;

	line = shuffle_data->s.lead;
	if (line) {
	    unsigned prefix, offset;

	    prefix = node_data->linetext.function.count;

	    offset = function_data->count - prefix;

	    status = _x1f4_a1_slip_side
		(shuffle_data, prefix, offset, line, function_data);
	}
	if (node_data->linetext.function.flags & X1f4_E4_SLIP_LIST) {
	    int excess;

	    excess = _x1f4_a1_slip_slip
		(shuffle_data, node_data->link_data, -1, function_data,
		 &node_data->linetext.function, used);
	    if (excess) {
		if (status) {
		} else {
		    status = excess;
		}
	    }
	}
    }

    return status;
}


static int
type_line(struct a1_node_type *node_data, struct a1_link_type *link_data,
	  void **input, void **used)
{
    int status = 0;

    if (1) {
	struct a1_shuffle_type *shuffle_data;
	unsigned count;
	void *subtext[4];

	shuffle_data = ((void **) input[-1])[X1f4_E4_USED_META];

	subtext[1] = shuffle_data;
	subtext[2] = node_data;
	subtext[3] = NULL;

	count = node_data->linetext.function.count;
	for (; count; count--) {
	    int (*line) (void **, void **, struct a1_link_type *, void *);

	    line = link_data->line;
	    if (line) {
		status = line(subtext, input, link_data, used);
		if (status) {
		    miss_line
			(shuffle_data, link_data, used,
			 node_data->linetext.function.count - count);
		    if (1) {
			break;
		    }
		}
	    } else {
		copy_link(link_data, *input);
	    }

	    input++;

	    link_data++;
	}
    }

    if (status) {
    } else {
	status = type_side(node_data, input, used);
	if (status) {
	    text_line(node_data, node_data->link_data, input, used);
	}
    }

    return status;
}


static int
type_side(struct a1_node_type *node_data, void **input, void **used)
{
    int status = 0;

    if (node_data->linetext.function.function == _x1f4_a1_side_aime) {
	struct a1_shuffle_type *shuffle_data;
	const struct x1f4_function_type *function_data;
	unsigned prefix, offset;

	prefix = node_data->linetext.function.count;

	input -= prefix;

	shuffle_data = ((void **) input[-1])[X1f4_E4_USED_META];

	function_data = shuffle_data->s.function_data;

	offset = function_data->count - prefix;
	if (node_data->linetext.function.flags & X1f4_E4_SLIP_LIST) {
	    status = _x1f4_a1_lead_slip
		(shuffle_data, input, node_data->link_data, function_data,
		 &node_data->linetext.function, used);
	    if (status) {
		offset = 0;
	    } else {
	    }
	}
	if (offset) {
	    void *line;

	    status = _x1f4_a1_lead_side
		(shuffle_data, offset, input, prefix, &line, function_data);
	    if (status) {
		if (node_data->linetext.function.flags & X1f4_E4_SLIP_LIST) {
		    _x1f4_a1_slip_slip
			(shuffle_data, node_data->link_data, -1, function_data,
			 &node_data->linetext.function, used);
		}
	    } else {
		shuffle_data->s.lead = line;
	    }
	} else {
	    shuffle_data->s.lead = NULL;
	}
    }

    return status;
}


int
_x1f4_a1_link_aime(void *context, void *output, void **input)
{
    return link_aime(context, output, input);
}
