/*
 * a1-l.x.c
 * Copyright (C) 2011-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <a1-inter.h>
#include <a1-types.h>
#include <e4.h>
#include <lxcall.h>
#include <lxcast.h>

#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_USER(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

extern const void *const x1f4_a1_walk_link;

static int beta_call(void *, void *, void **);
static int ever_call(void **, void **, unsigned, struct a1_node_type *,
		     unsigned, char *, int *, struct a1_shuffle_type *,
		     const int *, const int *, unsigned, unsigned);
static int fine_call(void *, void *, void **);

static const int c_____c__[] = {
/* *INDENT-OFF* */
    X1f4_E4_CASE
/* *INDENT-ON* */
};
const struct x1f4_function_type _x1f4_a1_l_x = {
/* *INDENT-OFF* */
    "xcall",
    fine_call,
    X1f4_E4_CASE,
    c_____c__,
    1,
    X1f4_E4_KEEP_CALL | X1f4_E4_LINK_PASS | X1f4_E4_SIDE_LIST
    | X1f4_E4_TEXT_LINK | X1f4_E4_WALK_LINK,
    5
/* *INDENT-ON* */
};

static int
beta_call(void *context, void *output, void **input)
{
    int status;
    struct a1_shuffle_type *shuffle_data;
    struct x1f4_dxcast_type *dxcast_data;
    void **track;

    if (output == x1f4_a1_walk_link) {
	track = input[1];
    } else {
	track = input;
    }

    shuffle_data = ((void **) track[-1])[X1f4_E4_USED_META];

    dxcast_data = I_USER(track[0]);

    if (X1f4_E4_CALL < dxcast_data->type) {
	struct x1f4_linetext_type *linetext_data;

	linetext_data = I_USER(&dxcast_data->data);
	if (linetext_data->function.function) {
	    struct a1_node_type *node_data;
	    struct x1f4_function_type function;
	    const struct x1f4_function_type *function_data, *function_text;
	    struct x1f4_trans_type v;
	    unsigned class, count, flags, parts, scale = 0;
	    void *beta;

	    node_data = shuffle_data->fail_node;

	    function_data = &node_data->linetext.function;

	    flags = function_data->flags;

	    if (flags & (X1f4_E4_SIDE_LIST | X1f4_E4_SLIP_LIST)) {
		function_data = shuffle_data->s.function_data;
		if (1) {
		    flags = function_data->flags;
		}
	    }

	    count = function_data->count;

	    function_text = context;

	    class = function_text->count - 1;

	    function.count = count + class;

	    parts = function_text->flags;

	    function.flags = (flags | parts) & X1f4_E4_POST_TYPE;

	    if (function.flags) {
		scale = 1;
	    }

	    v.data = shuffle_data->v.data;
	    v.link = shuffle_data->v.link;

	    status = v.link
		(v.data, &beta,
		 (sizeof(void *) + (sizeof(int) << scale)) * function.count
		 + sizeof(void *));
	    if (status) {
		status = _x1f4_a1_stat_link(shuffle_data);
	    } else {
		void *clear[3], **frame;

		frame = beta;
		frame++;

		function.args = (void *) (frame + function.count);

		frame[-1] = track[-1];

		ever_call
		    (frame, track, parts, node_data, flags, track[-1],
		     (int *) function.args, shuffle_data, function_text->args,
		     function_data->args, class, count);

		if (output == x1f4_a1_walk_link) {
		    clear[0] = input[0];
		    clear[1] = frame;
		    clear[2] = input[2];

		    frame = clear;
		}

		status = _libx1f4i0_lxcall_post_call
		    (linetext_data, &function, output, 0, frame, &v,
		     &shuffle_data->p, &shuffle_data->q, &shuffle_data->x,
		     shuffle_data->y.eelookup_data);
		if (status) {
		} else {
		    if (output == x1f4_a1_walk_link) {
			input[2] = clear[2];
		    }
		}
	    }
	} else {
	    status = _x1f4_a1_stat_zero(shuffle_data, "xcall", 5);
	}
    } else {
	status = _x1f4_a1_stat_call(shuffle_data, "xcall", 5);
    }

    return status;
}


static int
ever_call(void **post_data, void **line_data, unsigned parts,
	  struct a1_node_type *node_data, unsigned flags, char *used,
	  int *post_args, struct a1_shuffle_type *shuffle_data,
	  const int *line_args, const int *link_args, unsigned line,
	  unsigned link)
{
    struct a1_link_type *link_data;
    struct x1f4_dxcast_type *object_text;
    unsigned class, count;
    void **rail;

    link_data = node_data->link_data;

    memcpy(post_data, line_data + 1, line * sizeof(void *));

    class = node_data->linetext.function.count;

    post_data += line;
    count = class;
    for (; count; count--) {
	void *slip;

	if (flags & X1f4_E4_POST_TYPE) {
	    if (link_args[link] & X1f4_E4_POST_XSET) {
		slip = *(void **) (used + (int) link_data->datatext.link);
	    } else {
		slip = used + (int) link_data->datatext.link;
	    }
	} else {
	    slip = used + (int) link_data->datatext.link;
	}

	link_data++;
	link_args++;

	*post_data++ = slip;
    }

    object_text = shuffle_data->s.lead;
    rail = (void *) (object_text + link - class);

    count = link - class;
    for (; count; count--) {
	void *slip;

	if (flags & X1f4_E4_POST_TYPE) {
	    if (link_args[link] & X1f4_E4_POST_XSET) {
		slip = *rail;
	    } else {
		slip = &object_text->data;
	    }
	} else {
	    slip = &object_text->data;
	}

	link_data++;
	link_args++;

	rail++;
	object_text++;

	*post_data++ = slip;
    }

    memcpy(post_args, line_args + 1, line * sizeof(int));
    post_args += line;
    memcpy(post_args, link_args - link, link * sizeof(int));
    if ((flags | parts) & X1f4_E4_POST_TYPE) {
	post_args += link;
	memcpy(post_args, line_args + 2 + line, line * sizeof(int));
	post_args += line;
	memcpy(post_args, link_args, link * sizeof(int));
    }

    return 0;
}


static int
fine_call(void *context, void *data, void **text)
{
    struct x1f4_function_type *function_data;

    function_data = data;

    function_data->function = beta_call;

    *text = function_data;

    return 0;
}
