/*
 * a1-l.s.c
 * Copyright (C) 2011-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <a1-copy.h>
#include <a1-inter.h>
#include <a1-types.h>
#include <af.h>
#include <e4.h>
#include <lxcall.h>
#include <lxcast.h>

#define false(e)			0

#define I_MODE(i)			(*((X1f4_E4_C_MODE *) (i)))
#define I_TEXT(i)			(*((X1f4_E4_C_TEXT *) (i)))
#define I_USER(i)			(*((X1f4_E4_C_USER *) (i)))

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

extern const char *const x1f4_c1_empty_string;

extern const struct x1f4_datatype_type _x1f4_af_last_type;

static int beta_call(void *, void *, void **);
static int lead_call(void *, void *, struct a1_shuffle_type *);
static int lead_node(void *, void *, const struct x1f4_datatype_type *,
		     struct a1_shuffle_type *);
static int lead_text(void *, void *, struct a1_shuffle_type *);
static int true_type(const struct x1f4_datatype_type **, int,
		     struct a1_shuffle_type *);

static const int c_____m_c[] = {
/* *INDENT-OFF* */
    X1f4_E4_MODE,
    X1f4_E4_CASE
/* *INDENT-ON* */
};
const struct x1f4_function_type _x1f4_a1_l_s = {
/* *INDENT-OFF* */
    "set",
    beta_call,
    X1f4_E4_VOID,
    c_____m_c,
    2,
    X1f4_E4_KEEP_CALL,
    3
/* *INDENT-ON* */
};

static int
beta_call(void *context, void *output, void **input)
{
    X1f4_E4_C_MODE mode;
    int status;
    struct a1_node_type *node_data;
    struct a1_shuffle_type *shuffle_data;
    const struct x1f4_function_type *function_data;
    unsigned count, flags;

    shuffle_data = ((void **) input[-1])[X1f4_E4_USED_META];

    node_data = shuffle_data->fail_node;

    function_data = &node_data->linetext.function;

    flags = function_data->flags;

    if (flags & (X1f4_E4_SIDE_LIST | X1f4_E4_SLIP_LIST)) {
	function_data = shuffle_data->s.function_data;
	if (1) {
	    flags = function_data->flags;
	}
    }

    count = function_data->count;

    mode = I_MODE(input[0]);
    if (-(X1f4_E4_C_MODE) count - 1 < mode && mode < (X1f4_E4_C_MODE) count) {
	do {
	    const int *args;
	    int type;
	    const struct x1f4_datatype_type *datatype_data;
	    struct x1f4_dxcast_type *object_data;
	    unsigned class;
	    void *slip;

	    class = node_data->linetext.function.count;

	    object_data = I_USER(input[1]);

	    if (mode < 0) {
		mode += count;
	    }

	    args = function_data->args + mode;

	    type = *args;

	    if (type != object_data->type) {
		status = _x1f4_a1_stat_type
		    (shuffle_data, type, object_data->type);
		if (1) {
		    break;
		}
	    }

	    if (mode < class) {
		int true;
		struct a1_link_type *link_data;

		link_data = node_data->link_data;

		link_data += mode;

		true = link_data->variable.type;
		if (true ^ X1f4_E4_SLIP) {
		    datatype_data = link_data->datatext.type;
		} else {
		    true_type(&datatype_data, type, shuffle_data);
		}

		if (false(type == shuffle_data->r.type)) {
		} else {
		    if (flags & X1f4_E4_POST_TYPE) {
			if (args[count] & X1f4_E4_POST_XSET) {
			    slip = *(void **)
				((char *) input[-1]
				 + (int) link_data->datatext.link);
			} else {
			    slip = (char *) input[-1]
				+ (int) link_data->datatext.link;
			}
		    } else {
			slip = (char *) input[-1]
			    + (int) link_data->datatext.link;
		    }
		}
	    } else {
		const char *name;
		int trap;
		struct x1f4_dxcast_type *object_text;

		status = 0;

		trap = mode - class;

		object_text = shuffle_data->s.lead;
		object_text += trap;

		if (false(type == shuffle_data->r.type)) {
		} else {
		    if (flags & X1f4_E4_POST_TYPE) {
			if (args[count] & X1f4_E4_POST_XSET) {
			    slip = *((void **) (object_text + count - mode)
				     + trap);
			} else {
			    slip = &object_text->data;
			}
		    } else {
			slip = &object_text->data;
		    }
		}

		datatype_data = shuffle_data->u.sidetype_data;
		name = datatype_data->name;
		while (name) {
		    if (datatype_data->type == type) {
			break;
		    } else {
			datatype_data++;
			name = datatype_data->name;
		    }
		}
		if (name) {
		} else {
		    datatype_data = shuffle_data->u.datatype_data;
		    name = datatype_data->name;
		    while (name) {
			if (datatype_data->type == type) {
			    break;
			} else {
			    datatype_data++;
			    name = datatype_data->name;
			}
		    }
		}

		if (name) {
		} else {
		    datatype_data = NULL;
		}
	    }

	    if (datatype_data) {
		if (datatype_data->lead) {
		    status = lead_node
			(slip, &object_data->data, datatype_data,
			 shuffle_data);
		    if (1) {
			break;
		    }
		} else {
		}
	    } else {
		if (type == X1f4_E4_TEXT) {
		    status = lead_text
			(slip, &object_data->data, shuffle_data);
		    if (1) {
			break;
		    }
		} else {
		    if (X1f4_E4_CALL < type) {
			status = lead_call
			    (slip, &object_data->data, shuffle_data);
			if (1) {
			    break;
			}
		    }
		}
	    }

	    status = 0;

	    copy_miss(slip, type, &object_data->data);
	} while (0);
    } else {
	status = _x1f4_a1_stat_deck(shuffle_data, count, mode);
    }

    return status;
}


static int
lead_call(void *slip, void *data, struct a1_shuffle_type *shuffle_data)
{
    int status;

    status = _x1f4_lead_effect(NULL, data);
    if (status) {
    } else {
	status = _libx1f4i0_lxcall_near_node
	    (&shuffle_data->v, &shuffle_data->x,
	     (struct x1f4_datatype_type *) &_x1f4_af_last_type, I_USER(slip));
	if (status) {
	} else {
	    copy_miss(slip, X1f4_E4_CALL, data);
	}
    }

    return status;
}


static int
lead_node(void *slip, void *data,
	  const struct x1f4_datatype_type *datatype_data,
	  struct a1_shuffle_type *shuffle_data)
{
    int status;

    status = datatype_data->lead(datatype_data->context, data);
    if (status) {
    } else {
	status = _libx1f4i0_lxcall_near_node
	    (&shuffle_data->v, &shuffle_data->x,
	     (struct x1f4_datatype_type *) datatype_data, I_USER(slip));
	if (status) {
	} else {
	    copy_miss(slip, datatype_data->type, data);
	}
    }

    return status;
}


static int
lead_text(void *slip, void *data, struct a1_shuffle_type *shuffle_data)
{
    int status;
    void *miss, *side;

    miss = I_TEXT(data);
    side = I_TEXT(slip);

    if (side == miss) {
	status = 0;
    } else {
	do {
	    unsigned size;

	    size = strlen(miss);
	    if (size) {
		void *text;

		size++;
		status = shuffle_data->m.link
		    (shuffle_data->m.data, &text, size);
		if (status) {
		    status = _x1f4_a1_stat_link(shuffle_data);
		    if (1) {
			break;
		    }
		} else {
		    memcpy(text, miss, size);
		    l_TEXT(text, slip);
		}
	    } else {
		l_TEXT((char *const) x1f4_c1_empty_string, slip);
	    }

	    status = _libx1f4i0_lxcall_pick_text
		(&shuffle_data->v, &shuffle_data->m, &shuffle_data->x, &side);
	} while (0);
    }

    return status;
}


static int
true_type(const struct x1f4_datatype_type **datatype, int type,
	  struct a1_shuffle_type *shuffle_data)
{
    const char *name;
    const struct x1f4_datatype_type *datatype_data;

    datatype_data = shuffle_data->u.sidetype_data;
    name = datatype_data->name;
    while (name) {
	if (datatype_data->type == type) {
	    break;
	} else {
	    datatype_data++;
	    name = datatype_data->name;
	}
    }
    if (name) {
    } else {
	datatype_data = shuffle_data->u.datatype_data;
	name = datatype_data->name;
	while (name) {
	    if (datatype_data->type == type) {
		break;
	    } else {
		datatype_data++;
		name = datatype_data->name;
	    }
	}
    }

    if (name) {
	*datatype = datatype_data;
    } else {
	*datatype = NULL;
    }

    return 0;
}
