=pod 

=head1 NAME

buildscript.pl - script to reprocess all or only changed parts of the project
using one of Stunnix Obfuscators.

=head1 SYNOPSIS

perl B<buildscript.pl>
    S<[ B<--help> ]>
    S<[ B<--verbose ..>] [ B<--nostop> ] >
    S<[ B<--op> I<build>|I<build-and-test>|I<rebuildall-and-test>| >
    S<	        I<rebuildall>|I<clearout>|I<clearstate>|I<clearall>] >
    S<[ I<filenames...> ] >

=head1 DESCRIPTION

This is a perl script file that can be used to perform various operations
on the project created in Stunnix Obfuscator Project Manager. This script
can be recreated by running Stunnix Obfuscator Project Manager, then visiting
Project menu and clicking on the menuitem I<Export as buildscript> - you
will be prompted to enter name of file to save this script to.

In order to run this script, type I<perl buildscript.pl [arguments]>.

This script can be used to rebuild all files, rebuild only "dirty" files,
clear all output files and/or state files produced during build process - 
the operation performed is specified as the value of the I<op> commandline
option. It's possible to specify the set of files to apply 
operation 
to by passing space-separated list of file names (relative to the project 
"input" directory) after all commandline arguments. There are other switches 
to affect the behaviour.

This script is cross-platform, it will work correctly on any computer
provided that paths listed
in the script are correct for your system. It's possible to edit this file
by hand in order to tweak commandline options or set of files, provided
Perl language syntax is respected.

This script can be thought of as a replacement for Makefile for
I<make> utility, traditionally used for building large or complex projects.
It's recommended to generate such script rather than to write Makefile
instead since commandlines to be written are rather complex. So the 
recommended approach for people who prefer writing Makefiles for their 
projects is to create project in Stunnix Obfuscator Project Manager,
properly assign all options, export the buildscript and then use the
buildscript for building the project; if necessary, changes in the 
commandline options and adding set of files can be performed by editing
this script (though using Stunnix Obfuscator Project Manager would
still be more convenient for this task too).

If this script is invoked with empty commandline, all "dirty" output files 
(for which corresponding original files are more fresh than output files)
will be rebuilt.

Execution is aborted in case error occurs during processing of some 
file. It's possible to not abort processing in case of error by passing 
option I<--nostop>.

=head1 OPTIONS

=over 4

=item B<--op>

Specifies operation to be performed. Can be either of the following:

=over 2

=item I<build>

Process only those files, which were changed after their protected version
was built (or for which no protected version exists). This is the default
operation, it's performed when no I<--op> option was specified at all.

=item I<build-and-test>

Same as I<build>, but also runs B<test command> (specified in project options)
if processing all files was successful. It's useful to run some testsuite or
just navigate the browser to some page by using the test command.

=item I<rebuildall>

Processes all files in the project, without comparing the time of the
modification of input and output files.

=item I<rebuild-and-test>

Same as I<rebuild>, but also runs but B<test command> (specified in 
project options) if processing of all files was successful. 

=item I<clearout>

Clear all output files.

=item I<clearstate>

Clear all state files that were produced during building of the project -
such files are typically lists of exceptions extracted automatically and
mapping of original to protected symbols.

=item I<clearall>

Does everything that operations I<clearout> and I<clearstate>
do.

=back

=item B<--verbose>

Passing this option multiplie types increases level of verbosity of its
output.

=item B<--help>

Produces help on options the script supports.

=item B<--nostop>

Do not abort if some error occured while processing some file.

=back

=cut
