#!/usr/bin/perl

use strict;
use FindBin;

=head1

This is a helper script to start web-based UI for Stunnix Obfuscators.
It is not useful for Windows since installer adds proper entry to Start Menu.

=cut

$ENV{PERL5LIB}='';
chdir  "$FindBin::Bin/../lib/gui/site/stunnixwebsrv/"  || chdir "$FindBin::Bin/../lib/stunnix-webserver/";

if ($^O =~ /linux/i && -r 'check-linux-32bit-support')
{
    my $r = system('./check-linux-32bit-support');
    my $exit_value  = $? >> 8;
    if ($exit_value != 0)
    {
        print "You do not have libraries for 32 bit apps installed. The product will not work until you install them.\n";
        print "To install them on Ubuntu or Debian, run\n";
        print "  sudo apt-get install ia32-libs\n";
        print "To install them on Fedora, run\n";
        print "  sudo yum install redhat-lsb.i686\n";
	exit 1;
    }
}


if ($^O =~ /Win32/i)
{
    my $perlpath = $^X;
    $perlpath =~ s,[/\\]perl.exe$,\\wperl.exe,i;
    system("\"$perlpath\" startsite.pl");
} else {
    system("./startsite.pl");
};

