#!/usr/local/bin/python

# Copyright (C) Johan Ceuppens 2014
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import pygame
from pygame.locals import *

from resourcesdb import *
from rnuplayer import *
from room import *
from DuminassProton import *
from ExcellenceGunner import *

class RNu:
    "Main pattern class"
    def __init__(self):
        pygame.init()
#        pygame.font.init()
	self.screenw = 640
	self.screenh = 480
        self.screen = pygame.display.set_mode((self.screenw, self.screenh))
        ###pygame.key.set_repeat(1000,1000)
        pygame.key.set_repeat(1,1)
#        self.font = pygame.font.SysFont("Times", 14)
#        self.font2 = pygame.font.SysFont("Vera", 28)
#        self.font3 = pygame.font.SysFont("Courier", 10)
        self.blankimage = pygame.image.load('./pics/blank.bmp').convert()
        titleimage = pygame.image.load('./pics/titlescreen-1.bmp').convert()
	### dhp stands for hitpoints dimishing points, this can be changed by
	### an AI engine for example
        self.dhp = 1  
        self.playerdhp = 1  
        self.x = 0
        self.y = 0
	self.SCREENW = 640
	self.SCREENH = 480
	self.bullets = []
        self.exitloop = 0
	
	self.db = ResourcesDB()	           

	self.playerx = 100
	self.playery = 200
	self.player = RNuPlayer(self.playerx,self.playery,self.SCREENW,self.SCREENH)
	for key in self.player.getimagekeys():
		self.db.addImage(key, 0, 0, 0) 
	self.room = Room(0,0)

	self.enemies = []
	self.enemies.append(DuminassProton(639,200))
	self.enemies.append(ExcellenceGunner(500,200))

#        self.screen.blit(self.font2.render("Loading...Done. Click to continue.", 6, 
#					(255,255,255)), 
#					(0,450))
        pygame.display.update()

        self.exitloop = 0
        while self.exitloop == 0:
            pygame.display.update()
            self.screen.blit(titleimage, (150,150))
            for event in pygame.event.get():
                if event.type == QUIT:
                    return
                elif event.type == KEYDOWN:
                    self.exitloop = 1
                if event.type == pygame.MOUSEBUTTONDOWN:
                    self.exitloop = 1
        ###self.image = self.db.getImageData('./pics/playership-48x48.png')
	self.image = pygame.image.load('./pics/playership-48x48.png').convert()
	self.image.set_colorkey((0,0,0))
        self.screen.blit(self.blankimage, (0,0))
        self.screen.blit(self.image, (0,0))

	###if self.image:
        ###	self.screen.blit(self.image, (0,0))
	self.exitloop = 0
        while self.exitloop == 0:
            if 1 or pygame.event.peek():
		for event in pygame.event.get():
                	if event.type == QUIT:
                    		return
                	elif event.type == KEYDOWN:
				if event.key == K_q or event.key == K_ESCAPE:
                    			self.exitloop = 1
				elif event.key == K_LEFT:
					self.player.moveleft(self)	
				elif event.key == K_RIGHT:
					self.player.moveright(self)	
				elif event.key == K_UP:
					self.player.moveup(self)	
				elif event.key == K_DOWN:
					self.player.movedown(self)	
				
				if event.key == K_f or event.key == K_SPACE:
                    			self.player.fire(self)	

                	if event.type == pygame.MOUSEBUTTONDOWN:
                    		1###self.exitloop = 1

        	self.screen.blit(self.blankimage, (0,0))
		self.room.moveleft()	
        	self.screen.blit(self.room.bg, (self.room.x,self.room.y))

        	for b in self.bullets:
			b.update(self)
			### This isn't C++ but this might error
			### You remove the first item as this is certainly
			### the bullet to be removed from the list
			### for going out of screen
			if b.x > self.screenw:
				self.bullets.remove(b) 
			self.screen.blit(b.image, (b.x,b.y))
		for e in self.enemies:
			e.update(self)
			if self.collide2(self.player, e):
				e.diminishhitpoints(self, self.dhp)
				self.player.diminishhitpoints(self, self.playerdhp)
				if self.player.hitpoints <= 0:	
					self.enemies.remove(e)	
					self.exitloop = 1
			self.screen.blit(e.image, (e.x, e.y))

        	for b in self.bullets:
			for e in self.enemies:
				if self.collide(b,e):
					e.diminishhitpoints(self, self.dhp)
					if e.hitpoints <= 0:
						self.enemies.remove(e)	
						self.bullets.remove(b)
	
        	self.screen.blit(self.image, (self.player.x, self.player.y))
            	pygame.display.update()
      
	self.exitloop = 0 
        while self.exitloop == 0:
            pygame.display.update()
            self.screen.blit(self.blankimage, (0,0))
            self.screen.blit(titleimage, (150,150))
#            self.screen.blit(self.font2.render("Game Over!", 6, 
#					(255,255,255)), 
#					(0,450))
            for event in pygame.event.get():
                if event.type == QUIT:
                    return
                elif event.type == KEYDOWN:
                    self.exitloop = 1
                if event.type == pygame.MOUSEBUTTONDOWN:
                    self.exitloop = 1

    def collide(self, bullet, enemy):
	if bullet.x > enemy.x and bullet.x < enemy.x + enemy.w and bullet.y > enemy.y and bullet.y < enemy.y + enemy.h:
		return 1
	return 0
     
    def collide2(self, player, enemy):
	if player.x > enemy.x and player.x < enemy.x + enemy.w and player.y > enemy.y and player.y < enemy.y + enemy.h:
		return 1
	return 0
     
if __name__ == "__main__":
    foo = RNu()
