# Copyright (C) Johan Ceuppens 2014
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import pygame
from pygame.locals import *

from gameobject import *
from imagelib import *

from singlebullet import *
from entitytemplate import *
from entityfactory import *

class Player(GameObject):
    ""

    def __init__(self, startx, starty, roomw, roomh):
	GameObject.__init__(self, startx, starty)
	self.imagefilenamekeys = ImageLib()
	self.roomw = roomw
	self.roomh = roomh 
   	self.w = 48
	self.h = 48
	self.hitpoints = 1
	self.bulletfactory = EntityFactory()
 
    def addImageFilename(self, fn):
	self.imagefilenamekeys.add(fn)

    def getNextImageFilename(self):
	self.imagefilenamekeys.getNext()

    def getimagekeys(self):
	return self.imagefilenamekeys.list	

    def moveup(self,game):
	if self.y - self.h > 0:
		self.y -= self.movedy	
	game.playery = self.y

    def movedown(self,game):
	if self.y + self.h < self.roomh:
		self.y += self.movedy	
	game.playery = self.y

    def moveleft(self,game):
	if self.x - self.w > 0:
		self.x -= self.movedx	
	game.playerx = self.x

    def moveright(self,game):
	if self.x + self.w < self.roomw:
		self.x += self.movedx
	game.playerx = self.x

    def fire(self, game):
	###game.bullets.append(SingleBullet(self.x,self.y+self.h/2-8))
	game.bullets.append(self.bulletfactory.makebullet(EntityTemplate.ENTITY_BULLET_SINGLE, self.x,self.y+self.h/2-8))


    def diminishhitpoints(self, game, hp):
	self.hitpoints -= hp 
	
