##################################################
# SPYCE - Python-based HTML Scripting
# Copyright (c) 2002 Rimon Barr.
#
# Refer to spyce.py
# CVS: $Id: core.py,v 1.2 2002/12/02 18:04:49 batripler Exp $
##################################################

__doc__ = '''Core Spyce tags.'''

from spyceTag import spyceTagLibrary, spyceTagPlus

class tag_print(spyceTagPlus):
  name = 'print'
  def syntax(self):
    self.syntaxSingleOnly()
    self.syntaxExist('val')
    self.syntaxNonEmpty('val')
    self.syntaxValidSet('encode', ['false', 'url', 'html'])
  def begin(self, val, encode='html', default=None):
    try: out = str(self.contextEval(val))
    except: 
      if default:
        out = str(self.contextEval(default))
      else:
        raise
    if encode == 'html':
      out = self.contextGetModule('transform').html_encode(out)
    elif encode == 'url':
      out = self.contextGetModule('transform').url_encode(out)
    self.getOut().write(out)

class tag_let(spyceTagPlus):
  name = 'let'
  def syntax(self):
    self.syntaxExist('var', 'val')
    self.syntaxNonEmpty('var')
  def begin(self, var, val):
    self.var = var
    self.orig = self.contextSet(self.var, (1, self.contextEval(val)))
    return 1
  def end(self):
    self.contextSet(self.var, self.orig)

class tag_unlet(spyceTagPlus):
  name = 'unlet'
  def syntax(self):
    self.syntaxSingleOnly()
    self.syntaxExist('var')
    self.syntaxNonEmpty('var')
  def begin(self, var):
    self.contextSet(var, (0, None))

class tag_if(spyceTagPlus):
  name = 'if'
  def syntax(self):
    self.syntaxPairOnly()
    self.syntaxExist('test')
  def begin(self, test, var=None):
    value = self.contextEval(test)
    return value

# rimtodo: add first, last boolean flag variables
class tag_for(spyceTagPlus):
  name = 'for'
  def syntax(self):
    self.syntaxPairOnly()
    self.syntaxExist('items')
    self.syntaxNonEmpty('items', 'var', 'counter')
  def begin(self, items, var=None, counter=None):
    self.remaining = self.contextEval(items)
    if type(self.remaining) not in (type(()), type([])):
      raise 'items expressions should result in tuple or list, got: %s'%repr(self.remaining)
    self.var = var
    self.counter = counter
    self.i = 0
    if self.var:
      self.orig_var = self.contextGet(self.var)
    if self.counter:
      self.orig_counter = self.contextGet(self.counter)
    return self._iter()
  def _iter(self):
    if self.remaining:
      if self.var:
        self.contextSet(self.var, (5, self.remaining[0]))
      self.remaining = self.remaining[1:]
      if self.counter:
        self.contextSet(self.counter, (1, self.i))
      self.i = self.i + 1
      return 1
  def body(self, _):
    return self._iter()
  def end(self):
    if self.var:
      self.contextSet(self.var, self.orig_var)
    if self.counter:
      self.contextSet(self.counter, self.orig_counter)

# rimtodo: catch
# rimtodo: choose, when, otherwise

class core(spyceTagLibrary):
  tags = [
    tag_print, 
    tag_let, 
    tag_unlet, 
    tag_if,
    tag_for,
  ]

