##################################################
# SPYCE - Python-based HTML Scripting
# Copyright (c) 2002 Rimon Barr.
#
# Refer to spyce.py
# CVS: $Id: spyceWWW.py,v 1.15 2002/12/02 18:04:46 batripler Exp $
##################################################

import sys, os, string, socket, BaseHTTPServer, SocketServer
import spyce, spyceConfig, spyceException, spyceCmd, spyceUtil

__doc__ = '''Self-standing Spyce web server.'''

##################################################
# Request / response handlers
#

class spyceHTTPRequest(spyce.spyceRequest):
  'HTTP Spyce request object. (see spyce.spyceRequest)'
  def __init__(self, httpdHandler, documentRoot):
    spyce.spyceRequest.__init__(self)
    self._in = httpdHandler.rfile
    self._headers = httpdHandler.headers
    self._env = {}
    self._env['REMOTE_ADDR'], self._env['REMOTE_PORT'] = httpdHandler.client_address
    self._env['GATEWAY_INTERFACE'] = 'CGI/1.1'
    self._env['REQUEST_METHOD'] = httpdHandler.command
    self._env['REQUEST_URI'] = httpdHandler.path
    self._env['PATH_INFO'] = httpdHandler.path
    self._env['SERVER_SOFTWARE'] = 'spyce/%s' % spyce.__version__
    self._env['SERVER_PROTOCOL'] = httpdHandler.request_version
    # self._env['SERVER_ADDR'] ... '127.0.0.1'
    # self._env['SERVER_PORT'] ... '80'
    # self._env['SERVER_NAME'] ... 'pompom.u.cs.cornell.edu'
    # self._env['SERVER_SIGNATURE'] ... ' Apache/1.3.22 Server at pompom.u.cs.cornell.edu Port 80'
    # self._env['SERVER_ADMIN'] ... 'barr@cs.cornell.edu'
    self._env['DOCUMENT_ROOT'] = documentRoot
    self._env['QUERY_STRING'] = ''
    i=string.find(httpdHandler.path, '?')
    if i!=-1: self._env['QUERY_STRING'] = httpdHandler.path[i+1:]
    self._env['CONTENT_LENGTH'] = self.getHeader('Content-Length')
    self._env['CONTENT_TYPE'] = self.getHeader('Content-type')
    self._env['HTTP_USER_AGENT'] = self.getHeader('User-Agent')
    self._env['HTTP_ACCEPT'] = self.getHeader('Accept')
    self._env['HTTP_ACCEPT_ENCODING'] = self.getHeader('Accept-Encoding')
    self._env['HTTP_ACCEPT_LANGUAGE'] = self.getHeader('Accept-Language')
    self._env['HTTP_ACCEPT_CHARSET'] = self.getHeader('Accept-Charset')
    self._env['HTTP_COOKIE'] = self.getHeader('Cookie')
    self._env['HTTP_REFERER'] = self.getHeader('Referer')
    self._env['HTTP_HOST'] = self.getHeader('Host')
    self._env['HTTP_CONNECTION'] = self.getHeader('Connection')
    self._env['HTTP_KEEP_ALIVE'] = self.getHeader('Keep-alive')
    # From ASP
    # AUTH_TYPE, 
    # APPL_PHYSICAL_PATH, 
    # REMOTE_HOST,
    # SERVER_PROTOCOL, 
    # SERVER_SOFWARE
  def env(self, name=None):
    return spyceUtil.extractValue(self._env, name)
  def getHeader(self, type=None):
    if type: type=string.lower(type)
    return spyceUtil.extractValue(self._headers.dict, type)
  def getServerID(self):
    return os.getpid()

class spyceHTTPResponse(spyceCmd.spyceCmdlineResponse):
  'HTTP Spyce response object. (see spyce.spyceResponse)'
  def __init__(self, httpdHandler):
    self._httpheader = httpdHandler.request_version!='HTTP/0.9'
    spyceCmd.spyceCmdlineResponse.__init__(self, spyceUtil.NoCloseOut(httpdHandler.wfile), sys.stdout, self._httpheader)
    self._httpdHandler = httpdHandler
  def sendHeaders(self):
    if self._httpheader and not self.headersSent:
      resultText = spyceUtil.extractValue(self.RETURN_CODE, self.returncode)
      self.origout.write('%s %s %s\n' % (self._httpdHandler.request_version, self.returncode, resultText))
      spyceCmd.spyceCmdlineResponse.sendHeaders(self)
  def close(self):
    spyceCmd.spyceCmdlineResponse.close(self)
    self._httpdHandler.request.close()

##################################################
# Spyce web server
#

class spyceHTTPhandler(BaseHTTPServer.BaseHTTPRequestHandler):
  def do_GET(self):
    try:
      # parse path
      path = self.path
      i=string.find(path, '?')
      if i!=-1: path = path[:i]
      path = os.path.normpath(path)
      while path and (path[0]=='/' or path[0:2]=='..'):
        if path[0]=='/': path=path[1:]
        if path[0:2]=='..': path=path[2:]
      path = os.path.join(self.server.documentRoot, path)
      self.log_request()
      # process spyce
      request = spyceHTTPRequest(self, self.server.documentRoot)
      response = spyceHTTPResponse(self)
      result = spyce.spyceFileHandler(request, response, path)
      response.close()
    except IOError: 
      pass
  do_POST=do_GET

def spyceHTTPserver(port, root, config_file=None):
  os.environ[spyce.SPYCE_ENTRY] = 'www'
  # test for threading support, if needed
  try:
    server = spyce.getServer(config_file=config_file)
  except (spyceException.spyceForbidden, spyceException.spyceNotFound), e:
    print e
    return
  if server.concurrency==spyceConfig.SPYCE_CONCURRENCY_THREAD:
    spyceUtil.ThreadedWriter()  # will raise exception if 'import thread' fails
  # determine type of server concurrency
  serverSuperClass = {
    spyceConfig.SPYCE_CONCURRENCY_SINGLE: SocketServer.TCPServer,
    spyceConfig.SPYCE_CONCURRENCY_FORK:   SocketServer.ForkingTCPServer,
    spyceConfig.SPYCE_CONCURRENCY_THREAD: SocketServer.ThreadingTCPServer,
  } [server.concurrency]
  class sharedSocketServer(serverSuperClass):
    def server_bind(self):
      self.socket.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
      SocketServer.TCPServer.server_bind(self)
  try:
    # initialize server
    try:
      httpd = sharedSocketServer(('',port), spyceHTTPhandler)
      httpd.documentRoot = root
    except:
      print 'Unable to start server on port %s' % port
      return -1
    print 'Listening on port %d' % port
    # process requests
    while 1:
      try:
        httpd.handle_request()
      except KeyboardInterrupt: raise
      except:
        print 'Error: %s' % spyceUtil.exceptionString()
  except KeyboardInterrupt:
    print 'Break!'
  return 0

