##################################################
# SPYCE - Python-based HTML Scripting
# Copyright (c) 2002 Rimon Barr.
#
# Refer to spyce.py
# CVS: $Id: automaton.py,v 1.13 2002/12/01 21:13:25 batripler Exp $
##################################################

from spyceModule import spyceModule

__doc__ = '''Automaton module allows Spyce users to create websites with
state machine-based application flows. One can define an automaton
programmatically using the start(), transition() and begin methods. The
automaton is the executed (one step per request) using the step() method. This
method accepts the current state, which should be managed by the user
preferably via a session (keeping the information on the server), or possibly
by get, post or cookie. The step() method then calls the recv() function on
the given state, which returns an edge label. This edge points to the new
state. The step() method then calls the send() method of the new state to
generate the page content. The user should encode the new state in this
content, or use on a subsequent request.'''

class automaton(spyceModule):
  def start(self):
    "Initialise an empty automaton"
    self.clear()

  # defining the automaton
  def state(self, name, send, recv):
    "Add a new automaton state"
    self.nodes[name] = send, recv
    self.transition(name, None, name)
  def transition(self, state1, edge, state2):
    "Add a new automaton transition"
    self.edges[(state1, edge)] = state2
  node=state
  edge=transition
  def begin(self, name):
    "Define the automaton begin state"
    if not self.nodes.has_key(name):
      raise 'automaton does not contain state: %s' % name
    self.beginstate = name
  def clear(self):
    self.nodes = {}
    self.edges = {}
    self.beginstate = None

  # running the automaton
  def step(self, state=None):
    """Run the automaton one step: recv (old state), transition, 
    send (new state)"""
    if state:
      try: send, recv = self.nodes[state]
      except: raise 'invalid state: %s' % state
      edge = recv()
      try: state = self.edges[(state, edge)]
      except: raise 'invalid transition: %s,%s' % (state, edge)
    else: state = self.beginstate
    try: send, recv = self.nodes[state]
    except: raise 'invalid state: %s' % state
    send()

  def xmlString(self, xmlSM):
    pass
  def xmlFile(self, xmlSMFile):
    pass
    

  def string(self, xmlSM):
    def processRecvSend(state, sendrecv, self=self):
      sr = state.getElementsByTagName(sendrecv)
      if len(sr)!=1:
        raise 'need exactly one %s for a state definition' % sendrecv
      sr = sr[0]
      type = sr.getAttribute('type')
      info = ''
      for t in sr.childNodes:
        if t.nodeType==t.TEXT_NODE:
          info = info + t.data
      return self._stateFunction(type, info)
    # parse
    import xml.dom.minidom
    try:
      xmlSM = xml.dom.minidom.parseString(xmlSM)
      try:
        sm = xmlSM.getElementsByTagName('automaton')[0]
        states = sm.getElementsByTagName('state')+sm.getElementsByTagName('node')
        for state in states:
          statename = state.getAttribute('name')
          recvfn = processRecvSend(state, 'recv')
          sendfn = processRecvSend(state, 'send')
          self._api.getModule('response').write('state: %s\n'%statename)
          self._api.getModule('response').write('recv: %s\n'%recvfn)
          self._api.getModule('response').write('send: %s\n'%sendfn)
          edges = state.getElementsByTagName('edge')+state.getElementsByTagName('transition')
          for edge in edges:
            edgename, edgedst = edge.getAttribute('name'), edge.getAttribute('state')
            self._api.getModule('response').write('edge: %s %s\n'%(edgename,edgedst))
          self._api.getModule('response').write('-------------\n')
      finally:
        xmlSM.unlink()
    except:
      raise 'invalid automaton xml definition: '+util.exceptionString()



  # rimtodo: later
  def get(self, name):
    "Get cached automaton information"
    # rimtodo: later
    return 0
  def set(self, name):
    "Cache current automaton information"
    # rimtodo: later
    pass
  def _stateFunction(self, type, info):
    # rimtodo: later
    return None

  def load(self, string):
    # check cache
    file = os.path.join(os.path.dirname(self._api.getFilename()), file)
    if self.get(file): return
    # load
    f = open(file, 'r')
    xmlSM = f.read()
    f.close()
    # parse and cache
    self.string(xmlSM, file)
