" Vim syntax file
" Language:	   SPYCE
" Maintainer:	 Rimon Barr <barr+spyce@cs.cornell.edu>
" URL:		     http://www.cs.cornell.edu/barr
" Last Change: 2002 Nov 20

" For version 5.x: Clear all syntax items
" For version 6.x: Quit when a syntax file was already loaded
if version < 600
  syntax clear
elseif exists("b:current_syntax")
  finish
endif

" we define it here so that included files can test for it
if !exists("main_syntax")
  let main_syntax='spyce'
endif

" Read the HTML syntax to start with
let b:did_indent = 1         " don't perform HTML indentation!
let html_no_rendering = 1    " do not render <b>,<i>, etc...
if version < 600
  so <sfile>:p:h/html.vim
else
  runtime! syntax/html.vim
  unlet b:current_syntax
endif

" include python
syn include @Python <sfile>:p:h/python.vim
syn include @Html <sfile>:p:h/html.vim

" spyce definitions
syn keyword spyceDirectiveKeyword include compact module import contained
syn keyword spyceDirectiveArg name names file contained
syn region  spyceDirectiveString start=+"+ end=+"+ contained
syn match   spyceDirectiveValue "=[\t ]*[^'", \t>][^, \t>]*"hs=s+1 contained

syn match spyceBeginError ,\[\[,
syn match spyceEndError ,\]\],

syn match spyceEscBegin        ,\\\[\[,
syn match spyceEscEnd          ,\\\]\],
syn match spyceEscEndComment   ,--\\\]\],

syn region spyceStmt       matchgroup=spyceStmtDelim start=,\[\[, end=,\]\], contains=@Python,spyceLambda,spyceBeginError keepend
syn region spyceChunk      matchgroup=spyceChunkDelim start=,\[\[\\, end=,\]\], contains=@Python,spyceLambda,spyceBeginError keepend
syn region spyceEval       matchgroup=spyceEvalDelim start=,\[\[=, end=,\]\], contains=@Python,spyceLambda,spyceBeginError keepend
syn region spyceDirective  matchgroup=spyceDelim start=,\[\[\., end=,\]\], contains=spyceBeginError,spyceDirectiveKeyword,spyceDirectiveArg,spyceDirectiveValue,spyceDirectiveString keepend
syn region spyceComment    matchgroup=spyceCommentDelim start=,\[\[\--, end=,--\]\],
syn region spyceLambda     matchgroup=spyceLambdaDelim start=,\[\[spy!\?, end=,\]\], contains=@Html,@spyce extend

syn cluster spyce contains=spyceStmt,spyceChunk,spyceEval,spyceComment,spyceDirective

syn cluster htmlPreproc contains=@spyce

hi link spyceDirectiveKeyword Special
hi link spyceDirectiveArg     Type
hi link spyceDirectiveString  String
hi link spyceDirectiveValue   String

hi link spyceDelim            Special
hi link spyceStmtDelim        spyceDelim
hi link spyceChunkDelim       spyceDelim
hi link spyceEvalDelim        spyceDelim
hi link spyceLambdaDelim      spyceDelim
hi link spyceCommentDelim     Comment

hi link spyceBeginError       Error
hi link spyceEndError         Error

hi link spyceStmt             spyce
hi link spyceChunk            spyce
hi link spyceEval             spyce
hi link spyceDirective        spyce
hi link spyceComment          Comment
hi link spyceLambda           Normal

hi link spyce                 Statement

let b:current_syntax = "spyce"
if main_syntax == 'spyce'
  unlet main_syntax
endif

