#############################################################################
#
#	xnsc.py - Pyro Naming Service Control Tool with GUI (Xnsc)
#
#	This is part of "Pyro" - Python Remote Objects
#	which is (c) Irmen de Jong - irmen@bigfoot.com.
#
#############################################################################

from Tkinter import *
from Pyro.naming import NameServerLocator
from Pyro.errors import NamingError, SocketClosedError
import Pyro.core
import sys,string,socket

class xnscFrame:

	def quit(self):
		self.master.quit()

	def output(self,txt):
		self.text_out.insert(AtEnd(),txt)
		self.text_out.yview(AtEnd())

	def outputln(self,txt):
		self.output(txt+'\n')

	def b_findNS(self,event=None):
		hst,prt = None,Pyro.config.PYRO_NS_BC_PORT
		if event and event.char=='\r':
			# Pressed <return> in entry box
			addr = string.split(self.entry_NSloc.get(),':')
			hst=addr[0]
			if len(addr)>1:
				prt=int(addr[1])
		# We need to keep the host/port for the shutdown button...
		self.NShost = hst
		self.NSport = prt
		self.outputln('*** finding NS')
		locator=NameServerLocator()
		try:	
			self.NS=locator.getNS(hst,prt,trace=1)
			self.entry_NSloc.delete(0,AtEnd())
			self.entry_NSloc.insert(AtEnd(),self.NS.URI.host+':'+str(self.NS.URI.port))

			self.enable_buttons()
			self.outputln('   found, URI='+str(self.NS.URI))
		except:
			self.disable_buttons()
			self.outputln('   not found:');
			a,b,c = sys.exc_info()
			self.outputln('  '+str(a)+' : '+str(b))
			self.outputln('See standard output for trace messages.')
	
	def handle_comm_error(self,name):
		# Handle a communication error: disable buttons and print exception
		a,b,c = sys.exc_info()
		self.outputln('*** '+name+': exception occured:')
		self.outputln('  '+str(a)+' : '+str(b))
		if a==socket.error or a==SocketClosedError:
			self.disable_buttons()
			self.outputln('*** Connection with NS lost - reconnect')
	
	def b_list(self,event=None):
		name = string.split(self.entry_arg.get())
		try:
			if name:
				self.outputln('*** List groups:')
				for n in name:
					self.output(' '+self.NS.fullName(n)+' --> ')
					try:
						self.printList(self.NS.list(n))
					except NamingError,x:
						self.outputln('## can\'t list: '+str(x)+' ##')
			else:
				self.outputln('*** List default group:')
				self.printList(self.NS.list(None))
		except:
			self.handle_comm_error('list')
	def printList(self,list):
		out='( '
		list.sort()
		for (n,t) in list:
			if t==0:
				out=out+'['+n+'] '
			elif t==1:
				out=out+n+' '
		self.outputln(out+')')

	def b_listall(self,event=None):
		try:
			flat=self.NS.flatlist()
			flat.sort()
			self.outputln('--------- Flat dump of namespace')
			for (name,val) in flat:
				self.outputln(' '+name+' --> '+str(val))
			self.outputln('--------- End dump')
		except: 
			self.handle_comm_error('listall')
	
	def b_register(self,event=None):
		self.outputln('*** registering with NS:')
		try:
			(name,uri) = string.split(self.entry_arg.get())
			try:
				self.NS.register(name,uri)
				uri=Pyro.core.PyroURI(uri)
				self.outputln('  '+name+'  -->  '+str(uri))
			except NamingError,arg:
				self.outputln('  Error from NS: '+str(arg))
			except: 
				self.handle_comm_error('register')
		except ValueError:
			self.outputln('  Invalid arguments, use "<name> <URI>".')

	def b_resolve(self,event=None):
		self.outputln('*** resolving:')
		name=self.entry_arg.get()
		if not name:
			self.outputln('  Invalid arguments, use "<name>".')
		else:
			try:
				uri=self.NS.resolve(name)
				self.outputln('  '+name+'  -->  '+str(uri))
			except NamingError,x:
				self.outputln('  '+name+'  -->  ## can\'t resolve: '+str(x)+' ##')
			except: 
				self.handle_comm_error('resolve')
	
	def b_remove(self,event=None):
		self.outputln('*** removing:')
		name=self.entry_arg.get()
		if not name:
			self.outputln('  Invalid arguments, use "<name>".')
		else:
			try:
				self.NS.unregister(name)
				self.outputln('*** removed: '+name)
			except NamingError,x:
				self.outputln('  Can\'t remove '+name+' because '+str(x))
			except: 
				self.handle_comm_error('remove')
	
	def b_ping(self,event=None):
		try:
			self.NS.ping()
			self.outputln('*** ping NS: up and running!')
		except: 
			self.handle_comm_error('ping')
	
	def b_creategroup(self,event=None):
		name=self.entry_arg.get()
		if not name:
			self.outputln('  Invalid arguments, use "<name>".')
		else:
			try:
				self.NS.createGroup(name)
				self.outputln('*** group created: '+name)
			except: 
				self.handle_comm_error('creategroup')
	
	def b_deletegroup(self,event=None):
		name=self.entry_arg.get()
		if not name:
			self.outputln('  Invalid arguments, use "<name>".')
		else:
			try:
				self.NS.deleteGroup(name)
				self.outputln('*** group deleted: '+name)
			except: 
				self.handle_comm_error('deletegroup')

	def b_shutdown(self,event=None):
		locator = NameServerLocator()
		try:
			result = locator.sendSysCommand('shutdown',self.NShost,self.NSport,0)
			self.outputln('*** The NS replied to the shutdown message: '+str(result))
		except:
			self.disable_buttons()
			self.outputln('   not found:');
			a,b,c = sys.exc_info()
			self.outputln('  '+str(a)+' : '+str(b))
			
	def enable_buttons(self):
		self.but_ping['state']=NORMAL
		self.but_list['state']=NORMAL
		self.but_listall['state']=NORMAL
		self.but_resolve['state']=NORMAL
		self.but_register['state']=NORMAL
		self.but_remove['state']=NORMAL
		self.but_shutdown['state']=NORMAL
		self.but_creategroup['state']=NORMAL
		self.but_deletegroup['state']=NORMAL

	def disable_buttons(self):
		self.but_ping['state']=DISABLED
		self.but_list['state']=DISABLED
		self.but_listall['state']=DISABLED
		self.but_resolve['state']=DISABLED
		self.but_register['state']=DISABLED
		self.but_remove['state']=DISABLED
		self.but_shutdown['state']=DISABLED
		self.but_creategroup['state']=DISABLED
		self.but_deletegroup['state']=DISABLED

	def createWidgets(self):
		frame_NSloc=Frame(self.master,borderwidth=2,relief=GROOVE)
		self.entry_NSloc=Entry(frame_NSloc)
		self.entry_NSloc.bind('<Return>',self.b_findNS)
		self.but_findNS=Button(frame_NSloc,text='Auto Discover NS',command=self.b_findNS)
		self.QUIT=Button(frame_NSloc,text='QUIT',command=self.quit)
		Label(frame_NSloc,text='Naming Service Location (host:port)').pack(anchor=W)
		self.entry_NSloc.pack(expand=1,fill=X,side=LEFT)
		self.but_findNS.pack(side=LEFT)
		self.QUIT.pack(side=RIGHT)
	
		frame_cmds=Frame(self.master)
		frame_cmds1=Frame(frame_cmds)
		frame_cmds2=Frame(frame_cmds)
		self.but_ping=Button(frame_cmds1,text='Ping',state=DISABLED,command=self.b_ping)
		self.but_list=Button(frame_cmds1,text='List',state=DISABLED,command=self.b_list)
		self.but_listall=Button(frame_cmds1,text='List All',state=DISABLED,command=self.b_listall)
		self.but_register=Button(frame_cmds2,text='Register',state=DISABLED,command=self.b_register)
		self.but_resolve=Button(frame_cmds1,text='Resolve',state=DISABLED,command=self.b_resolve)
		self.but_remove=Button(frame_cmds2,text='Remove',state=DISABLED,command=self.b_remove)
		self.but_creategroup=Button(frame_cmds2,text='Create Group',state=DISABLED,command=self.b_creategroup)
		self.but_deletegroup=Button(frame_cmds2,text='Delete Group',state=DISABLED,command=self.b_deletegroup)
		self.but_shutdown=Button(frame_cmds1,text='Shutdown',state=DISABLED,command=self.b_shutdown)
		Label(frame_cmds,text='NS commands:').pack(side=LEFT)
		self.but_ping.pack(side=LEFT)
		self.but_list.pack(side=LEFT)
		self.but_listall.pack(side=LEFT)
		self.but_register.pack(side=LEFT)
		self.but_resolve.pack(side=LEFT)
		self.but_remove.pack(side=LEFT)
		self.but_creategroup.pack(side=LEFT)
		self.but_deletegroup.pack(side=LEFT)
		self.but_shutdown.pack(side=LEFT)

		frame_args=Frame(self.master,borderwidth=2)
		self.entry_arg=Entry(frame_args)
		Label(frame_args,text='Command arguments').pack(side=LEFT)
		self.entry_arg.pack(expand=1,fill=X)
		
		frame_output=Frame(self.master)
		ys=Scrollbar(frame_output,orient=VERTICAL)
		self.text_out=Text(frame_output,yscrollcommand=ys.set)
		ys['command']=self.text_out.yview
		ys.pack(fill=Y,side=LEFT)
		self.text_out.pack(side=LEFT,expand=1,fill=BOTH)

		# pack root children:
		frame_NSloc.pack(fill=X)
		frame_cmds1.pack(fill=X)
		frame_cmds2.pack(fill=X)
		frame_cmds.pack(fill=X)
		frame_args.pack(fill=X)
		frame_output.pack(fill=BOTH,expand=1)

	def __init__(self, master=None):
		self.master = master	
		self.createWidgets()

def main():
	root=Tk()
	root.title('xnsc - Python NamingService control tool')
	app=xnscFrame(root)
	root.protocol('WM_DELETE_WINDOW',root.quit)
	root.mainloop()

