#############################################################################
#
#	util.py - Pyro Utilities
#
#	This is part of "Pyro" - Python Remote Objects
#	which is (c) Irmen de Jong - irmen@bigfoot.com.
#
#############################################################################

# Fall back on pickle if cPickle isn't available
try: 
	import cPickle; pickle = cPickle
except ImportError:
	import pickle

import os,random,time,string,sys,time,Pyro


# Log classes for (M)essages, (W)arnings, (E)rrors.


class LoggerBase:
	# Logger base class. Subclasses must implement _logfile and  _checkTraceLevel.
	def msg(self,source,*args):
		if self._checkTraceLevel(3): self._trace('NOTE',source, args)
	def warn(self,source,*args):
		if self._checkTraceLevel(2): self._trace('WARN',source, args)
	def error(self,source,*args):
		if self._checkTraceLevel(1): self._trace('ERR!',source, args)
	def raw(self,string):
		try:
			open(self._logfile(),'a').write(string)
		except:
			pass
	def _trace(self,type,source, arglist):
		if not arglist:
			arglist=['<no message>']
		try:
			tf=open(self._logfile(),'a')
			tf.write(time.strftime('%x %X',time.localtime(time.time()))+
			  ' ** '+type+' ** '+str(source)+' ** '+reduce(lambda x,y: str(x)+' '+str(y),arglist)+'\n')
		except:
			pass

class SystemLogger(LoggerBase):
	def _checkTraceLevel(self, level):
		return Pyro.config.PYRO_TRACELEVEL >= level
	def _logfile(self):
		return Pyro.config.PYRO_LOGFILE
		
class UserLogger(LoggerBase):
	def _checkTraceLevel(self, level):
		return Pyro.config.PYRO_USER_TRACELEVEL >= level
	def _logfile(self):
		return Pyro.config.PYRO_USER_LOGFILE


# The logger object 'Log'.
Log = SystemLogger()


import string

# Fairly simple argument options parser. Like getopt(3).
class ArgParser:
	def __init__(self):
		self.options={}		# public, the option->value dictionary
		self.args=[]		# public, the rest of the arguments
		self.ignored=[]		# public, ignored options
	def parse(self, args, optionlist):
		# arglist is a string such as "ab:c" which means
		# we search for 3 options (-a, -b, -c) of which -b has an argument.
		self.options={}
		self.args=[]
		self.ignored=[]
		optionlist=optionlist+' ' # add sentinel
		if type(args)==type(''):
			args=string.split(args)
		while args:
			arg=args[0]
			del args[0]
			if arg[0]=='-':
				if len(arg)>=2:   # arg is an option. Check our list
					idx = string.find(optionlist,arg[1])
					if idx>=0:
						if optionlist[idx+1]==':':   # option requires argument.
							if len(arg)>=3:   # argument is appended. Use this.
								self.options[arg[1]]=arg[2:]
								continue
							# fetch argument from next string
							if len(args)>=1:
								self.options[arg[1]]=args[0]
								del args[0]
								continue
							else:   # missing arg, substitute None
								self.options[arg[1]]=None
						else:   # option requires no argument, use None
							self.options[arg[1]]=None
					else:   # didn't find this option, skip it
						self.ignored.append(arg[1])
				else:   # arg is a single '-'. Stop parsing.
					for a in args:
						self.args.append(a)
					args=None
			else:   # arg is no option, add it to the residu list and continue
				self.args.append(arg)
	def getOpt(self, option, default=Exception()):
		try:
			return self.options[option]
		except KeyError:
			if not isinstance(default,Exception):
				return default
			raise KeyError('no such option')
	def printIgnored(self):
		if self.ignored:
			print 'Ignored options:',
			for o in self.ignored:
				print '-'+o,
			print


	
def getGUID():
	# Generate GUID.
	# Should use the machine's MAC ethernet address, but there is no
	# portable way to get it... use the IP address + a random number instead.
	# If on Windows, you might want to use the Win32 GUIDs.
	# Otherwise, the GUID is constructed as follows;
	# AAAAAAAAAAAA-BBBBBBBBBBBBBB-CCCCCC  (in fact, a 128-bit number)
	# where A=network address, B=timestamp, C=random.

	if Pyro.config.PYRO_USE_WIN32GUID:
		try:
			import pythoncom
			return str(pythoncom.CreateGuid())
		except:
			Log.warn('getGUID','Win32 CreateGuid failed, using default GUID')

	from Pyro.protocol import getIPAddress
	
	ip=getIPAddress()
	if ip:
		ip=map(eval, string.split(ip,'.'))
		ip=reduce(lambda x,y: x+'%02x' % y, ip, '')
	else:
		# can't get IP address... use another value, like our Python id() and PID
		Log.warn('getGUID','Can\'t get IP address')
		try:
			ip=os.getpid()
		except:
			ip=0
		ip='%08lx' % (id(getGUID)+ip)
	
	t1=time.time()*100
	t2=int((t1*time.clock())%sys.maxint) & 0xffffff
	t1=int(t1%sys.maxint)
	r1=(random.randint(0,sys.maxint/2)>>3) & 0xffff
	r2=(random.randint(0,sys.maxint/2)>>4) & 0xffff
	r3=(random.randint(0,sys.maxint/2)>>5) & 0xff
	return ip+'%04lx-%08lx%06lx-%04lx%02lx' % (r1,t1,t2,r2,r3)

def genguid_scripthelper():
	if __name__!='__main__':
		del sys.argv[0]	# remove '-c' arg
	p=ArgParser()
	p.parse(sys.argv,'w')
	if p.args or p.ignored:
		print 'usage: genguid [-w]'
		print '-w = use Windows GUID if possible'
		raise SystemExit
	try:
		p.getOpt('w')
		Pyro.config.PYRO_USE_WIN32GUID=1
	except KeyError:
		pass
	print getGUID()
	
