#
#	Test server base implementation, used by each of the tests
#

import sys, socket
import Pyro.naming
import Pyro.core
from Pyro.errors import PyroError,NamingError

group = ':test'   # the namespace group for all test servers


######## main program

# objClass = the class of the Pyro implementation object
# objName = the name for the object to register in the Name Server
# delegate = wether to use the delegate approach or the regular
#            objBase subclassing approach

def start(objClass, objName, delegate=0):
	# initialize the server and set the default namespace group
	Pyro.core.initServer()
	Pyro.config.PYRO_NS_DEFAULTGROUP=group

	# locate the NS
	PyroDaemon = Pyro.core.Daemon()
	locator = Pyro.naming.NameServerLocator()
	print 'searching for Naming Service...'
	try:
		ns = locator.getNS()
	except (PyroError,socket.error),x:
		hn = socket.gethostname()
		print '\nNaming Service not found with broadcast. Trying host',hn,'...',
		ns = locator.getNS(host=hn)

	print 'Naming Service found at',ns.URI.host,ns.URI.port

	# make sure our namespace group exists
	try:
		ns.createGroup(group)
	except NamingError:
		pass

	PyroDaemon.useNameServer(ns)

	# connect a new object implementation (first unregister previous one)
	try:
		ns.unregister(objName)
	except NamingError:
		pass

	if delegate:
		# use Deletation approach
		obj=Pyro.core.ObjBase()
		obj.delegateTo(objClass())
		PyroDaemon.connect(obj,objName)
	else:
		# use regular ObjBase subclassing approach
		PyroDaemon.connect(objClass(),objName)

	# enter the service loop.
	print 'Server object "'+objName+'" ready.'
	while 1:
		PyroDaemon.handleRequests(3.0)
		print '.',
		sys.stdout.flush()

