#############################################################################
#
#	nsc.py - Pyro Naming Service Control Tool
#
#	This is part of "Pyro" - Python Remote Objects
#	which is (c) Irmen de Jong - irmen@bigfoot.com.
#
#############################################################################

from naming import NameServerLocator
from errors import NamingError, PyroError
import Pyro.core
import sys


class PyroNSControl:
	def args(self, args):
		import Pyro.util
		self.Args = Pyro.util.ArgParser()
		self.Args.parse(args,'h:p:')
		self.Args.printIgnored()
		if self.Args.args:
			cmd = self.Args.args[0]
			del self.Args.args[0]
			return cmd

	def connect(self, sysCmd=None):
		host = self.Args.getOpt('h',None)
		port = int(self.Args.getOpt('p', Pyro.config.PYRO_NS_BC_PORT))
		if host:
			print 'Trying NS @',host,port
		else:
			print 'Finding NS using broadcast @ port',port

		locator = NameServerLocator()
		if not sysCmd:
			self.NS = locator.getNS(host,port,1)
			print 'NS is at',self.NS.URI.host,'port',self.NS.URI.port
		else:
			result = locator.sendSysCommand(sysCmd,host,port,1)
			print 'NS replied to system command',sysCmd,':',result

		
	def ping(self):
		self.connect()
		self.NS.ping()
		print 'NS is up and running!'

	def listall(self):
		self.connect()
		flat=self.NS.flatlist()
		flat.sort()
		print '-------------- START DATABASE'
		for (name,val) in flat:
			print name,' --> ',str(val)
		print '-------------- END'

	def list(self):
		self.connect()
		if not self.Args.args:
			# list the current group
			print self.NS.fullName(''),'-->',
			self.printList(self.NS.list(None))
		else:
			# list all subpaths
			for n in self.Args.args:
				print self.NS.fullName(n),' -->',
				try:
					self.printList(self.NS.list(n))
				except NamingError,x:
					print '## can\'t list:',x,'##'

	def printList(self,list):
		list.sort()
		print '(',
		for (n,t) in list:
			if t==0:
				print '['+n+']',
			elif t==1:
				print n,
		print ')'

	def resolve(self):
		self.connect()
		if not self.Args.args:
			print 'No arguments, nothing to resolve'
		else:
			for n in self.Args.args:
				print n,' -->',
				try:
					print self.NS.resolve(n)
				except NamingError,x:
					print '## can\'t resolve:',x,'##'
	
	def register(self):
		self.connect()
		try:
			self.NS.register(self.Args.args[0],self.Args.args[1])
			uri=Pyro.core.PyroURI(self.Args.args[1])
			print 'registered',self.Args.args[0],' --> ',uri
		except NamingError,arg:
			print 'Error from NS:',arg
		except IndexError:
			print 'Register needs 2 args: name URI'
		
	def remove(self):
		self.connect()
		for n in self.Args.args:
			try:
				self.NS.unregister(n)
				print n,'unregistered.'
			except NamingError,x:
				print '## Can\'t unregister',n,'because',x

	def creategroup(self):
		self.connect()
		for n in self.Args.args:
			try:
				self.NS.createGroup(n)
				print n,'created.'
			except NamingError,x:
				print '## Can\'t create',n,'because',x

	def deletegroup(self):
		self.connect()
		for n in self.Args.args:
			try:
				self.NS.deleteGroup(n)
				print n,'deleted.'
			except NamingError,x:
				print '## Can\'t delete',n,'because',x

	def shutdown(self):
		self.connect(sysCmd='shutdown')


def usage():
	print 'PyroNS control program - usage is as follows;'
	print '>> nsc [-h host] [-p port] command [args...]'
	print 'where command is one of: ping, list, listall, resolve, register, remove, creategroup, deletegroup, shutdown'
	print '      host is the host where the NS should be contacted'
	print '      port is the non-standard Pyro NS broadcast port'
	print '      args... depend on the command.'
	raise SystemExit

def main():
	if __name__!='__main__':
		del sys.argv[0]	# remove '-c' arg

	ctrl = PyroNSControl()
	cmd=ctrl.args(sys.argv)

	if not cmd:
		usage()

	try:
		# nice construct to map commands to the member function to call
		{ 'ping': ctrl.ping,
		  'list': ctrl.list,
		  'listall': ctrl.listall,
		  'resolve': ctrl.resolve,
		  'register': ctrl.register,
		  'remove': ctrl.remove,
		  'creategroup': ctrl.creategroup,
		  'deletegroup': ctrl.deletegroup,
		  'shutdown': ctrl.shutdown } [cmd] ()
	except KeyError:
		usage()
	except PyroError,arg:
		print 'There is a problem:',arg


