#############################################################################
#
#	configuration.py
#	Sets up Pyro's configuration (Pyro.config).
#
#	This is part of "Pyro" - Python Remote Objects
#	Which is (c) Irmen de Jong - irmen@bigfoot.com.
#
#############################################################################


# Initialize Pyro Configuration.

import re, os, errno

# ---------------------- DEFAULT CONFIGURATION VARIABLES -----------

# Special characters are '%c' (current directory, absolute) and
# $STORAGE which is replaced by the PYRO_STORAGE path.
defaults= {
	'PYRO_STORAGE':			'%c',	# current dir (abs)
	'PYRO_PORT':			7766,
	'PYRO_PORT_RANGE':		100,
	'PYRO_NS_PORT':			9090,
	'PYRO_NS_BC_PORT':		9091,
	'PYRO_NS_NAME':			':Pyro.NameServer',		# (not from env var)
	'PYRO_NS_URIFILE':		'$STORAGE/Pyro_NS_URI', # (abs)
	'PYRO_NS_GROUPSEP':		'.',
	'PYRO_NS_ROOTCHAR':		':',
	'PYRO_NS_DEFAULTGROUP': ':Default',
	'PYRO_BC_RETRIES':		2,
	'PYRO_BC_TIMEOUT':		2,
	'PYRO_BINARY_PICKLE':	1,
	'PYRO_TRACELEVEL':		0,
	'PYRO_USER_TRACELEVEL':	0,
	'PYRO_LOGFILE':			'$STORAGE/Pyro_log',		# (abs)
	'PYRO_USER_LOGFILE':	'$STORAGE/Pyro_userlog',	# (abs)
	'PYRO_USE_WIN32GUID':	0,
	'PYRO_MAXCONNECTIONS':	200
}

# ---------------------- END OF DEFAULT CONFIGURATION VARIABLES -----


class Config:

	def __init__(s):
		pass

	def setup(s, configFile):
		reader = ConfigReader(defaults)
		reader.parse(configFile)
		s.__dict__.update(reader.items)
		if(configFile):
			s.__dict__['PYRO_CONFIG_FILE'] = os.path.abspath(configFile)
		else:
			s.__dict__['PYRO_CONFIG_FILE'] = ''


		# Create the storage directory if it doesn't exist yet
		try:
			os.mkdir(s.PYRO_STORAGE)
		except OSError,x:
			if x.errno not in (errno.EEXIST, errno.EBUSY):
				raise OSError(x)

#	def __getattr__(self,name):
#		# add smart code here to deal with other requested config items!



class ConfigReader:
	def __init__(self, defaults):
		self.matcher=re.compile(r'\s*([^#]\w*)\s*=\s*(\S*)\s*$')
		self.items=defaults.copy()

	def parse(self, file):
		if file:
			file=open(file).readlines()
			for l in file:
				match=self.matcher.match(l)
				if match:
					if defaults.has_key(match.group(1)):
						if match.group(2):
							self.items[match.group(1)] = match.group(2)
					else:
						raise KeyError('Unknown config item in configfile: '+match.group(1))

		# Parse the environment variables (they override the config file)
		self.items.update(self.processEnv(defaults.keys()))

		# First, fix up PYRO_STORAGE because others depend on it.
		self.items['PYRO_STORAGE'] = self.treatSpecial(self.items['PYRO_STORAGE'])
		# Now fix up all other items:
		for i in self.items.keys():
			newVal = self.treatSpecial(self.items[i])
			if i in ('PYRO_STORAGE', 'PYRO_LOGFILE', 'PYRO_USER_LOGFILE', 'PYRO_NS_URIFILE'):
				newVal=os.path.abspath(newVal)
			# fix the variable type if it's an integer
			if type(defaults[i]) == type(42):
				newVal = int(newVal)
			self.items[i]= newVal

	def processEnv(self, keys):
		# do NOT process PYRO_NS_NAME!
		if 'PYRO_NS_NAME' in keys:
			keys.remove('PYRO_NS_NAME')
		env={}
		for key in keys:
			try: env[key] = os.environ[key]
			except KeyError: pass
		return env

	def treatSpecial(self, value):
		# treat special escape strings
		if type(value)==type(""):
			if value=='%c':
				return os.curdir
			elif len(value)>=9 and value[:9]=='$STORAGE/':
				return os.path.join(self.items['PYRO_STORAGE'], value[9:])
		return value


