#
#	The VSB bank office. (server)
#

import sys, socket
import Pyro.naming
import Pyro.core
from Pyro.errors import PyroError,NamingError
import banks

group = ':banks'   # the namespace group for all test servers


# initialize the server and set the default namespace group
Pyro.core.initServer()
Pyro.config.PYRO_NS_DEFAULTGROUP=group

# locate the NS
print 'Searching Naming Service...'
PyroDaemon = Pyro.core.Daemon()
locator = Pyro.naming.NameServerLocator()
try:
	ns = locator.getNS()
except (PyroError,socket.error),x:
	hn = socket.gethostname()
	print '\nNaming Service not found with broadcast. Trying host',hn,'...',
	ns = locator.getNS(host=hn)


# make sure our namespace group exists
try:
	ns.createGroup(group)
except NamingError:
	pass

PyroDaemon.useNameServer(ns)

# connect a new object implementation (first unregister previous one)
try:
	ns.unregister('VSB')
except NamingError:
	pass

# bank class is direct subclass of Pyro.core.ObjBase
PyroDaemon.connect(banks.VSB(),'VSB')

# enter the service loop.
print 'VSB bank ready for customers.'
while 1:
	PyroDaemon.handleRequests(3.0)
	print '.',
	sys.stdout.flush()

