#!/usr/local/bin/python

import fileinput, os, shutil, string, sys

site_python = site_packages = None

if '-u' in sys.argv:  # uninstall
  index = sys.argv.index('-u')
  del sys.argv[index]
  for file in fileinput.input():
    file = string.rstrip(file)
    os.remove(file)

else:
  for index in range(len(sys.path)):
    dirname = sys.path[index]
    if os.path.basename(dirname) == 'site-python':
      site_python = (index, dirname)
    elif os.path.basename(dirname) == 'site-packages':
      site_packages = (index, dirname)

  if site_python and site_packages:
    if site_python[0] < site_packages[0]:
      install_dir = site_python[1]
    else:
      install_dir = site_packages[1]
  elif site_python:
    install_dir = site_python[1]
  else:
    install_dir = site_packages[1]

  installed_at = []
  for file in sys.argv[1:]:
    newloc = os.path.join(install_dir, file)
    try:
      shutil.copy2(file, newloc)
    except OSError:
      print 'Cannot install modules in', install_dir
      break
    installed_at.append( newloc )

  for file in installed_at:
    print file

