# unbox.py = unpack archive files
#
#############################################################
# Copyright (c) 2003 Philip Hunt. 
# You may use this software under the terms of the GNU
# General Public License (GPL). See file COPYING for details.
#############################################################

# Last altered: 12-Jan-2004
# History:
# 26-Dec-2003 PH: created
# 12-Jan-2004 PH: added ability to unbox .tar.bz2 files

#----- Python standard library
import sys, os, os.path

sys.path.append('..') #so utility can be imported
import utility

#---------------------------------------------------------------------

UNPACK_FILE_TYPES = {
   '.zip': 'unzip %s',
   '.tar': 'tar -xf %s',
   '.tar.gz': 'tar -xzf %s',
   '.tgz': 'tar -xzf %s',
   '.tar.bz2': 'tar -xjf %s'
}

def osrun(cmd):
   print "RUN { %s }" % cmd
   os.system(cmd)

def unpackArchive(destDirRoot, archiveFile):
   """ Unpack (archiveFile) in (destDirRoot) """
   uftKeys = UNPACK_FILE_TYPES.keys()
   cmd = ''
   for k in uftKeys:
      kl = len(k)
      if archiveFile[-kl:] == k:
         # we are using this type to unarchive the file
         cmd = UNPACK_FILE_TYPES[k]
   #//for k  
   if cmd == '':
      raise Error, "<%s> isn't a recognised archive file type"\
         % (archiveFile,)
   cmdWithAF = cmd % archiveFile      
   cmd2 = "cd %s ; %s" % (destDirRoot, cmdWithAF)
   osrun(cmd2)    

def unbox(destDirRoot, archiveFile):
   """ Unpack an archive file in a directory.
   @param destDirRoot [string] = the root directory of the destination
   @param archiveFile [string] = the filename of an archive file
   """
   # create directory (destDirRoot)
   osrun("mkdir %s" % destDirRoot)
   
   # empty it
   osrun("rm -r %s/*" % destDirRoot)
   
   # put the archive file in it
   osrun("cp %s %s/" %(archiveFile, destDirRoot))
   
   # unpack the archive file
   unpackArchive(destDirRoot, os.path.basename(archiveFile))
   

#end
