# easibox_const.py = global constants for Easibox
#
#############################################################
# Copyright (c) 2001-2003 Philip Hunt. 
# You may use this software under the terms of the GNU
# General Public License (GPL). See file COPYING for details.
#############################################################

# Last altered: 12-Jan-2004
# History:
# 17-Oct-2001 PH: created
#
# 12-Jan-2004 PH: added 'tar.bz2' to BOX_FORMAT_INTERP

#---------------------------------------------------------------------

EASIBOX_VERSION = "0.3.0"

DEFAULT_BOX_DESTINATION = "~/box/"

DEFAULT_KEEP_DIRECTORIES = 1

"""***
If the user doesn't specify which box file formats they want to create,
easibox creates all the ones that are in this default.
***"""
DEFAULT_BOX_FORMATS = ['tar.gz']


"""***
BOX_FORMAT_INTERP determines what box formats easibox knows about, 
and how it deals with them.

It is a dictionary, the keys are the file format extensions, and
the corresponding values are the commands to be executed to create
a file of that extension. The commands rely on these variables
existing:
   ad = the archive directory. This is the name of the 
      top-level directory, under the box directory, that all the files 
      in the archive have been put into. For example "leafwa-0.6.1".
      
   afn = the archive filename. This will consist of the ad with
      the corresponding extension, sparated by a ".", for example
      "leafwa-0.6.1.tgz"   
***"""
BOX_FORMAT_INTERP = {
   'tar': 'tar cvf %(afn)s %(ad)s',
   'tar.gz': 'tar czvf %(afn)s %(ad)s',
   'tgz': 'tar czvf %(afn)s %(ad)s',
   'zip': 'zip -r %(afn)s %(ad)s',
   #'tar.bz2': 'tar cf %(ad)s.tar  %(ad)s && bzip2 -f %(ad)s.tar'
   'tar.bz2': 'tar cjvf %(afn)s %(ad)s'
   }
   

#---------------------------------------------------------------------
#end
