package joker

import (
	"math/rand"
	"time"
)

// A Deck represents a deck of cards that is usually shuffled.
type Deck struct {
	cards    []*Card
	discards []*Card
}

// NewDeck returns a new deck of 52 unique cards that is optionally shuffled.
func NewDeck(shuffle bool) *Deck {
	cards := []*Card{}
	for _, r := range allRanks() {
		for _, s := range allSuits() {
			c := NewCard(r, s)
			cards = append(cards, c)
		}
	}

	if shuffle {
		cards = shuffleCards(cards)
	}

	return &Deck{cards, []*Card{}}
}

// Pop removes a card from the deck and returns it.
// TODO need to utilize discards if cards required is greater than 52.
func (d *Deck) Pop() *Card {
	last := len(d.cards) - 1
	cards, card := d.cards[:last], d.cards[last]
	d.cards = cards
	return card
}

// PopMulti removes n cards from the deck and returns them.
func (d *Deck) PopMulti(n int) []*Card {
	cards := []*Card{}
	for i := 0; i < n; i++ {
		cards = append(cards, d.Pop())
	}
	return cards
}

// Discard adds the cards to the deck's discards
func (d *Deck) Discard(cards ...*Card) {
	d.discards = append(d.discards, cards...)
}

func shuffleCards(cards []*Card) []*Card {
	rand.Seed(time.Now().UTC().UnixNano())
	dest := []*Card{}
	perm := rand.Perm(len(cards))
	for _, v := range perm {
		dest = append(dest, cards[v])
	}
	return dest
}
