joker
========

Poker library written in go (golang)

[![GoDoc](https://godoc.org/github.com/loganjspears/joker?status.png)](https://godoc.org/github.com/loganjspears/joker)
[![Build Status](https://drone.io/github.com/loganjspears/joker/status.png)](https://drone.io/github.com/loganjspears/joker/latest)

Package joker implements poker hand evaluation and ranking.

```go
package main

import (
	"fmt"
	"sort"

	"github.com/loganjspears/joker"
)

func main() {
	deck := joker.NewDeck(true)
	h1, _ := joker.NewHand(deck.PopMulti(5))
	h2, _ := joker.NewHand(deck.PopMulti(5))

	const format = "Ranking: %v, Cards: %v, Description: %v\n"
	fmt.Printf(format, h1.Ranking(), h1.Cards(), h1.Description())
	fmt.Printf(format, h2.Ranking(), h2.Cards(), h2.Description())

	hands := []*joker.Hand{h1, h2}
	sort.Sort(joker.ByHighHand(hands))

	fmt.Println("Winner is:", hands[1].Cards())
}

```
