REM: Include file for Hex Editor v2.8a PD 2002.

' initialize all default variables as integer.
DEFINT A-Z

' load all arrays during runtime.
REM $DYNAMIC

' get include files.
REM $INCLUDE: 'dta.bi'
REM $INCLUDE: 'qbx.bi'
REM $INCLUDE: 'wdta.bi'

' declare windows filename structure.
TYPE WinFileType
 Name AS STRING*260
END TYPE

' declare dos filename structure.
TYPE DosFileType
 Name AS STRING*12
END TYPE

REM QBX 7.10 allows the Currency datatype allowing higher values than Long.

' declare undo arrays.
COMMON SHARED UndoByte() AS INTEGER, UndoPosition() AS CURRENCY

' declare undo variables.
COMMON SHARED MaxUndos AS CURRENCY, CurrentUndo AS CURRENCY

' declare marker array.
COMMON SHARED Markers() AS CURRENCY

' declare marker variables.
COMMON SHARED CurrentMarker AS CURRENCY, NewMarker AS CURRENCY
COMMON SHARED MaxMarkers AS CURRENCY, MarkerCount AS CURRENCY

' declare menu area storage arrays.
COMMON SHARED Area1() AS INTEGER, Area2() AS INTEGER

' declare ascii character variables.
COMMON SHARED Hline AS INTEGER, Vline AS INTEGER
COMMON SHARED ULcorner AS INTEGER, URcorner AS INTEGER
COMMON SHARED LLcorner AS INTEGER, LRcorner AS INTEGER

' declare temporary file position variables.
COMMON SHARED Low AS CURRENCY, High AS CURRENCY, HeapSortOff AS INTEGER
COMMON SHARED TempPosition AS CURRENCY, TempPosition1 AS CURRENCY
COMMON SHARED TempPosition2 AS CURRENCY, TempPosition3 AS CURRENCY

' declare common program variables.
COMMON SHARED AsciiValue AS INTEGER, AsciiValue2 AS INTEGER
COMMON SHARED CurrentWindow AS INTEGER, CurrentWindow2 AS INTEGER
COMMON SHARED PageColumn AS INTEGER, PageRow AS INTEGER
COMMON SHARED ScreenDrawn AS INTEGER, ScreenRow AS INTEGER
COMMON SHARED StatusMessage AS STRING, SupportedCall AS INTEGER

' declare filename/file position variables.
COMMON SHARED DumpFile AS STRING, Filename AS STRING
COMMON SHARED FileByte AS STRING*1, FileBytePosition AS CURRENCY
COMMON SHARED FileLength AS CURRENCY, FilePage AS CURRENCY
COMMON SHARED FilePosition AS CURRENCY, FirstByte AS CURRENCY
COMMON SHARED LastByte AS CURRENCY, LastPage AS CURRENCY
COMMON SHARED NewByte AS CURRENCY, NextByte AS CURRENCY
COMMON SHARED NextLine AS CURRENCY, NextPage AS CURRENCY
COMMON SHARED SeekPosition AS CURRENCY, StorePosition AS CURRENCY
COMMON SHARED NewPosition AS CURRENCY, FilePage2 AS CURRENCY
COMMON SHARED PageRow2 AS CURRENCY, PageColumn2 AS CURRENCY
COMMON SHARED Column2 AS CURRENCY, FilePosition2 AS CURRENCY

' declare all long filename common variables.
COMMON SHARED ASCIIZ AS STRING*261, ASCIIZ2 AS STRING*261
COMMON SHARED Buffer AS STRING*1, ConfigFile AS STRING
COMMON SHARED BASIC.DTA.OFF AS INTEGER, BASIC.DTA.SEG AS INTEGER
COMMON SHARED DTAfile AS DTAtype, ErrorTrap AS INTEGER
COMMON SHARED FileAttribute AS INTEGER, Quote AS STRING
COMMON SHARED Windows.Detected AS INTEGER, Wfile.Handle AS INTEGER
COMMON SHARED WDTAfile AS WDTAtype

' declare all common mouse variables.
COMMON SHARED Mouse.Present AS INTEGER, Mouse.Button1 AS INTEGER
COMMON SHARED Mouse.Button2 AS INTEGER, Mouse.Button3 AS INTEGER
COMMON SHARED Mouse.Row AS INTEGER, Mouse.Column AS INTEGER
COMMON SHARED Old.Mouse.Row AS INTEGER, Old.Mouse.Column AS INTEGER
COMMON SHARED Mouse.X AS INTEGER, Mouse.Y AS INTEGER

' declare filename variables for menu.bas
COMMON SHARED Attribute AS INTEGER, ASCIIZ3 AS STRING*261
COMMON SHARED Num.Dirs AS INTEGER, Num.Files AS INTEGER

' declare structures for menu.bas
COMMON SHARED WinFileStruc AS WinFileType, DosFileStruc AS DosFileType

' declare menu screen location offsets for menu.bas
COMMON SHARED Xcoor AS INTEGER, Ycoor AS INTEGER

' declare menu variables for DropDownMenu
COMMON SHARED CurrentMenu AS INTEGER, CurrentMenuSelection AS INTEGER

' declare interrupt structures.
COMMON SHARED InregsX AS RegTypeX, OutregsX AS RegTypeX

' declare author constants.
CONST Author="Erik Jon Oredson AS. CSci"
CONST Email="eoredson@yahoo.com"
CONST Urls="www.simtel.net www.filegate.net"

' declare constants.
CONST Nul=""
CONST False=0
CONST True=-1
CONST Version="v2.8a"
CONST Release="r1.0a"
CONST Publish="08/01/2002."
CONST Status="Public Domain"
CONST Program="Hex Editor"

' declare colors.
CONST Black=0
CONST Blue=1
CONST Cyan=11
CONST Green=10
CONST Magenta=13
CONST Plain=7
CONST Red=12
CONST White=15
CONST Yellow=14

' declare bit constants.
CONST ReadOnlyBit=1
CONST HiddenBit=2
CONST SystemBit=4
CONST ArchiveBit=32

' declare mouse function constants.
CONST CheckMouse=0
CONST ShowMouse=1
CONST HideMouse=2
CONST Position=3
CONST Button=5

' declare functions.
DECLARE FUNCTION Conanicalize$(V$)
DECLARE FUNCTION ReleaseTime()
DECLARE FUNCTION TestFile(V$)
DECLARE FUNCTION TrimSpaces$(V$)

' declare record structure functions.
DECLARE FUNCTION Directories$(V%)
DECLARE FUNCTION Filenames$(V%)

' declare subroutines.
Declare Sub DropDownMenu()
Declare Sub MouseDriver()
Declare Sub MouseFunction(V1%,V2%)
Declare Sub Menu(V1$,V2$,V3$,V4$)
Declare Sub ReadConfigFile (V$)
