namespace eval tab {



# Autogenerated with DRAKON Editor 1.21

proc actions_and_shelves { } {
    #item 209
    set vertex_ids [ vertex_type_keys ]
    #item 210
    set result {}
    #item 2120001
    set _col212 $vertex_ids
    set _len212 [ llength $_col212 ]
    set _ind212 0
    while { 1 } {
        #item 2120002
        if {$_ind212 < $_len212} {
            
        } else {
            break
        }
        #item 2120004
        set vertex_id [ lindex $_col212 $_ind212 ]
        #item 214
        set type [ get_vertex_type $vertex_id ]
        #item 2150001
        if {($type == "action") || ($type == "shelf")} {
            #item 223
            lappend result $vertex_id
        } else {
            
        }
        #item 2120003
        incr _ind212
    }
    #item 211
    return $result
}

proc add_class { name properties defined } {
    #item 127
    set id [ class_next_id ]
    #item 145
    set key [ string tolower $name ]
    #item 131
    insert_class $id $name $properties {} {} {} $defined
    #item 129
    insert_class_by_name $key $id
    #item 970
    return $id
}

proc add_class_declaration { vertex_id } {
    #item 879
    set name [ get_vertex_text $vertex_id ]
    #item 899
    set parts [ split_space $name ]
    #item 904
    if {[ lindex $parts 0 ] == ""} {
        #item 907
        report_error_vertex $vertex_id \
         "Class name expected here"
    } else {
        
    }
    #item 900
    if {[ lindex $parts 0 ] == "class"} {
        #item 903
        report_error_vertex $vertex_id \
         "'class' keyword not expected here"
    } else {
        
    }
    #item 894
    set id [ find_class $name ]
    #item 895
    if {$id == ""} {
        #item 898
        add_class $name {} 0
    } else {
        
    }
}

proc add_class_definition { vertex_id } {
    #item 909
    set header [ get_vertex_text2 $vertex_id ]
    #item 940
    set header_parts [ split $header ":" ]
    lassign $header_parts header_start header_end
    #item 935
    set parts [ split_space $header_start ]
    set options [ split_space $header_end ]
    #item 920
    if {[ llength $parts ] == 2} {
        #item 937
        lassign $parts class name
        #item 911
        if {($class == "class") && (!($name == ""))} {
            
        } else {
            #item 914
            report_error_vertex $vertex_id \
             "'class <Class Name>' expected here"
        }
    } else {
        #item 914
        report_error_vertex $vertex_id \
         "'class <Class Name>' expected here"
    }
    #item 938
    set body [ get_vertex_text $vertex_id ]
    set body_lines [ split_lines $body ]
    #item 961
    set id [ find_class $name ]
    #item 962
    if {$id == ""} {
        #item 965
        set id [ add_class $name $options 1 ]
    } else {
        #item 966
        if {[get_class_defined $id]} {
            #item 969
            report_error_vertex $vertex_id \
             "class $name is already defined elsewhere"
        } else {
            #item 971
            set_class_defined $id 1
            set_class_properties $id $options
        }
    }
    #item 991
    set indices {}
    #item 9720001
    set _col972 $body_lines
    set _len972 [ llength $_col972 ]
    set _ind972 0
    while { 1 } {
        #item 9720002
        if {$_ind972 < $_len972} {
            
        } else {
            break
        }
        #item 9720004
        set line [ lindex $_col972 $_ind972 ]
        #item 974
        set line_parts [ split $line ":" ]
        lassign $line_parts line_begin line_end
        #item 975
        set begin_parts [ split_space $line_begin ]
        set tail_parts [ split_space $line_end ]
        #item 979
        set begin_length [ llength $begin_parts ]
        #item 9800001
        if {$begin_length == 0} {
            #item 988
            report_error_vertex $vertex_id \
             "error in field definition: $line"
        } else {
            #item 9800002
            if {$begin_length == 1} {
                #item 989
                create_field $id $begin_parts $tail_parts \
                  $vertex_id
            } else {
                #item 990
                lappend indices \
                 [ list $begin_parts $tail_parts ]
            }
        }
        #item 9720003
        incr _ind972
    }
    #item 9950001
    set _col995 $indices
    set _len995 [ llength $_col995 ]
    set _ind995 0
    while { 1 } {
        #item 9950002
        if {$_ind995 < $_len995} {
            
        } else {
            break
        }
        #item 9950004
        set index [ lindex $_col995 $_ind995 ]
        #item 997
        create_index $id $index $vertex_id
        #item 9950003
        incr _ind995
    }
}

proc add_diagram { dbase diagram_id } {
    #item 191
    set name [ $dbase onecolumn {
    	select name
    	from diagrams
    	where diagram_id = :diagram_id } ]
    #item 194
    set vertices {}
    #item 192
    $dbase eval {
    	select vertex_id, item_id, type, text, text2, left, up, right, down
    	from vertices
    	where diagram_id = :diagram_id
    	order by vertex_id
    } {
    	insert_vertex $vertex_id $item_id $diagram_id $type $text $text2 $left $up $right $down
    	lappend vertices $vertex_id
    }
    #item 193
    $dbase eval {
    	select edge_id, vertex1, vertex2, head, vertical, items
    	from edges
    	where diagram_id = :diagram_id
    	order by edge_id
    } {
    	insert_edge $edge_id $vertex1 $vertex2 $head $vertical $items 0
    }
    #item 195
    insert_diagram $diagram_id $name $vertices
}

proc add_field { name properties class_id } {
    #item 107
    set key [ make_field_key $class_id $name ]
    #item 108
    set id [ field_next_id ]
    #item 109
    insert_field $id $class_id $name $properties
    #item 113
    insert_field_by_name $key $id
    #item 110
    set class_fields [ get_class_fields $class_id ]
    #item 111
    lappend class_fields $id
    #item 112
    set_class_fields $class_id $class_fields
}

proc add_index { class_id name properties fields } {
    #item 155
    set id [ index_next_id ]
    #item 156
    insert_index $id $class_id $name $properties $fields
    #item 157
    set indexes [ get_class_indexes $class_id ]
    #item 158
    lappend indexes $id
    #item 159
    set_class_indexes $class_id $indexes
}

proc add_link { type ownership src_vertex dst_vertex src_field_id dst_field_id edge } {
    #item 180
    set id [ link_next_id ]
    #item 1289
    set src_class [ get_vertex_class $src_vertex ]
    set dst_class [ get_vertex_class $dst_vertex ]
    #item 845
    set src [ find_class $src_class ]
    set dst [ find_class $dst_class ]
    #item 1288
    set src_field [ get_vertex_text $src_field_id ]
    set dst_field [ get_vertex_text $dst_field_id ]
    #item 1160
    ensure_no_fields_reuse $src $src_field $edge
    ensure_no_fields_reuse $dst $dst_field $edge
    #item 181
    add_link_to_class $src $id
    add_link_to_class $dst $id
    #item 182
    insert_link $id $type $ownership $src $dst $src_field $dst_field
}

proc add_link_to_class { class_id link_id } {
    #item 177
    set class_links [ get_class_links $class_id ]
    #item 178
    lappend class_links $link_id
    #item 179
    set_class_links $class_id $class_links
}

proc base_classes { class } {
    #item 1936
    set result {}
    #item 1938
    set links [ get_class_links $class ]
    #item 19390001
    set _col1939 $links
    set _len1939 [ llength $_col1939 ]
    set _ind1939 0
    while { 1 } {
        #item 19390002
        if {$_ind1939 < $_len1939} {
            
        } else {
            break
        }
        #item 19390004
        set link [ lindex $_col1939 $_ind1939 ]
        #item 1941
        set type [ get_link_type $link ]
        set src [ get_link_src_table $link ]
        #item 1942
        if {($src == $class) && ($type == "inheritance")} {
            #item 1948
            lappend result $link
        } else {
            
        }
        #item 19390003
        incr _ind1939
    }
    #item 1937
    return $result
}

proc build_aux { } {
    #item 1436
    set classes [ class_name_keys ]
    #item 14370001
    set _col1437 $classes
    set _len1437 [ llength $_col1437 ]
    set _ind1437 0
    while { 1 } {
        #item 14370002
        if {$_ind1437 < $_len1437} {
            
        } else {
            break
        }
        #item 14370004
        set class [ lindex $_col1437 $_ind1437 ]
        #item 1439
        set base [ find_base $class ]
        set derived [ find_derived $class ]
        #item 1440
        if {($base == {}) && ($derived == {})} {
            #item 1444
            set simple 1
        } else {
            #item 1445
            set simple 0
        }
        #item 2314
        lassign \
        [has_ref_count $class] \
        ref_count master_arrow
        #item 1446
        insert_class2 $class $simple $base \
         $derived $ref_count $master_arrow
        #item 1449
        set fields [ get_class_fields $class ]
        #item 14470001
        set _col1447 $fields
        set _len1447 [ llength $_col1447 ]
        set _ind1447 0
        while { 1 } {
            #item 14470002
            if {$_ind1447 < $_len1447} {
                
            } else {
                break
            }
            #item 14470004
            set field [ lindex $_col1447 $_ind1447 ]
            #item 1450
            gen_field_aux $class $field
            #item 14470003
            incr _ind1447
        }
        #item 14370003
        incr _ind1437
    }
    #item 26860001
    set _col2686 $classes
    set _len2686 [ llength $_col2686 ]
    set _ind2686 0
    while { 1 } {
        #item 26860002
        if {$_ind2686 < $_len2686} {
            
        } else {
            break
        }
        #item 26860004
        set class [ lindex $_col2686 $_ind2686 ]
        #item 2688
        check_class_inheritance $class
        #item 26860003
        incr _ind2686
    }
    #item 23420001
    set _col2342 $classes
    set _len2342 [ llength $_col2342 ]
    set _ind2342 0
    while { 1 } {
        #item 23420002
        if {$_ind2342 < $_len2342} {
            
        } else {
            break
        }
        #item 23420004
        set class [ lindex $_col2342 $_ind2342 ]
        #item 2344
        set chain [ inheritance_chain $class ]
        set base [ lindex $chain 0 ]
        set ref_count [ get_class2_has_ref_count $class ]
        #item 2345
        if {$ref_count} {
            #item 2348
            set_class2_has_ref_count $base 1
        } else {
            
        }
        #item 23420003
        incr _ind2342
    }
}

proc build_classes { } {
    #item 847
    set vertex_ids [ vertex_type_keys ]
    #item 8500001
    set _col850 $vertex_ids
    set _len850 [ llength $_col850 ]
    set _ind850 0
    while { 1 } {
        #item 8500002
        if {$_ind850 < $_len850} {
            
        } else {
            break
        }
        #item 8500004
        set vertex_id [ lindex $_col850 $_ind850 ]
        #item 852
        set type [ get_vertex_type $vertex_id ]
        #item 8530001
        if {$type == "action"} {
            #item 863
            add_class_declaration $vertex_id
        } else {
            #item 8530002
            if {$type == "shelf"} {
                #item 864
                add_class_definition $vertex_id
            } else {
                
            }
        }
        #item 8500003
        incr _ind850
    }
}

proc build_connections { } {
    #item 226
    set vertexes \
    [actions_and_shelves]
    #item 2270001
    set _col227 $vertexes
    set _len227 [ llength $_col227 ]
    set _ind227 0
    while { 1 } {
        #item 2270002
        if {$_ind227 < $_len227} {
            
        } else {
            break
        }
        #item 2270004
        set vertex_id [ lindex $_col227 $_ind227 ]
        #item 229
        set right \
        [get_vertex_right $vertex_id]
        #item 232
        set down \
        [get_vertex_down $vertex_id]
        #item 589
        set in_head {}
        #item 595
        set con \
        [make_con $vertex_id {} $in_head {}]
        #item 233
        con_hor_begin $right $con
        #item 234
        con_ver_begin $down $con
        #item 2270003
        incr _ind227
    }
}

proc build_indexes { } {
    #item 1324
    set ids [ index_info_data_keys ]
    #item 13250001
    set _col1325 $ids
    set _len1325 [ llength $_col1325 ]
    set _ind1325 0
    while { 1 } {
        #item 13250002
        if {$_ind1325 < $_len1325} {
            
        } else {
            break
        }
        #item 13250004
        set id [ lindex $_col1325 $_ind1325 ]
        #item 1327
        set class_id [ get_index_info_class_id $id ]
        set data [ get_index_info_data $id ]
        set vertex_id [ get_index_info_vertex $id ]
        #item 1328
        create_index_core $class_id $data $vertex_id
        #item 13250003
        incr _ind1325
    }
}

proc build_link { connection_id } {
    #item 1091
    set orientation \
    [get_connection_orientation $connection_id]
    #item 1092
    set head \
    [get_connection_head $connection_id]
    #item 1129
    set ovals \
    [get_connection_ovals $connection_id]
    #item 1158
    set vertex1 [ get_connection_vertex1 $connection_id ]
    set vertex2 [ get_connection_vertex2 $connection_id ]
    #item 1159
    set edge [ get_connection_edge $connection_id ]
    #item 1213
    set rovals [ lreverse $ovals ]
    #item 10990001
    if {$orientation == "horizontal"} {
        #item 11060001
        if {$head == "line"} {
            #item 1128
            link_line "none" $edge \
             $vertex1 $vertex2 $ovals
        } else {
            #item 11060002
            if {$head == "arrow"} {
                #item 1132
                link_arrow "none" $edge \
                 $vertex1 $vertex2 $ovals
            } else {
                #item 11060003
                if {$head == "m2m"} {
                    #item 1332
                    link_m2m $edge \
                     $vertex1 $vertex2 $ovals
                } else {
                    #item 11060004
                    if {$head == "paw"} {
                        
                    } else {
                        #item 11060005
                        error "Unexpected switch value: $head"
                    }
                    #item 1133
                    link_paw "none" $edge \
                     $vertex1 $vertex2 $ovals
                }
            }
        }
    } else {
        #item 10990002
        if {$orientation == "vertical"} {
            
        } else {
            #item 10990003
            error "Unexpected switch value: $orientation"
        }
        #item 11170001
        if {$head == "up white arrow"} {
            #item 1135
            link_inherit $edge \
             $vertex2 $vertex1 $rovals
        } else {
            #item 11170002
            if {$head == "up arrow"} {
                #item 1136
                link_arrow "dst" $edge \
                 $vertex2 $vertex1 $rovals
            } else {
                #item 11170003
                if {$head == "down arrow"} {
                    #item 1137
                    link_arrow "src" $edge \
                     $vertex1 $vertex2 $ovals
                } else {
                    #item 11170004
                    if {$head == "line"} {
                        #item 1138
                        link_line "src" $edge \
                         $vertex1 $vertex2 $ovals
                    } else {
                        #item 11170005
                        if {$head == "down paw"} {
                            
                        } else {
                            #item 11170006
                            error "Unexpected switch value: $head"
                        }
                        #item 1139
                        link_paw "src" $edge \
                         $vertex1 $vertex2 $ovals
                    }
                }
            }
        }
    }
}

proc build_links { } {
    #item 1069
    set connections \
    [connection_vertex1_keys]
    #item 10870001
    set _col1087 $connections
    set _len1087 [ llength $_col1087 ]
    set _ind1087 0
    while { 1 } {
        #item 10870002
        if {$_ind1087 < $_len1087} {
            
        } else {
            break
        }
        #item 10870004
        set connection_id [ lindex $_col1087 $_ind1087 ]
        #item 1068
        build_link $connection_id
        #item 10870003
        incr _ind1087
    }
}

proc chain_ref_count { chain } {
    #item 23260001
    set _col2326 $chain
    set _len2326 [ llength $_col2326 ]
    set _ind2326 0
    while { 1 } {
        #item 23260002
        if {$_ind2326 < $_len2326} {
            
        } else {
            #item 2332
            return 0
        }
        #item 23260004
        set $class [ lindex $_col2326 $_ind2326 ]
        #item 2328
        if {[get_class2_has_ref_count $class]} {
            #item 2331
            return 1
        } else {
            
        }
        #item 23260003
        incr _ind2326
    }
}

proc check_class_inheritance { class } {
    #item 1876
    set base_links [ base_classes $class ]
    set base_count [ llength $base_links ]
    #item 1892
    set name [ get_class_name $class ]
    #item 19490001
    if {$base_count == 0} {
        #item 1956
        set base_link {}
    } else {
        #item 19490002
        if {$base_count == 1} {
            #item 1957
            set base_link [ lindex $base_links 0 ]
        } else {
            #item 1959
            set message "Class $name has several base classes."
            #item 1958
            report_error_class $name $message
        }
    }
    #item 1912
    if {$base_link == {}} {
        
    } else {
        #item 1915
        if {[find_cycles $base_link [ list $class ]]} {
            #item 1919
            set message "Inheritance cycle detected at class $name."
            #item 1918
            report_error_class $name $message
        } else {
            
        }
    }
}

proc check_empty_link { id } {
    #item 1406
    set type [ get_empty_link_type $id ]
    set own [ get_empty_link_ownership $id ]
    set src [ get_empty_link_src $id ]
    set dst [ get_empty_link_dst $id ]
    set edge [ get_empty_link_edge $id ]
    #item 1407
    set links [ link_type_keys ]
    #item 14080001
    set _col1408 $links
    set _len1408 [ llength $_col1408 ]
    set _ind1408 0
    while { 1 } {
        #item 14080002
        if {$_ind1408 < $_len1408} {
            
        } else {
            #item 1414
            report_error_edge $edge \
             "Properties for this link are not defined"
            break
        }
        #item 14080004
        set link_id [ lindex $_col1408 $_ind1408 ]
        #item 1410
        set type2 [ get_link_type $link_id ]
        set own2 [ get_link_ownership $link_id ]
        set src2 [ get_link_src_table $link_id ]
        set dst2 [ get_link_dst_table $link_id ]
        #item 1411
        if {$type == $type2} {
            #item 1415
            if {$own == $own2} {
                #item 1416
                if {$src == $src2} {
                    #item 1417
                    if {$dst == $dst2} {
                        break
                    } else {
                        
                    }
                } else {
                    
                }
            } else {
                
            }
        } else {
            
        }
        #item 14080003
        incr _ind1408
    }
}

proc check_hor_ellipse { vertex_id } {
    #item 369
    set right [ get_vertex_right $vertex_id ]
    set up [ get_vertex_up $vertex_id ]
    set down [ get_vertex_down $vertex_id ]
    #item 370
    if {$up == ""} {
        #item 373
        if {$down == ""} {
            #item 376
            if {$right == ""} {
                #item 380
                report_error_vertex $vertex_id
                 "Connector expected to the right"
            } else {
                #item 381
                return $right
            }
        } else {
            #item 804
            report_error_edge $down \
             "Connector not expected"
        }
    } else {
        #item 379
        report_error_edge $up \
         "Connector not expected"
    }
}

proc check_inheritance { } {
    #item 1855
    set links [ link_type_keys ]
    #item 18530001
    set _col1853 $links
    set _len1853 [ llength $_col1853 ]
    set _ind1853 0
    while { 1 } {
        #item 18530002
        if {$_ind1853 < $_len1853} {
            
        } else {
            break
        }
        #item 18530004
        set link [ lindex $_col1853 $_ind1853 ]
        #item 1856
        set type [ get_link_type $link ]
        #item 1857
        if {$type == "inheritance"} {
            #item 1860
            set derived [ get_link_src_table $link ]
            #item 1861
            check_class_inheritance $derived
        } else {
            
        }
        #item 18530003
        incr _ind1853
    }
}

proc check_links_defined { } {
    #item 1377
    set ids \
    [empty_link_src_keys]
    #item 13790001
    set _col1379 $ids
    set _len1379 [ llength $_col1379 ]
    set _ind1379 0
    while { 1 } {
        #item 13790002
        if {$_ind1379 < $_len1379} {
            
        } else {
            break
        }
        #item 13790004
        set id [ lindex $_col1379 $_ind1379 ]
        #item 1376
        check_empty_link $id
        #item 13790003
        incr _ind1379
    }
}

proc check_ver_ellipse { vertex_id } {
    #item 792
    set right [ get_vertex_right $vertex_id ]
    set left [ get_vertex_left $vertex_id ]
    set down [ get_vertex_down $vertex_id ]
    #item 793
    if {$left == ""} {
        #item 796
        if {$right == ""} {
            #item 797
            if {$down == ""} {
                #item 800
                report_error_vertex $vertex_id
                 "Connector expected down"
            } else {
                #item 801
                return $down
            }
        } else {
            #item 805
            report_error_edge $right \
             "Connector not expected"
        }
    } else {
        #item 799
        report_error_edge $left \
         "Connector not expected"
    }
}

proc con_hor_begin { edge_id in_con } {
    #item 440
    if {$edge_id == ""} {
        
    } else {
        #item 417
        lassign $in_con vertex1 _ in_head ovals
        #item 245
        set head [ get_edge_head $edge_id ]
        set vertex2 [ get_edge_vertex2 $edge_id ]
        set type2 [ get_vertex_type $vertex2 ]
        #item 2570001
        if {($type2 == "action") || ($type2 == "shelf")} {
            #item 418
            set next_head \
            [select_hor_head $edge_id $in_head $head]
            #item 287
            connect $vertex1 $vertex2 $next_head $ovals $edge_id
        } else {
            #item 2570003
            if {$type2 == "beginend"} {
                #item 306
                ensure_simple_right $edge_id $head
                #item 307
                set next_edge [ check_hor_ellipse $vertex2 ]
                #item 433
                lappend ovals $vertex2
                #item 600
                set next_head \
                [select_hor_head $edge_id $in_head $head]
                #item 288
                set con \
                [make_con $vertex1 {} $next_head $ovals]
                #item 308
                con_hor_begin $next_edge $con
            } else {
                #item 2570004
                if {$type2 == ""} {
                    #item 311
                    ensure_simple_right $edge_id $head
                    #item 309
                    set right [ get_vertex_right $vertex2 ]
                    set up [ get_vertex_up $vertex2 ]
                    set down [ get_vertex_down $vertex2 ]
                    #item 439
                    set next_head \
                    [select_hor_head $edge_id $in_head $head]
                    #item 310
                    set con \
                    [make_con $vertex1 {} $next_head $ovals]
                    #item 312
                    con_hor_up $up $con
                    con_hor_begin $right $con
                    con_hor_down $down $con
                } else {
                    #item 284
                    report_error_vertex \
                     $vertex2 "Unexpected icon type: $type"
                }
            }
        }
    }
}

proc con_hor_down { edge_id in_con } {
    #item 530
    if {$edge_id == ""} {
        
    } else {
        #item 529
        lassign $in_con vertex1 _ in_head ovals
        #item 513
        set head [ get_edge_head $edge_id ]
        set vertex2 [ get_edge_vertex2 $edge_id ]
        set type2 [ get_vertex_type $vertex2 ]
        #item 535
        if {$head == ""} {
            
        } else {
            #item 538
            report_error_edge \
             $edge_id "Simple vertical line expected"
        }
        #item 5140001
        if {(($type2 == "action") || ($type2 == "shelf")) || ($type2 == "beginend")} {
            #item 533
            report_error_vertex \
             $vertex2 "Unexpected vertical connection"
        } else {
            #item 5140004
            if {$type2 == ""} {
                #item 527
                set right [ get_vertex_right $vertex2 ]
                set down [ get_vertex_down $vertex2 ]
                #item 528
                con_hor_down $down $in_con
                con_hor_end $right $in_con
            } else {
                #item 524
                report_error_vertex \
                 $vertex2 "Unexpected icon type: $type"
            }
        }
    }
}

proc con_hor_end { edge_id in_con } {
    #item 581
    if {$edge_id == ""} {
        
    } else {
        #item 576
        lassign $in_con vertex1 _ in_head ovals
        #item 552
        set head [ get_edge_head $edge_id ]
        set vertex2 [ get_edge_vertex2 $edge_id ]
        set type2 [ get_vertex_type $vertex2 ]
        #item 5530001
        if {($type2 == "action") || ($type2 == "shelf")} {
            #item 577
            set next_head \
            [select_hor_head $edge_id $in_head $head]
            #item 567
            connect $vertex1 $vertex2 $next_head $ovals $edge_id
        } else {
            #item 5530003
            if {$type2 == "beginend"} {
                #item 569
                ensure_simple_right $edge_id $head
                #item 570
                set next_edge [ check_hor_ellipse $vertex2 ]
                #item 578
                lappend ovals $vertex2
                #item 568
                set con \
                [make_con $vertex1 {} $in_head $ovals]
                #item 571
                con_hor_end $next_edge $con
            } else {
                #item 5530004
                if {$type2 == ""} {
                    #item 574
                    ensure_simple_right $edge_id $head
                    #item 572
                    set right [ get_vertex_right $vertex2 ]
                    #item 584
                    if {$right == ""} {
                        #item 585
                        report_error_edge \
                         $edge_id \
                         "Expected connector to the right"
                    } else {
                        
                    }
                    #item 580
                    set next_head \
                    [select_hor_head $edge_id $in_head $head]
                    #item 573
                    set con \
                    [make_con $vertex1 {} $next_head $ovals]
                    #item 575
                    con_hor_end $right $con
                } else {
                    #item 564
                    report_error_vertex \
                     $vertex2 "Unexpected icon type: $type"
                }
            }
        }
    }
}

proc con_hor_up { edge_id in_con } {
    #item 481
    if {$edge_id == ""} {
        
    } else {
        #item 472
        lassign $in_con vertex2 _ in_head ovals
        #item 448
        set head [ get_edge_head $edge_id ]
        set vertex1 [ get_edge_vertex1 $edge_id ]
        set type2 [ get_vertex_type $vertex1 ]
        #item 486
        if {$head == ""} {
            
        } else {
            #item 489
            report_error_edge \
             $edge_id "Simple vertical line expected"
        }
        #item 4490001
        if {(($type2 == "action") || ($type2 == "shelf")) || ($type2 == "beginend")} {
            #item 484
            report_error_vertex \
             $vertex1 "Unexpected vertical connection"
        } else {
            #item 4490004
            if {$type2 == ""} {
                #item 468
                set right [ get_vertex_right $vertex1 ]
                set up [ get_vertex_up $vertex1 ]
                #item 490
                if {$right == ""} {
                    #item 493
                    if {$up == ""} {
                        #item 496
                        report_error_edge \
                         $edge_id \
                         "Expected connector up or to the right"
                    } else {
                        
                    }
                } else {
                    
                }
                #item 471
                con_hor_up $up $in_con
                con_hor_end $right $in_con
            } else {
                #item 460
                report_error_vertex \
                 $vertex1 "Unexpected icon type: $type2"
            }
        }
    }
}

proc con_ver_begin { edge_id in_con } {
    #item 641
    if {$edge_id == ""} {
        
    } else {
        #item 637
        lassign $in_con vertex1 _ in_head ovals
        #item 613
        set head [ get_edge_head $edge_id ]
        set vertex2 [ get_edge_vertex2 $edge_id ]
        set type2 [ get_vertex_type $vertex2 ]
        #item 6140001
        if {($type2 == "action") || ($type2 == "shelf")} {
            #item 638
            set next_head \
            [select_ver_head $edge_id $in_head $head]
            #item 628
            connect_ver $vertex1 $vertex2 $next_head $ovals $edge_id
        } else {
            #item 6140003
            if {$type2 == "beginend"} {
                #item 630
                ensure_simple_down $edge_id $head
                #item 631
                set next_edge [ check_ver_ellipse $vertex2 ]
                #item 639
                lappend ovals $vertex2
                #item 644
                set next_head \
                [select_ver_head $edge_id $in_head $head]
                #item 629
                set con \
                [make_con $vertex1 {} $next_head $ovals]
                #item 632
                con_ver_begin $next_edge $con
            } else {
                #item 6140004
                if {$type2 == ""} {
                    #item 635
                    ensure_simple_down $edge_id $head
                    #item 633
                    set right [ get_vertex_right $vertex2 ]
                    set left [ get_vertex_left $vertex2 ]
                    set down [ get_vertex_down $vertex2 ]
                    #item 640
                    set next_head \
                    [select_ver_head $edge_id $in_head $head]
                    #item 634
                    set con \
                    [make_con $vertex1 {} $next_head $ovals]
                    #item 636
                    con_ver_left $left $con
                    con_ver_right $right $con
                    con_ver_begin $down $con
                } else {
                    #item 625
                    report_error_vertex \
                     $vertex2 "Unexpected icon type: $type"
                }
            }
        }
    }
}

proc con_ver_end { edge_id in_con } {
    #item 780
    if {$edge_id == ""} {
        
    } else {
        #item 776
        lassign $in_con vertex1 _ in_head ovals
        #item 752
        set head [ get_edge_head $edge_id ]
        set vertex2 [ get_edge_vertex2 $edge_id ]
        set type2 [ get_vertex_type $vertex2 ]
        #item 7530001
        if {($type2 == "action") || ($type2 == "shelf")} {
            #item 777
            set next_head \
            [select_ver_head $edge_id $in_head $head]
            #item 767
            connect_ver $vertex1 $vertex2 $next_head $ovals $edge_id
        } else {
            #item 7530003
            if {$type2 == "beginend"} {
                #item 769
                ensure_simple_down $edge_id $head
                #item 770
                set next_edge [ check_ver_ellipse $vertex2 ]
                #item 778
                lappend ovals $vertex2
                #item 768
                set con \
                [make_con $vertex1 {} $in_head $ovals]
                #item 771
                con_ver_end $next_edge $con
            } else {
                #item 7530004
                if {$type2 == ""} {
                    #item 774
                    ensure_simple_down $edge_id $head
                    #item 772
                    set down [ get_vertex_down $vertex2 ]
                    #item 783
                    if {$down == ""} {
                        #item 784
                        report_error_edge \
                         $edge_id \
                         "Expected connector down"
                    } else {
                        
                    }
                    #item 779
                    set next_head \
                    [select_ver_head $edge_id $in_head $head]
                    #item 773
                    set con \
                    [make_con $vertex1 {} $next_head $ovals]
                    #item 775
                    con_ver_end $down $con
                } else {
                    #item 764
                    report_error_vertex \
                     $vertex2 "Unexpected icon type: $type"
                }
            }
        }
    }
}

proc con_ver_left { edge_id in_con } {
    #item 700
    if {$edge_id == ""} {
        
    } else {
        #item 699
        lassign $in_con vertex2 _ in_head ovals
        #item 683
        set head [ get_edge_head $edge_id ]
        set vertex1 [ get_edge_vertex1 $edge_id ]
        set type2 [ get_vertex_type $vertex1 ]
        #item 705
        if {$head == ""} {
            
        } else {
            #item 708
            report_error_edge \
             $edge_id "Simple horizontal line expected"
        }
        #item 6840001
        if {(($type2 == "action") || ($type2 == "shelf")) || ($type2 == "beginend")} {
            #item 703
            report_error_vertex \
             $vertex1 "Unexpected horizontal connection"
        } else {
            #item 6840004
            if {$type2 == ""} {
                #item 697
                set down [ get_vertex_down $vertex1 ]
                set left [ get_vertex_left $vertex1 ]
                #item 709
                if {$left == ""} {
                    #item 712
                    if {$down == ""} {
                        #item 715
                        report_error_edge \
                         $edge_id \
                         "Expected connector down or to the left"
                    } else {
                        
                    }
                } else {
                    
                }
                #item 698
                con_ver_left $left $in_con
                con_ver_end $down $in_con
            } else {
                #item 694
                report_error_vertex \
                 $vertex1 "Unexpected icon type: $type2"
            }
        }
    }
}

proc con_ver_right { edge_id in_con } {
    #item 738
    if {$edge_id == ""} {
        
    } else {
        #item 737
        lassign $in_con vertex1 _ in_head ovals
        #item 721
        set head [ get_edge_head $edge_id ]
        set vertex2 [ get_edge_vertex2 $edge_id ]
        set type2 [ get_vertex_type $vertex2 ]
        #item 743
        if {$head == ""} {
            
        } else {
            #item 746
            report_error_edge \
             $edge_id "Simple horizontal line expected"
        }
        #item 7220001
        if {(($type2 == "action") || ($type2 == "shelf")) || ($type2 == "beginend")} {
            #item 741
            report_error_vertex \
             $vertex2 "Unexpected horizontal connection"
        } else {
            #item 7220004
            if {$type2 == ""} {
                #item 735
                set right [ get_vertex_right $vertex2 ]
                set down [ get_vertex_down $vertex2 ]
                #item 736
                con_ver_end $down $in_con
                con_ver_right $right $in_con
            } else {
                #item 732
                report_error_vertex \
                 $vertex2 "Unexpected icon type: $type"
            }
        }
    }
}

proc connect { vertex1 vertex2 head ovals edge } {
    #item 3400001
    if {$head == "left paw"} {
        #item 347
        set out_head "paw"
        #item 351
        set out_ovals [ lreverse $ovals ]
        #item 353
        set out_vertex1 $vertex2
        set out_vertex2 $vertex1
    } else {
        #item 3400002
        if {$head == "left arrow"} {
            #item 348
            set out_head "arrow"
            #item 351
            set out_ovals [ lreverse $ovals ]
            #item 353
            set out_vertex1 $vertex2
            set out_vertex2 $vertex1
        } else {
            #item 3400003
            if {$head == "right paw"} {
                #item 358
                set out_head "paw"
            } else {
                #item 3400004
                if {$head == "right arrow"} {
                    #item 359
                    set out_head "arrow"
                } else {
                    #item 3400005
                    if {$head == "m2m"} {
                        #item 606
                        set out_head "m2m"
                    } else {
                        #item 3400006
                        if {$head == ""} {
                            
                        } else {
                            #item 3400007
                            error "Unexpected switch value: $head"
                        }
                        #item 362
                        set out_head "line"
                    }
                }
            }
            #item 352
            set out_ovals $ovals
            #item 354
            set out_vertex1 $vertex1
            set out_vertex2 $vertex2
        }
    }
    #item 363
    set id [ connection_next_id ]
    #item 334
    insert_connection \
    	$id \
    	$out_vertex1 \
    	$out_vertex2 \
    	"horizontal" \
    	$out_head \
    	$out_ovals \
    	$edge
}

proc connect_ver { vertex1 vertex2 head ovals edge } {
    #item 841
    if {$head == ""} {
        #item 844
        set head "line"
    } else {
        
    }
    #item 674
    set id [ connection_next_id ]
    #item 650
    insert_connection \
    	$id \
    	$vertex1 \
    	$vertex2 \
    	"vertical" \
    	$head \
    	$ovals \
    	$edge
}

proc core_can_delete { class } {
    #item 2469
    set body {}
    #item 2454
    set fields [ get_class_fields $class ]
    #item 24550001
    set _col2455 $fields
    set _len2455 [ llength $_col2455 ]
    set _ind2455 0
    while { 1 } {
        #item 24550002
        if {$_ind2455 < $_len2455} {
            
        } else {
            break
        }
        #item 24550004
        set field [ lindex $_col2455 $_ind2455 ]
        #item 2457
        set type [ get_field2_type $field ]
        #item 2458
        if {$type == "collection"} {
            #item 2461
            set link [ get_field2_link $field ]
            set own [ get_link_ownership $link ]
            set link_type [ get_link_type $link ]
            #item 2610
            if {$link_type == "paw"} {
                #item 2462
                if {$own == "none"} {
                    #item 2467
                    set dst [ get_link_dst_table $link ]
                    #item 2468
                    set action [ list \
                     "action" "ensure_deleted" "field" $field \
                     "class" $dst ]
                    #item 2466
                    set check [ list \
                     "foreach" [ list "field" $field ] \
                     "do" $action ]
                    #item 2470
                    lappend body $check
                } else {
                    
                }
            } else {
                
            }
        } else {
            
        }
        #item 24550003
        incr _ind2455
    }
    #item 2471
    set head [ list "proc" "can_delete" "body" $body ]
    #item 2472
    return $head
}

proc core_classes_table { } {
    #item 1982
    set names {}
    #item 1976
    set classes [ class_name_keys ]
    #item 19780001
    set _col1978 $classes
    set _len1978 [ llength $_col1978 ]
    set _ind1978 0
    while { 1 } {
        #item 19780002
        if {$_ind1978 < $_len1978} {
            
        } else {
            break
        }
        #item 19780004
        set class [ lindex $_col1978 $_ind1978 ]
        #item 1980
        set name [ get_class_name $class ]
        lappend names $name
        #item 19780003
        incr _ind1978
    }
    #item 1983
    set sorted [ lsort $names ]
    #item 1988
    set tables {}
    #item 19840001
    set _col1984 $sorted
    set _len1984 [ llength $_col1984 ]
    set _ind1984 0
    while { 1 } {
        #item 19840002
        if {$_ind1984 < $_len1984} {
            
        } else {
            break
        }
        #item 19840004
        set name [ lindex $_col1984 $_ind1984 ]
        #item 1986
        set class [ find_class $name ]
        lappend tables [ list $class $name ]
        #item 19840003
        incr _ind1984
    }
    #item 1987
    return $tables
}

proc core_debug_print { output field_selector } {
    #item 2011
    set classes [ core_classes_table ]
    #item 2036
    puts $output "classes:"
    #item 2037
    print_list $classes $output
    #item 20240001
    set _col2024 $classes
    set _len2024 [ llength $_col2024 ]
    set _ind2024 0
    while { 1 } {
        #item 20240002
        if {$_ind2024 < $_len2024} {
            
        } else {
            break
        }
        #item 20240004
        set cls [ lindex $_col2024 $_ind2024 ]
        #item 2038
        lassign $cls class name
        #item 2039
        puts $output ""
        puts $output "class $name"
        #item 2040
        print_proc [ core_insert $class $field_selector ]
        #item 2041
        print_proc [ core_delete $class ]
        #item 2270
        set fields [ get_class_fields $class ]
        #item 22680001
        set _col2268 $fields
        set _len2268 [ llength $_col2268 ]
        set _ind2268 0
        while { 1 } {
            #item 22680002
            if {$_ind2268 < $_len2268} {
                
            } else {
                break
            }
            #item 22680004
            set field [ lindex $_col2268 $_ind2268 ]
            #item 2042
            set chunk [ core_update $field ]
            #item 2271
            if {$chunk == ""} {
                
            } else {
                #item 2274
                print_proc $chunk
            }
            #item 22680003
            incr _ind2268
        }
        #item 2043
        print_proc \
         [ core_insert_possible $class $field_selector ]
        print_proc \
         [ core_pre_delete_outer $class ]
        print_proc \
         [ core_pre_delete_middle $class ]
        print_proc \
         [ core_pre_delete_inner $class ]
        print_proc \
         [ core_can_delete $class ]
        print_proc \
         [ core_do_delete $class ]
        #item 20240003
        incr _ind2024
    }
}

proc core_delete { class } {
    #item 2003
    set body {}
    #item 2394
    set master [ get_class2_master_arrow $class ]
    #item 2395
    if {$master} {
        #item 2398
        set mvalue "false"
    } else {
        #item 2397
        set mvalue "none"
    }
    #item 2538
    lappend body \
     [ list "action" "check_self" "class" $class ]
    #item 2393
    lappend body [ list \
     "action" "pre_delete_outer" \
     "class" $class "field_name" "id" "master" $mvalue ]
    #item 2005
    lappend body \
     [ list "foreach" { "variable" "del_list" } \
     "do" { "action" "can_delete" } ]
    #item 2400
    lappend body \
     [ list "foreach" { "variable" "del_list" } \
     "do" { "action" "do_delete" } ]
    #item 2401
    set head [ list "proc" "delete" "body" $body ]
    #item 2402
    return $head
}

proc core_delete_body { class } {
    #item 2641
    set body {}
    #item 2640
    set fields [ get_class_fields $class ]
    set indexes [ get_class_indexes $class ]
    #item 26480001
    set _col2648 $fields
    set _len2648 [ llength $_col2648 ]
    set _ind2648 0
    while { 1 } {
        #item 26480002
        if {$_ind2648 < $_len2648} {
            
        } else {
            break
        }
        #item 26480004
        set field [ lindex $_col2648 $_ind2648 ]
        #item 2649
        set type [ get_field2_type $field ]
        #item 26640001
        if {$type == "reference"} {
            #item 2651
            set link [ get_field2_link $field ]
            set target [ get_target $link ]
            #item 2653
            set op [ get_connect_type $field ]
            #item 2652
            lappend body \
             [ list "action" "disconnect" "op" $op \
             "field" $field "link" $link "target" $target]
        } else {
            #item 26640002
            if {$type == "collection"} {
                #item 2671
                set link [ get_field2_link $field ]
                set link_type [ get_link_type $link ]
                #item 2672
                if {$link_type == "m2m"} {
                    #item 2675
                    lassign \
                    [get_other_side $field] \
                    target_class target_field
                    #item 2674
                    set action \
                     [ list "action" "disconnect_m2m" \
                     "field" $field "target_field" $target_field]
                    #item 2673
                    lappend body [ list \
                     "foreach" [ list "field" $field ] \
                     "do" $action ]
                } else {
                    
                }
            } else {
                
            }
        }
        #item 26480003
        incr _ind2648
    }
    #item 26610001
    set _col2661 $indexes
    set _len2661 [ llength $_col2661 ]
    set _ind2661 0
    while { 1 } {
        #item 26610002
        if {$_ind2661 < $_len2661} {
            
        } else {
            break
        }
        #item 26610004
        set index [ lindex $_col2661 $_ind2661 ]
        #item 2663
        set i_fields [ index_fields $index ]
        lappend body \
         [ list "action" "remove_from_index" \
         "index" $index \
         "fields" $i_fields ]
        #item 26610003
        incr _ind2661
    }
    #item 2656
    return $body
}

proc core_do_delete { class } {
    #item 2676
    set chain [ inheritance_chain $class ]
    set chain [ lreverse $chain ]
    #item 2481
    set body {}
    #item 26770001
    set _col2677 $chain
    set _len2677 [ llength $_col2677 ]
    set _ind2677 0
    while { 1 } {
        #item 26770002
        if {$_ind2677 < $_len2677} {
            
        } else {
            break
        }
        #item 26770004
        set cls [ lindex $_col2677 $_ind2677 ]
        #item 2679
        set part [ core_delete_body $cls ]
        set body [ concat $body $part ]
        #item 2478
        set fields [ get_class_fields $class ]
        set indexes [ get_class_indexes $class ]
        #item 26770003
        incr _ind2677
    }
    #item 2682
    set head \
     [ list "proc" "do_delete" "body" $body ]
    #item 2681
    return $head
}

proc core_insert { class fields_selector } {
    #item 1641
    set body {}
    #item 1636
    set chain [ inheritance_chain $class ]
    set indexed {}
    set all_fields {}
    #item 16370001
    set _col1637 $chain
    set _len1637 [ llength $_col1637 ]
    set _ind1637 0
    while { 1 } {
        #item 16370002
        if {$_ind1637 < $_len1637} {
            
        } else {
            break
        }
        #item 16370004
        set cls [ lindex $_col1637 $_ind1637 ]
        #item 1639
        set fields [ select_fields $cls $fields_selector ]
        #item 1640
        set all_fields [ concat $all_fields $fields ]
        dict append indexed $cls $fields
        #item 16370003
        incr _ind1637
    }
    #item 1642
    set root [ lindex $chain 0 ]
    lappend body [ list \
     "action" "check_id" "class" $root ]
    #item 17350001
    set _col1735 $chain
    set _len1735 [ llength $_col1735 ]
    set _ind1735 0
    while { 1 } {
        #item 17350002
        if {$_ind1735 < $_len1735} {
            
        } else {
            break
        }
        #item 17350004
        set cls [ lindex $_col1735 $_ind1735 ]
        #item 1737
        set fields [ dict get $indexed $cls ]
        #item 1739
        lappend body \
         [ list "action" "insert_possible" \
         "class" $cls \
         "fields" $fields ]
        #item 17350003
        incr _ind1735
    }
    #item 1644
    lappend body \
     [ list "action" "assemble" \
     "indexed" $indexed \
     "all" $all_fields ]
    #item 16510001
    set _col1651 $chain
    set _len1651 [ llength $_col1651 ]
    set _ind1651 0
    while { 1 } {
        #item 16510002
        if {$_ind1651 < $_len1651} {
            
        } else {
            break
        }
        #item 16510004
        set cls [ lindex $_col1651 $_ind1651 ]
        #item 1653
        set indexes [ get_class_indexes $cls ]
        #item 16680001
        set _col1668 $indexes
        set _len1668 [ llength $_col1668 ]
        set _ind1668 0
        while { 1 } {
            #item 16680002
            if {$_ind1668 < $_len1668} {
                
            } else {
                break
            }
            #item 16680004
            set index [ lindex $_col1668 $_ind1668 ]
            #item 1654
            set i_fields [ index_fields $index ]
            lappend body \
             [ list "action" "add_to_index" \
             "index" $index \
             "fields" $i_fields ]
            #item 16680003
            incr _ind1668
        }
        #item 16510003
        incr _ind1651
    }
    #item 16710001
    set _col1671 $all_fields
    set _len1671 [ llength $_col1671 ]
    set _ind1671 0
    while { 1 } {
        #item 16710002
        if {$_ind1671 < $_len1671} {
            
        } else {
            break
        }
        #item 16710004
        set field [ lindex $_col1671 $_ind1671 ]
        #item 2263
        set op [ get_connect_type $field ]
        set link [ get_field2_link $field ]
        #item 1674
        if {$op == ""} {
            
        } else {
            #item 1688
            lappend body \
             [ list "action" "connect" \
             "op" $op \
             "field" $field \
             "link" $link ]
        }
        #item 16710003
        incr _ind1671
    }
    #item 2103
    set head \
     [ list "proc" "insert" "args" $all_fields "body" $body ]
    #item 1670
    return $head
}

proc core_insert_possible { class fields_selector } {
    #item 1704
    set body {}
    #item 1703
    set fields [ select_fields $class $fields_selector ]
    #item 1705
    set head \
     [ list "proc" "insert_possible" "args" $fields ]
    #item 1706
    set indexes [ get_class_indexes $class ]
    #item 17070001
    set _col1707 $indexes
    set _len1707 [ llength $_col1707 ]
    set _ind1707 0
    while { 1 } {
        #item 17070002
        if {$_ind1707 < $_len1707} {
            
        } else {
            break
        }
        #item 17070004
        set index [ lindex $_col1707 $_ind1707 ]
        #item 2100
        set ifields [ index_fields $index ]
        #item 1709
        lappend body \
         [ list "action" "index_not_exists" \
         "index" $index \
         "fields" $ifields "changed" "" ]
        #item 17070003
        incr _ind1707
    }
    #item 17110001
    set _col1711 $fields
    set _len1711 [ llength $_col1711 ]
    set _ind1711 0
    while { 1 } {
        #item 17110002
        if {$_ind1711 < $_len1711} {
            
        } else {
            break
        }
        #item 17110004
        set field [ lindex $_col1711 $_ind1711 ]
        #item 1713
        set type [ get_field2_type $field ]
        #item 1714
        if {$type == "reference"} {
            #item 1717
            set link [ get_field2_link $field ]
            #item 2607
            lappend body \
            [ make_foreign_check $field $link "insert" ]
        } else {
            
        }
        #item 17110003
        incr _ind1711
    }
    #item 2101
    lappend head "body" $body
    #item 2102
    return $head
}

proc core_pre_delete_inner { class } {
    #item 2378
    set body {}
    #item 2356
    set fields [ get_class_fields $class ]
    #item 23570001
    set _col2357 $fields
    set _len2357 [ llength $_col2357 ]
    set _ind2357 0
    while { 1 } {
        #item 23570002
        if {$_ind2357 < $_len2357} {
            
        } else {
            break
        }
        #item 23570004
        set field [ lindex $_col2357 $_ind2357 ]
        #item 2359
        set link [ get_field2_link $field ]
        set own [ get_link_ownership $link ]
        set link_type [ get_link_type $link ]
        set src [ get_link_src_field $link ]
        set dst_table [ get_link_dst_table $link ]
        set field_name [ get_field_name $field ]
        #item 2367
        if {($own == "src") && ($field_name == $src)} {
            #item 23700001
            if {$link_type == "arrow"} {
                #item 2379
                set action [ list \
                 "action" "pre_delete_outer" \
                 "class" $dst_table "field_name" $field_name \
                 "master" "true" ]
                #item 2380
                set check [ list \
                 "if" [ list "field_not_null" $field ] \
                 "then" $action ]
                #item 2390
                lappend body $check
            } else {
                #item 23700002
                if {$link_type == "paw"} {
                    #item 2382
                    set master [ get_class2_master_arrow $dst_table ]
                    #item 2383
                    if {$master} {
                        #item 2387
                        set mvalue "false"
                    } else {
                        #item 2386
                        set mvalue "none"
                    }
                    #item 2381
                    set action [ list \
                     "action" "pre_delete_outer" \
                     "class" $dst_table "field_name" "that" \
                     "master" $mvalue ]
                    #item 2388
                    set check [ list \
                     "foreach" [ list "field" $field ] \
                     "do" $action ]
                    #item 2390
                    lappend body $check
                } else {
                    
                }
            }
        } else {
            
        }
        #item 23570003
        incr _ind2357
    }
    #item 2509
    set head [ list "proc" "pre_delete_inner" \
     "body" $body ]
    #item 2510
    return $head
}

proc core_pre_delete_middle { class } {
    #item 2292
    set chain [ inheritance_chain $class ]
    set base [ lindex $chain 0 ]
    #item 22930001
    set _col2293 $chain
    set _len2293 [ llength $_col2293 ]
    set _ind2293 0
    while { 1 } {
        #item 22930002
        if {$_ind2293 < $_len2293} {
            
        } else {
            break
        }
        #item 22930004
        set cls [ lindex $_col2293 $_ind2293 ]
        #item 2295
        lappend body [ list \
         "action" "pre_delete_inner" \
         "class" $cls ]
        #item 22930003
        incr _ind2293
    }
    #item 2349
    set head [ list "proc" "pre_delete_middle" \
     "body" $body ]
    #item 2350
    return $head
}

proc core_pre_delete_outer { class } {
    #item 2280
    set chain [ inheritance_chain $class ]
    set base [ lindex $chain 0 ]
    set ref_count [ get_class2_has_ref_count $base ]
    set master_arrow [ get_class2_master_arrow $class ]
    #item 2281
    set body {}
    #item 2282
    lappend body [ list \
     "action" "get_class_id" "class" $base ]
    #item 2283
    lappend body [ list \
     "action" "check_deleted" "class" $base ]
    #item 2333
    if {$ref_count} {
        #item 2315
        lappend body [ list \
         "action" "check_ref_count" \
         "class" $base "master" $master_arrow ]
    } else {
        
    }
    #item 2284
    lappend body [ list \
     "action" "pre_delete_middle" \
     "class" $class ]
    #item 2285
    set head [ list "proc" "pre_delete_outer" \
     "master" $master_arrow "body" $body ]
    #item 2286
    return $head
}

proc core_update { field } {
    #item 1755
    set type [ get_field2_type $field ]
    set indexes [ get_field2_indexes $field ]
    set link [ get_field2_link $field ]
    set class [ get_field_class $field ]
    #item 1756
    set head {}
    #item 1763
    if {$type == "collection"} {
        
    } else {
        #item 2104
        lappend head \
         "proc" "setter" "class" $class \
         "field" $field "args" {}
        #item 1758
        if {$indexes == {}} {
            #item 1760
            if {$type == "data"} {
                #item 2105
                lappend head "type" "simple"
            } else {
                #item 1771
                lappend head "type" "complex"
                set body {}
                #item 1778
                lappend body \
                 [ list "action" "check_self" "class" $class ]
                #item 2539
                lappend body \
                 [ list "action" "check_change" "field" $field ]
                #item 2543
                set fields [ get_class_fields $class ]
                #item 25440001
                set _col2544 $fields
                set _len2544 [ llength $_col2544 ]
                set _ind2544 0
                while { 1 } {
                    #item 25440002
                    if {$_ind2544 < $_len2544} {
                        
                    } else {
                        break
                    }
                    #item 25440004
                    set other [ lindex $_col2544 $_ind2544 ]
                    #item 2546
                    if {$other == $field} {
                        
                    } else {
                        #item 2550
                        set f_indexes [ get_field2_indexes $other ]
                        #item 2551
                        if {[indexes_contain_field $f_indexes $field]} {
                            #item 2549
                            lappend body \
                             [ list "action" "fetch_field" "field" $other ]
                        } else {
                            
                        }
                    }
                    #item 25440003
                    incr _ind2544
                }
                #item 17790001
                set _col1779 $indexes
                set _len1779 [ llength $_col1779 ]
                set _ind1779 0
                while { 1 } {
                    #item 17790002
                    if {$_ind1779 < $_len1779} {
                        
                    } else {
                        break
                    }
                    #item 17790004
                    set index [ lindex $_col1779 $_ind1779 ]
                    #item 1793
                    set ifields [ index_fields $index ]
                    #item 2552
                    if {[contains $ifields $field]} {
                        #item 1792
                        set old [ remove $ifields $field ]
                        #item 2106
                        lappend body \
                         [ list "action" "index_not_exists" \
                         "index" $index "fields" $ifields \
                         "changed" $field ]
                    } else {
                        
                    }
                    #item 17790003
                    incr _ind1779
                }
                #item 1794
                if {$link == {}} {
                    
                } else {
                    #item 2606
                    lappend body \
                    [ make_foreign_check $field $link "update" ]
                }
                #item 1809
                if {$link == {}} {
                    
                } else {
                    #item 2265
                    set op [ get_connect_type $field ]
                    set target [ get_target $link ]
                    #item 2264
                    if {$op == ""} {
                        
                    } else {
                        #item 1824
                        lappend body \
                         [ list "action" "disconnect_old" \
                         "op" $op "field" $field \
                         "link" $link "target" $target ]
                    }
                }
                #item 18250001
                set _col1825 $indexes
                set _len1825 [ llength $_col1825 ]
                set _ind1825 0
                while { 1 } {
                    #item 18250002
                    if {$_ind1825 < $_len1825} {
                        
                    } else {
                        break
                    }
                    #item 18250004
                    set index [ lindex $_col1825 $_ind1825 ]
                    #item 1828
                    set ifields [ index_fields $index ]
                    #item 2555
                    if {[contains $ifields $field]} {
                        #item 1827
                        lappend body \
                         [ list "action" "remove_from_index_old" \
                         "index" $index "fields" $ifields \
                         "old" $field ]
                    } else {
                        
                    }
                    #item 18250003
                    incr _ind1825
                }
                #item 1829
                lappend body \
                 [ list "action" "replace" \
                 "class" $class "field" $field ]
                #item 18300001
                set _col1830 $indexes
                set _len1830 [ llength $_col1830 ]
                set _ind1830 0
                while { 1 } {
                    #item 18300002
                    if {$_ind1830 < $_len1830} {
                        
                    } else {
                        break
                    }
                    #item 18300004
                    set index [ lindex $_col1830 $_ind1830 ]
                    #item 1833
                    set ifields [ index_fields $index ]
                    #item 2558
                    if {[contains $ifields $field]} {
                        #item 1832
                        set old [ remove $ifields $field ]
                        #item 2107
                        lappend body \
                         [ list "action" "add_to_index" \
                         "index" $index "fields" $ifields ]
                    } else {
                        
                    }
                    #item 18300003
                    incr _ind1830
                }
                #item 1834
                if {$link == {}} {
                    
                } else {
                    #item 2267
                    set op [ get_connect_type $field ]
                    #item 2266
                    if {$op == ""} {
                        
                    } else {
                        #item 2108
                        lappend body \
                         [ list "action" "connect" \
                         "op" $op \
                         "field" $field \
                         "link" $link ]
                    }
                }
                #item 2109
                lappend head "body" $body
            }
        } else {
            #item 1771
            lappend head "type" "complex"
            set body {}
            #item 1778
            lappend body \
             [ list "action" "check_self" "class" $class ]
            #item 2539
            lappend body \
             [ list "action" "check_change" "field" $field ]
            #item 2543
            set fields [ get_class_fields $class ]
            #item 25440001
            set _col2544 $fields
            set _len2544 [ llength $_col2544 ]
            set _ind2544 0
            while { 1 } {
                #item 25440002
                if {$_ind2544 < $_len2544} {
                    
                } else {
                    break
                }
                #item 25440004
                set other [ lindex $_col2544 $_ind2544 ]
                #item 2546
                if {$other == $field} {
                    
                } else {
                    #item 2550
                    set f_indexes [ get_field2_indexes $other ]
                    #item 2551
                    if {[indexes_contain_field $f_indexes $field]} {
                        #item 2549
                        lappend body \
                         [ list "action" "fetch_field" "field" $other ]
                    } else {
                        
                    }
                }
                #item 25440003
                incr _ind2544
            }
            #item 17790001
            set _col1779 $indexes
            set _len1779 [ llength $_col1779 ]
            set _ind1779 0
            while { 1 } {
                #item 17790002
                if {$_ind1779 < $_len1779} {
                    
                } else {
                    break
                }
                #item 17790004
                set index [ lindex $_col1779 $_ind1779 ]
                #item 1793
                set ifields [ index_fields $index ]
                #item 2552
                if {[contains $ifields $field]} {
                    #item 1792
                    set old [ remove $ifields $field ]
                    #item 2106
                    lappend body \
                     [ list "action" "index_not_exists" \
                     "index" $index "fields" $ifields \
                     "changed" $field ]
                } else {
                    
                }
                #item 17790003
                incr _ind1779
            }
            #item 1794
            if {$link == {}} {
                
            } else {
                #item 2606
                lappend body \
                [ make_foreign_check $field $link "update" ]
            }
            #item 1809
            if {$link == {}} {
                
            } else {
                #item 2265
                set op [ get_connect_type $field ]
                set target [ get_target $link ]
                #item 2264
                if {$op == ""} {
                    
                } else {
                    #item 1824
                    lappend body \
                     [ list "action" "disconnect_old" \
                     "op" $op "field" $field \
                     "link" $link "target" $target ]
                }
            }
            #item 18250001
            set _col1825 $indexes
            set _len1825 [ llength $_col1825 ]
            set _ind1825 0
            while { 1 } {
                #item 18250002
                if {$_ind1825 < $_len1825} {
                    
                } else {
                    break
                }
                #item 18250004
                set index [ lindex $_col1825 $_ind1825 ]
                #item 1828
                set ifields [ index_fields $index ]
                #item 2555
                if {[contains $ifields $field]} {
                    #item 1827
                    lappend body \
                     [ list "action" "remove_from_index_old" \
                     "index" $index "fields" $ifields \
                     "old" $field ]
                } else {
                    
                }
                #item 18250003
                incr _ind1825
            }
            #item 1829
            lappend body \
             [ list "action" "replace" \
             "class" $class "field" $field ]
            #item 18300001
            set _col1830 $indexes
            set _len1830 [ llength $_col1830 ]
            set _ind1830 0
            while { 1 } {
                #item 18300002
                if {$_ind1830 < $_len1830} {
                    
                } else {
                    break
                }
                #item 18300004
                set index [ lindex $_col1830 $_ind1830 ]
                #item 1833
                set ifields [ index_fields $index ]
                #item 2558
                if {[contains $ifields $field]} {
                    #item 1832
                    set old [ remove $ifields $field ]
                    #item 2107
                    lappend body \
                     [ list "action" "add_to_index" \
                     "index" $index "fields" $ifields ]
                } else {
                    
                }
                #item 18300003
                incr _ind1830
            }
            #item 1834
            if {$link == {}} {
                
            } else {
                #item 2267
                set op [ get_connect_type $field ]
                #item 2266
                if {$op == ""} {
                    
                } else {
                    #item 2108
                    lappend body \
                     [ list "action" "connect" \
                     "op" $op \
                     "field" $field \
                     "link" $link ]
                }
            }
            #item 2109
            lappend head "body" $body
        }
    }
    #item 1757
    return $head
}

proc create_field { class_id begin_parts end_parts vertex_id } {
    #item 1003
    set name [ lindex $begin_parts 0 ]
    #item 2689
    if {[ string tolower $name ] == "id"} {
        #item 2691
        report_error_vertex $vertex_id \
          "'id' is not allowed as a field name"
    } else {
        #item 1004
        set existing [ find_field $class_id $name ]
        #item 1005
        if {$existing == ""} {
            #item 1009
            add_field $name $end_parts $class_id
        } else {
            #item 1008
            report_error_vertex $vertex_id \
              "Field $name already defined"
        }
    }
}

proc create_index { class_id index vertex_id } {
    #item 1319
    set id [ index_info_next_id ]
    #item 1316
    insert_index_info $id $class_id $index $vertex_id
}

proc create_index_core { class_id index vertex_id } {
    #item 1015
    lassign $index begin end
    #item 1016
    set first [ lindex $begin 0 ]
    set fields [ lrange $begin 1 end ]
    #item 1017
    if {$first == "index"} {
        #item 1032
        if {[has_repeating $fields]} {
            #item 1035
            report_error_vertex $vertex_id \
             "Repeating fields in index"
        } else {
            #item 10360001
            set _col1036 $fields
            set _len1036 [ llength $_col1036 ]
            set _ind1036 0
            while { 1 } {
                #item 10360002
                if {$_ind1036 < $_len1036} {
                    
                } else {
                    #item 1044
                    set class_name [ get_class_name $class_id ]
                    
                    set index_name "${class_name}_[ join $fields "_" ]"
                    #item 1043
                    add_index $class_id $index_name $end $fields
                    break
                }
                #item 10360004
                set field [ lindex $_col1036 $_ind1036 ]
                #item 1038
                set field_id [ find_field $class_id $field ]
                #item 1039
                if {$field_id == ""} {
                    #item 1041
                    report_error_vertex $vertex_id \
                     "Indexed field $field not found in class"
                    break
                } else {
                    
                }
                #item 1350
                if {[ is_collection $field_id ]} {
                    #item 1352
                    report_error_vertex $vertex_id \
                     "Indexed field $field is a collection"
                    break
                } else {
                    
                }
                #item 10360003
                incr _ind1036
            }
        }
    } else {
        #item 1020
        report_error_vertex $vertex_id \
         "'index' keyword expected"
    }
}

proc ensure_no_fields_reuse { class_id field_name edge } {
    #item 1205
    if {$field_name == ""} {
        
    } else {
        #item 1190
        set field [ find_field $class_id $field_name ]
        #item 1191
        if {$field == ""} {
            #item 1194
            add_field $field_name {link} $class_id
            #item 1166
            set class_links [ get_class_links $class_id ]
            #item 11670001
            set _col1167 $class_links
            set _len1167 [ llength $_col1167 ]
            set _ind1167 0
            while { 1 } {
                #item 11670002
                if {$_ind1167 < $_len1167} {
                    
                } else {
                    break
                }
                #item 11670004
                set link_id [ lindex $_col1167 $_ind1167 ]
                #item 1169
                set src_table [ get_link_src_table $link_id ]
                set dst_table [ get_link_dst_table $link_id ]
                set src_field [ get_link_src_field $link_id ]
                set dst_field [ get_link_dst_field $link_id ]
                #item 1170
                if {$src_table == $class_id} {
                    #item 1173
                    if {$src_field == $field_name} {
                        #item 1180
                        report_error_edge $edge \
                         "Field $field_name is already used for another link"
                        break
                    } else {
                        
                    }
                } else {
                    
                }
                #item 1176
                if {$dst_table == $class_id} {
                    #item 1179
                    if {$dst_field == $field_name} {
                        #item 1180
                        report_error_edge $edge \
                         "Field $field_name is already used for another link"
                        break
                    } else {
                        
                    }
                } else {
                    
                }
                #item 11670003
                incr _ind1167
            }
        } else {
            #item 1195
            set props [ get_field_properties $field ]
            #item 1196
            if {$props == {}} {
                #item 1199
                set_field_properties $field {link}
                #item 1166
                set class_links [ get_class_links $class_id ]
                #item 11670001
                set _col1167 $class_links
                set _len1167 [ llength $_col1167 ]
                set _ind1167 0
                while { 1 } {
                    #item 11670002
                    if {$_ind1167 < $_len1167} {
                        
                    } else {
                        break
                    }
                    #item 11670004
                    set link_id [ lindex $_col1167 $_ind1167 ]
                    #item 1169
                    set src_table [ get_link_src_table $link_id ]
                    set dst_table [ get_link_dst_table $link_id ]
                    set src_field [ get_link_src_field $link_id ]
                    set dst_field [ get_link_dst_field $link_id ]
                    #item 1170
                    if {$src_table == $class_id} {
                        #item 1173
                        if {$src_field == $field_name} {
                            #item 1180
                            report_error_edge $edge \
                             "Field $field_name is already used for another link"
                            break
                        } else {
                            
                        }
                    } else {
                        
                    }
                    #item 1176
                    if {$dst_table == $class_id} {
                        #item 1179
                        if {$dst_field == $field_name} {
                            #item 1180
                            report_error_edge $edge \
                             "Field $field_name is already used for another link"
                            break
                        } else {
                            
                        }
                    } else {
                        
                    }
                    #item 11670003
                    incr _ind1167
                }
            } else {
                #item 1202
                set first [ lindex $props 0 ]
                #item 1200
                if {$first == "link"} {
                    #item 1166
                    set class_links [ get_class_links $class_id ]
                    #item 11670001
                    set _col1167 $class_links
                    set _len1167 [ llength $_col1167 ]
                    set _ind1167 0
                    while { 1 } {
                        #item 11670002
                        if {$_ind1167 < $_len1167} {
                            
                        } else {
                            break
                        }
                        #item 11670004
                        set link_id [ lindex $_col1167 $_ind1167 ]
                        #item 1169
                        set src_table [ get_link_src_table $link_id ]
                        set dst_table [ get_link_dst_table $link_id ]
                        set src_field [ get_link_src_field $link_id ]
                        set dst_field [ get_link_dst_field $link_id ]
                        #item 1170
                        if {$src_table == $class_id} {
                            #item 1173
                            if {$src_field == $field_name} {
                                #item 1180
                                report_error_edge $edge \
                                 "Field $field_name is already used for another link"
                                break
                            } else {
                                
                            }
                        } else {
                            
                        }
                        #item 1176
                        if {$dst_table == $class_id} {
                            #item 1179
                            if {$dst_field == $field_name} {
                                #item 1180
                                report_error_edge $edge \
                                 "Field $field_name is already used for another link"
                                break
                            } else {
                                
                            }
                        } else {
                            
                        }
                        #item 11670003
                        incr _ind1167
                    }
                } else {
                    #item 1204
                    report_error_edge $edge \
                     "Field $field_name is not a link"
                }
            }
        }
    }
}

proc ensure_simple_down { edge_id head } {
    #item 8130001
    if {((($head == "up arrow") || ($head == "up white arrow")) || ($head == "up paw")) || ($head == "")} {
        
    } else {
        #item 821
        report_error_edge \
         $edge_id "Unexpected line ending: $head"
    }
}

proc ensure_simple_right { edge_id head } {
    #item 2940001
    if {(($head == "left arrow") || ($head == "left paw")) || ($head == "")} {
        
    } else {
        #item 303
        report_error_edge \
         $edge_id "Unexpected right line ending: $head"
    }
}

proc find_base { class } {
    #item 1456
    set links [ get_class_links $class ]
    #item 14570001
    set _col1457 $links
    set _len1457 [ llength $_col1457 ]
    set _ind1457 0
    while { 1 } {
        #item 14570002
        if {$_ind1457 < $_len1457} {
            
        } else {
            #item 1465
            return {}
        }
        #item 14570004
        set link [ lindex $_col1457 $_ind1457 ]
        #item 1459
        set type [ get_link_type $link ]
        set src [ get_link_src_table $link ]
        #item 1460
        if {$type == "inheritance"} {
            #item 2097
            if {$src == $class} {
                #item 1463
                set dst [ get_link_dst_table $link ]
                #item 1464
                return $dst
            } else {
                
            }
        } else {
            
        }
        #item 14570003
        incr _ind1457
    }
}

proc find_class { name } {
    #item 146
    set key [ string tolower $name ]
    #item 147
    set id [ get_class_by_name_class $key ]
    #item 148
    return $id
}

proc find_cycles { link traversed } {
    #item 1925
    set dst [ get_link_dst_table $link ]
    #item 1926
    if {[contains $traversed $dst]} {
        #item 1929
        return 1
    } else {
        #item 1930
        lappend traversed $dst
    }
    #item 1961
    set base_links [ base_classes $dst ]
    #item 19620001
    set _col1962 $base_links
    set _len1962 [ llength $_col1962 ]
    set _ind1962 0
    while { 1 } {
        #item 19620002
        if {$_ind1962 < $_len1962} {
            
        } else {
            break
        }
        #item 19620004
        set base_link [ lindex $_col1962 $_ind1962 ]
        #item 1964
        if {[find_cycles $base_link $traversed]} {
            #item 1967
            return 1
        } else {
            
        }
        #item 19620003
        incr _ind1962
    }
    #item 1968
    return 0
}

proc find_derived { class } {
    #item 1485
    set result {}
    #item 1480
    set classes [ class_name_keys ]
    #item 14810001
    set _col1481 $classes
    set _len1481 [ llength $_col1481 ]
    set _ind1481 0
    while { 1 } {
        #item 14810002
        if {$_ind1481 < $_len1481} {
            
        } else {
            break
        }
        #item 14810004
        set other_class [ lindex $_col1481 $_ind1481 ]
        #item 1483
        set base [ find_base $other_class ]
        #item 1487
        if {$base == $class} {
            #item 1490
            lappend result $other_class
        } else {
            
        }
        #item 14810003
        incr _ind1481
    }
    #item 1486
    return $result
}

proc find_field { class_id name } {
    #item 144
    set key [ make_field_key $class_id $name ]
    #item 120
    set id [ get_field_by_name_field $key ]
    #item 121
    return $id
}

proc gen_field_aux { class field } {
    #item 1508
    set name [ get_field_name $field ]
    set incoming {}
    set outgoing {}
    #item 1505
    set links [ get_class_links $class ]
    #item 15060001
    set _col1506 $links
    set _len1506 [ llength $_col1506 ]
    set _ind1506 0
    while { 1 } {
        #item 15060002
        if {$_ind1506 < $_len1506} {
            
        } else {
            break
        }
        #item 15060004
        set link [ lindex $_col1506 $_ind1506 ]
        #item 1509
        set dst_table [ get_link_dst_table $link ]
        set src_table [ get_link_src_table $link ]
        set dst_field [ get_link_dst_field $link ]
        set src_field [ get_link_src_field $link ]
        #item 1510
        if {$src_table == $class} {
            #item 1516
            if {$src_field == $name} {
                #item 1519
                set outgoing $link
            } else {
                
            }
        } else {
            #item 1513
            if {($dst_table == $class) && ($dst_field == $name)} {
                #item 1520
                set incoming $link
            } else {
                
            }
        }
        #item 15060003
        incr _ind1506
    }
    #item 1521
    if {$outgoing == {}} {
        #item 1525
        if {$incoming == {}} {
            #item 1549
            set type "data"
        } else {
            #item 1528
            set link_type [ get_link_type $incoming ]
            #item 15390001
            if {$link_type == "paw"} {
                #item 1547
                set type "reference"
            } else {
                #item 15390002
                if {$link_type == "m2m"} {
                    #item 1570
                    set type "collection"
                } else {
                    #item 15390003
                    if {$link_type == "line"} {
                        #item 1575
                        set type "reference"
                    } else {
                        #item 1548
                        set type "data"
                    }
                }
            }
        }
    } else {
        #item 1524
        set link_type [ get_link_type $outgoing ]
        #item 15290001
        if {$link_type == "paw"} {
            #item 1536
            set type "collection"
        } else {
            #item 15290002
            if {$link_type == "arrow"} {
                #item 1537
                set type "reference"
            } else {
                #item 15290003
                if {$link_type == "m2m"} {
                    #item 1567
                    set type "collection"
                } else {
                    #item 15290004
                    if {$link_type == "line"} {
                        #item 1578
                        set type "reference"
                    } else {
                        #item 1538
                        set type "data"
                    }
                }
            }
        }
    }
    #item 1557
    set indexed_by {}
    #item 1553
    set indexes [ get_class_indexes $class ]
    #item 15540001
    set _col1554 $indexes
    set _len1554 [ llength $_col1554 ]
    set _ind1554 0
    while { 1 } {
        #item 15540002
        if {$_ind1554 < $_len1554} {
            
        } else {
            break
        }
        #item 15540004
        set index [ lindex $_col1554 $_ind1554 ]
        #item 1556
        set ifields [ get_index_fields $index ]
        #item 15580001
        set _col1558 $ifields
        set _len1558 [ llength $_col1558 ]
        set _ind1558 0
        while { 1 } {
            #item 15580002
            if {$_ind1558 < $_len1558} {
                
            } else {
                break
            }
            #item 15580004
            set ifield [ lindex $_col1558 $_ind1558 ]
            #item 1560
            if {$ifield == $name} {
                #item 1563
                lappend indexed_by $index
                break
            } else {
                
            }
            #item 15580003
            incr _ind1558
        }
        #item 15540003
        incr _ind1554
    }
    #item 2245
    if {$incoming == {}} {
        #item 2248
        set link $outgoing
    } else {
        #item 2249
        set link $incoming
    }
    #item 1564
    insert_field2 $field $type \
     $link $incoming $outgoing $indexed_by
}

proc generate_tables { dbase callbacks after_connections } {
    #item 70
    reset_db
    #item 1045
    set diagrams [ $dbase eval {
    	select diagram_id
    	from diagrams
    } ]
    #item 10460001
    set _col1046 $diagrams
    set _len1046 [ llength $_col1046 ]
    set _ind1046 0
    while { 1 } {
        #item 10460002
        if {$_ind1046 < $_len1046} {
            
        } else {
            break
        }
        #item 10460004
        set diagram_id [ lindex $_col1046 $_ind1046 ]
        #item 1048
        if {[mwc::is_drakon $diagram_id]} {
            
        } else {
            #item 1051
            add_diagram $dbase $diagram_id
        }
        #item 10460003
        incr _ind1046
    }
    #item 77
    #print_diagram
    #print_vertex
    #print_edge
    #item 183
    build_connections
    #item 1052
    if {$after_connections} {
        
    } else {
        #item 184
        build_classes
        #item 185
        build_links
        #item 1329
        build_indexes
        #item 1373
        check_links_defined
        #item 1431
        build_aux
    }
    #item 1565
    #print_class
    #print_class2
    #print_field
    #print_field2
    #print_link
}

proc get_collection_target { field link } {
    #item 2711
    set type [ get_link_type $link ]
    #item 27120001
    if {$type == "paw"} {
        #item 2724
        set target [ get_link_dst_table $link ]
    } else {
        #item 27120002
        if {$type == "m2m"} {
            
        } else {
            #item 27120003
            error "Unexpected switch value: $type"
        }
        #item 2717
        set class [ get_field_class $field ]
        set src [ get_link_src_table $link ]
        set dst [ get_link_dst_table $link ]
        #item 2718
        if {$class == $src} {
            #item 2721
            set target $dst
        } else {
            #item 2722
            set target $src
        }
    }
    #item 2723
    return $target
}

proc get_connect_type { field } {
    #item 2208
    set type [ get_field2_type $field ]
    set link [ get_field2_link $field ]
    #item 2215
    set link_type [ get_link_type $link ]
    #item 2209
    if {$type == "reference"} {
        #item 22500001
        if {$link_type == "paw"} {
            #item 2240
            set op "collection"
        } else {
            #item 22500002
            if {$link_type == "arrow"} {
                #item 2241
                set op "ref_count"
            } else {
                #item 2258
                set op ""
            }
        }
    } else {
        #item 2258
        set op ""
    }
    #item 2261
    return $op
}

proc get_other_side { field } {
    #item 2628
    set link [ get_field2_link $field ]
    set field_name [ get_field_name $field ]
    set src_field_name [ get_link_src_field $link ]
    set dst_field_name [ get_link_dst_field $link ]
    #item 2629
    if {$field_name == $src_field_name} {
        #item 2632
        set other_class [ get_link_dst_table $link ]
        set other_field [ find_field $other_class $dst_field_name ]
    } else {
        #item 2633
        set other_class [ get_link_src_table $link ]
        set other_field [ find_field $other_class $src_field_name ]
    }
    #item 2634
    return [ list $other_class $other_field ]
}

proc get_target { link } {
    #item 2608
    set type [ get_link_type $link ]
    #item 25950001
    if {$type == "arrow"} {
        #item 2601
        set target [ get_link_dst_table $link ]
    } else {
        #item 25950002
        if {$type == "paw"} {
            
        } else {
            #item 25950003
            error "Unexpected switch value: $type"
        }
        #item 2602
        set target [ get_link_src_table $link ]
    }
    #item 2603
    return $target
}

proc get_vertex_class { vertex_id } {
    #item 1295
    set type [ get_vertex_type $vertex_id ]
    #item 12960001
    if {$type == "action"} {
        #item 1304
        set name [ get_vertex_text $vertex_id ]
    } else {
        #item 12960002
        if {$type == "shelf"} {
            
        } else {
            #item 12960003
            error "Unexpected switch value: $type"
        }
        #item 1305
        set text2 [ get_vertex_text2 $vertex_id ]
        #item 1306
        set name [ lindex $text2 1 ]
    }
    #item 1307
    return $name
}

proc has_ref_count { class } {
    #item 2313
    set has_ref_count 0
    set master_arrow 0
    #item 2303
    set links [ get_class_links $class ]
    #item 23010001
    set _col2301 $links
    set _len2301 [ llength $_col2301 ]
    set _ind2301 0
    while { 1 } {
        #item 23010002
        if {$_ind2301 < $_len2301} {
            
        } else {
            break
        }
        #item 23010004
        set link [ lindex $_col2301 $_ind2301 ]
        #item 2304
        set type [ get_link_type $link ]
        set dst [ get_link_dst_table $link ]
        set own [ get_link_ownership $link ]
        #item 2305
        if {($type == "arrow") && ($dst == $class)} {
            #item 2309
            set has_ref_count 1
            #item 2310
            if {$own == "src"} {
                #item 2311
                set master_arrow 1
            } else {
                
            }
        } else {
            
        }
        #item 23010003
        incr _ind2301
    }
    #item 2312
    return [ list \
     $has_ref_count $master_arrow ]
}

proc has_repeating { collection } {
    #item 1026
    set unique [ lsort -unique $collection ]
    #item 1027
    if {[ llength $collection ] == [ llength $unique ]} {
        #item 1030
        return 0
    } else {
        #item 1031
        return 1
    }
}

proc index_fields { index } {
    #item 2086
    set class [ get_index_class $index ]
    set field_names [ get_index_fields $index ]
    #item 2087
    set result {}
    #item 20890001
    set _col2089 $field_names
    set _len2089 [ llength $_col2089 ]
    set _ind2089 0
    while { 1 } {
        #item 20890002
        if {$_ind2089 < $_len2089} {
            
        } else {
            break
        }
        #item 20890004
        set name [ lindex $_col2089 $_ind2089 ]
        #item 2091
        set field [ find_field $class $name ]
        #item 2092
        lappend result $field
        #item 20890003
        incr _ind2089
    }
    #item 2088
    return $result
}

proc indexes_contain_field { indexes field } {
    #item 25660001
    set _col2566 $indexes
    set _len2566 [ llength $_col2566 ]
    set _ind2566 0
    while { 1 } {
        #item 25660002
        if {$_ind2566 < $_len2566} {
            
        } else {
            #item 2572
            return 0
        }
        #item 25660004
        set index [ lindex $_col2566 $_ind2566 ]
        #item 2568
        set ifields [ index_fields $index ]
        #item 2569
        if {[contains $ifields $field]} {
            #item 2573
            return 1
        } else {
            
        }
        #item 25660003
        incr _ind2566
    }
}

proc inheritance_chain { class } {
    #item 2052
    set chain {}
    while { 1 } {
        #item 2049
        lappend chain $class
        #item 2053
        set class [ get_class2_base $class ]
        #item 2051
        if {$class == ""} {
            break
        } else {
            
        }
    }
    #item 2054
    set chain [ lreverse $chain ]
    #item 2055
    return $chain
}

proc is_collection { field_id } {
    #item 1358
    set class_id [ get_field_class $field_id ]
    set name [ get_field_name $field_id ]
    #item 1359
    set links [ link_type_keys ]
    #item 13600001
    set _col1360 $links
    set _len1360 [ llength $_col1360 ]
    set _ind1360 0
    while { 1 } {
        #item 13600002
        if {$_ind1360 < $_len1360} {
            
        } else {
            #item 1369
            return 0
        }
        #item 13600004
        set link [ lindex $_col1360 $_ind1360 ]
        #item 1362
        set src [ get_link_src_table $link ]
        set src_field [ get_link_src_field $link ]
        set type [ get_link_type $link ]
        #item 1363
        if {$type == "paw"} {
            #item 1366
            if {$src == $class_id} {
                #item 1371
                if {$src_field == $name} {
                    #item 1370
                    return 1
                } else {
                    
                }
            } else {
                
            }
        } else {
            
        }
        #item 13600003
        incr _ind1360
    }
}

proc is_m2m_field { field } {
    #item 2697
    set link [ get_field2_link $field ]
    #item 2698
    if {$link == {}} {
        #item 2704
        return 0
    } else {
        #item 2701
        set type [ get_link_type $link ]
        #item 2702
        if {$type == "m2m"} {
            #item 2703
            return 1
        } else {
            #item 2704
            return 0
        }
    }
}

proc link_arrow { ownership edge src_table dst_table ovals } {
    #item 1239
    set oval_count [ llength $ovals ]
    #item 12410001
    if {$oval_count == 0} {
        #item 1397
        set id [ empty_link_next_id ]
        insert_empty_link \
        	$id \
        	"arrow" \
        	$ownership \
        	$src_table \
        	$dst_table \
        	$edge
    } else {
        #item 12410002
        if {$oval_count == 1} {
            #item 1250
            set src_field [ lindex $ovals 0 ]
            set dst_field ""
            #item 1249
            add_link \
             "arrow" \
             $ownership \
             $src_table \
             $dst_table \
             $src_field \
             $dst_field \
             $edge
        } else {
            #item 1248
            report_wrong_ovals $edge
        }
    }
}

proc link_inherit { edge src_table dst_table ovals } {
    #item 1277
    set oval_count [ llength $ovals ]
    #item 12790001
    if {$oval_count == 0} {
        #item 1287
        add_link \
         "inheritance" \
         "none" \
         $src_table \
         $dst_table \
         "" \
         "" \
         $edge
    } else {
        #item 1286
        report_wrong_ovals $edge
    }
}

proc link_line { ownership edge src_table dst_table ovals } {
    #item 1214
    set oval_count [ llength $ovals ]
    #item 12240001
    if {$oval_count == 0} {
        #item 1398
        set id [ empty_link_next_id ]
        insert_empty_link \
        	$id \
        	"line" \
        	$ownership \
        	$src_table \
        	$dst_table \
        	$edge
    } else {
        #item 12240002
        if {$oval_count == 2} {
            #item 1233
            lassign $ovals src_field dst_field
            #item 1232
            add_link \
             "line" \
             $ownership \
             $src_table \
             $dst_table \
             $src_field \
             $dst_field \
             $edge
        } else {
            #item 1231
            report_wrong_ovals $edge
        }
    }
}

proc link_m2m { edge src_table dst_table ovals } {
    #item 1338
    set oval_count [ llength $ovals ]
    #item 13400001
    if {$oval_count == 0} {
        #item 1399
        set id [ empty_link_next_id ]
        insert_empty_link \
        	$id \
        	"m2m" \
        	$ownership \
        	$src_table \
        	$dst_table \
        	$edge
    } else {
        #item 13400002
        if {$oval_count == 2} {
            #item 1349
            lassign $ovals src_field dst_field
            #item 1348
            add_link \
             "m2m" \
             "none" \
             $src_table \
             $dst_table \
             $src_field \
             $dst_field \
             $edge
        } else {
            #item 1347
            report_wrong_ovals $edge
        }
    }
}

proc link_paw { ownership edge src_table dst_table ovals } {
    #item 1256
    set oval_count [ llength $ovals ]
    #item 12580001
    if {$oval_count == 0} {
        #item 1400
        set id [ empty_link_next_id ]
        insert_empty_link \
        	$id \
        	"paw" \
        	$ownership \
        	$src_table \
        	$dst_table \
        	$edge
    } else {
        #item 12580002
        if {$oval_count == 1} {
            #item 1267
            set src_field [ lindex $ovals 0 ]
            set dst_field ""
            #item 1266
            add_link \
             "paw" \
             $ownership \
             $src_table \
             $dst_table \
             $src_field \
             $dst_field \
             $edge
        } else {
            #item 12580003
            if {$oval_count == 2} {
                #item 1270
                lassign $ovals src_field dst_field
                #item 1266
                add_link \
                 "paw" \
                 $ownership \
                 $src_table \
                 $dst_table \
                 $src_field \
                 $dst_field \
                 $edge
            } else {
                #item 1265
                report_wrong_ovals $edge
            }
        }
    }
}

proc make_con { vertex1 vertex2 head ovals } {
    #item 387
    return [ list $vertex1 $vertex2 $head $ovals ]
}

proc make_field_key { class_id field_name } {
    #item 170
    set name [ string tolower $field_name ]
    #item 171
    return "${class_id},${name}"
}

proc make_foreign_check { field link action } {
    #item 2579
    set target [ get_target $link ]
    #item 2604
    return \
     [ list "action" "foreign_check" \
     "field" $field "class" $target \
     "action" $action ]
}

proc print_action { chunk indent } {
    #item 2187
    puts -nonewline $indent
    #item 2178
    set keys [ dict keys $chunk ]
    #item 21790001
    set _col2179 $keys
    set _len2179 [ llength $_col2179 ]
    set _ind2179 0
    while { 1 } {
        #item 21790002
        if {$_ind2179 < $_len2179} {
            
        } else {
            break
        }
        #item 21790004
        set key [ lindex $_col2179 $_ind2179 ]
        #item 2181
        set value [ dict get $chunk $key ]
        #item 2186
        print_prop $key $value
        #item 21790003
        incr _ind2179
    }
    #item 2188
    puts ""
}

proc print_block { block indent } {
    #item 24080001
    set _col2408 $block
    set _len2408 [ llength $_col2408 ]
    set _ind2408 0
    while { 1 } {
        #item 24080002
        if {$_ind2408 < $_len2408} {
            
        } else {
            break
        }
        #item 24080004
        set item [ lindex $_col2408 $_ind2408 ]
        #item 2410
        print_item $item "    $indent"
        #item 24080003
        incr _ind2408
    }
}

proc print_for { chunk indent } {
    #item 2444
    set condition [ dict get $chunk "foreach" ]
    set body [ dict get $chunk "do" ]
    #item 2445
    puts "${indent}foreach"
    #item 2447
    print_action $condition "    $indent"
    #item 2446
    puts "${indent}do"
    #item 2448
    print_item $body "    $indent"
}

proc print_if { chunk indent } {
    #item 2423
    set condition [ dict get $chunk "if" ]
    set body [ dict get $chunk "then" ]
    #item 2435
    puts "${indent}if"
    #item 2437
    print_action $condition "    $indent"
    #item 2436
    puts "${indent}then"
    #item 2438
    print_item $body "    $indent"
}

proc print_item { item indent } {
    #item 2162
    set first [ lindex $item 0 ]
    #item 21630001
    if {$first == ""} {
        
    } else {
        #item 21630002
        if {$first == "foreach"} {
            #item 2417
            print_for $item $indent
        } else {
            #item 21630003
            if {$first == "if"} {
                #item 2414
                print_if $item $indent
            } else {
                #item 21630004
                if {$first == "action"} {
                    #item 2171
                    print_action $item $indent
                } else {
                    
                }
            }
        }
    }
}

proc print_list { list output } {
    #item 20330001
    set _col2033 $list
    set _len2033 [ llength $_col2033 ]
    set _ind2033 0
    while { 1 } {
        #item 20330002
        if {$_ind2033 < $_len2033} {
            
        } else {
            break
        }
        #item 20330004
        set item [ lindex $_col2033 $_ind2033 ]
        #item 2035
        puts $output "    $item"
        #item 20330003
        incr _ind2033
    }
}

proc print_proc { chunk } {
    #item 2148
    set body {}
    #item 2144
    set keys [ dict keys $chunk ]
    #item 21450001
    set _col2145 $keys
    set _len2145 [ llength $_col2145 ]
    set _ind2145 0
    while { 1 } {
        #item 21450002
        if {$_ind2145 < $_len2145} {
            
        } else {
            break
        }
        #item 21450004
        set key [ lindex $_col2145 $_ind2145 ]
        #item 2147
        set value [ dict get $chunk $key ]
        #item 2149
        if {$key == "body"} {
            #item 2152
            set body $value
        } else {
            #item 2153
            print_prop $key $value
        }
        #item 21450003
        incr _ind2145
    }
    #item 2189
    puts ""
    #item 2411
    print_block $body ""
}

proc print_prop { key value } {
    #item 21150001
    if {$key == "class"} {
        #item 2122
        set name [ get_class_name $value ]
    } else {
        #item 21150002
        if {$key == "link"} {
            #item 2132
            set dst [ get_link_dst_table $value ]
            set src [ get_link_src_table $value ]
            set dname [ get_class_name $dst ]
            set sname [ get_class_name $src ]
            set type [ get_link_type $value ]
            set name "$type:$sname->$dname"
        } else {
            #item 21150003
            if {$key == "index"} {
                #item 2129
                set class [ get_index_class $value ]
                set fields [ get_index_fields $value ]
                set fields_str [ join $fields "-" ]
                set cname [ get_class_name $class ]
                set name "${cname}:$fields_str"
            } else {
                #item 21150004
                if {($key == "field") || ($key == "new")} {
                    #item 2134
                    set name [ get_field_name $value ]
                } else {
                    #item 21150006
                    if {(($key == "old") || ($key == "fields")) || ($key == "all")} {
                        #item 2135
                        set names [ map2 $value tab::get_field_name ]
                        set name [ join $names "-" ]
                    } else {
                        #item 2136
                        set name $value
                    }
                }
            }
        }
    }
    #item 2138
    puts -nonewline " $key=$name"
}

proc remove { collection element } {
    #item 2061
    set found [ lsearch $collection $element ]
    #item 2062
    if {$found == -1} {
        #item 2065
        return $collection
    } else {
        #item 2066
        return [ lreplace $collection $found $found ]
    }
}

proc report_error_class { name message } {
    #item 1898
    set vertexes [ vertex_type_keys ]
    #item 18990001
    set _col1899 $vertexes
    set _len1899 [ llength $_col1899 ]
    set _ind1899 0
    while { 1 } {
        #item 18990002
        if {$_ind1899 < $_len1899} {
            
        } else {
            #item 1908
            error "Error in class $name."
            break
        }
        #item 18990004
        set vertex [ lindex $_col1899 $_ind1899 ]
        #item 1901
        set text [ get_vertex_text $vertex ]
        set text2 [ get_vertex_text2 $vertex ]
        set type [ get_vertex_type $vertex ]
        #item 1902
        if {$type == "action"} {
            #item 1905
            if {$text == $name} {
                #item 1911
                report_error_vertex $vertex $message
                break
            } else {
                
            }
        } else {
            
        }
        #item 1906
        if {$type == "shelf"} {
            #item 1907
            if {$text2 == "class $name"} {
                #item 1911
                report_error_vertex $vertex $message
                break
            } else {
                
            }
        } else {
            
        }
        #item 18990003
        incr _ind1899
    }
}

proc report_error_edge { edge_id message } {
    #item 273
    set vertex1 [ get_edge_vertex1 $edge_id ]
    set diagram_id [ get_vertex_diagram_id $vertex1 ]
    set name [ get_diagram_name $diagram_id ]
    set item [ get_edge_items $edge_id ]
    #item 275
    gen::report_error $diagram_id $item $message
}

proc report_error_vertex { vertex_id message } {
    #item 281
    set diagram_id [ get_vertex_diagram_id $vertex_id ]
    set name [ get_diagram_name $diagram_id ]
    set item [ get_vertex_item_id $vertex_id ]
    #item 846
    gen::report_error $diagram_id $item $message
}

proc report_wrong_ovals { edge_id } {
    #item 1223
    set message "Unexpected number of link fields"
    #item 1311
    report_error_edge $edge_id $message
}

proc reset_db { } {
    #item 69
    art::create_table tab diagram {
    	name 
    	vertices
    }
    #item 98
    art::create_table tab vertex {
    	item_id 
    	diagram_id
    	type 
    	text
    	text2
    	left 
    	up 
    	right 
    	down
    }
    #item 99
    art::create_table tab edge {
    	vertex1 
    	vertex2 
    	head 
    	vertical 
    	items 
    	marked
    }
    #item 78
    art::create_table tab connection {
    	vertex1 
    	vertex2 
    	orientation
    	head
    	ovals
    	edge
    }
    #item 1318
    art::create_table tab index_info {
    	class_id
    	data
    	vertex
    }
    #item 1395
    art::create_table tab empty_link {
    	type
    	ownership
    	src
    	dst
    	edge
    }
    #item 79
    art::create_table tab class {
    	name
    	properties
    	fields
    	indexes
    	links
    	defined
    }
    #item 80
    art::create_table tab field {
    	class
    	name
    	properties
    }
    #item 96
    art::create_table tab index {
    	class
    	name
    	properties
    	fields
    }
    #item 97
    art::create_table tab link {
    	type
    	ownership
    	src_table
    	dst_table
    	src_field
    	dst_field
    }
    #item 1430
    art::create_table tab class2 {
    	simple
    	base
    	derived
    	has_ref_count
    	master_arrow
    }
    #item 1423
    art::create_table tab field2 {
    	type
    	link
    	incoming
    	outgoing
    	indexes
    }
    #item 100
    art::create_table tab field_by_name {
    	field
    }
    #item 122
    art::create_table tab class_by_name {
    	class
    }
}

proc select_fields { class field_selector } {
    #item 2072
    set result {}
    #item 2076
    set fields [ get_class_fields $class ]
    #item 20740001
    set _col2074 $fields
    set _len2074 [ llength $_col2074 ]
    set _ind2074 0
    while { 1 } {
        #item 20740002
        if {$_ind2074 < $_len2074} {
            
        } else {
            break
        }
        #item 20740004
        set field [ lindex $_col2074 $_ind2074 ]
        #item 2196
        set type [ get_field2_type $field ]
        set indexes [ get_field2_indexes $field ]
        #item 2077
        if {($field_selector == "") || (!([ $field_selector $field ]))} {
            #item 2200
            if {$indexes == {}} {
                
            } else {
                #item 2080
                lappend result $field
            }
        } else {
            #item 2080
            lappend result $field
        }
        #item 20740003
        incr _ind2074
    }
    #item 2073
    return $result
}

proc select_hor_head { edge_id left right } {
    #item 424
    if {$left == ""} {
        #item 427
        return $right
    } else {
        #item 428
        if {$right == ""} {
            #item 431
            return $left
        } else {
            #item 601
            if {($left == "left paw") && ($right == "right paw")} {
                #item 604
                return "m2m"
            } else {
                #item 599
                puts "select_hor_head:"
                puts "left=$left"
                puts "righ=$right"
                #item 432
                report_error_edge $edge_id \
                	"Simple line expected"
            }
        }
    }
}

proc select_ver_head { edge_id left right } {
    #item 829
    if {$left == ""} {
        #item 832
        return $right
    } else {
        #item 833
        if {$right == ""} {
            #item 836
            return $left
        } else {
            #item 838
            puts "select_ver_head:"
            puts "left=$left"
            puts "righ=$right"
            #item 837
            report_error_edge $edge_id \
            	"Simple line expected"
        }
    }
}

proc split_lines { text } {
    #item 946
    set lines [ split $text "\n" ]
    #item 947
    set result {}
    #item 9490001
    set _col949 $lines
    set _len949 [ llength $_col949 ]
    set _ind949 0
    while { 1 } {
        #item 9490002
        if {$_ind949 < $_len949} {
            
        } else {
            break
        }
        #item 9490004
        set line [ lindex $_col949 $_ind949 ]
        #item 956
        set trimmed [ string trim $line ]
        #item 951
        if {($trimmed == "") || ([string match "#*" $trimmed])} {
            
        } else {
            #item 954
            lappend result $trimmed
        }
        #item 9490003
        incr _ind949
    }
    #item 948
    return $result
}

proc split_space { text } {
    #item 926
    set parts [ split $text " \t" ]
    #item 927
    set result {}
    #item 9290001
    set _col929 $parts
    set _len929 [ llength $_col929 ]
    set _ind929 0
    while { 1 } {
        #item 9290002
        if {$_ind929 < $_len929} {
            
        } else {
            break
        }
        #item 9290004
        set part [ lindex $_col929 $_ind929 ]
        #item 931
        if {$part == ""} {
            
        } else {
            #item 934
            lappend result $part
        }
        #item 9290003
        incr _ind929
    }
    #item 928
    return $result
}

}
