namespace eval nogoto {

variable g_fail_reason ""
array set debug_paths {}

variable structures_built 0
variable g_stack {}

# Autogenerated with DRAKON Editor 1.21

proc after_others { order nodes current } {
    #item 39730001
    set _col3973 $nodes
    set _len3973 [ llength $_col3973 ]
    set _ind3973 0
    while { 1 } {
        #item 39730002
        if {$_ind3973 < $_len3973} {
            
        } else {
            #item 3983
            return 1
        }
        #item 39730004
        set node [ lindex $_col3973 $_ind3973 ]
        #item 3975
        if {$node == $current} {
            
        } else {
            #item 3981
            set after [ get_value $order $node ]
            #item 3978
            if {[ contains $after $current ]} {
                
            } else {
                #item 3982
                return 0
            }
        }
        #item 39730003
        incr _ind3973
    }
}

proc build_structures { } {
    #item 437
    variable structures_built
    #item 438
    if {$structures_built} {
        
    } else {
        #item 445
        set structures_built 1
        #item 441
        generate_structure state {
        	tree
        	points
        	remaining
        	passed
        	parents
        	incount
        	nodes
        }
        #item 442
        generate_structure point {item_id path stack phase}
        #item 636
        generate_structure parent {item_id value type path}
        #item 446
        generate_structure tar {tree position}
        #item 675
        generate_structure ncounter { item_id count waiting }
    }
}

proc choose_latest { order nodes } {
    #item 39600001
    set _col3960 $nodes
    set _len3960 [ llength $_col3960 ]
    set _ind3960 0
    while { 1 } {
        #item 39600002
        if {$_ind3960 < $_len3960} {
            
        } else {
            #item 4103
            complain [ list \
             "choose_latest" \
             "fail" \
             "nodes=/$nodes/" ]
            #item 3966
            return {}
        }
        #item 39600004
        set current [ lindex $_col3960 $_ind3960 ]
        #item 3963
        if {[ after_others $order $nodes $current ]} {
            #item 3967
            return $current
        } else {
            
        }
        #item 39600003
        incr _ind3960
    }
}

proc clear_marked { db } {
    #item 249
    $db eval {
    	update nodes
    	set marked = 0;
    }
}

proc complain { message } {
    #item 4076
    variable g_fail_reason
    #item 4077
    lappend g_fail_reason $message
}

proc create_db { db } {
    #item 403
    global script_path
    #item 402
    catch {
    	$db close
    }
    sqlite3 $db :memory:
    #item 404
    set filename $script_path/generators/nogoto.sql
    set init_sql [ read_all_text $filename ]
    $db eval $init_sql
    #item 457
    build_structures
    #item 1480
    init_debug
}

proc ends_with { path node } {
    #item 4136
    set last [ last_item $path ]
    #item 4137
    return [ expr { $last == $node } ]
}

proc explain_fail { } {
    #item 4083
    variable g_fail_reason
    #item 40860001
    set _col4086 $g_fail_reason
    set _len4086 [ llength $_col4086 ]
    set _ind4086 0
    while { 1 } {
        #item 40860002
        if {$_ind4086 < $_len4086} {
            
        } else {
            break
        }
        #item 40860004
        set line [ lindex $_col4086 $_ind4086 ]
        #item 4084
        puts $line
        #item 40860003
        incr _ind4086
    }
}

proc find_block_ends { db start_item } {
    #item 3934
    set order [ find_nodes_order $db $start_item ]
    #item 3511
    set ifs [ select_ifs $db ]
    #item 3518
    set user_data [ list $db $order ]
    set if_recs [ lmap_user $ifs nogoto::find_if_end $user_data ]
    #item 3657
    if {[ any_true $if_recs nogoto::has_error ]} {
        #item 4095
        set msg [ list \
         "find_block_ends" \
         "some ifs have errors" \
         $if_recs ]
        #item 4100
        complain $msg
        #item 3660
        set result 0
    } else {
        #item 3669
        lassign [ lpartition $if_recs nogoto::has_loop ] \
         loop_ifs usual_ifs
        #item 3676
        array set if_by_loop [ group_by \
         $loop_ifs nogoto::get_loop_id ]
        #item 4056
        set loops [ array names if_by_loop ]
        #item 36830001
        set _col3683 $loops
        set _len3683 [ llength $_col3683 ]
        set _ind3683 0
        while { 1 } {
            #item 36830002
            if {$_ind3683 < $_len3683} {
                
            } else {
                #item 3724
                if {[ stray_loops $db ] > 0} {
                    #item 4099
                    set msg [ list \
                     "find_block_ends" \
                     "stray loops found" ]
                    #item 4100
                    complain $msg
                    #item 3660
                    set result 0
                } else {
                    #item 35190001
                    set _col3519 $if_recs
                    set _len3519 [ llength $_col3519 ]
                    set _ind3519 0
                    while { 1 } {
                        #item 35190002
                        if {$_ind3519 < $_len3519} {
                            
                        } else {
                            break
                        }
                        #item 35190004
                        set record [ lindex $_col3519 $_ind3519 ]
                        #item 3750
                        set item_id [ get_value $record "item_id" ]
                        set if_stop [ get_value $record "if_stop" ]
                        #item 3760
                        set_node_if_stop $db $item_id $if_stop
                        #item 35190003
                        incr _ind3519
                    }
                    #item 3661
                    set result 1
                }
                break
            }
            #item 36830004
            set loop_id [ lindex $_col3683 $_ind3683 ]
            #item 3686
            set records $if_by_loop($loop_id)
            #item 3693
            set break_id [ find_break $order $records ]
            #item 3685
            if {$break_id == {}} {
                #item 4096
                set msg [ list \
                 "find_block_ends" \
                 "could not find break" \
                 "$loop_id, $records" ]
                #item 4100
                complain $msg
                #item 3660
                set result 0
                break
            } else {
                
            }
            #item 3716
            set_node_loop_break $db $loop_id $break_id
            #item 3723
            set_if_breaks $db $records $break_id $loop_id
            #item 36830003
            incr _ind3683
        }
    }
    #item 3709
    return $result
}

proc find_break { order records } {
    #item 4062
    set if_stop_breaks [ lmap $records nogoto::get_if_break ]
    #item 4069
    set latest [ choose_latest $order $if_stop_breaks ]
    #item 4070
    return $latest
}

proc find_common_point { paths } {
    #item 3612
    set first_path [ lindex $paths 0 ]
    #item 3605
    if {[ llength $paths ] == 1} {
        #item 3609
        return [ item0 $first_path ]
    } else {
        #item 3613
        set other_paths [ lrange $paths 1 end ]
        #item 36100001
        set _col3610 $first_path
        set _len3610 [ llength $_col3610 ]
        set _ind3610 0
        while { 1 } {
            #item 36100002
            if {$_ind3610 < $_len3610} {
                
            } else {
                #item 3619
                return {}
            }
            #item 36100004
            set current [ lindex $_col3610 $_ind3610 ]
            #item 3617
            set found_in_all [ all_true_user \
             $other_paths contains $current ]
            #item 3614
            if {$found_in_all} {
                #item 3618
                return $current
            } else {
                
            }
            #item 36100003
            incr _ind3610
        }
    }
}

proc find_if_end { if_id user_data } {
    #item 3994
    lassign $user_data db order
    #item 3527
    set then_paths [ find_if_end_impl $db $if_id 0 {} {} ]
    set else_paths [ find_if_end_impl $db $if_id 1 {} {} ]
    #item 3990
    set all_paths $then_paths
    add_range all_paths $else_paths
    #item 3991
    set common [ find_common_point $all_paths ]
    #item 3992
    if {$common == {}} {
        #item 4015
        set all_ends [ lmap $all_paths last_item ]
        #item 4130
        set loop_id [ find_nearest_exit \
         $db $order $all_ends ]
        #item 4016
        if {$loop_id == {}} {
            #item 4090
            set msg [ list "find_if_end" \
             "could not find loop_id" \
             $all_paths \
             $all_ends ]
            #item 4093
            complain $msg
            #item 3597
            set result "error"
        } else {
            #item 4138
            lassign [ lpartition_user \
             $all_paths nogoto::ends_with $loop_id ] \
             cont_paths break_paths
            #item 4019
            set if_stop [ find_common_point $cont_paths ]
            set loop_break [ find_common_point $break_paths ]
            #item 4020
            if {$if_stop == {}} {
                #item 4139
                set msg [ list "find_if_end" \
                 "could not find if_stop" \
                 $all_paths \
                 $cont_paths ]
                #item 4093
                complain $msg
                #item 3597
                set result "error"
            } else {
                #item 4140
                if {$loop_break == {}} {
                    #item 4143
                    set msg [ list "find_if_end" \
                     "could not find loop_break" \
                     $all_paths \
                     $break_paths ]
                    #item 4093
                    complain $msg
                    #item 3597
                    set result "error"
                } else {
                    #item 4053
                    set result [ list \
                     "item_id"       $if_id \
                     "if_stop"       $if_stop \
                     "if_stop_break" $loop_break \
                     "loop_id"       $loop_id ]
                }
            }
        }
    } else {
        #item 4054
        set result [ list \
         "item_id"       $if_id \
         "if_stop"       $common \
         "if_stop_break" {} \
         "loop_id"       {} ]
    }
    #item 4006
    return $result
}

proc find_if_end_impl { db parent_id ordinal path loops } {
    #item 3537
    set item_id [ get_next_node \
     $db $parent_id $ordinal ]
    #item 3564
    if {$item_id == ""} {
        #item 3988
        set result [ list $path ]
    } else {
        #item 3547
        lappend path $item_id
        #item 3534
        if {[ is_link_up $db $parent_id $ordinal ]} {
            #item 3573
            if {[ contains $loops $item_id ]} {
                #item 3576
                set result {}
            } else {
                #item 3988
                set result [ list $path ]
            }
        } else {
            #item 3538
            set type [ get_node_type $db $item_id ]
            #item 35390001
            if {$type == "action"} {
                #item 3546
                set result [ find_if_end_impl \
                 $db $item_id 0 $path $loops ]
            } else {
                #item 35390002
                if {$type == "loop"} {
                    #item 3548
                    lappend loops $item_id
                    #item 3549
                    set result [ find_if_end_impl \
                     $db $item_id 0 $path $loops ]
                } else {
                    #item 35390003
                    if {$type == "if"} {
                        
                    } else {
                        #item 35390004
                        error "Unexpected switch value: $type"
                    }
                    #item 3550
                    set result [ find_if_end_impl \
                     $db $item_id 0 $path $loops ]
                    #item 3551
                    set result2 [ find_if_end_impl \
                     $db $item_id 1 $path $loops ]
                    #item 3552
                    add_range result $result2
                }
            }
        }
    }
    #item 3559
    return $result
}

proc find_incoming_links { db item_id } {
    #item 306
    return [ $db eval {
    	select link_id
    	from links
    	where dst = :item_id } ]
}

proc find_loop_starts { db } {
    #item 291
    return [ $db eval {
    	select dst
    	from links
    	where link_type = 'up'
    	group by dst
    } ]
}

proc find_nearest_exit { db order ends } {
    #item 4113
    set loops [ lfilter_user $ends nogoto::not_action $db ]
    #item 4114
    if {[ llength $loops ] == 0} {
        #item 4117
        set result [ item0 $ends ]
    } else {
        #item 4040
        set result [ choose_latest $order $loops ]
    }
    #item 4120
    return $result
}

proc find_nodes_order { db start_item } {
    #item 3901
    array set result {}
    #item 3903
    find_order $db $start_item result
    #item 3902
    return [ array get result ]
}

proc find_order { db item_id visited_name } {
    #item 3909
    upvar $visited_name visited
    #item 3914
    if {[ info exists visited($item_id) ]} {
        #item 3917
        set result $visited($item_id)
    } else {
        #item 3922
        set result {}
        #item 3926
        add_range result [ find_order_for_child \
         $db $item_id 0 visited ]
        #item 3953
        add_range result [ find_order_for_child \
         $db $item_id 1 visited ]
        #item 3931
        set result [ lsort -unique $result ]
        #item 3933
        set visited($item_id) $result
    }
    #item 3932
    return $result
}

proc find_order_for_child { db parent_item ordinal visited_name } {
    #item 3945
    upvar $visited_name visited
    #item 3946
    if {[ is_link_up $db $parent_item $ordinal ]} {
        #item 3949
        set result {}
    } else {
        #item 3941
        set item_id [ get_next_node $db $parent_item $ordinal ]
        #item 3942
        if {$item_id == ""} {
            #item 3949
            set result {}
        } else {
            #item 4145
            set result [ list $item_id ]
            #item 3951
            add_range result [ find_order $db $item_id visited ]
        }
    }
    #item 3952
    return $result
}

proc find_outgoing_links { db item_id } {
    #item 244
    return [ $db eval {
    	select link_id
    	from links
    	where src = :item_id } ]
}

proc gen_action { db item_id ignored } {
    #item 3850
    set next [ get_next_node $db $item_id 0 ]
    #item 3851
    return [ list $item_id $next ]
}

proc gen_if { db item_id parent_loop } {
    #item 3857
    set next0 [ get_next_node $db $item_id 0 ]
    set next1 [ get_next_node $db $item_id 1 ]
    set if_stop [ get_node_if_stop $db $item_id ]
    set loop_break [ get_node_loop_break $db $item_id ]
    #item 4207
    set loop_id [ get_node_loop_id $db $item_id ]
    #item 4208
    if {$loop_id == {}} {
        #item 3859
        set result [ list "if" $item_id ]
        #item 3860
        lassign \
        [ generate_if_seq $db $next0 $if_stop $loop_break $parent_loop ] \
        then_block after_then
        #item 3861
        lassign \
        [ generate_if_seq $db $next1 $if_stop $loop_break $parent_loop ] \
        else_block after_else
        #item 4202
        if {($then_block == {}) || ($else_block == {})} {
            #item 4206
            return {}
        } else {
            #item 3862
            lappend result $then_block $else_block
            #item 3864
            if {$after_then == ""} {
                #item 3867
                set next $after_else
            } else {
                #item 3863
                set next $after_then
            }
            #item 3858
            return [ list $result $next ]
        }
    } else {
        #item 4211
        if {$parent_loop == $loop_id} {
            #item 3859
            set result [ list "if" $item_id ]
            #item 3860
            lassign \
            [ generate_if_seq $db $next0 $if_stop $loop_break $parent_loop ] \
            then_block after_then
            #item 3861
            lassign \
            [ generate_if_seq $db $next1 $if_stop $loop_break $parent_loop ] \
            else_block after_else
            #item 4202
            if {($then_block == {}) || ($else_block == {})} {
                #item 4206
                return {}
            } else {
                #item 3862
                lappend result $then_block $else_block
                #item 3864
                if {$after_then == ""} {
                    #item 3867
                    set next $after_else
                } else {
                    #item 3863
                    set next $after_then
                }
                #item 3858
                return [ list $result $next ]
            }
        } else {
            #item 4212
            complain [ list \
             "gen_if" \
             "if is not inside its loop" \
             "$item_id, $parent_loop, $loop_id" ]
            #item 4206
            return {}
        }
    }
}

proc gen_loop { db item_id ignored } {
    #item 3885
    set start [ get_next_node $db $item_id 0 ]
    set loop_break [ get_node_loop_break $db $item_id ]
    #item 3887
    set result [ list "loop" ]
    #item 3888
    set current $start
    while { 1 } {
        #item 3889
        if {[ is_link_up $db $current 0 ]} {
            #item 3886
            return [ list $result $loop_break ]
        } else {
            
        }
        #item 3891
        lassign \
        [ generate_item $db $current $item_id ] \
         subtree next
        #item 4217
        if {$subtree == {}} {
            #item 4220
            return {}
        } else {
            
        }
        #item 3893
        lappend result $subtree
        #item 3892
        set current $next
    }
}

proc generate { db start_item } {
    #item 4085
    variable g_fail_reason
    set g_fail_reason {}
    #item 2069
    variable g_stack
    set g_stack {}
    #item 1807
    set dummy 88888
    insert_dummy $db $dummy $start_item
    #item 503
    clear_marked $db
    #item 502
    mark_backward_links $db 0 $dummy {}
    #item 504
    insert_loops $db
    #item 2478
    set start_id $dummy
    #item 2240
    if { 1 } {
    	#print_nodes $db
    	if { ![find_block_ends $db $start_id ] } {
    		#explain_fail
    		return {}
    	}
    	set tree [ generate3 $db $start_id ]
    	set result [ remove_dummy $tree ]
    	return $result
    }
    #item 3055
    set solution [ generate2 $db $start_id ]
    set result [ remove_dummy $solution ]
    #item 493
    return $result
}

proc generate3 { db start_item } {
    #item 3766
    set result [ list seq ]
    set current $start_item
    while { 1 } {
        #item 3771
        if {$current == ""} {
            #item 3770
            return $result
        } else {
            
        }
        #item 3767
        lassign \
        [ generate_item $db $current {} ] \
         subtree next
        #item 4197
        if {$subtree == {}} {
            #item 4201
            return {}
        } else {
            
        }
        #item 3769
        lappend result $subtree
        #item 3768
        set current $next
    }
}

proc generate_if_seq { db start_item if_stop break_loop parent_loop } {
    #item 3817
    set result [ list seq ]
    set current $start_item
    while { 1 } {
        #item 3824
        if {$current == $break_loop} {
            #item 3825
            lappend result "break"
            #item 3844
            set current ""
            #item 3821
            return [ list $result $current ]
        } else {
            
        }
        #item 3827
        if {$current == $if_stop} {
            #item 3821
            return [ list $result $current ]
        } else {
            
        }
        #item 3831
        lassign \
        [ generate_item $db $current $parent_loop ] \
         subtree next
        #item 4213
        if {$subtree == {}} {
            #item 4216
            return {}
        } else {
            
        }
        #item 3832
        lappend result $subtree
        set current $next
    }
}

proc generate_item { db item_id parent_loop } {
    #item 3799
    set type [ get_node_type $db $item_id ]
    #item 37920001
    if {$type == "action"} {
        #item 3800
        set fun gen_action
    } else {
        #item 37920002
        if {$type == "if"} {
            #item 3801
            set fun gen_if
        } else {
            #item 37920003
            if {$type == "loop"} {
                
            } else {
                #item 37920004
                error "Unexpected switch value: $type"
            }
            #item 3802
            set fun gen_loop
        }
    }
    #item 3804
    return [ $fun $db $item_id $parent_loop ]
}

proc generate_state_key { state } {
    #item 1938
    set incounts [ get_state_incount $state ]
    set count [ llength $incounts ]
    #item 1939
    set result [ get_state_tree $state ]
    lappend result "|"
    #item 1945
    set incs {}
    #item 19400001
    set i 1
    while { 1 } {
        #item 19400002
        if {$i < $count} {
            
        } else {
            break
        }
        #item 1942
        set ncounter [ lindex $incounts $i ]
        set item_id [ get_ncounter_item_id $ncounter ]
        set waiting [ get_ncounter_waiting $ncounter ]
        #item 1947
        if {[ llength $waiting ] > 0} {
            #item 1952
            set stacks {}
            #item 19500001
            set _col1950 $waiting
            set _len1950 [ llength $_col1950 ]
            set _ind1950 0
            while { 1 } {
                #item 19500002
                if {$_ind1950 < $_len1950} {
                    
                } else {
                    break
                }
                #item 19500004
                set point [ lindex $_col1950 $_ind1950 ]
                #item 1953
                set stack [ get_point_stack $point ]
                lappend stacks $stack
                #item 19500003
                incr _ind1950
            }
            #item 1954
            set stacks [ lsort $stacks ]
            #item 1943
            lappend incs [ list $item_id $stacks ]
        } else {
            
        }
        #item 19400003
        incr i 2
    }
    #item 1946
    set incs [ lsort $incs ]
    #item 1944
    return [ concat $result $incs ]
}

proc get_if_break { record } {
    #item 4068
    return [ get_value $record "if_stop_break" ]
}

proc get_link_dst { db link_id } {
    #item 279
    return [ $db onecolumn {
    	select dst
    	from links
    	where link_id = :link_id } ]
}

proc get_loop_id { record } {
    #item 3675
    return [ get_value $record "loop_id" ]
}

proc get_next_node { db src ordinal } {
    #item 2370
    return [ $db onecolumn {
    	select dst
    	from links
    	where src = :src and ordinal = :ordinal } ]
}

proc get_node_continue { db item_id } {
    #item 2543
    return [ $db onecolumn {
    	select continue_item
    	from nodes
    	where item_id = :item_id } ]
}

proc get_node_if_stop { db item_id } {
    #item 3873
    return [ $db onecolumn {
    	select if_stop
    	from nodes
    	where item_id = :item_id } ]
}

proc get_node_leaves { db item_id } {
    #item 1898
    return [ $db onecolumn {
    	select leaves
    	from nodes
    	where item_id = :item_id } ]
}

proc get_node_loop_break { db item_id } {
    #item 3879
    return [ $db onecolumn {
    	select loop_break
    	from nodes
    	where item_id = :item_id } ]
}

proc get_node_loop_id { db item_id } {
    #item 4157
    return [ $db onecolumn {
    	select loop_id
    	from nodes
    	where item_id = :item_id } ]
}

proc get_node_type { db item_id } {
    #item 720
    return [ $db onecolumn {
    	select type
    	from nodes
    	where item_id = :item_id } ]
}

proc get_normal { record } {
    #item 3692
    return [ get_value $record "normal" ]
}

proc has_error { item } {
    #item 3651
    return [ expr { $item == "error" } ]
}

proc has_loop { record } {
    #item 3667
    set loop_id [ get_value $record "loop_id" ]
    #item 4055
    return [ expr { $loop_id != {} } ]
}

proc init_debug { } {
    #item 1478
    variable debug_paths
    #item 1479
    array unset debug_paths
    array set debug_paths {}
}

proc insert_dummy { db dummy_id start } {
    #item 1804
    insert_node $db $dummy_id action {}
    #item 1806
    insert_link $db $dummy_id 0 $start normal
}

proc insert_link { db src ordinal dst link_type } {
    #item 418
    $db eval {
    	insert into links (src, ordinal, dst, link_type)
    	values (:src, :ordinal, :dst, :link_type)
    }
}

proc insert_loops { db } {
    #item 214
    set starts [ find_loop_starts $db ]
    #item 2150001
    set _col215 $starts
    set _len215 [ llength $_col215 ]
    set _ind215 0
    while { 1 } {
        #item 2150002
        if {$_ind215 < $_len215} {
            
        } else {
            break
        }
        #item 2150004
        set item_id [ lindex $_col215 $_ind215 ]
        #item 217
        insert_node_before $db $item_id
        #item 2150003
        incr _ind215
    }
}

proc insert_node { db item_id type text_lines } {
    #item 412
    $db eval {
    	insert into nodes (item_id, type, text_lines)
    	values (:item_id, :type, :text_lines)
    }
}

proc insert_node_before { db before_node } {
    #item 319
    set incoming [ find_incoming_links $db $before_node ]
    #item 320
    set item_id [ $db onecolumn {
    	select max(item_id)
    	from nodes } ]
    incr item_id
    #item 321
    insert_node $db $item_id loop {}
    #item 3230001
    set _col323 $incoming
    set _len323 [ llength $_col323 ]
    set _ind323 0
    while { 1 } {
        #item 3230002
        if {$_ind323 < $_len323} {
            
        } else {
            break
        }
        #item 3230004
        set link_id [ lindex $_col323 $_ind323 ]
        #item 325
        set_link_dst $db $link_id $item_id
        #item 3230003
        incr _ind323
    }
    #item 322
    insert_link $db $item_id 0 $before_node normal
}

proc is_link_up { db src ordinal } {
    #item 1317
    set link_type [ $db onecolumn {
    	select link_type
    	from links
    	where src = :src and ordinal = :ordinal } ]
    #item 1318
    return [ expr { $link_type == "up" } ]
}

proc is_marked { db item_id } {
    #item 256
    set result [ $db onecolumn {
    	select marked
    	from nodes
    	where item_id = :item_id } ]
    #item 752
    if {$result == ""} {
        #item 753
        set count [ $db onecolumn {
        	select count(*)
        	from nodes
        	where item_id = :item_id } ]
        error "item_id: $item_id, found: $count. No marked value"
    } else {
        #item 751
        return $result
    }
}

proc many_ends { records } {
    #item 3643
    set ends [ lmap $records nogoto::get_path_tail ]
    set unique_ends [ lsort -unique $ends ]
    set count [ llength $unique_ends ]
    #item 3644
    return [ expr { $count > 1 } ]
}

proc mark { db item_id } {
    #item 263
    $db onecolumn {
    	update nodes
    	set marked = 1
    	where item_id = :item_id
    }
}

proc mark_backward_links { db src_link_id item_id path } {
    #item 153
    if {$item_id == 0} {
        
    } else {
        #item 115
        if {[ is_marked $db $item_id ]} {
            #item 138
            if {[ contains $path $item_id ]} {
                #item 2533
                set citem [ get_node_continue $db $item_id ]
                #item 2534
                if {$citem == ""} {
                    #item 2014
                    set dummy_id [ next_node_id $db ]
                    #item 2536
                    set_node_continue $db $item_id $dummy_id
                    #item 2015
                    insert_node $db $dummy_id action {}
                    set_node_dummy $db $dummy_id 1
                    mark $db $dummy_id
                    #item 2016
                    set_link_dst $db $src_link_id $dummy_id
                    insert_link $db $dummy_id 0 $item_id up
                } else {
                    #item 2537
                    set_link_dst $db $src_link_id $citem
                }
            } else {
                
            }
        } else {
            #item 116
            mark $db $item_id
            #item 117
            lappend path $item_id
            #item 125
            set outgoing [ find_outgoing_links $db $item_id ]
            #item 1330001
            set _col133 $outgoing
            set _len133 [ llength $_col133 ]
            set _ind133 0
            while { 1 } {
                #item 1330002
                if {$_ind133 < $_len133} {
                    
                } else {
                    break
                }
                #item 1330004
                set link_id [ lindex $_col133 $_ind133 ]
                #item 135
                set dst [ get_link_dst $db $link_id ]
                mark_backward_links $db $link_id $dst $path
                #item 1330003
                incr _ind133
            }
        }
    }
}

proc next_node_id { db } {
    #item 2531
    set node_id [ $db onecolumn {
    	select max(item_id)
    	from nodes } ]
    incr node_id
    #item 2532
    return $node_id
}

proc node_exists { db item_id } {
    #item 1819
    set count [ $db onecolumn {
    	select count(*)
    	from nodes
    	where item_id = :item_id } ]
    #item 1820
    return $count
}

proc not_action { item_id db } {
    #item 4111
    set type [ get_node_type $db $item_id ]
    #item 4112
    return [ expr { $type != "action" } ]
}

proc print_nodes { db } {
    #item 2485
    
    puts \n
    $db eval {
    	select * from nodes order by item_id
    } {
    	set link0 [ $db onecolumn { select dst, link_type
    		from links
    		where src = :item_id and ordinal = 0
    	} ]
    
    	set link1 [ $db onecolumn { select dst, link_type
    		from links
    		where src = :item_id and ordinal = 1
    	} ]
    	puts "$type\t$item_id: $link0, $link1.  if_stop=$if_stop loop_break=$loop_break"	
    }
}

proc print_state { state } {
    #item 1494
    set tree [ get_state_tree $state ]
    set points [ get_state_points $state ]
    set remaining [ get_state_remaining $state ]
    set passed [ get_state_passed $state ]
    set nodes [ get_state_nodes $state ]
    
    set parents_map [ get_state_parents $state ]
    set incounts_map [ get_state_incount $state ]
    
    array set parents $parents_map
    array set incounts $incounts_map
    #item 1499
    puts "tree: $tree"
    #item 1500
    puts "remaining: $remaining, passed: $passed"
    #item 1501
    parray parents
    puts ----------
    parray incounts
    #item 15080001
    set _col1508 $points
    set _len1508 [ llength $_col1508 ]
    set _ind1508 0
    while { 1 } {
        #item 15080002
        if {$_ind1508 < $_len1508} {
            
        } else {
            break
        }
        #item 15080004
        set point [ lindex $_col1508 $_ind1508 ]
        #item 1510
        unpack $point item_id path stack stage
        puts "point item_id: $item_id, path: $path, stack: $stack, stage: $stage"
        #item 15080003
        incr _ind1508
    }
    #item 1511
    puts "nodes: $nodes\n"
}

proc print_tree_path { leaf } {
    #item 2486
    return
    #item 1515
    variable debug_paths
    #item 1518
    set steps {}
    set current $leaf
    while { 1 } {
        #item 1519
        lappend steps $current
        #item 1520
        if {[ info exists debug_paths($current) ]} {
            
        } else {
            break
        }
        #item 1522
        set current $debug_paths($current)
    }
    #item 1524
    set steps [ lreverse $steps ]
    #item 1531
    puts \n\n\n===========================\n\n\n
    #item 15250001
    set _col1525 $steps
    set _len1525 [ llength $_col1525 ]
    set _ind1525 0
    while { 1 } {
        #item 15250002
        if {$_ind1525 < $_len1525} {
            
        } else {
            break
        }
        #item 15250004
        set state [ lindex $_col1525 $_ind1525 ]
        #item 1527
        print_state $state
        puts ------------------------------------------
        #item 15250003
        incr _ind1525
    }
}

proc record_edge { src dst } {
    #item 2487
    return
    #item 1473
    variable debug_paths
    #item 1474
    set debug_paths($dst) $src
}

proc remove_dummy { tree } {
    #item 1813
    return [ lreplace $tree 1 1 ]
}

proc select_ifs { db } {
    #item 3517
    return [ $db eval {
    	select item_id
    	from nodes
    	where type = 'if' } ]
}

proc set_if_breaks { db records break_id loop_id } {
    #item 37300001
    set _col3730 $records
    set _len3730 [ llength $_col3730 ]
    set _ind3730 0
    while { 1 } {
        #item 37300002
        if {$_ind3730 < $_len3730} {
            
        } else {
            break
        }
        #item 37300004
        set record [ lindex $_col3730 $_ind3730 ]
        #item 3732
        set item_id [ get_value $record "item_id" ]
        set if_stop [ get_value $record "if_stop" ]
        #item 3734
        set_node_loop_break $db $item_id $break_id
        #item 3733
        set_node_if_stop $db $item_id $if_stop
        #item 4164
        set_node_loop_id $db $item_id $loop_id
        #item 37300003
        incr _ind3730
    }
}

proc set_link_dst { db link_id new_dst } {
    #item 286
    $db eval {
    	update links
    	set dst = :new_dst
    	where link_id = :link_id
    }
}

proc set_link_src { db link_id new_src } {
    #item 2022
    $db eval {
    	update links
    	set src = :new_src
    	where link_id = :link_id
    }
}

proc set_link_type { db link_id link_type } {
    #item 272
    $db eval {
    	update links
    	set link_type = :link_type
    	where link_id = :link_id
    }
}

proc set_node_continue { db item_id continue_item } {
    #item 2549
    $db eval {
    	update nodes
    	set continue_item = :continue_item
    	where item_id = :item_id
    }
}

proc set_node_dummy { db item_id is_dummy } {
    #item 2040
    $db eval {
    	update nodes
    	set is_dummy = :is_dummy
    	where item_id = :item_id
    }
}

proc set_node_if_stop { db item_id if_stop } {
    #item 3743
    $db eval {
    	update nodes
    	set if_stop = :if_stop
    	where item_id = :item_id
    }
}

proc set_node_loop_break { db item_id loop_break } {
    #item 3737
    $db eval {
    	update nodes
    	set loop_break = :loop_break
    	where item_id = :item_id
    }
}

proc set_node_loop_id { db item_id value } {
    #item 4163
    $db eval {
    	update nodes
    	set loop_id = :value
    	where item_id = :item_id
    }
}

proc stray_loops { db } {
    #item 3749
    return [ $db onecolumn {
    	select count(*)
    	from nodes
    	where type = 'loop'
    		and loop_break is null
    } ]
}

}
