gen::add_generator Lua gen_lua::generate

namespace eval gen_lua {


# Autogenerated with DRAKON Editor 1.21

proc assign { variable value } {
    #item 1398
    return "$variable = $value"
}

proc bad_case { switch_var } {
    #item 1408
    return "error\($switch_var\)"
}

proc block_close { output depth } {
    #item 1787
    upvar 1 $output result
    set line [ gen::make_indent $depth ]
    append line "end"
    lappend result $line
}

proc commentator { text } {
    #item 143
    return "-- $text"
}

proc compare { variable constant } {
    #item 1404
    return "$variable == $constant"
}

proc declare { type name value } {
    #item 1434
    return "local $name = $value"
}

proc else_start { } {
    #item 1530
    return "else"
}

proc elseif_start { } {
    #item 1773
    return "elseif "
}

proc extract_signature { text name } {
    #item 783
    array set props { type function access public }
    set error_message ""
    set parameters {}
    #item 15
    set lines [ gen::separate_from_comments $text ]
    #item 17
    if {[ llength $lines ] == 0} {
        
    } else {
        #item 16
        set first_line [ lindex $lines 0 ]
        set first [ lindex $first_line 0 ]
        #item 589
        if {$first == "#comment"} {
            #item 42
            set props(type) "comment"
        } else {
            #item 1562
            if {$first == "local"} {
                #item 1565
                set props(access) "local"
                #item 1567
                set start_index 1
            } else {
                #item 1566
                set start_index 0
            }
            #item 34
            set count [ llength $lines ]
            #item 370001
            set i $start_index
            while { 1 } {
                #item 370002
                if {$i < $count} {
                    
                } else {
                    break
                }
                #item 36
                set current [ lindex $lines $i ]
                #item 45
                lappend parameters $current
                #item 370003
                incr i
            }
        }
    }
    #item 793
    set prop_list [ array get props ]
    #item 38
    return [ list $error_message \
    [ gen::create_signature $props(type) $prop_list $parameters "" ] ]
}

proc foreach_check { item_id first second } {
    #item 1676
    set vars [ split_vars $item_id $first ]
    #item 1677
    set var1 [ lindex $vars 0 ]
    #item 1678
    return "$var1 ~= nil"
}

proc foreach_current { item_id first second } {
    #item 1610
    return ""
}

proc foreach_declare { item_id first second } {
    #item 1667
    set iter_var "_iter$item_id"
    set state_var "_state$item_id"
    #item 1618
    return "local $iter_var, $state_var, $first"
}

proc foreach_incr { item_id first second } {
    #item 1673
    set vars [ split_vars $item_id $first ]
    #item 1675
    set iter_var "_iter$item_id"
    set state_var "_state$item_id"
    #item 1674
    set var1 [ lindex $vars 0 ]
    #item 1672
    return "$first = $iter_var\($state_var, $var1\)"
}

proc foreach_init { item_id first second } {
    #item 1668
    set vars [ split_vars $item_id $first ]
    #item 1671
    set iter_var "_iter$item_id"
    set state_var "_state$item_id"
    #item 1669
    set var1 [ lindex $vars 0 ]
    #item 1670
    return "$iter_var, $state_var, $var1 = $second $first = $iter_var\($state_var, $var1\)"
}

proc generate { db gdb filename } {
    #item 1767
    set diagrams [ $gdb eval {
    	select diagram_id
    	from vertices
    	group by diagram_id
    } ]
    #item 17680001
    set _col1768 $diagrams
    set _len1768 [ llength $_col1768 ]
    set _ind1768 0
    while { 1 } {
        #item 17680002
        if {$_ind1768 < $_len1768} {
            
        } else {
            break
        }
        #item 17680004
        set diagram_id [ lindex $_col1768 $_ind1768 ]
        #item 1766
        rewire_lua_for $gdb $diagram_id
        #item 17680003
        incr _ind1768
    }
    #item 1284
    set callbacks [ make_callbacks ]
    #item 1278
    gen::fix_graph $gdb $callbacks 0
    #item 1279
    set sections { header footer }
    unpack [ gen::scan_file_description $db $sections ] \
    header footer
    #item 1270
    set functions [ gen::generate_functions $db $gdb  \
    	$callbacks 1 ]
    #item 1261
    if {[ graph::errors_occured ]} {
        
    } else {
        #item 1280
        set filename [ replace_extension $filename "lua" ]
        #item 1282
        set fhandle [ open $filename w ]
        
        catch {
        	print_to_file $fhandle $functions \
        		$header $footer
        } error_message
        
        catch { close $fhandle }
        #item 1262
        if {$error_message == ""} {
            
        } else {
            #item 1263
            puts $::errorInfo
            error $error_message
        }
    }
}

proc generate_body { gdb diagram_id start_item node_list items incoming } {
    #item 1512
    set callbacks [ make_callbacks ]
    #item 1511
    cbody::generate_body $gdb $diagram_id $start_item $node_list \
        $items $incoming $callbacks
}

proc goto { text } {
    #item 1644
    return "goto $text"
}

proc if_end { } {
    #item 1526
    return " then"
}

proc if_start { } {
    #item 1522
    return "if "
}

proc is_for { text } {
    #item 1684
    set trimmed [ string trim $text]
    #item 1685
    set result [ string match "for *" $trimmed ]
    #item 1686
    return $result
}

proc make_callbacks { } {
    #item 1192
    set callbacks {}
    #item 1194
    gen::put_callback callbacks assign    gen_lua::assign
    gen::put_callback callbacks compare   gen_lua::compare
    gen::put_callback callbacks compare2  gen_lua::compare
    gen::put_callback callbacks bad_case  gen_lua::bad_case
    
    gen::put_callback callbacks body      gen_lua::generate_body
    gen::put_callback callbacks signature gen_lua::extract_signature
    gen::put_callback callbacks and       gen_lua::p.and
    gen::put_callback callbacks or        gen_lua::p.or
    gen::put_callback callbacks not       gen_lua::p.not
    gen::put_callback callbacks declare   gen_lua::declare
    
    gen::put_callback callbacks comment   gen_lua::commentator
    #item 1505
    gen::put_callback callbacks if_start     gen_lua::if_start
    gen::put_callback callbacks while_start     gen_lua::while_start
    gen::put_callback callbacks elseif_start     gen_lua::elseif_start
    gen::put_callback callbacks if_end       gen_lua::if_end
    gen::put_callback callbacks pass       gen_lua::pass
    gen::put_callback callbacks else_start   gen_lua::else_start
    gen::put_callback callbacks block_close  gen_lua::block_close
    gen::put_callback callbacks return_none  gen_lua::return_none
    gen::put_callback callbacks goto         gen_lua::goto
    gen::put_callback callbacks tag          gen_lua::tag
    gen::put_callback callbacks break        "break"
    #item 1619
    gen::put_callback callbacks for_check		gen_lua::foreach_check
    gen::put_callback callbacks for_current		gen_lua::foreach_current
    gen::put_callback callbacks for_init		gen_lua::foreach_init
    gen::put_callback callbacks for_incr		gen_lua::foreach_incr
    gen::put_callback callbacks for_declare		gen_lua::foreach_declare
    gen::put_callback callbacks shelf gen_lua::shelf
    #item 1193
    return $callbacks
}

proc normalize_for { var start end } {
    #item 1726
    return "$var = $start; $var <= $end; $var = $var + 1"
}

proc p.and { left right } {
    #item 1414
    return "($left) and ($right)"
}

proc p.not { operand } {
    #item 1426
    return "not ($operand)"
}

proc p.or { left right } {
    #item 1422
    return "($left) or ($right)"
}

proc parse_for { item_id text } {
    #item 1692
    set tokens [ to_tokens $text ]
    #item 1711
    if {[ llength $tokens ] < 6} {
        #item 1714
        error "Wrong 'for' syntax in item $item_id"
    } else {
        #item 1694
        unpack $tokens for var eq start comma
        #item 1715
        if {(($for == "for") && ($eq == "=")) && ($comma == ",")} {
            #item 1718
            set comma_index [ string first "," $text ]
            #item 1719
            set target_index [ expr { $comma_index + 1 } ]
            set target [ string range $text $target_index end ]
            set end [ string trim $target ]
            #item 1720
            return [ list $var $start $end ]
        } else {
            #item 1714
            error "Wrong 'for' syntax in item $item_id"
        }
    }
}

proc parse_foreach { item_id init } {
    #item 1625
    set length [ llength $init ]
    #item 1627
    if {$length == 2} {
        
    } else {
        #item 1626
        set message "item id: $item_id, wrong syntax in foreach. Should be: Type variable; collection"
    }
    #item 1630
    return $init
}

proc pass { } {
    #item 1781
    return ""
}

proc print_function { fhandle function } {
    #item 1571
    unpack $function diagram_id name signature body
    unpack $signature type prop_list parameters returns
    array set props $prop_list
    #item 1572
    set type   $props(type)
    set access $props(access)
    #item 1576
    set line ""
    set result {}
    #item 1575
    if {$type == "comment"} {
        
    } else {
        #item 1577
        if {$access == "local"} {
            #item 1580
            append line "local "
        } else {
            
        }
        #item 1581
        append line "function "
        #item 536
        append line "$name\("
        #item 588
        set param_count [ llength $parameters ]
        #item 5400001
        set i 0
        while { 1 } {
            #item 5400002
            if {$i < $param_count} {
                
            } else {
                break
            }
            #item 543
            set parameter_info [ lindex $parameters $i ]
            set parameter [ lindex $parameter_info 0 ]
            #item 541
            append line $parameter
            #item 544
            if {$i == $param_count - 1} {
                
            } else {
                #item 545
                append line ", "
            }
            #item 5400003
            incr i
        }
        #item 542
        append line "\)"
        #item 552
        lappend result $line
        #item 5830001
        set _col583 $body
        set _len583 [ llength $_col583 ]
        set _ind583 0
        while { 1 } {
            #item 5830002
            if {$_ind583 < $_len583} {
                
            } else {
                break
            }
            #item 5830004
            set line [ lindex $_col583 $_ind583 ]
            #item 582
            lappend result "    $line"
            #item 5830003
            incr _ind583
        }
        #item 585
        lappend result "end"
        #item 10200001
        set _col1020 $result
        set _len1020 [ llength $_col1020 ]
        set _ind1020 0
        while { 1 } {
            #item 10200002
            if {$_ind1020 < $_len1020} {
                
            } else {
                break
            }
            #item 10200004
            set line [ lindex $_col1020 $_ind1020 ]
            #item 1022
            puts $fhandle $line
            #item 10200003
            incr _ind1020
        }
        #item 1023
        puts $fhandle ""
    }
}

proc print_to_file { fhandle functions header footer } {
    #item 1561
    put_credits $fhandle
    #item 1559
    puts $fhandle $header
    #item 15680001
    set _col1568 $functions
    set _len1568 [ llength $_col1568 ]
    set _ind1568 0
    while { 1 } {
        #item 15680002
        if {$_ind1568 < $_len1568} {
            
        } else {
            break
        }
        #item 15680004
        set function [ lindex $_col1568 $_ind1568 ]
        #item 1570
        print_function $fhandle $function
        #item 15680003
        incr _ind1568
    }
    #item 1560
    puts $fhandle $footer
}

proc put_credits { fhandle } {
    #item 180
    set version [ version_string ]
    puts $fhandle \
        "-- Autogenerated with DRAKON Editor $version"
}

proc return_none { } {
    #item 1640
    return "return"
}

proc rewire_lua_for { gdb diagram_id } {
    #item 1732
    set starts [ $gdb eval {
    	select vertex_id
    	from vertices
    	where type = 'loopstart'
    		and text like 'for %'
    		and diagram_id = :diagram_id
    } ]
    #item 1733
    set loop_vars {}
    #item 17340001
    set _col1734 $starts
    set _len1734 [ llength $_col1734 ]
    set _ind1734 0
    while { 1 } {
        #item 17340002
        if {$_ind1734 < $_len1734} {
            
        } else {
            break
        }
        #item 17340004
        set vertex_id [ lindex $_col1734 $_ind1734 ]
        #item 1736
        unpack [ $gdb eval { 
        	select text, item_id
        	from vertices
        	where vertex_id = :vertex_id
        } ] text item_id
        #item 1737
        unpack [ parse_for $item_id $text ] var start end
        #item 1738
        set new_text [ normalize_for $var $start $end ]
        #item 1739
        $gdb eval {
        	update vertices
        	set text = :new_text
        	where vertex_id = :vertex_id
        }
        #item 1740
        lappend loop_vars $var
        #item 17340003
        incr _ind1734
    }
    #item 1753
    set var_list [ lsort -unique $loop_vars ]
    #item 1759
    if {$var_list == {}} {
        
    } else {
        #item 1755
        set vars_comma [ join $var_list ", " ]
        #item 1756
        set declaration "local $vars_comma"
        #item 1757
        gen::p.save_declare_kernel $gdb $diagram_id $declaration
    }
}

proc shelf { primary secondary } {
    #item 1793
    return "$secondary = $primary"
}

proc split_vars { $item_id var_list } {
    #item 1652
    set raw [ split $var_list "," ]
    #item 1653
    set result {}
    #item 16550001
    set _col1655 $raw
    set _len1655 [ llength $_col1655 ]
    set _ind1655 0
    while { 1 } {
        #item 16550002
        if {$_ind1655 < $_len1655} {
            
        } else {
            break
        }
        #item 16550004
        set part [ lindex $_col1655 $_ind1655 ]
        #item 1657
        set stripped [ string trim $part ]
        #item 1658
        if {$stripped == ""} {
            
        } else {
            #item 1661
            lappend result $stripped
        }
        #item 16550003
        incr _ind1655
    }
    #item 1663
    if {$result == {}} {
        #item 1662
        error "Bad variable list in $item_id"
    } else {
        
    }
    #item 1654
    return $result
}

proc tag { text } {
    #item 1634
    return "\:\:$text\:\:"
}

proc to_tokens { text } {
    #item 1700
    set tokens [ search::to_tokens $text ]
    #item 1701
    set result {}
    #item 17030001
    set _col1703 $tokens
    set _len1703 [ llength $_col1703 ]
    set _ind1703 0
    while { 1 } {
        #item 17030002
        if {$_ind1703 < $_len1703} {
            
        } else {
            break
        }
        #item 17030004
        set token [ lindex $_col1703 $_ind1703 ]
        #item 1705
        set text [ lindex $token 0 ]
        #item 1706
        set trimmed [ string trim $text ]
        #item 1708
        if {$trimmed == ""} {
            
        } else {
            #item 1707
            lappend result $text
        }
        #item 17030003
        incr _ind1703
    }
    #item 1702
    return $result
}

proc while_start { } {
    #item 1777
    return "while true do"
}

}
