
gen::add_generator Javascript gen_js::generate

namespace eval gen_js {

proc shelf { primary secondary } {
	return "$secondary = $primary;"
}


proc foreach_init { item_id first second } {
	set index_var "_ind$item_id"
	set keys_var "_keys$item_id"
	set coll_var "_col$item_id"
	set length_var "_len$item_id"
	return "var $index_var = 0;\nvar $coll_var = $second;\nvar $keys_var = Object.keys\($coll_var\); \nvar $length_var = $keys_var.length;"
}

proc foreach_check { item_id first second } {
	set index_var "_ind$item_id"
	set length_var "_len$item_id"
	return "$index_var < $length_var"
}

proc foreach_current { item_id first second } {
	set index_var "_ind$item_id"
	set coll_var "_col$item_id"
	set keys_var "_keys$item_id"
	return "var $first = $coll_var\[$keys_var\[$index_var\]\];"
}

proc foreach_incr { item_id first second } {
	set index_var "_ind$item_id"
	return "$index_var++;"
}

proc make_callbacks { } {
	set callbacks {}
	
	gen::put_callback callbacks assign			gen_java::assign
	gen::put_callback callbacks compare			gen_java::compare
	gen::put_callback callbacks compare2		gen_java::compare2
	gen::put_callback callbacks while_start 	gen_java::while_start
	gen::put_callback callbacks if_start		gen_java::if_start
	gen::put_callback callbacks elseif_start	gen_java::elseif_start
	gen::put_callback callbacks if_end			gen_java::if_end
	gen::put_callback callbacks else_start		gen_java::else_start
	gen::put_callback callbacks pass			gen_java::pass
	gen::put_callback callbacks continue		gen_java::p.continue
	
	gen::put_callback callbacks return_none		gen_js::p.return_none
	
	gen::put_callback callbacks block_close		gen_java::block_close
	gen::put_callback callbacks comment			gen_java::commentator
	
	gen::put_callback callbacks bad_case		gen_js::p.bad_case
	gen::put_callback callbacks for_init		gen_js::foreach_init
	gen::put_callback callbacks for_check		gen_js::foreach_check
	gen::put_callback callbacks for_current		gen_js::foreach_current
	gen::put_callback callbacks for_incr		gen_js::foreach_incr
	gen::put_callback callbacks body			gen_js::generate_body
	gen::put_callback callbacks signature		gen_tcl::extract_signature
	gen::put_callback callbacks and				gen_java::p.and
	gen::put_callback callbacks or				gen_java::p.or
	gen::put_callback callbacks not				gen_java::p.not
	gen::put_callback callbacks break			"break;"
	gen::put_callback callbacks declare			gen_js::p.declare
	gen::put_callback callbacks for_declare		gen_js::for_declare
	gen::put_callback callbacks shelf		gen_js::shelf
	

	return $callbacks
}

proc p.declare { type name value } {
	return "var $name = $value;"
}

proc generate_body { gdb diagram_id start_item node_list sorted incoming } {
	set callbacks [ make_callbacks ]
	return [ cbody::generate_body $gdb $diagram_id $start_item $node_list \
		$sorted $incoming $callbacks ]
}


proc p.return_none { } {
	return "return null;"
}

proc p.block_close { output depth } {
	upvar 1 $output result
	set line [ gen::make_indent $depth ]
	append line "\}"
	lappend result $line
}

proc p.bad_case { switch_var } {
	return "throw \"Unexpected switch value: \" + $switch_var;"
}

proc for_declare { item_id first second } {
	return ""
}

proc generate { db gdb filename } {
	set callbacks [ make_callbacks ]

	gen::fix_graph $gdb $callbacks 0
	unpack [ gen::scan_file_description $db { header footer } ] header footer

	set use_nogoto 1
	set functions [ gen::generate_functions $db $gdb $callbacks $use_nogoto ]

	if { [ graph::errors_occured ] } { return }


	set hfile [ replace_extension $filename "js" ]
	set f [ open $hfile w ]
	catch {
		p.print_to_file $f $functions $header $footer
	} error_message

	catch { close $f }
	if { $error_message != "" } {
		error $error_message
	}
}

proc build_declaration { name signature } {
	unpack $signature type access parameters returns
	set result "function $name\("
	set params {}
	foreach parameter $parameters {
		lappend params [ lindex $parameter 0 ]
	}
	set params_list [ join $params ", " ]
	append result $params_list
	append result "\) \{"
	return $result
}

proc p.print_to_file { fhandle functions header footer } {
	if { $header != "" } {
		puts $fhandle $header
	}
	set version [ version_string ]
	puts $fhandle \
	    "// Autogenerated with DRAKON Editor $version"


	foreach function $functions {
		unpack $function diagram_id name signature body
		set type [ lindex $signature 0 ]
		if { $type != "comment" } {
			puts $fhandle ""
			set declaration [ build_declaration $name $signature ]
			puts $fhandle $declaration
			set lines [ gen::indent $body 1 ]
			puts $fhandle $lines
			puts $fhandle "\}"
		}
	}
	puts $fhandle ""
	puts $fhandle $footer
}





}

