gen::add_generator "C++" gen_cpp::generate
gen::add_generator "C" gen_cpp::generate_c

namespace eval gen_cpp {

# Autogenerated with DRAKON Editor 1.21

proc append_to_end { gdb diagram_id text } {
    #item 1962
    set end_ids [ $gdb eval {
    	select vertex_id
    	from vertices v
    	inner join links l on v.vertex_id = l.dst
    	where v.diagram_id = :diagram_id
    	and v.type = 'beginend'
    	group by vertex_id 
    } ]
    #item 1963
    if {[ llength $end_ids ] == 1} {
        #item 1967
        set end_id [ lindex $end_ids 0 ]
        #item 1968
        set new_id [ insert_vertex $gdb $diagram_id "action" $text ]
        #item 1969
        $gdb eval {
        	update links
        	set dst = :new_id
        	where dst = :end_id;
        }
        #item 1970
        gen::p.link $gdb $new_id 1 $end_id
    } else {
        #item 1971
        puts "end_ids: $end_ids"
        #item 1966
        set name [ diagram_name $gdb $diagram_id ]
        error "Diagram $name: can't find End..."
    }
}

proc check { keywords args } {
    #item 6290001
    set _col629 $args
    set _len629 [ llength $_col629 ]
    set _ind629 0
    while { 1 } {
        #item 6290002
        if {$_ind629 < $_len629} {
            
        } else {
            break
        }
        #item 6290004
        set arg [ lindex $_col629 $_ind629 ]
        #item 622
        upvar 1 $arg keyword
        #item 623
        if {[ contains $keywords $arg ]} {
            #item 625
            set keyword 1
        } else {
            #item 624
            set keyword 0
        }
        #item 6290003
        incr _ind629
    }
}

proc classify_keywords { keywords name } {
    #item 687
    set errors {}
    check $keywords abstract const inline
    #item 633
    set access [ find_keywords \
     $keywords { private public protected } ]
    #item 6480000
    set _sw6480000_ [ llength $access ]
    #item 6480001
    if {($_sw6480000_ == 0) || ($_sw6480000_ == 1)} {
        
    } else {
        #item 638
        lappend errors \
         "$name: inconsistent access: $access"
    }
    #item 640
    set dispatch [ find_keywords \
     $keywords { virtual static } ]
    #item 6610000
    set _sw6610000_ [ llength $dispatch ]
    #item 6610001
    if {$_sw6610000_ == 0} {
        #item 660
        set dispatch "normal"
    } else {
        #item 6610002
        if {$_sw6610000_ == 1} {
            
        } else {
            #item 653
            lappend errors \
             "$name: inconsistent dispatch: $dispatch"
        }
    }
    #item 671
    set subtype [ find_keywords $keywords \
      { function method ctr dtr signal slot} ]
    #item 6720000
    set _sw6720000_ [ llength $subtype ]
    #item 6720001
    if {$_sw6720000_ == 0} {
        #item 670
        set subtype "function"
    } else {
        #item 6720002
        if {$_sw6720000_ == 1} {
            
        } else {
            #item 663
            lappend errors \
             "$name: inconsistent procedure type: $subtype"
        }
    }
    #item 1212
    if {$inline} {
        #item 1213
        if {$abstract} {
            #item 1216
            lappend errors \
            "$name: both inline and abstract is not allowed"
        } else {
            
        }
    } else {
        
    }
    #item 1217
    if {$abstract} {
        #item 1218
        set dispatch "virtual"
    } else {
        
    }
    #item 6740001
    if {$subtype == "function"} {
        #item 855
        if {($access == "protected") || ($access == "private")} {
            #item 859
            lappend errors \
            "$name: a function cannot be $access"
        } else {
            
        }
        #item 695
        if {$access == "public"} {
            #item 706
            if {$dispatch == "static"} {
                #item 699
                lappend errors \
                "$name: a function cannot be both public and static"
            } else {
                
            }
        } else {
            #item 713
            set access "static"
        }
        #item 703
        if {$dispatch == "normal"} {
            
        } else {
            #item 698
            if {$dispatch == "static"} {
                
            } else {
                #item 704
                lappend errors \
                "$name: wrong dispatch: $dispatch"
            }
        }
        #item 716
        if {$abstract} {
            #item 717
            lappend errors \
            "$name: a function cannot be abstract"
        } else {
            
        }
        #item 723
        if {$const} {
            #item 724
            lappend errors \
            "$name: a function cannot be abstract"
        } else {
            
        }
    } else {
        #item 6740002
        if {$subtype == "method"} {
            
        } else {
            #item 6740003
            if {$subtype == "ctr"} {
                #item 730
                if {$dispatch == "normal"} {
                    
                } else {
                    #item 731
                    lappend errors \
                    "$name: constructor cannot be $dispatch"
                }
                #item 734
                if {$const} {
                    #item 735
                    lappend errors \
                    "$name: constructor cannot be const"
                } else {
                    
                }
                #item 738
                if {$abstract} {
                    #item 739
                    lappend errors \
                    "$name: constructor cannot be abstract"
                } else {
                    
                }
            } else {
                #item 6740004
                if {$subtype == "dtr"} {
                    #item 7530001
                    if {$dispatch == "normal"} {
                        #item 759
                        set dispatch "virtual"
                    } else {
                        #item 7530002
                        if {$dispatch == "virtual"} {
                            
                        } else {
                            #item 746
                            lappend errors \
                            "$name: destructor cannot be $dispatch"
                        }
                    }
                    #item 760
                    if {$const} {
                        #item 761
                        lappend errors \
                        "$name: destructor cannot be const"
                    } else {
                        
                    }
                    #item 764
                    if {$abstract} {
                        #item 765
                        lappend errors \
                        "$name: destructor cannot be abstract"
                    } else {
                        
                    }
                    #item 7710001
                    if {$access == ""} {
                        #item 776
                        set access "public"
                    } else {
                        #item 7710002
                        if {$access == "public"} {
                            
                        } else {
                            #item 768
                            lappend errors \
                            "$name: destructor cannot be $access"
                        }
                    }
                } else {
                    #item 6740005
                    if {$subtype == "signal"} {
                        #item 784
                        if {$dispatch == "normal"} {
                            
                        } else {
                            #item 788
                            lappend errors \
                            "$name: a signal cannot be virtual or static"
                        }
                        #item 1230
                        if {$const} {
                            #item 1231
                            lappend errors \
                            "$name: signal cannot be const"
                        } else {
                            
                        }
                        #item 1234
                        if {$abstract} {
                            #item 1235
                            lappend errors \
                            "$name: signal cannot be abstract"
                        } else {
                            
                        }
                        #item 1244
                        set access "public"
                        set inline 0
                    } else {
                        #item 6740006
                        if {($subtype == "slot") && ($dispatch == "static")} {
                            #item 1224
                            lappend errors \
                            "$name: a slot cannot be static"
                        } else {
                            
                        }
                    }
                }
            }
        }
    }
    #item 749
    if {$access == ""} {
        #item 750
        set access "private"
    } else {
        
    }
    #item 778
    array set props {}
    #item 779
    set props(access) $access
    set props(dispatch) $dispatch
    set props(type) $subtype
    set props(abstract) $abstract
    set props(const) $const
    set props(inline) $inline
    #item 780
    set proplist [ array get props ]
    set error_message [ join $errors "\n" ]
    #item 781
    return [ list $error_message $proplist ]
}

proc clean_params { text } {
    #item 1541
    set raw_lines [ split $text "\n" ]
    #item 1555
    set wo_comments [ lmap $raw_lines gen_cpp::strip_comment ]
    #item 1556
    return [ non_empty_lines $wo_comments ]
}

proc commentator { text } {
    #item 143
    return "// $text"
}

proc create_jump { gdb diagram_id branches vertex_id dname } {
    #item 1931
    set count [ llength $branches ]
    #item 1932
    set branch [ find_branch $branches $vertex_id ]
    #item 1952
    set header [ get_value $branch header ]
    set header_text [ gen::p.vertex_text $gdb $header ]
    #item 1934
    set ordinal [ get_value $branch ordinal ]
    #item 1935
    if {$ordinal == $count} {
        #item 1955
        set text "self->State = 0;"
    } else {
        #item 1938
        if {[ is_receiving_branch $branch ]} {
            #item 1953
            set name [ state_info_name $dname $header_text ]
            #item 1954
            set text "self->State = &$name;"
        } else {
            #item 1950
            set name [ state_fun_name $dname $header_text ]
            #item 1951
            set text "${name}\(self\);"
        }
    }
    #item 1956
    return [ insert_vertex \
     $gdb $diagram_id "action" $text ]
}

proc delete_diagram { gdb diagram_id } {
    #item 1756
    $gdb eval {
    	delete from branches 
    	where diagram_id = :diagram_id;
    
    	delete from diagrams
    	where diagram_id = :diagram_id;
    }
}

proc diagram_name { gdb diagram_id } {
    #item 1425
    set name [ $gdb onecolumn {
    	select name
    	from diagrams
    	where diagram_id = :diagram_id } ]
    #item 1426
    return $name
}

proc extract_class_name { section } {
    #item 1202
    set section [ string map { "\{" " " } $section ]
    #item 944
    set lines [ split $section "\n" ]
    #item 9450001
    set _col945 $lines
    set _len945 [ llength $_col945 ]
    set _ind945 0
    while { 1 } {
        #item 9450002
        if {$_ind945 < $_len945} {
            
        } else {
            #item 955
            return ""
        }
        #item 9450004
        set line [ lindex $_col945 $_ind945 ]
        #item 946
        if {[ llength $line ] >= 2} {
            #item 947
            set first [ lindex $line 0 ]
            set second [ lindex $line 1 ]
            #item 948
            if {($first == "class") || ($first == "struct")} {
                #item 956
                return [ string map { ":" "" } $second ]
            } else {
                
            }
        } else {
            
        }
        #item 9450003
        incr _ind945
    }
}

proc extract_copying { section } {
    #item 879
    set lines [ split $section "\n" ]
    #item 8780001
    set _col878 $lines
    set _len878 [ llength $_col878 ]
    set _ind878 0
    while { 1 } {
        #item 8780002
        if {$_ind878 < $_len878} {
            
        } else {
            #item 885
            return 0
        }
        #item 8780004
        set line [ lindex $_col878 $_ind878 ]
        #item 880
        set value [ get_property $line "copying" ]
        #item 881
        if {$value == ""} {
            
        } else {
            #item 887
            if {$value == "yes"} {
                #item 888
                return 1
            } else {
                #item 886
                return 0
            }
            break
        }
        #item 8780003
        incr _ind878
    }
}

proc extract_return_type { text } {
    #item 491
    set skip [ string length "returns " ]
    set raw [ string range $text $skip end ]
    return [ string trim $raw ]
}

proc extract_signature { text name } {
    #item 783
    array set props { access static abstract 0
     inline 0 dispatch normal const 0 type function }
    set error_message ""
    set parameters {}
    set type "function"
    set returns ""
    #item 15
    set lines [ gen::separate_from_comments $text ]
    #item 17
    if {[ llength $lines ] == 0} {
        #item 833
        set returns "void"
    } else {
        #item 16
        set first_line [ lindex $lines 0 ]
        set first [ lindex $first_line 0 ]
        #item 589
        if {$first == "#comment"} {
            #item 42
            set type comment
            set returns ""
        } else {
            #item 595
            set keywords { 
            	public private protected
            	virtual static
            	inline abstract const
            	method function ctr dtr 
            	signal slot }
            #item 596
            set found_keywords \
             [ find_keywords $first $keywords ]
            #item 594
            if {[ llength $found_keywords ] == 0} {
                #item 598
                set start_index 0
                #item 34
                set count [ llength $lines ]
                set last [ expr { $count - 1 } ]
                #item 370001
                set i $start_index
                while { 1 } {
                    #item 370002
                    if {$i < $count} {
                        
                    } else {
                        break
                    }
                    #item 36
                    set current [ lindex $lines $i ]
                    set stripped [ lindex $current 0 ]
                    #item 46
                    if {[ string match "returns *" $stripped ]} {
                        #item 47
                        if {$i == $last} {
                            #item 50
                            set returns [ extract_return_type $stripped ]
                        } else {
                            #item 52
                            set error_message \
                            "$name: 'returns' can only be the last line."
                        }
                        break
                    } else {
                        
                    }
                    #item 45
                    lappend parameters $current
                    #item 370003
                    incr i
                }
                #item 834
                if {$type == "ctr"} {
                    #item 838
                    if {$returns == ""} {
                        
                    } else {
                        #item 839
                        set error_message \
                        "$name: constructors and destructors must not have return type"
                    }
                } else {
                    #item 835
                    if {$type == "dtr"} {
                        #item 838
                        if {$returns == ""} {
                            
                        } else {
                            #item 839
                            set error_message \
                            "$name: constructors and destructors must not have return type"
                        }
                    } else {
                        #item 842
                        if {$returns == ""} {
                            #item 845
                            set returns "void"
                        } else {
                            
                        }
                    }
                }
            } else {
                #item 597
                set start_index 1
                #item 600
                set alien_keywords \
                 [ find_not_belonging $first $keywords ]
                #item 601
                if {[ llength $alien_keywords ] == 0} {
                    #item 790
                    unpack [ classify_keywords $found_keywords $name ] \
                    	error_message prop_list
                    #item 791
                    if {$error_message == ""} {
                        #item 792
                        array unset props
                        array set props $prop_list
                        set type $props(type)
                        #item 34
                        set count [ llength $lines ]
                        set last [ expr { $count - 1 } ]
                        #item 370001
                        set i $start_index
                        while { 1 } {
                            #item 370002
                            if {$i < $count} {
                                
                            } else {
                                break
                            }
                            #item 36
                            set current [ lindex $lines $i ]
                            set stripped [ lindex $current 0 ]
                            #item 46
                            if {[ string match "returns *" $stripped ]} {
                                #item 47
                                if {$i == $last} {
                                    #item 50
                                    set returns [ extract_return_type $stripped ]
                                } else {
                                    #item 52
                                    set error_message \
                                    "$name: 'returns' can only be the last line."
                                }
                                break
                            } else {
                                
                            }
                            #item 45
                            lappend parameters $current
                            #item 370003
                            incr i
                        }
                        #item 834
                        if {$type == "ctr"} {
                            #item 838
                            if {$returns == ""} {
                                
                            } else {
                                #item 839
                                set error_message \
                                "$name: constructors and destructors must not have return type"
                            }
                        } else {
                            #item 835
                            if {$type == "dtr"} {
                                #item 838
                                if {$returns == ""} {
                                    
                                } else {
                                    #item 839
                                    set error_message \
                                    "$name: constructors and destructors must not have return type"
                                }
                            } else {
                                #item 842
                                if {$returns == ""} {
                                    #item 845
                                    set returns "void"
                                } else {
                                    
                                }
                            }
                        }
                    } else {
                        
                    }
                } else {
                    #item 602
                    set error_message \
                        "$name: Unexpected keywords: $alien_keywords"
                }
            }
        }
    }
    #item 846
    if {$type == "dtr"} {
        #item 847
        if {[ llength $parameters ] > 0} {
            #item 850
            set error_message \
            "$name: destructor cannot have parameters"
        } else {
            
        }
    } else {
        
    }
    #item 793
    set prop_list [ array get props ]
    #item 38
    return [ list $error_message \
    [ gen::create_signature $type $prop_list $parameters $returns ] ]
}

proc extract_sm_methods { gdb diagram_id } {
    #item 1595
    set name [ diagram_name $gdb $diagram_id ]
    #item 1372
    has_branches $gdb $diagram_id
    #item 1373
    has_receive $gdb $diagram_id
    #item 1431
    receives_in_the_middle $gdb $diagram_id
    #item 1432
    receives_are_first $gdb $diagram_id
    #item 1396
    returns_void $gdb $diagram_id
    #item 1526
    set lines [ get_params_lines $gdb $diagram_id ]
    #item 1557
    set last_line [ lindex $lines end ]
    #item 1558
    if {[ is_message_spec $last_line ]} {
        #item 1562
        set arg_lines [ lrange $lines 1 end-1 ]
        set msg_line $last_line
    } else {
        #item 1561
        set arg_lines [ lrange $lines 1 end ]
        set msg_line "receives Message* msg"
    }
    #item 1574
    set message_spec [ parse_message_spec $msg_line $name ]
    #item 1575
    set arguments [ lmap_user $arg_lines \
      gen_cpp::parse_argument $name ]
    #item 1608
    set max_branch [ $gdb onecolumn {
    	select max(ordinal)
    	from branches
    	where diagram_id = :diagram_id } ]
    #item 1609
    set branches {}
    #item 16100001
    set i 1
    while { 1 } {
        #item 16100002
        if {$i <= $max_branch} {
            
        } else {
            break
        }
        #item 1612
        lappend branches [ read_branch $gdb $diagram_id $i ]
        #item 16100003
        incr i
    }
    #item 1613
    set last_branch [ lindex $branches end ]
    set last_branch_header [ get_value $last_branch header ]
    #item 1633
    set init_branch [ lindex $branches 0 ]
    set cleanup_branch [ lindex $branches end ]
    set middle_branches [ lrange $branches 1 end-1 ]
    #item 1632
    lassign [ lpartition $middle_branches \
     gen_cpp::is_receiving_branch ] receiving normal
    #item 1634
    set fields [ make_init $gdb $init_branch $branches \
     $diagram_id $arguments ]
    #item 1635
    make_cleanup $gdb $cleanup_branch $branches \
     $diagram_id $fields
    #item 16360001
    set _col1636 $normal
    set _len1636 [ llength $_col1636 ]
    set _ind1636 0
    while { 1 } {
        #item 16360002
        if {$_ind1636 < $_len1636} {
            
        } else {
            break
        }
        #item 16360004
        set branch [ lindex $_col1636 $_ind1636 ]
        #item 1638
        make_sub_diagram $gdb $branch $branches $name 0 ""
        #item 16360003
        incr _ind1636
    }
    #item 16390001
    set _col1639 $receiving
    set _len1639 [ llength $_col1639 ]
    set _ind1639 0
    while { 1 } {
        #item 16390002
        if {$_ind1639 < $_len1639} {
            
        } else {
            break
        }
        #item 16390004
        set branch [ lindex $_col1639 $_ind1639 ]
        #item 2049
        make_sub_diagram $gdb $branch $branches $name 1 $message_spec
        #item 16390003
        incr _ind1639
    }
    #item 2096
    make_on_message $gdb $name $message_spec
    #item 2117
    set mname "${name}OnMessageFun"
    #item 2118
    set return_value { "void" "" }
    #item 2115
    set self [ st::sfield "$name*" self "" ]
    #item 2116
    set args [ list $self $message_spec ]
    #item 2119
    set comment "OnMessage callback for $name"
    #item 2120
    set on_message [ st::ssignature $mname $return_value $args $comment ]
    #item 2122
    set comment "Structure for $name state machine."
    #item 2123
    set code [ make_code $gdb $name $receiving ]
    #item 2133
    set sfields [ lmap $fields gen_cpp::table_field_to_struct ]
    #item 2121
    set sm_structure [ st::sstruct \
    $name \
    $sfields \
    {} \
    {} \
    1 \
    $comment \
    [ list $on_message ] \
    $code ]
    #item 2124
    put_value sm_structure on_message 1
    #item 1642
    delete_diagram $gdb $diagram_id
    #item 1347
    return $sm_structure
}

proc filter_functions { functions inline access } {
    #item 1082
    set result {}
    #item 10810001
    set _col1081 $functions
    set _len1081 [ llength $_col1081 ]
    set _ind1081 0
    while { 1 } {
        #item 10810002
        if {$_ind1081 < $_len1081} {
            
        } else {
            break
        }
        #item 10810004
        set function [ lindex $_col1081 $_ind1081 ]
        #item 1085
        unpack $function diagram_id name signature body
        unpack $signature type prop_list parameters returns
        array set props $prop_list
        #item 1086
        if {($props(inline) == $inline) && ($props(access) == $access)} {
            #item 1088
            lappend result $function
        } else {
            
        }
        #item 10810003
        incr _ind1081
    }
    #item 1083
    return $result
}

proc filter_methods { functions access } {
    #item 1097
    set result {}
    #item 10960001
    set _col1096 $functions
    set _len1096 [ llength $_col1096 ]
    set _ind1096 0
    while { 1 } {
        #item 10960002
        if {$_ind1096 < $_len1096} {
            
        } else {
            break
        }
        #item 10960004
        set function [ lindex $_col1096 $_ind1096 ]
        #item 1100
        unpack $function diagram_id name signature body
        unpack $signature type prop_list parameters returns
        array set props $prop_list
        #item 1102
        if {$props(access) == $access} {
            #item 1103
            lappend result $function
        } else {
            
        }
        #item 10960003
        incr _ind1096
    }
    #item 1098
    return $result
}

proc find_branch { branches vertex_id } {
    #item 19140001
    set _col1914 $branches
    set _len1914 [ llength $_col1914 ]
    set _ind1914 0
    while { 1 } {
        #item 19140002
        if {$_ind1914 < $_len1914} {
            
        } else {
            #item 1921
            error "Not found"
            break
        }
        #item 19140004
        set branch [ lindex $_col1914 $_ind1914 ]
        #item 1917
        set header [ get_value $branch header ]
        #item 1918
        if {$header == $vertex_id} {
            #item 1933
            return $branch
            #item 1916
            set ordinal [ get_value $branch ordinal ]
            #item 1922
            if {$ordinal == $count} {
                #item 1925
                return "last"
            } else {
                #item 1926
                if {[ is_receiving_branch $branch ]} {
                    #item 1929
                    return "receiving"
                } else {
                    #item 1928
                    return "normal"
                }
            }
            break
        } else {
            
        }
        #item 19140003
        incr _ind1914
    }
}

proc find_keywords { list keywords } {
    #item 804
    set result {}
    #item 8030001
    set _col803 $keywords
    set _len803 [ llength $_col803 ]
    set _ind803 0
    while { 1 } {
        #item 8030002
        if {$_ind803 < $_len803} {
            
        } else {
            break
        }
        #item 8030004
        set keyword [ lindex $_col803 $_ind803 ]
        #item 807
        if {[ contains $list $keyword ]} {
            #item 808
            lappend result $keyword
        } else {
            
        }
        #item 8030003
        incr _ind803
    }
    #item 1171
    if {$result == "const"} {
        
    } else {
        #item 805
        return $result
    }
}

proc find_not_belonging { list keywords } {
    #item 817
    set result {}
    #item 8190001
    set _col819 $list
    set _len819 [ llength $_col819 ]
    set _ind819 0
    while { 1 } {
        #item 8190002
        if {$_ind819 < $_len819} {
            
        } else {
            break
        }
        #item 8190004
        set item [ lindex $_col819 $_ind819 ]
        #item 820
        if {[ contains $keywords $item ]} {
            
        } else {
            #item 823
            lappend result $item
        }
        #item 8190003
        incr _ind819
    }
    #item 818
    return $result
}

proc generate { db gdb filename } {
    #item 964
    p.generate $db $gdb $filename "cpp"
}

proc generate_body { gdb diagram_id start_item node_list items incoming } {
    #item 1262
    set callbacks [ gen_cpp::make_callbacks "C++" ]
    #item 1261
    generate_body_goto \
    $gdb $diagram_id $start_item $node_list $items $incoming \
    $callbacks
}

proc generate_c { db gdb filename } {
    #item 977
    p.generate $db $gdb $filename "c"
}

proc get_field_list { gdb first diagram_id } {
    #item 1702
    set name [ diagram_name $gdb $diagram_id ]
    #item 1691
    set first_type [ gen::p.vertex_type $gdb $first ]
    #item 1692
    if {$first_type == "action"} {
        
    } else {
        #item 1695
        set msg "Diagram $name: the first icon "
        append msg "of a state machine must be "
        append msg "an action icon with fields."
        error $msg
    }
    #item 1696
    set first_text [ gen::p.vertex_text $gdb $first ]
    #item 1697
    set lines [ clean_params $first_text ]
    #item 1698
    if {[ llength $lines ] == 0} {
        #item 1701
        set msg "Diagram $name: empty fields list."
        error $msg
    } else {
        
    }
    #item 1703
    set fields [ lmap_user $lines \
     gen_cpp::parse_field $name ]
    #item 1748
    return $fields
}

proc get_params { gdb diagram_id } {
    #item 1390
    set params_icon [ $gdb onecolumn {
    	select params_icon
    	from branches
    	where diagram_id = :diagram_id
    	and ordinal = 1 } ]
    #item 1391
    set text [ gen::p.vertex_text $gdb $params_icon ]
    #item 1392
    return [ string trim $text ]
}

proc get_params_lines { gdb diagram_id } {
    #item 1604
    set params_icon [ $gdb onecolumn {
    	select params_icon
    	from branches
    	where diagram_id = :diagram_id
    	and ordinal = 1 } ]
    #item 1605
    set params_text [ gen::p.vertex_text $gdb $params_icon ]
    #item 1606
    set lines [ clean_params $params_text ]
    #item 1607
    return $lines
}

proc get_property { line key } {
    #item 870
    set eq_position [ string first "=" $line ]
    #item 872
    if {$eq_position == -1} {
        #item 875
        return ""
    } else {
        #item 871
        set name [ string range $line 0 $eq_position-1 ]
        set value [ string range $line $eq_position+1 end ]
        set name [ string trim $name ]
        set value [ string trim $value ]
        #item 874
        if {$name == $key} {
            #item 873
            return $value
        } else {
            #item 875
            return ""
        }
    }
}

proc get_single_line { block } {
    #item 1281
    set lines [ split $block "\n" ]
    #item 12820001
    set _col1282 $lines
    set _len1282 [ llength $_col1282 ]
    set _ind1282 0
    while { 1 } {
        #item 12820002
        if {$_ind1282 < $_len1282} {
            
        } else {
            break
        }
        #item 12820004
        set line [ lindex $_col1282 $_ind1282 ]
        #item 1284
        set trimmed [ string trim $line ]
        #item 1286
        if {$trimmed == ""} {
            
        } else {
            #item 1289
            return $trimmed
        }
        #item 12820003
        incr _ind1282
    }
    #item 1285
    return ""
}

proc has_branches { gdb diagram_id } {
    #item 1355
    set count [ $gdb onecolumn {
    	select count(*)
    	from branches
    	where diagram_id = :diagram_id } ]
    #item 1356
    if {$count < 2} {
        #item 1359
        set name [ diagram_name $gdb $diagram_id ]
        #item 1360
        error "Diagram $name is a state machine and must be a silhouette."
    } else {
        
    }
}

proc has_receive { gdb diagram_id } {
    #item 1365
    set count [ $gdb onecolumn {
    	select count(*)
    	from vertices
    	where diagram_id = :diagram_id
    	and type = 'action'
    	and text = 'RECEIVE' } ]
    #item 1367
    if {$count == 0} {
        #item 1429
        set name [ diagram_name $gdb $diagram_id ]
        #item 1371
        error "Diagram $name is a state machine and must have at least one RECEIVE icon."
    } else {
        
    }
}

proc has_value { field } {
    #item 1765
    set value [ get_value $field value ]
    #item 1766
    if {$value == ""} {
        #item 1769
        return 0
    } else {
        #item 1770
        return 1
    }
}

proc init_field { field } {
    #item 1795
    set name [ get_value $field name ]
    set value [ get_value $field value ]
    #item 1796
    return "self->$name = $value;"
}

proc insert_vertex { gdb diagram_id type text } {
    #item 1515
    set vertex_id [ mod::next_key $gdb vertices vertex_id ]
    #item 1973
    set item_id [ mod::next_key $gdb vertices item_id ]
    #item 1516
    $gdb eval {
    	insert into vertices
    		(vertex_id, diagram_id, type, text, marked, item_id )
    	values  (:vertex_id, :diagram_id, :type, :text, 0, :item_id)
    }
    #item 1517
    return $vertex_id
}

proc is_message_spec { text } {
    #item 1568
    if {([ llength $text ] >= 2) && ([ lindex $text 0 ] == "receives")} {
        #item 1571
        return 1
    } else {
        #item 1572
        return 0
    }
}

proc is_own { field } {
    #item 2033
    set type [ get_value $field type ]
    #item 2036
    if {$type == "own"} {
        #item 2034
        return 1
    } else {
        #item 2035
        return 0
    }
}

proc is_receive { gdb vertex_id } {
    #item 1451
    lassign [ $gdb eval {
    	select type, text
    	from vertices
    	where vertex_id = :vertex_id } ] type text
    #item 1452
    if {($type == "action") && ($text == "RECEIVE")} {
        #item 1456
        return 1
    } else {
        #item 1457
        return 0
    }
}

proc is_receiving_branch { branch } {
    #item 1628
    return [ get_value $branch receiving ]
}

proc is_state_machine { diagram_id gdb } {
    #item 1298
    lassign [ gen::get_diagram_start $gdb $diagram_id ] start params_icon
    #item 1299
    if {$params_icon == {}} {
        #item 1308
        return 0
    } else {
        #item 1302
        set text [ gen::p.vertex_text $gdb $params_icon ]
        #item 1304
        if {$text == ""} {
            #item 1308
            return 0
        } else {
            #item 1303
            set lines [ split $text "\n" ]
            #item 1306
            set fline [ lindex $lines 0 ]
            set text [ string trim $fline ]
            #item 1305
            if {$text == "state machine"} {
                #item 1307
                return 1
            } else {
                #item 1308
                return 0
            }
        }
    }
}

proc isolate_branch { gdb branches branch name } {
    set diagram_id -1
    #item 1820
    set first_branch [ lindex $branches 0 ]
    #item 1821
    set first_header [ get_value $first_branch header ]
    #item 1822
    set end ""
    set visited {}
    #item 2040
    set my_header [ get_value $branch header ]
    #item 1823
    set stack {}
    lappend stack $my_header
    
    set _next_item_ 1824
    while { 1 } {
        if {$_next_item_ == 1824} {
            set current [ lindex $stack end ]
            set stack [ lrange $stack 0 end-1 ]
            #item 1834
            set next_links [ $gdb eval {
            	select ordinal
            	from links
            	where src = :current } ]
            #item 18350001
            set _col1835 $next_links
            set _len1835 [ llength $_col1835 ]
            set _ind1835 0
            set _next_item_ 18350002
    
        } elseif {$_next_item_ == 18350002} {
            if {$_ind1835 < $_len1835} {
                #item 18350004
                set ordinal [ lindex $_col1835 $_ind1835 ]
                #item 1840
                set next [ gen::p.link_dst \
                 $gdb $current $ordinal ]
                set _next_item_ 1828
            } else {
                set _next_item_ 1825
            }
    
        } elseif {$_next_item_ == 1828} {
            if {$next == $first_header} {
                set _next_item_ 1832
            } else {
                #item 1841
                set type [ gen::p.vertex_type $gdb $next ]
                set _next_item_ 18420001
            }
    
        } elseif {$_next_item_ == 1832} {
            set msg "Diagram $name: cannot jump to the first branch "
            append msg "of state machine."
            #item 1833
            error $msg
            set _next_item_ 1984
    
        } elseif {$_next_item_ == 18420001} {
            if {$type == "beginend"} {
                set _next_item_ 1850
            } else {
                set _next_item_ 18420002
            }
    
        } elseif {$_next_item_ == 1850} {
            if {$end == ""} {
                #item 1852
                set end $next
                set_diagram $gdb $next $diagram_id
                set _next_item_ 18350003
            } else {
                set _next_item_ 18350003
            }
    
        } elseif {$_next_item_ == 18420002} {
            if {$type == "branch"} {
                #item 1867
                set jump [ create_jump $gdb $diagram_id \
                 $branches $next $name ]
                set _next_item_ 1864
            } else {
                set _next_item_ 1859
            }
    
        } elseif {$_next_item_ == 1864} {
            if {$end == ""} {
                #item 1866
                set end [ insert_vertex $gdb $diagram_id \
                 "beginend" "End" ]
                set _next_item_ 1869
            } else {
                set _next_item_ 1869
            }
    
        } elseif {$_next_item_ == 1869} {
            gen::p.set_link_dst $gdb $current $ordinal $jump
            gen::p.link $gdb $jump 1 $end
            set _next_item_ 18350003
    
        } elseif {$_next_item_ == 1859} {
            if {[ contains $visited $next ]} {
                set _next_item_ 18350003
            } else {
                #item 1862
                lappend visited $next
                #item 1863
                set_diagram $gdb $next $diagram_id
                #item 1870
                lappend stack $next
                set _next_item_ 18350003
            }
    
        } elseif {$_next_item_ == 18350003} {
            incr _ind1835
            set _next_item_ 18350002
    
        } elseif {$_next_item_ == 1825} {
            if {[ llength $stack ] == 0} {
                set _next_item_ 1984
            } else {
                set _next_item_ 1824
            }
    
        } elseif {$_next_item_ == 1984} {
            return [ gen::p.link_dst $gdb $my_header 1 ]
    
        }
    }
}

proc make_callbacks { language } {
    #item 1192
    set callbacks {}
    #item 1194
    gen::put_callback callbacks assign			gen_c::assign
    gen::put_callback callbacks compare			gen_c::compare
    gen::put_callback callbacks compare2		gen_c::compare
    gen::put_callback callbacks bad_case		gen_c::bad_case
    gen::put_callback callbacks tag		gen_c::tag
    
    gen::put_callback callbacks body			gen_c::generate_body
    gen::put_callback callbacks signature		gen_cpp::extract_signature
    gen::put_callback callbacks and				gen_c::p.and
    gen::put_callback callbacks or				gen_c::p.or
    gen::put_callback callbacks not				gen_c::p.not
    gen::put_callback callbacks declare				gen_c::declare
    #item 1263
    gen::put_callback callbacks if_start		gen_c::if_start
    gen::put_callback callbacks if_end		gen_c::if_end
    gen::put_callback callbacks else_start		gen_c::else_start
    gen::put_callback callbacks block_close		gen_c::block_close
    gen::put_callback callbacks return_none		gen_c::return_none
    gen::put_callback callbacks goto		gen_c::goto
    gen::put_callback callbacks shelf		gen_c::shelf
    #item 1199
    if {$language == "c"} {
        #item 1197
        gen::put_callback callbacks comment gen_c::commentator
    } else {
        #item 1198
        gen::put_callback callbacks comment gen_cpp::commentator
    }
    #item 1193
    return $callbacks
}

proc make_cleanup { gdb branch branches diagram_id fields } {
    #item 2021
    set name [ diagram_name $gdb $diagram_id ]
    #item 2002
    set first [ get_value $branch first ]
    #item 2039
    set own_fields [ lfilter $fields gen_cpp::is_own ]
    #item 2013
    set params {}
    #item 2019
    lappend params "public"
    lappend params "$name* self"
    #item 2022
    set params_text [ join $params "\n" ]
    #item 2005
    set init_text "if \(!self\) return;"
    #item 2006
    set preface [ insert_vertex $gdb -1 "action" $init_text ]
    #item 2025
    set new_first [ isolate_branch $gdb $branches $branch $name ]
    #item 2048
    gen::p.relink $gdb $new_first $preface
    gen::p.link $gdb $preface 1 $new_first
    #item 2041
    set outro {}
    #item 20440001
    set _col2044 $own_fields
    set _len2044 [ llength $_col2044 ]
    set _ind2044 0
    while { 1 } {
        #item 20440002
        if {$_ind2044 < $_len2044} {
            
        } else {
            break
        }
        #item 20440004
        set field [ lindex $_col2044 $_ind2044 ]
        #item 2046
        set fname [ get_value $field name ]
        #item 2047
        lappend outro "Object_Destroy\(self->$fname\);"
        #item 20440003
        incr _ind2044
    }
    #item 2042
    lappend outro "Allocator_Free\(self\);"
    #item 2043
    set outro_text [ join $outro "\n" ]
    #item 2026
    append_to_end $gdb -1 $outro_text
    #item 2023
    set dname "${name}_Destroy"
    #item 2024
    set new_dia [ make_diagram $gdb $dname $params_text $preface ]
    #item 2027
    move_dangling_to_diagram $gdb $new_dia
}

proc make_code { gdb name receiving } {
    #item 2152
    set lines {}
    #item 2159
    set state "${name}_State"
    #item 2154
    lappend lines "struct $state \{"
    lappend lines "    int Id;"
    lappend lines "    const char* Name;"
    lappend lines "    ${name}OnMessageFun Handler;"
    lappend lines "\};"
    lappend lines ""
    #item 21550001
    set _col2155 $receiving
    set _len2155 [ llength $_col2155 ]
    set _ind2155 0
    while { 1 } {
        #item 21550002
        if {$_ind2155 < $_len2155} {
            
        } else {
            break
        }
        #item 21550004
        set branch [ lindex $_col2155 $_ind2155 ]
        #item 2157
        set header_icon [ get_value $branch header ]
        set header [ gen::p.vertex_text $gdb $header_icon ]
        set ordinal [ get_value $branch ordinal ]
        #item 2158
        set fun [ state_fun_name $name $header ]
        set state_obj [ state_info_name $name $header ]
        #item 2160
        lappend lines "$state $state_obj = \{"
        lappend lines "    $ordinal,"
        lappend lines "    \"$header\","
        lappend lines "    $fun \};"
        lappend lines ""
        #item 21550003
        incr _ind2155
    }
    #item 2153
    return [ join $lines "\n" ]
}

proc make_diagram { gdb name params first_vertex } {
    #item 1506
    set diagram_id [ mod::next_key $gdb diagrams diagram_id ]
    #item 1508
    $gdb eval {
    	insert into diagrams (diagram_id, name)
    	values (:diagram_id, :name) }
    #item 1518
    set start_icon [ insert_vertex $gdb $diagram_id "beginend" $name ]
    #item 1519
    set params_icon [ insert_vertex $gdb $diagram_id "action" $params ]
    #item 1985
    $gdb eval {
    	delete from links
    	where dst = :first_vertex
    }
    #item 1975
    gen::p.link $gdb $start_icon 1 $first_vertex
    #item 1520
    $gdb eval {
    	insert into branches
    		(diagram_id, ordinal, start_icon, params_icon, first_icon)
    	values (:diagram_id, 1, :start_icon, :params_icon, :first_vertex)
    }
    #item 1507
    return $diagram_id
}

proc make_identifier { text } {
    #item 1890
    set trimmed [ string trim $text ]
    #item 1891
    return [ string map { " " "_" "-" "_" } $trimmed ]
}

proc make_init { gdb init_branch branches diagram_id arguments } {
    #item 1789
    set name [ diagram_name $gdb $diagram_id ]
    #item 1758
    set first [ get_value $init_branch first ]
    #item 1749
    set fields [ get_field_list $gdb $first $diagram_id ]
    #item 2113
    set super [ list type value class Object name Super \
     comment "Base class" value "" ]
    set state [ list type value class "${name}_State*" name State \
     comment "Current state" value "" ]
    set fields [ linsert $fields 0 $super $state ]
    #item 1759
    set init_fields [ lfilter $fields gen_cpp::has_value ]
    #item 1788
    set init_lines {}
    lappend init_lines \
    "$name* self = \($name*\)Allocator_Allocate\(sizeof\($name\)\, 1);"
    lappend init_lines \
    "self->Super.Type = &g${name};"
    lappend init_lines \
    "self->State = 0;"
    #item 1771
    add_range init_lines [ lmap $init_fields gen_cpp::init_field ]
    #item 1772
    set init_text [ join $init_lines "\n" ]
    #item 1773
    $gdb eval {
    	update vertices
    	set text = :init_text
    	where vertex_id = :first
    }
    #item 1780
    set params {}
    #item 1781
    lappend params "public"
    #item 17820001
    set _col1782 $arguments
    set _len1782 [ llength $_col1782 ]
    set _ind1782 0
    while { 1 } {
        #item 17820002
        if {$_ind1782 < $_len1782} {
            
        } else {
            break
        }
        #item 17820004
        set arg [ lindex $_col1782 $_ind1782 ]
        #item 1785
        set type [ get_value $arg type ]
        set aname [ get_value $arg name ]
        #item 1784
        lappend params "$type $aname"
        #item 17820003
        incr _ind1782
    }
    #item 1787
    lappend params "returns Object*"
    #item 1797
    set params_text [ join $params "\n" ]
    #item 1801
    set new_first [ isolate_branch $gdb $branches $init_branch $name ]
    #item 1802
    append_to_end $gdb -1 "return \(Object*\)self;"
    #item 1798
    set dname "${name}_Create"
    #item 1800
    set new_dia [ make_diagram $gdb $dname $params_text $new_first ]
    #item 1982
    move_dangling_to_diagram $gdb $new_dia
    #item 1750
    return $fields
}

proc make_on_message { gdb name message_spec } {
    #item 2103
    set type [ get_value $message_spec type ]
    set mname [ get_value $message_spec name ]
    #item 2102
    set lines {}
    lappend lines "public"
    lappend lines "$name* self"
    lappend lines "$type $mname"
    #item 2106
    set params_text [ join $lines "\n" ]
    #item 2104
    set lines {}
    lappend lines "${name}_State* state = self->State;"
    lappend lines "if \(state\) \{"
    lappend lines "    self->State = 0;"
    lappend lines "    state->Handler\(self, $mname\);"
    lappend lines "\}"
    #item 2105
    set body_text [ join $lines "\n" ]
    #item 2107
    set body [ insert_vertex $gdb -1 "action" $body_text ]
    #item 2108
    set end [ insert_vertex $gdb -1 "beginend" "End" ]
    #item 2109
    gen::p.link $gdb $body 1 $end
    #item 2111
    set dname "${name}_OnMessage"
    #item 2110
    set new_dia [ make_diagram $gdb $dname $params_text $body ]
    #item 2112
    move_dangling_to_diagram $gdb $new_dia
}

proc make_sub_diagram { gdb branch branches name receiving message_spec } {
    #item 2079
    set new_first [ isolate_branch $gdb $branches $branch $name ]
    #item 2076
    set params_text "public\n$name* self\n"
    #item 2093
    if {$receiving} {
        #item 2092
        gen::p.set_vertex_text $gdb $new_first ""
        #item 2161
        set type [ get_value $message_spec type ]
        set mname [ get_value $message_spec name ]
        #item 2162
        append params_text "$type $mname"
    } else {
        
    }
    #item 2091
    set header [ get_value $branch header ]
    set header_text [ gen::p.vertex_text $gdb $header ]
    set dname [ state_fun_name $name $header_text ]
    #item 2078
    set new_dia [ make_diagram $gdb $dname $params_text $new_first ]
    #item 2081
    move_dangling_to_diagram $gdb $new_dia
}

proc move_dangling_to_diagram { gdb diagram_id } {
    #item 1981
    $gdb eval {
    	update vertices
    	set diagram_id = :diagram_id
    	where diagram_id = -1
    }
}

proc noncopyable { fhandle class_name } {
    #item 1184
    puts $fhandle "private:"
    puts $fhandle "    // non-copyable"
    puts $fhandle "    $class_name\(const $class_name& other\) \{\}"
    puts $fhandle "    void operator=\(const $class_name& other\) \{\}"
}

proc p.generate { db gdb filename language } {
    #item 1309
    set diagrams [ $gdb eval {
    	select diagram_id from diagrams } ]
    #item 1310
    set sm_diagrams [ lfilter_user $diagrams \
     gen_cpp::is_state_machine $gdb ]
    #item 1327
    set sm_structures {}
    #item 13250001
    set _col1325 $sm_diagrams
    set _len1325 [ llength $_col1325 ]
    set _ind1325 0
    while { 1 } {
        #item 13250002
        if {$_ind1325 < $_len1325} {
            
        } else {
            break
        }
        #item 13250004
        set diagram_id [ lindex $_col1325 $_ind1325 ]
        #item 1328
        lappend sm_structures [ extract_sm_methods $gdb $diagram_id ]
        #item 13250003
        incr _ind1325
    }
    #item 933
    set callbacks [ make_callbacks $language ]
    #item 1324
    set diagrams [ $gdb eval {
    	select diagram_id from diagrams } ]
    #item 13190001
    set _col1319 $diagrams
    set _len1319 [ llength $_col1319 ]
    set _ind1319 0
    while { 1 } {
        #item 13190002
        if {$_ind1319 < $_len1319} {
            
        } else {
            break
        }
        #item 13190004
        set diagram_id [ lindex $_col1319 $_ind1319 ]
        #item 1318
        gen::fix_graph_for_diagram $gdb $callbacks 1 $diagram_id
        #item 13190003
        incr _ind1319
    }
    #item 923
    set sections { 
      h_header h_footer c_header c_footer class options
      structure
    }
    unpack [ gen::scan_file_description $db $sections ] \
      h_header h_footer c_header c_footer class options \
      structure
    #item 905
    set functions [ gen::generate_functions $db $gdb  \
    	$callbacks 0 ]
    #item 895
    if {[ graph::errors_occured ]} {
        
    } else {
        #item 937
        if {$language == "cpp"} {
            #item 938
            set copying [ extract_copying $options ]
            set class_name [ extract_class_name $class ]
        } else {
            #item 957
            set copying 0
            set class_name ""
        }
        #item 960
        unpack [ sort_functions $functions $language $class_name ] \
        free_funs \
        ctrs dtrs methods signals slots
        #item 1267
        set struct_path [ get_single_line $structure ]
        #item 1268
        if {$struct_path == ""} {
            #item 1272
            set struct_h ""
            set struct_c ""
        } else {
            #item 1275
            set dir [ file dirname $filename ]
            set full_spath [ file normalize \
              [ file join $dir $struct_path ] ]
            #item 1271
            unpack [ st::generate_classes $full_spath ] \
              struct_h struct_c
        }
        #item 1331
        st::add_structures $sm_structures struct_h struct_c
        #item 928
        set h_filename [ replace_extension $filename "h" ]
        set c_filename [ replace_extension $filename $language ]
        set filenames [ list $h_filename $c_filename ]
        #item 929
        unpack [ open_files $filenames "w" ] hfile cfile
        #item 930
        catch {
            print_header $h_filename $hfile $free_funs \
            $ctrs $dtrs $methods $signals $slots \
            $h_header $h_footer $class $copying $class_name \
            $language $struct_h
            
            print_cpp $h_filename $cfile $free_funs \
            $ctrs $dtrs $methods $slots \
            $c_header $c_footer $class_name \
            $language $struct_c
        } error_message
        #item 931
        close_files [ list $hfile $cfile ]
        #item 896
        if {$error_message == ""} {
            
        } else {
            #item 897
            puts $::errorInfo
            error $error_message
        }
    }
}

proc parse_argument { line name } {
    #item 1582
    if {[ llength $line ] >= 2} {
        #item 1585
        set type [ lrange $line 0 end-1 ]
        set name [ lindex $line end ]
        #item 1586
        return [ list \
         type $type \
         name $name \
         comment "" ]
    } else {
        #item 1587
        error "Diagram $name: syntax error in arguments icon: $line"
    }
}

proc parse_field { line name } {
    #item 1727
    if {[ string match "*;" $line ]} {
        #item 1731
        set text [ string range $line 0 end-1 ]
        #item 1718
        set eq_pos [ string first "=" $text ]
        #item 1719
        if {$eq_pos == -1} {
            #item 1722
            set field $text
            set value ""
            #item 1735
            if {[ llength $field ] < 2} {
                #item 1730
                set msg "Diagram $name: syntax error in: $line"
                #item 1726
                error $msg
            } else {
                #item 1736
                set first [ lindex $field 0 ]
                #item 1737
                if {$first == "own"} {
                    #item 1739
                    if {[ llength $field ] == 3} {
                        #item 1742
                        set class [ lindex $field 1 ]
                        #item 1745
                        set type "own"
                        #item 2125
                        set fname [ lindex $field end ]
                    } else {
                        #item 1730
                        set msg "Diagram $name: syntax error in: $line"
                        #item 1726
                        error $msg
                    }
                } else {
                    #item 1743
                    set class [ lrange $field 0 end-1 ]
                    #item 1744
                    set type "value"
                    #item 2125
                    set fname [ lindex $field end ]
                }
            }
        } else {
            #item 1732
            set value_start $eq_pos
            set field_end $eq_pos
            incr value_start
            incr field_end -1
            #item 1733
            set field [ string range $text 0 $field_end ]
            set value [ string range $text $value_start end ]
            set value [ string trim $value ]
            #item 1734
            if {$value == ""} {
                #item 1730
                set msg "Diagram $name: syntax error in: $line"
                #item 1726
                error $msg
            } else {
                #item 1735
                if {[ llength $field ] < 2} {
                    #item 1730
                    set msg "Diagram $name: syntax error in: $line"
                    #item 1726
                    error $msg
                } else {
                    #item 1736
                    set first [ lindex $field 0 ]
                    #item 1737
                    if {$first == "own"} {
                        #item 1739
                        if {[ llength $field ] == 3} {
                            #item 1742
                            set class [ lindex $field 1 ]
                            #item 1745
                            set type "own"
                            #item 2125
                            set fname [ lindex $field end ]
                        } else {
                            #item 1730
                            set msg "Diagram $name: syntax error in: $line"
                            #item 1726
                            error $msg
                        }
                    } else {
                        #item 1743
                        set class [ lrange $field 0 end-1 ]
                        #item 1744
                        set type "value"
                        #item 2125
                        set fname [ lindex $field end ]
                    }
                }
            }
        }
    } else {
        #item 1730
        set msg "Diagram $name: syntax error in: $line"
        #item 1726
        error $msg
    }
    #item 1747
    return [ list \
     name $fname \
     type $type \
     class $class \
     generate "" \
     value $value \
     comment "" ]
}

proc parse_message_spec { line name } {
    #item 1593
    set spec [ lrange $line 1 end ]
    #item 1594
    return [ parse_argument $spec $name ]
}

proc previous_is_header { gdb vertex_id } {
    #item 1475
    set previous [ $gdb onecolumn {
    	select src
    	from links
    	where dst = :vertex_id
    	and ordinal = 1 } ]
    #item 1476
    set type [ $gdb onecolumn {
    	select type
    	from vertices
    	where vertex_id = :previous } ]
    #item 1477
    return [ expr { $type == "branch" } ]
}

proc print_cpp { header_filename fhandle functions ctrs dtrs methods slots header footer class_name language structure } {
    #item 204
    put_credits $fhandle
    #item 205
    set header_tail [ file tail $header_filename ]
    puts $fhandle "#include \"$header_tail\""
    #item 206
    puts $fhandle ""
    puts $fhandle $header
    #item 1274
    puts $fhandle ""
    puts $fhandle $structure
    #item 11440001
    set _col1144 [ filter_functions $functions 0 static ]
    set _len1144 [ llength $_col1144 ]
    set _ind1144 0
    while { 1 } {
        #item 11440002
        if {$_ind1144 < $_len1144} {
            
        } else {
            break
        }
        #item 11440004
        set function [ lindex $_col1144 $_ind1144 ]
        #item 1146
        print_function $fhandle $function 1 "" $language
        #item 11440003
        incr _ind1144
    }
    #item 11470001
    set _col1147 [ filter_functions $functions 1 static ]
    set _len1147 [ llength $_col1147 ]
    set _ind1147 0
    while { 1 } {
        #item 11470002
        if {$_ind1147 < $_len1147} {
            
        } else {
            break
        }
        #item 11470004
        set function [ lindex $_col1147 $_ind1147 ]
        #item 1149
        print_function $fhandle $function 1 "" $language
        #item 11470003
        incr _ind1147
    }
    #item 11500001
    set _col1150 [ filter_functions $functions 1 static ]
    set _len1150 [ llength $_col1150 ]
    set _ind1150 0
    while { 1 } {
        #item 11500002
        if {$_ind1150 < $_len1150} {
            
        } else {
            break
        }
        #item 11500004
        set function [ lindex $_col1150 $_ind1150 ]
        #item 1152
        print_function $fhandle $function 0 "" $language
        #item 11500003
        incr _ind1150
    }
    #item 11680001
    set _col1168 [ filter_functions $functions 0 static ]
    set _len1168 [ llength $_col1168 ]
    set _ind1168 0
    while { 1 } {
        #item 11680002
        if {$_ind1168 < $_len1168} {
            
        } else {
            break
        }
        #item 11680004
        set function [ lindex $_col1168 $_ind1168 ]
        #item 1170
        print_function $fhandle $function 0 "" $language
        #item 11680003
        incr _ind1168
    }
    #item 11530001
    set _col1153 [ filter_functions $functions 0 public ]
    set _len1153 [ llength $_col1153 ]
    set _ind1153 0
    while { 1 } {
        #item 11530002
        if {$_ind1153 < $_len1153} {
            
        } else {
            break
        }
        #item 11530004
        set function [ lindex $_col1153 $_ind1153 ]
        #item 1155
        print_function $fhandle $function 0 "" $language
        #item 11530003
        incr _ind1153
    }
    #item 11590001
    set _col1159 $ctrs
    set _len1159 [ llength $_col1159 ]
    set _ind1159 0
    while { 1 } {
        #item 11590002
        if {$_ind1159 < $_len1159} {
            
        } else {
            break
        }
        #item 11590004
        set method [ lindex $_col1159 $_ind1159 ]
        #item 1161
        print_function $fhandle $method 0 $class_name "cpp"
        #item 11590003
        incr _ind1159
    }
    #item 11620001
    set _col1162 $dtrs
    set _len1162 [ llength $_col1162 ]
    set _ind1162 0
    while { 1 } {
        #item 11620002
        if {$_ind1162 < $_len1162} {
            
        } else {
            break
        }
        #item 11620004
        set method [ lindex $_col1162 $_ind1162 ]
        #item 1164
        print_function $fhandle $method 0 $class_name  "cpp"
        #item 11620003
        incr _ind1162
    }
    #item 11650001
    set _col1165 $methods
    set _len1165 [ llength $_col1165 ]
    set _ind1165 0
    while { 1 } {
        #item 11650002
        if {$_ind1165 < $_len1165} {
            
        } else {
            break
        }
        #item 11650004
        set method [ lindex $_col1165 $_ind1165 ]
        #item 1167
        print_function $fhandle $method 0 $class_name "cpp"
        #item 11650003
        incr _ind1165
    }
    #item 12520001
    set _col1252 $slots
    set _len1252 [ llength $_col1252 ]
    set _ind1252 0
    while { 1 } {
        #item 12520002
        if {$_ind1252 < $_len1252} {
            
        } else {
            break
        }
        #item 12520004
        set method [ lindex $_col1252 $_ind1252 ]
        #item 1254
        print_function $fhandle $method 0 $class_name "cpp"
        #item 12520003
        incr _ind1252
    }
    #item 210
    puts $fhandle $footer
    #item 211
    puts $fhandle ""
}

proc print_function { fhandle function in_header class_name language } {
    #item 1035
    unpack $function diagram_id name signature body
    unpack $signature type prop_list parameters returns
    array set props $prop_list
    set inline $props(inline)
    #item 1174
    if {$language == "c"} {
        #item 1177
        set empty "void"
    } else {
        #item 1178
        set empty ""
    }
    #item 1063
    if {$type == "function"} {
        #item 1037
        set depth 0
        set static [ expr { $props(access) != "public" } ]
        set virtual 0
        set class ""
        set const 0
        set abstract 0
        set print_body [ expr !$in_header ]
        #item 1038
        print_function_kernel \
        $fhandle \
        $depth \
        $static \
        $virtual \
        $inline \
        $returns \
        $class \
        $name \
        $parameters \
        $props(const) \
        $abstract \
        $body \
        $print_body \
        $empty
    } else {
        #item 1046
        if {$in_header} {
            #item 1048
            set depth 1
            set static [ expr { $props(dispatch) == "static" } ]
            set virtual [ expr { $props(dispatch) == "virtual" } ]
            set class ""
            set abstract $props(abstract)
            #item 1051
            if {$inline} {
                #item 1054
                set print_body 1
            } else {
                #item 1050
                set print_body 0
            }
            #item 1059
            if {$type == "ctr"} {
                #item 1060
                set returns "explicit"
                set name $class_name
            } else {
                
            }
            #item 1068
            if {$type == "dtr"} {
                #item 1071
                set returns ""
                set name "~$class_name"
            } else {
                
            }
            #item 1038
            print_function_kernel \
            $fhandle \
            $depth \
            $static \
            $virtual \
            $inline \
            $returns \
            $class \
            $name \
            $parameters \
            $props(const) \
            $abstract \
            $body \
            $print_body \
            $empty
        } else {
            #item 1055
            set depth 0
            set static 0
            set virtual 0
            set class $class_name
            set abstract 0
            #item 1056
            if {($inline) || ($props(abstract))} {
                
            } else {
                #item 1070
                set print_body 1
                #item 1064
                if {$type == "ctr"} {
                    #item 1065
                    set returns ""
                    set name $class_name
                } else {
                    
                }
                #item 1068
                if {$type == "dtr"} {
                    #item 1071
                    set returns ""
                    set name "~$class_name"
                } else {
                    
                }
                #item 1038
                print_function_kernel \
                $fhandle \
                $depth \
                $static \
                $virtual \
                $inline \
                $returns \
                $class \
                $name \
                $parameters \
                $props(const) \
                $abstract \
                $body \
                $print_body \
                $empty
            }
        }
    }
}

proc print_function_kernel { fhandle depth static virtual inline returns class name parameters const abstract body print_body empty } {
    #item 515
    set result {}
    set line ""
    #item 513
    if {$static} {
        #item 514
        append line "static "
    } else {
        
    }
    #item 518
    if {$virtual} {
        #item 519
        append line "virtual "
    } else {
        
    }
    #item 522
    if {$inline} {
        #item 523
        append line "inline "
    } else {
        
    }
    #item 526
    append line "$returns "
    #item 533
    if {$class == ""} {
        
    } else {
        #item 535
        append line "$class\:\:"
    }
    #item 536
    append line "$name\("
    #item 588
    set param_count [ llength $parameters ]
    #item 527
    if {$param_count == 0} {
        #item 537
        append line "$empty\)"
    } else {
        #item 550
        lappend result $line
        #item 5400001
        set i 0
        while { 1 } {
            #item 5400002
            if {$i < $param_count} {
                
            } else {
                break
            }
            #item 543
            set parameter_info [ lindex $parameters $i ]
            set parameter [ lindex $parameter_info 0 ]
            #item 541
            set line "    $parameter"
            #item 544
            if {$i == $param_count - 1} {
                
            } else {
                #item 545
                append line ","
            }
            #item 552
            lappend result $line
            #item 5400003
            incr i
        }
        #item 542
        set line "\)"
    }
    #item 560
    if {$const} {
        #item 561
        append line " const"
    } else {
        
    }
    #item 564
    if {$abstract} {
        #item 565
        append line " = 0"
    } else {
        
    }
    #item 568
    if {$print_body} {
        #item 571
        append line " \{"
        #item 572
        lappend result $line
        #item 5830001
        set _col583 $body
        set _len583 [ llength $_col583 ]
        set _ind583 0
        while { 1 } {
            #item 5830002
            if {$_ind583 < $_len583} {
                
            } else {
                break
            }
            #item 5830004
            set line [ lindex $_col583 $_ind583 ]
            #item 582
            lappend result "    $line"
            #item 5830003
            incr _ind583
        }
        #item 585
        lappend result "\}"
    } else {
        #item 570
        append line ";"
        #item 573
        lappend result $line
    }
    #item 1021
    set space [ gen::make_indent $depth ]
    #item 10200001
    set _col1020 $result
    set _len1020 [ llength $_col1020 ]
    set _ind1020 0
    while { 1 } {
        #item 10200002
        if {$_ind1020 < $_len1020} {
            
        } else {
            break
        }
        #item 10200004
        set line [ lindex $_col1020 $_ind1020 ]
        #item 1022
        puts -nonewline $fhandle $space
        puts $fhandle $line
        #item 10200003
        incr _ind1020
    }
    #item 1023
    puts $fhandle ""
}

proc print_header { filename fhandle functions ctrs dtrs methods signals slots header footer class copying class_name language structure } {
    #item 181
    put_credits $fhandle
    #item 171
    set guard [ gen_c::guard_name $filename ]
    #item 182
    puts $fhandle "#ifndef $guard"
    puts $fhandle "#define $guard"
    #item 183
    puts $fhandle ""
    puts $fhandle $header
    #item 1273
    puts $fhandle ""
    puts $fhandle $structure
    #item 1840001
    set _col184 [ filter_functions $functions 0 public ]
    set _len184 [ llength $_col184 ]
    set _ind184 0
    while { 1 } {
        #item 1840002
        if {$_ind184 < $_len184} {
            
        } else {
            break
        }
        #item 1840004
        set function [ lindex $_col184 $_ind184 ]
        #item 186
        print_function $fhandle $function 1 "" $language
        #item 1840003
        incr _ind184
    }
    #item 11070001
    set _col1107 [ filter_functions $functions 1 public ]
    set _len1107 [ llength $_col1107 ]
    set _ind1107 0
    while { 1 } {
        #item 11070002
        if {$_ind1107 < $_len1107} {
            
        } else {
            break
        }
        #item 11070004
        set function [ lindex $_col1107 $_ind1107 ]
        #item 1109
        print_function $fhandle $function 1 "" $language
        #item 11070003
        incr _ind1107
    }
    #item 11100001
    set _col1110 [ filter_functions $functions 1 public ]
    set _len1110 [ llength $_col1110 ]
    set _ind1110 0
    while { 1 } {
        #item 11100002
        if {$_ind1110 < $_len1110} {
            
        } else {
            break
        }
        #item 11100004
        set function [ lindex $_col1110 $_ind1110 ]
        #item 1112
        print_function $fhandle $function 0 "" $language
        #item 11100003
        incr _ind1110
    }
    #item 1025
    if {$class == ""} {
        
    } else {
        #item 1131
        puts $fhandle $class
        #item 1185
        if {$copying} {
            
        } else {
            #item 1186
            noncopyable $fhandle $class_name
        }
        #item 1132
        print_methods $fhandle $ctrs public $class_name
        #item 1133
        print_methods $fhandle $ctrs protected $class_name
        #item 1135
        print_methods $fhandle $dtrs public $class_name
        #item 1134
        print_methods $fhandle $ctrs private $class_name
        #item 1255
        print_methods $fhandle $signals public $class_name "signals"
        #item 1245
        print_methods $fhandle $slots public $class_name "public slots"
        #item 1246
        print_methods $fhandle $slots protected $class_name "protected slots"
        #item 1247
        print_methods $fhandle $slots private $class_name "private slots"
        #item 1138
        print_methods $fhandle $methods public $class_name
        #item 1139
        print_methods $fhandle $methods protected $class_name
        #item 1140
        print_methods $fhandle $methods private $class_name
        #item 1024
        puts $fhandle "\};"
    }
    #item 187
    puts $fhandle $footer
    #item 188
    puts $fhandle "#endif"
    puts $fhandle ""
}

proc print_methods { fhandle functions access class_name {access_label ""} } {
    #item 1118
    set to_print [ filter_methods $functions $access ]
    #item 1119
    if {$to_print == ""} {
        
    } else {
        #item 1248
        if {$access_label == ""} {
            #item 1251
            set access_label $access
        } else {
            
        }
        #item 1120
        puts $fhandle "$access_label:"
        #item 11210001
        set _col1121 $to_print
        set _len1121 [ llength $_col1121 ]
        set _ind1121 0
        while { 1 } {
            #item 11210002
            if {$_ind1121 < $_len1121} {
                
            } else {
                break
            }
            #item 11210004
            set method [ lindex $_col1121 $_ind1121 ]
            #item 1124
            print_function $fhandle $method 1 $class_name "cpp"
            #item 11210003
            incr _ind1121
        }
    }
}

proc put_credits { fhandle } {
    #item 180
    set version [ version_string ]
    puts $fhandle \
        "/* Autogenerated with DRAKON Editor $version */"
}

proc read_branch { gdb diagram_id ordinal } {
    #item 1620
    lassign [ $gdb eval {
    	select header_icon, first_icon
    	from branches
    	where diagram_id = :diagram_id
    	and ordinal = :ordinal 
    } ] header_icon first_icon
    #item 1622
    set receiving [ is_receive $gdb $first_icon ]
    #item 1621
    return [ list \
     ordinal $ordinal \
     header $header_icon \
     first $first_icon \
     receiving $receiving ]
}

proc receives_are_first { gdb diagram_id } {
    #item 1414
    set receives [ $gdb eval {
    	select vertex_id
    	from vertices
    	where diagram_id = :diagram_id
    	and type = 'action'
    	and text = 'RECEIVE' } ]
    #item 14150001
    set _col1415 $receives
    set _len1415 [ llength $_col1415 ]
    set _ind1415 0
    while { 1 } {
        #item 14150002
        if {$_ind1415 < $_len1415} {
            
        } else {
            break
        }
        #item 14150004
        set receive [ lindex $_col1415 $_ind1415 ]
        #item 1417
        if {[ previous_is_header $gdb $receive ]} {
            
        } else {
            #item 1428
            set name [ diagram_name $gdb $diagram_id ]
            #item 1430
            error "Diagram $name: a RECEIVE icon must be first in the branch."
        }
        #item 14150003
        incr _ind1415
    }
}

proc receives_in_the_middle { gdb diagram_id } {
    #item 1438
    set max [ $gdb onecolumn {
    	select max(ordinal)
    	from branches
    	where diagram_id = :diagram_id } ]
    #item 1444
    set name [ diagram_name $gdb $diagram_id ]
    #item 1441
    if {[ starts_with_receive $gdb $diagram_id 1 ]} {
        #item 1445
        error "Diagram $name: a RECEIVE icon must not be placed on the first branch."
    } else {
        
    }
    #item 1466
    if {[ starts_with_receive $gdb $diagram_id $max ]} {
        #item 1469
        error "Diagram $name: a RECEIVE icon must not be placed on the last branch."
    } else {
        
    }
}

proc returns_void { gdb diagram_id } {
    #item 1379
    set params [ get_params $gdb $diagram_id ]
    #item 1393
    set lines [ split $params "\n" ]
    #item 1394
    set last [ lindex $lines end ]
    #item 1395
    set trimmed [ string trim $last ]
    #item 1397
    if {$trimmed == "returns void"} {
        
    } else {
        #item 1380
        if {[ string match "returns *" $trimmed ]} {
            #item 1427
            set name [ diagram_name $gdb $diagram_id ]
            #item 1384
            error "Diagram $name is a state machine and must not return values."
        } else {
            
        }
    }
}

proc set_diagram { gdb vertex_id diagram_id } {
    #item 1858
    $gdb eval {
    	update vertices
    	set diagram_id = :diagram_id
    	where vertex_id = :vertex_id
    }
}

proc sort_functions { functions language class_name } {
    #item 968
    set free_funs {}
    set ctrs {}
    set dtrs {}
    set methods {}
    set signals {}
    set slots {}
    #item 9790001
    set _col979 $functions
    set _len979 [ llength $_col979 ]
    set _ind979 0
    while { 1 } {
        #item 9790002
        if {$_ind979 < $_len979} {
            
        } else {
            break
        }
        #item 9790004
        set function [ lindex $_col979 $_ind979 ]
        #item 978
        unpack $function diagram_id name signature body
        unpack $signature type prop_list
        array set props $prop_list
        #item 980
        if {$type == "comment"} {
            
        } else {
            #item 983
            if {$type == "function"} {
                
            } else {
                #item 981
                if {$language == "c"} {
                    #item 986
                    error \
                    "$name: methods, constructors and destructors not supported by C language."
                    #item 988
                    error \
                    "$name: cannot have methods: class not defined."
                } else {
                    #item 987
                    if {$class_name == ""} {
                        #item 988
                        error \
                        "$name: cannot have methods: class not defined."
                    } else {
                        
                    }
                }
            }
            #item 9890001
            if {$type == "function"} {
                #item 999
                lappend free_funs $function
            } else {
                #item 9890002
                if {$type == "signal"} {
                    #item 1240
                    lappend signals $function
                } else {
                    #item 9890003
                    if {$type == "slot"} {
                        #item 1243
                        lappend slots $function
                    } else {
                        #item 9890004
                        if {$type == "method"} {
                            #item 1009
                            lappend methods $function
                        } else {
                            #item 9890005
                            if {$type == "ctr"} {
                                #item 1012
                                lappend ctrs $function
                            } else {
                                #item 9890006
                                if {$type == "dtr"} {
                                    
                                } else {
                                    #item 9890007
                                    error "Unexpected switch value: $type"
                                }
                                #item 1013
                                lappend dtrs $function
                            }
                        }
                    }
                }
            }
        }
        #item 9790003
        incr _ind979
    }
    #item 971
    return [ list \
    $free_funs \
    $ctrs \
    $dtrs \
    $methods \
    $signals \
    $slots ]
}

proc starts_with_receive { gdb diagram_id ordinal } {
    #item 1463
    set header [ $gdb onecolumn {
    	select header_icon
    	from branches
    	where diagram_id = :diagram_id
    	and ordinal = :ordinal } ]
    #item 1464
    set first [ gen::p.get_next $gdb $header 1 ]
    #item 1465
    return [ is_receive $gdb $first ]
}

proc state_fun_name { name text } {
    #item 1897
    set normal_name [ make_identifier $text ]
    #item 1898
    return "${name}_${normal_name}"
}

proc state_info_name { name text } {
    #item 1904
    set normal_name [ make_identifier $text ]
    #item 1905
    return "${name}_${normal_name}_State"
}

proc strip_comment { text } {
    #item 1547
    set comment_start [ string first "//" $text ]
    #item 1549
    if {$comment_start == -1} {
        #item 1552
        set wo_comment $text
    } else {
        #item 1548
        set before_comment $comment_start
        incr before_comment -1
        #item 1553
        set wo_comment [ string range $text 0 $before_comment ]
    }
    #item 1554
    return [ string trim $wo_comment ]
}

proc table_field_to_struct { field } {
    #item 2131
    set name [ get_value $field name ]
    set class [ get_value $field class ]
    set type [ get_value $field type ]
    #item 2135
    if {$type == "own"} {
        #item 2134
        set class "$class*"
    } else {
        
    }
    #item 2132
    return [ st::sfield $class $name "" ]
}

}
